/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JRRtfExporter
extends JRAbstractExporter {
    protected JRExportProgressMonitor progressMonitor = null;
    protected Writer writer = null;
    protected File destFile = null;
    protected int reportIndex = 0;
    private StringBuffer colorBuffer = null;
    private StringBuffer fontBuffer = null;
    protected List colors = null;
    protected List fonts = null;
    private int zorder = 1;
    private boolean isUnicode = false;
    private Map fontMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block14: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            try {
                this.setExportContext();
                this.setInput();
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.fonts = new ArrayList();
                this.fontBuffer = new StringBuffer();
                this.colors = new ArrayList();
                this.colors.add(null);
                this.colorBuffer = new StringBuffer(";");
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                StringBuffer sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
                if (sb != null) {
                    StringBuffer buffer = this.exportReportToBuffer();
                    sb.append(buffer.toString());
                    break block14;
                }
                Writer outWriter = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (outWriter != null) {
                    try {
                        this.writer = outWriter;
                        this.exportReportToStream();
                        break block14;
                    }
                    catch (IOException ex) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), ex);
                    }
                }
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.writer = new OutputStreamWriter(os);
                        this.exportReportToStream();
                        break block14;
                    }
                    catch (Exception ex) {
                        throw new JRException("Error writing to output stream : " + this.jasperPrint.getName(), ex);
                    }
                }
                this.destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (this.destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        this.destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter");
                    }
                }
                this.exportReportToFile();
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected StringBuffer exportReportToBuffer() throws JRException {
        StringWriter buffer = new StringWriter();
        this.writer = buffer;
        try {
            this.exportReportToStream();
        }
        catch (IOException ex) {
            throw new JRException("Error while exporting report to the buffer");
        }
        return buffer.getBuffer();
    }

    protected void exportReportToStream() throws JRException, IOException {
        this.writer.write("{\\rtf1\\ansi\\deff0\n");
        this.createColorAndFontEntries();
        this.writer.write("{\\fonttbl ");
        this.writer.write(this.fontBuffer.toString());
        this.writer.write("}\n");
        this.writer.write("{\\colortbl ");
        this.writer.write(this.colorBuffer.toString());
        this.writer.write("}\n");
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                JRPrintPage page = null;
                this.writer.write("{\\info{\\nofpages");
                this.writer.write(String.valueOf(pages.size()));
                this.writer.write("}}\n");
                this.writer.write("\\viewkind1\\paperw");
                this.writer.write(String.valueOf(this.twip(this.jasperPrint.getPageWidth())));
                this.writer.write("\\paperh");
                this.writer.write(String.valueOf(this.twip(this.jasperPrint.getPageHeight())));
                this.writer.write("\\marglsxn0\\margrsxn0\\margtsxn0\\margbsxn0");
                if (this.jasperPrint.getOrientation() == 2) {
                    this.writer.write("\\lndscpsxn");
                }
                for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                    this.writer.write("\n");
                    if (Thread.currentThread().isInterrupted()) {
                        throw new JRException("Current thread intrerrupted");
                    }
                    page = (JRPrintPage)pages.get(pageIndex);
                    boolean lastPageFlag = false;
                    if (pageIndex == this.endPageIndex && this.reportIndex == this.jasperPrintList.size() - 1) {
                        lastPageFlag = true;
                    }
                    this.exportPage(page, lastPageFlag);
                }
            }
            ++this.reportIndex;
        }
        this.writer.write("}\n");
        this.writer.flush();
    }

    protected void exportReportToFile() throws JRException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.destFile);
            this.writer = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            this.exportReportToStream();
        }
        catch (IOException ex) {
            throw new JRException("Error writing to the file : " + this.destFile, ex);
        }
        finally {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void createColorAndFontEntries() throws JRException {
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            this.getFontIndex(new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider()));
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new JRException("Current thread interrupted");
                    }
                    JRPrintPage page = (JRPrintPage)pages.get(pageIndex);
                    JRPrintElement element = null;
                    List elements = page.getElements();
                    if (elements == null || elements.size() <= 0) continue;
                    Iterator it = elements.iterator();
                    while (it.hasNext()) {
                        element = (JRPrintElement)it.next();
                        this.getColorIndex(element.getForecolor());
                        this.getColorIndex(element.getBackcolor());
                        if (!(element instanceof JRPrintText)) continue;
                        JRPrintText text = (JRPrintText)element;
                        this.getColorIndex(text.getBorderColor());
                        this.getColorIndex(text.getTopBorderColor());
                        this.getColorIndex(text.getBottomBorderColor());
                        this.getColorIndex(text.getLeftBorderColor());
                        this.getColorIndex(text.getRightBorderColor());
                        for (int i = 0; i < text.getText().length(); ++i) {
                            if (text.getText().charAt(i) <= '\u007f') continue;
                            this.isUnicode = true;
                            break;
                        }
                        int runLimit = 0;
                        JRStyledText styledText = this.getStyledText((JRPrintText)element);
                        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
                        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
                            Map<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = iterator.getAttributes();
                            this.getFontIndex(new JRBaseFont(styledTextAttributes));
                            this.getColorIndex((Color)styledTextAttributes.get(TextAttribute.FOREGROUND));
                            this.getColorIndex((Color)styledTextAttributes.get(TextAttribute.BACKGROUND));
                            iterator.setIndex(runLimit);
                        }
                        this.getFontIndex((JRPrintText)element);
                    }
                }
            }
            ++this.reportIndex;
        }
    }

    private int getColorIndex(Color color) {
        int colorNdx = this.colors.indexOf(color);
        if (colorNdx < 0) {
            colorNdx = this.colors.size();
            this.colors.add(color);
            this.colorBuffer.append("\\red").append(color.getRed()).append("\\green").append(color.getGreen()).append("\\blue").append(color.getBlue()).append(";");
        }
        return colorNdx;
    }

    private int getFontIndex(JRFont font) {
        int fontIndex;
        String fontName = font.getFontName();
        if (this.fontMap != null && this.fontMap.containsKey(fontName)) {
            fontName = (String)this.fontMap.get(fontName);
        }
        if ((fontIndex = this.fonts.indexOf(fontName)) < 0) {
            fontIndex = this.fonts.size();
            this.fonts.add(fontName);
            this.fontBuffer.append("{\\f").append(fontIndex).append("\\fnil ").append(fontName).append(";}");
        }
        return fontIndex;
    }

    private int twip(int points) {
        return points * 20;
    }

    private int twip(float points) {
        return (int)(points * 20.0f);
    }

    protected void exportPage(JRPrintPage page, boolean lastPage) throws JRException, IOException {
        this.exportElements(page.getElements());
        if (!lastPage) {
            if (this.isUnicode) {
                this.writer.write("{\\pard\\pagebb\\par}\n");
            } else {
                this.writer.write("\\page\n");
            }
        }
    }

    private void startGraphic(String type, int x, int y, int w, int h) throws IOException {
        this.writer.write("{\\*\\do\\dobxpage\\dobypage\\dodhgt");
        this.writer.write(String.valueOf(this.zorder++));
        this.writer.write("\\");
        this.writer.write(type);
        this.writer.write("\\dpx");
        this.writer.write(String.valueOf(x));
        this.writer.write("\\dpy");
        this.writer.write(String.valueOf(y));
        this.writer.write("\\dpxsize");
        this.writer.write(String.valueOf(w));
        this.writer.write("\\dpysize");
        this.writer.write(String.valueOf(h));
    }

    private void finishGraphic(JRPrintGraphicElement element) throws IOException {
        int mode = 0;
        if (element.getMode() == 1) {
            mode = 1;
        }
        this.finishGraphic(element.getPen(), element.getForecolor(), element.getBackcolor(), mode);
    }

    private void finishGraphic(byte pen, Color fg, Color bg, int fillPattern) throws IOException {
        switch (pen) {
            case 5: {
                this.writer.write("\\dplinew10");
                break;
            }
            case 1: {
                this.writer.write("\\dplinew20");
                break;
            }
            case 2: {
                this.writer.write("\\dplinew40");
                break;
            }
            case 3: {
                this.writer.write("\\dplinew80");
                break;
            }
            case 4: {
                this.writer.write("\\dplinedash");
                break;
            }
            case 0: {
                this.writer.write("\\dplinehollow");
                break;
            }
            default: {
                this.writer.write("\\dplinew20");
            }
        }
        this.writer.write("\\dplinecor");
        this.writer.write(String.valueOf(fg.getRed()));
        this.writer.write("\\dplinecob");
        this.writer.write(String.valueOf(fg.getBlue()));
        this.writer.write("\\dplinecog");
        this.writer.write(String.valueOf(fg.getGreen()));
        this.writer.write("\\dpfillfgcr");
        this.writer.write(String.valueOf(fg.getRed()));
        this.writer.write("\\dplinefgcb");
        this.writer.write(String.valueOf(fg.getBlue()));
        this.writer.write("\\dpfillfgcg");
        this.writer.write(String.valueOf(fg.getGreen()));
        this.writer.write("\\dpfillbgcr");
        this.writer.write(String.valueOf(bg.getRed()));
        this.writer.write("\\dpfillbgcg");
        this.writer.write(String.valueOf(bg.getGreen()));
        this.writer.write("\\dpfillbgcb");
        this.writer.write(String.valueOf(bg.getBlue()));
        this.writer.write("\\dpfillpat");
        this.writer.write(String.valueOf(fillPattern));
        this.writer.write("}\n");
    }

    protected int getAdjustment(byte pen) {
        switch (pen) {
            case 5: {
                return 0;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 40;
            }
            case 4: {
                return 0;
            }
            case 0: {
                return 0;
            }
        }
        return 0;
    }

    protected void exportLine(JRPrintLine line) throws IOException {
        int x = this.twip(line.getX());
        x += this.getOffsetX();
        int y = this.twip(line.getY());
        y += this.getOffsetY();
        int h = this.twip(line.getHeight());
        int w = this.twip(line.getWidth());
        if (w <= 20 || h <= 20) {
            if (w > 20) {
                h = 0;
            } else {
                w = 0;
            }
        }
        this.startGraphic("dpline", x, y, w, h);
        if (line.getDirection() == 1) {
            this.writer.write("\\dpptx");
            this.writer.write(String.valueOf(x));
            this.writer.write("\\dppty");
            this.writer.write(String.valueOf(y));
            this.writer.write("\\dpptx");
            this.writer.write(String.valueOf(x + w));
            this.writer.write("\\dppty");
            this.writer.write(String.valueOf(y + h));
        } else {
            this.writer.write("\\dpptx");
            this.writer.write(String.valueOf(x));
            this.writer.write("\\dppty");
            this.writer.write(String.valueOf(y + h));
            this.writer.write("\\dpptx");
            this.writer.write(String.valueOf(x + w));
            this.writer.write("\\dppty");
            this.writer.write(String.valueOf(y));
        }
        this.finishGraphic(line);
    }

    protected void exportRectangle(JRPrintRectangle rect) throws IOException {
        this.startGraphic("dprect" + (rect.getRadius() > 0 ? "\\dproundr" : ""), this.twip(rect.getX() + this.getOffsetX()), this.twip(rect.getY() + this.getOffsetY()), this.twip(rect.getWidth()), this.twip(rect.getHeight()));
        this.finishGraphic(rect);
    }

    protected void exportEllipse(JRPrintEllipse ellipse) throws IOException {
        this.startGraphic("dpellipse", this.twip(ellipse.getX() + this.getOffsetX()), this.twip(ellipse.getY() + this.getOffsetY()), this.twip(ellipse.getWidth()), this.twip(ellipse.getHeight()));
        this.finishGraphic(ellipse);
    }

    protected void exportText(JRPrintText text) throws IOException, JRException {
        JRStyledText styledText = this.getStyledText(text);
        if (styledText == null) {
            return;
        }
        int x = this.twip(text.getX() + this.getOffsetX());
        int y = this.twip(text.getY() + this.getOffsetY());
        int width = this.twip(text.getWidth());
        int height = this.twip(text.getHeight());
        int textBoxAdjustment = 20;
        int textHeight = this.twip(text.getTextHeight());
        if (textHeight <= 0) {
            if (height <= 0) {
                throw new JRException("Invalid text height");
            }
            textHeight = height;
        }
        int topPadding = this.twip(text.getTopPadding());
        int leftPadding = this.twip(text.getLeftPadding());
        int bottomPadding = this.twip(text.getBottomPadding());
        int rightPadding = this.twip(text.getRightPadding());
        Color bgcolor = text.getBackcolor();
        if (text.getMode() == 1) {
            this.startGraphic("dprect", x, y, width, height);
            this.finishGraphic((byte)0, text.getForecolor(), bgcolor, 1);
        }
        int verticalAdjustment = topPadding;
        switch (text.getVerticalAlignment()) {
            case 1: {
                verticalAdjustment = 0;
                break;
            }
            case 2: {
                verticalAdjustment = (height - topPadding - bottomPadding - this.twip(text.getTextHeight())) / 2;
                break;
            }
            case 3: {
                verticalAdjustment = height - topPadding - bottomPadding - this.twip(text.getTextHeight());
            }
        }
        if (this.isUnicode) {
            this.writer.write("{\\pard\\absw");
            this.writer.write(String.valueOf(width));
            this.writer.write("\\absh");
            this.writer.write(String.valueOf(textHeight));
            this.writer.write("\\phpg\\posx");
            this.writer.write(String.valueOf(x));
            this.writer.write("\\pvpg\\posy");
            this.writer.write(String.valueOf(y + verticalAdjustment + topPadding));
        } else {
            this.writer.write("{\\*\\do\\dobxpage\\dobypage\\dodhgt");
            this.writer.write(String.valueOf(this.zorder++));
            this.writer.write("\\dptxbx\\dpx");
            this.writer.write(String.valueOf(x + textBoxAdjustment));
            this.writer.write("\\dpxsize");
            this.writer.write(String.valueOf(width - textBoxAdjustment));
            this.writer.write("\\dpy");
            this.writer.write(String.valueOf(y + verticalAdjustment + topPadding + textBoxAdjustment));
            this.writer.write("\\dpysize");
            this.writer.write(String.valueOf(textHeight + bottomPadding - textBoxAdjustment));
            this.writer.write("\\dpfillpat0\\dplinehollow{\\dptxbxtext {\\pard");
        }
        JRPrintText font = text;
        this.writer.write("\\f");
        this.writer.write(String.valueOf(this.getFontIndex(font)));
        this.writer.write("\\cf");
        this.writer.write(String.valueOf(this.getColorIndex(text.getForecolor())));
        this.writer.write("\\cb");
        this.writer.write(String.valueOf(this.getColorIndex(bgcolor)));
        this.writer.write(" ");
        if (leftPadding > 0) {
            this.writer.write("\\li");
            this.writer.write(String.valueOf(leftPadding));
        }
        if (rightPadding > 0) {
            this.writer.write("\\ri");
            this.writer.write(String.valueOf(rightPadding));
        }
        if (font.isBold()) {
            this.writer.write("\\b");
        }
        if (font.isItalic()) {
            this.writer.write("\\i");
        }
        if (font.isStrikeThrough()) {
            this.writer.write("\\strike");
        }
        if (font.isUnderline()) {
            this.writer.write("\\ul");
        }
        this.writer.write("\\fs");
        this.writer.write(String.valueOf(font.getFontSize() * 2));
        switch (text.getHorizontalAlignment()) {
            case 1: {
                this.writer.write("\\ql");
                break;
            }
            case 2: {
                this.writer.write("\\qc");
                break;
            }
            case 3: {
                this.writer.write("\\qr");
                break;
            }
            case 4: {
                this.writer.write("\\qj");
                break;
            }
            default: {
                this.writer.write("\\ql");
            }
        }
        this.writer.write("\\sl");
        this.writer.write(String.valueOf(this.twip(text.getLineSpacingFactor() * (float)font.getFontSize())));
        this.writer.write(" ");
        String plainText = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            Map<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = iterator.getAttributes();
            JRBaseFont styleFont = new JRBaseFont(styledTextAttributes);
            Color styleForeground = (Color)styledTextAttributes.get(TextAttribute.FOREGROUND);
            Color styleBackground = (Color)styledTextAttributes.get(TextAttribute.BACKGROUND);
            this.writer.write("\\f");
            this.writer.write(String.valueOf(this.getFontIndex(styleFont)));
            this.writer.write("\\fs");
            this.writer.write(String.valueOf(2 * styleFont.getFontSize()));
            if (styleFont.isBold()) {
                this.writer.write("\\b");
            }
            if (styleFont.isItalic()) {
                this.writer.write("\\i");
            }
            if (styleFont.isUnderline()) {
                this.writer.write("\\ul");
            }
            if (styleFont.isStrikeThrough()) {
                this.writer.write("\\strike");
            }
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(styledTextAttributes.get(TextAttribute.SUPERSCRIPT))) {
                this.writer.write("\\super");
            } else if (TextAttribute.SUPERSCRIPT_SUB.equals(styledTextAttributes.get(TextAttribute.SUPERSCRIPT))) {
                this.writer.write("\\sub");
            }
            if (null != styleBackground && !styleBackground.equals(bgcolor)) {
                this.writer.write("\\highlight");
                this.writer.write(String.valueOf(this.getColorIndex(styleBackground)));
            }
            this.writer.write("\\cf");
            this.writer.write(String.valueOf(this.getColorIndex(styleForeground)));
            this.writer.write(" ");
            int s = 0;
            int e = 0;
            String str = plainText.substring(iterator.getIndex(), runLimit);
            String pattern = "\n";
            String replace = "\\line ";
            StringBuffer result = new StringBuffer();
            while ((e = str.indexOf(pattern, s)) >= 0) {
                result.append(str.substring(s, e));
                result.append(replace);
                s = e + pattern.length();
            }
            result.append(str.substring(s));
            this.writer.write(this.handleUnicodeText(result, text.getRunDirection() == 1));
            this.writer.write("\\plain");
            iterator.setIndex(runLimit);
        }
        if (this.isUnicode) {
            this.writer.write("\\par}\n");
        } else {
            this.writer.write("\\par}}}\n");
        }
        this.exportBox(text, x, y, width, height, text.getForecolor(), bgcolor);
    }

    private String handleUnicodeText(StringBuffer source, boolean isRightToLeft) {
        StringBuffer resultBuffer = new StringBuffer();
        StringBuffer leftToRightBuffer = new StringBuffer();
        for (int i = 0; i < source.length(); ++i) {
            long ch = source.charAt(i);
            if (ch > 127L) {
                if (isRightToLeft) {
                    resultBuffer.insert(0, leftToRightBuffer.toString());
                    leftToRightBuffer = new StringBuffer();
                    resultBuffer.insert(0, "\\u" + ch + '?');
                    continue;
                }
                leftToRightBuffer.append("\\u" + ch + '?');
                continue;
            }
            leftToRightBuffer.append((char)ch);
        }
        if (leftToRightBuffer != null && leftToRightBuffer.length() > 0) {
            if (isRightToLeft) {
                resultBuffer.insert(0, leftToRightBuffer.toString());
            } else {
                resultBuffer.append(leftToRightBuffer.toString());
            }
        }
        return resultBuffer.toString();
    }

    protected void exportImage(JRPrintImage printImage) throws JRException, IOException {
        int x = this.twip(printImage.getX() + this.globalOffsetX);
        int y = this.twip(printImage.getY() + this.globalOffsetY);
        int width = this.twip(printImage.getWidth());
        int height = this.twip(printImage.getHeight());
        if (printImage.getMode() == 1) {
            this.startGraphic("dprect", x, y, width, height);
            this.finishGraphic((byte)0, printImage.getForecolor(), printImage.getBackcolor(), 1);
        }
        int leftPadding = printImage.getLeftPadding();
        int topPadding = printImage.getTopPadding();
        int rightPadding = printImage.getRightPadding();
        int bottomPadding = printImage.getBottomPadding();
        int availableImageWidth = printImage.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = printImage.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        JRRenderable renderer = printImage.getRenderer();
        if (availableImageWidth > 0 && availableImageHeight > 0 && renderer != null) {
            int normalWidth = availableImageWidth;
            int normalHeight = availableImageHeight;
            Dimension2D dimension = renderer.getDimension();
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            float xalignFactor = 0.0f;
            switch (printImage.getHorizontalAlignment()) {
                case 3: {
                    xalignFactor = 1.0f;
                    break;
                }
                case 2: {
                    xalignFactor = 0.5f;
                    break;
                }
                default: {
                    xalignFactor = 0.0f;
                }
            }
            float yalignFactor = 0.0f;
            switch (printImage.getVerticalAlignment()) {
                case 3: {
                    yalignFactor = 1.0f;
                    break;
                }
                case 2: {
                    yalignFactor = 0.5f;
                    break;
                }
                default: {
                    yalignFactor = 0.0f;
                }
            }
            BufferedImage bi = new BufferedImage(availableImageWidth, availableImageHeight, 1);
            Graphics2D grx = bi.createGraphics();
            grx.setColor(printImage.getBackcolor());
            grx.fillRect(0, 0, availableImageWidth, availableImageHeight);
            switch (printImage.getScaleImage()) {
                case 1: {
                    int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                    int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                    renderer.render(grx, new Rectangle(xoffset, yoffset, normalWidth, normalHeight));
                    break;
                }
                case 2: {
                    renderer.render(grx, new Rectangle(0, 0, availableImageWidth, availableImageHeight));
                    break;
                }
                default: {
                    if (printImage.getHeight() <= 0) break;
                    double ratio = (double)normalWidth / (double)normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        normalWidth = availableImageWidth;
                        normalHeight = (int)((double)availableImageWidth / ratio);
                    } else {
                        normalWidth = (int)((double)availableImageHeight * ratio);
                        normalHeight = availableImageHeight;
                    }
                    int xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                    int yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                    renderer.render(grx, new Rectangle(xoffset, yoffset, normalWidth, normalHeight));
                }
            }
            this.writer.write("{\\*\\do\\dobxpage\\dobypage\\dodhgt");
            this.writer.write(String.valueOf(this.zorder++));
            this.writer.write("\\dptxbx\\dpx");
            this.writer.write(String.valueOf(this.twip(printImage.getX() + leftPadding + this.globalOffsetX + this.getOffsetX())));
            this.writer.write("\\dpxsize");
            this.writer.write(String.valueOf(this.twip(availableImageWidth)));
            this.writer.write("\\dpy");
            this.writer.write(String.valueOf(this.twip(printImage.getY() + topPadding + this.globalOffsetY + this.getOffsetY())));
            this.writer.write("\\dpysize");
            this.writer.write(String.valueOf(this.twip(availableImageHeight)));
            this.writer.write("\\dpfillpat0\\dplinehollow{\\dptxbxtext {\\pict\\jpegblip\\picwgoal");
            this.writer.write(String.valueOf(this.twip(availableImageWidth)));
            this.writer.write("\\pichgoal");
            this.writer.write(String.valueOf(this.twip(availableImageHeight)));
            this.writer.write("\n");
            ByteArrayInputStream bais = new ByteArrayInputStream(JRImageLoader.loadImageDataFromAWTImage(bi));
            int count = 0;
            int current = 0;
            while ((current = bais.read()) != -1) {
                String helperStr = Integer.toHexString(current);
                if (helperStr.length() < 2) {
                    helperStr = "0" + helperStr;
                }
                this.writer.write(helperStr);
                if (++count != 64) continue;
                this.writer.write("\n");
                count = 0;
            }
            this.writer.write("\n}}}\n");
        }
        if (printImage.getTopBorder() == 0 && printImage.getLeftBorder() == 0 && printImage.getBottomBorder() == 0 && printImage.getRightBorder() == 0) {
            if (printImage.getPen() != 0) {
                this.startGraphic("dprect", x, y, width, height);
                this.finishGraphic(printImage);
            }
        } else {
            this.exportBox(printImage, x, y, width, height, printImage.getForecolor(), printImage.getBackcolor());
        }
    }

    protected void exportFrame(JRPrintFrame frame) throws JRException, IOException {
        int x = this.twip(frame.getX() + this.getOffsetX());
        int y = this.twip(frame.getY() + this.getOffsetY());
        int width = this.twip(frame.getWidth());
        int height = this.twip(frame.getHeight());
        if (frame.getMode() == 1) {
            this.startGraphic("dprect", x, y, width, height);
            this.finishGraphic((byte)0, frame.getForecolor(), frame.getBackcolor(), 1);
        }
        this.setFrameElementsOffset(frame, false);
        this.exportElements(frame.getElements());
        this.restoreElementOffsets();
        this.exportBox(frame, x, y, width, height, frame.getForecolor(), frame.getBackcolor());
    }

    protected void exportElements(Collection elements) throws JRException, IOException {
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                JRPrintElement element = (JRPrintElement)it.next();
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (element instanceof JRPrintText) {
                    this.exportText((JRPrintText)element);
                    continue;
                }
                if (!(element instanceof JRPrintFrame)) continue;
                this.exportFrame((JRPrintFrame)element);
            }
        }
    }

    private void exportBox(JRBox box, int x, int y, int width, int height, Color fg, Color bg) throws IOException {
        int a;
        byte pen;
        Color bc;
        if (box.getTopBorder() != 0) {
            bc = box.getTopBorderColor();
            pen = box.getTopBorder();
            a = this.getAdjustment(box.getTopBorder());
            if (bc == null) {
                bc = fg;
            }
            this.startGraphic("dpline", x, y + a, width, 0);
            this.finishGraphic(pen, bc, bg, 1);
        }
        if (box.getLeftBorder() != 0) {
            bc = box.getLeftBorderColor();
            pen = box.getLeftBorder();
            a = this.getAdjustment(pen);
            if (bc == null) {
                bc = fg;
            }
            this.startGraphic("dpline", x + a, y, 0, height);
            this.finishGraphic(pen, bc, bg, 1);
        }
        if (box.getBottomBorder() != 0) {
            bc = box.getBottomBorderColor();
            pen = box.getBottomBorder();
            a = this.getAdjustment(pen);
            if (bc == null) {
                bc = fg;
            }
            this.startGraphic("dpline", x, y + height - a, width, 0);
            this.finishGraphic(pen, bc, bg, 1);
        }
        if (box.getRightBorder() != 0) {
            bc = box.getRightBorderColor();
            pen = box.getRightBorder();
            a = this.getAdjustment(pen);
            if (bc == null) {
                bc = fg;
            }
            this.startGraphic("dpline", x + width - a, y, 0, height);
            this.finishGraphic(pen, bc, bg, 1);
        }
    }
}

