/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.xml;

import net.sf.jasperreports.charts.design.JRDesignMeterPlot;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.xml.sax.Attributes;

public class JRMeterPlotFactory
extends JRBaseFactory {
    public static final String ATTRIBUTE_shape = "shape";
    public static final String ATTRIBUTE_angle = "angle";
    public static final String ATTRIBUTE_units = "units";
    public static final String ATTRIBUTE_tickInterval = "tickInterval";
    public static final String ATTRIBUTE_meterColor = "meterColor";
    public static final String ATTRIBUTE_needleColor = "needleColor";
    public static final String ATTRIBUTE_tickColor = "tickColor";

    public Object createObject(Attributes atts) throws JRException {
        String tickColor;
        String needleColor;
        String meterColor;
        String tickInterval;
        String units;
        JRChart chart = (JRChart)this.digester.peek();
        JRDesignMeterPlot meterPlot = (JRDesignMeterPlot)chart.getPlot();
        String shapeAttr = atts.getValue(ATTRIBUTE_shape);
        Byte shape = (Byte)JRXmlConstants.getMeterShapeMap().get(shapeAttr);
        if (shape == null) {
            throw new JRException("Invalid meter shape: " + shapeAttr);
        }
        meterPlot.setShape(shape);
        String angle = atts.getValue(ATTRIBUTE_angle);
        if (angle != null && angle.length() > 0) {
            meterPlot.setMeterAngle(Integer.parseInt(angle));
        }
        if ((units = atts.getValue(ATTRIBUTE_units)) != null && units.length() > 0) {
            meterPlot.setUnits(units);
        }
        if ((tickInterval = atts.getValue(ATTRIBUTE_tickInterval)) != null && tickInterval.length() > 0) {
            meterPlot.setTickInterval(Double.parseDouble(tickInterval));
        }
        if ((meterColor = atts.getValue(ATTRIBUTE_meterColor)) != null && meterColor.length() > 0) {
            meterPlot.setMeterBackgroundColor(JRXmlConstants.getColor(meterColor, null));
        }
        if ((needleColor = atts.getValue(ATTRIBUTE_needleColor)) != null && needleColor.length() > 0) {
            meterPlot.setNeedleColor(JRXmlConstants.getColor(needleColor, null));
        }
        if ((tickColor = atts.getValue(ATTRIBUTE_tickColor)) != null && tickColor.length() > 0) {
            meterPlot.setTickColor(JRXmlConstants.getColor(tickColor, null));
        }
        return meterPlot;
    }
}

