/*
 * SeriesColorsDialog.java
 *
 * Created on September 27, 2006, 1:16 AM
 */

package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.chart.SeriesColor;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import javax.swing.DefaultListModel;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;

/**
 *
 * @author  gtoffoli
 */
public class SeriesColorsDialog extends javax.swing.JDialog {
    
    private int dialogResult = javax.swing.JOptionPane.CANCEL_OPTION;
    private java.util.List seriescolors = null;
    
    public static java.util.List clipboard = new java.util.ArrayList();
    public static java.util.List lastSeries = new java.util.ArrayList();
    
    /** Creates new form SeriesColorsDialog */
    public SeriesColorsDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initAll();
        
        
    }
    
    /** Creates new form SeriesColorsDialog */
    public SeriesColorsDialog(java.awt.Dialog parent, boolean modal) {
        super(parent, modal);
        initAll();
    }
    
    public void initAll()
    {
        initComponents();
        
        jList1.setModel(new DefaultListModel());
        jList1.setCellRenderer(new ColorsListCellRenderer());
        
        jList1ValueChanged(null);
        
        jButtonPasteSeries.setEnabled( clipboard.size() > 0 );
        jButtonUseLast.setEnabled( lastSeries.size() > 0 );
        
        this.pack();
        Misc.centerFrame(this);
    }
    
    
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jPanel2 = new javax.swing.JPanel();
        jButtonAddColor = new javax.swing.JButton();
        jButtonModify = new javax.swing.JButton();
        jButtonDelete = new javax.swing.JButton();
        jButtonMoveUp = new javax.swing.JButton();
        jButtonMoveDown = new javax.swing.JButton();
        jButtonCopySeries = new javax.swing.JButton();
        jButtonPasteSeries = new javax.swing.JButton();
        jButtonUseLast = new javax.swing.JButton();
        jButtonRandomColor = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();
        jPanel1 = new javax.swing.JPanel();
        jButtonOk = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        jList1.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jList1ValueChanged(evt);
            }
        });
        jList1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jList1MouseClicked(evt);
            }
        });

        jScrollPane1.setViewportView(jList1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jScrollPane1, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setMinimumSize(new java.awt.Dimension(150, 150));
        jPanel2.setPreferredSize(new java.awt.Dimension(100, 283));
        jButtonAddColor.setText("Add");
        jButtonAddColor.setMargin(new java.awt.Insets(2, 8, 2, 8));
        jButtonAddColor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAddColorActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanel2.add(jButtonAddColor, gridBagConstraints);

        jButtonModify.setText("Modify");
        jButtonModify.setEnabled(false);
        jButtonModify.setMargin(new java.awt.Insets(2, 8, 2, 8));
        jButtonModify.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModifyActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanel2.add(jButtonModify, gridBagConstraints);

        jButtonDelete.setText("Delete");
        jButtonDelete.setEnabled(false);
        jButtonDelete.setMargin(new java.awt.Insets(2, 8, 2, 8));
        jButtonDelete.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDeleteActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanel2.add(jButtonDelete, gridBagConstraints);

        jButtonMoveUp.setText("Move up");
        jButtonMoveUp.setEnabled(false);
        jButtonMoveUp.setMargin(new java.awt.Insets(2, 8, 2, 8));
        jButtonMoveUp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMoveUpActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanel2.add(jButtonMoveUp, gridBagConstraints);

        jButtonMoveDown.setText("Move down");
        jButtonMoveDown.setEnabled(false);
        jButtonMoveDown.setMargin(new java.awt.Insets(2, 8, 2, 8));
        jButtonMoveDown.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMoveDownActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 14, 4);
        jPanel2.add(jButtonMoveDown, gridBagConstraints);

        jButtonCopySeries.setText("Copy series");
        jButtonCopySeries.setMargin(new java.awt.Insets(2, 8, 2, 8));
        jButtonCopySeries.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCopySeriesActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanel2.add(jButtonCopySeries, gridBagConstraints);

        jButtonPasteSeries.setText("Paste series");
        jButtonPasteSeries.setEnabled(false);
        jButtonPasteSeries.setMargin(new java.awt.Insets(2, 8, 2, 8));
        jButtonPasteSeries.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonPasteSeriesActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanel2.add(jButtonPasteSeries, gridBagConstraints);

        jButtonUseLast.setText("Use the last");
        jButtonUseLast.setEnabled(false);
        jButtonUseLast.setMargin(new java.awt.Insets(2, 8, 2, 8));
        jButtonUseLast.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonUseLastActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanel2.add(jButtonUseLast, gridBagConstraints);

        jButtonRandomColor.setText("Random color");
        jButtonRandomColor.setMargin(new java.awt.Insets(2, 8, 2, 8));
        jButtonRandomColor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRandomColorActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanel2.add(jButtonRandomColor, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 4);
        getContentPane().add(jPanel2, gridBagConstraints);

        jSeparator1.setMinimumSize(new java.awt.Dimension(0, 2));
        jSeparator1.setPreferredSize(new java.awt.Dimension(3, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(jSeparator1, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jPanel1.setPreferredSize(new java.awt.Dimension(320, 23));
        jButtonOk.setText("OK");
        jButtonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOkActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 4);
        jPanel1.add(jButtonOk, gridBagConstraints);

        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        jPanel1.add(jButtonCancel, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jPanel1, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonUseLastActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonUseLastActionPerformed

        DefaultListModel dtm = ((DefaultListModel)jList1.getModel());
        if (lastSeries.size() > 0)
        {
            for (int i=0; i<lastSeries.size(); ++i)
            {
                dtm.addElement(  new Color(  ((Color)lastSeries.get(i)).getRGB() ));
            }
        }
        
    }//GEN-LAST:event_jButtonUseLastActionPerformed

    private void jButtonPasteSeriesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonPasteSeriesActionPerformed

        DefaultListModel dtm = ((DefaultListModel)jList1.getModel());
        if (clipboard.size() > 0)
        {
            for (int i=0; i<clipboard.size(); ++i)
            {
                dtm.addElement(  new Color(  ((Color)clipboard.get(i)).getRGB() ));
            }
        }
        
        
    }//GEN-LAST:event_jButtonPasteSeriesActionPerformed

    private void jButtonCopySeriesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCopySeriesActionPerformed

        DefaultListModel dtm = ((DefaultListModel)jList1.getModel());
        if (dtm.size() > 0)
        {
            clipboard.clear();
            for (int i=0; i<dtm.size(); ++i)
            {
                clipboard.add(  new Color(  ((Color)dtm.get(i)).getRGB() ));
            }
        }
        
        jButtonPasteSeries.setEnabled(true);
    }//GEN-LAST:event_jButtonCopySeriesActionPerformed

    private void jButtonRandomColorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRandomColorActionPerformed

        Color c = new Color((int)(Math.random() * 255), (int)(Math.random() * 255), (int)(Math.random() * 255) );
        DefaultListModel dtm = ((DefaultListModel)jList1.getModel());
        dtm.addElement(c);
        
    }//GEN-LAST:event_jButtonRandomColorActionPerformed

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed

        setDialogResult( JOptionPane.CANCEL_OPTION);
        setVisible(false);
        dispose();
        
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOkActionPerformed

        
        java.util.List temp_list = new java.util.ArrayList();
        
        DefaultListModel dtm = ((DefaultListModel)jList1.getModel());
        
        lastSeries.clear();
        
        for (int i=0; i<dtm.size(); ++i)
        {
            SeriesColor sc = new SeriesColor();
            sc.setSeriesOrder(i);
            sc.setColor( (java.awt.Color)dtm.get(i) );
            
            temp_list.add(sc);
            lastSeries.add( (java.awt.Color)dtm.get(i) );
        }
        
        
        setSeriescolors(temp_list);
        setDialogResult(JOptionPane.OK_OPTION);
        this.setVisible(false);
        this.dispose();
        
    }//GEN-LAST:event_jButtonOkActionPerformed

    private void jButtonMoveDownActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonMoveDownActionPerformed
        if (jList1.getSelectedValues() != null)
        {
            int[] indices = jList1.getSelectedIndices();
            for (int i=indices.length-1; i>=0; --i)
            {
                if (indices[i] >= ((DefaultListModel)jList1.getModel()).size() -1 ) continue;

                Object val = ((DefaultListModel)jList1.getModel()).remove( indices[i] );
                ((DefaultListModel)jList1.getModel()).insertElementAt(val, indices[i]+1);
                indices[i]++;
            }
            jList1.setSelectedIndices(indices);

        }
    }//GEN-LAST:event_jButtonMoveDownActionPerformed

    private void jButtonMoveUpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonMoveUpActionPerformed
    if (jList1.getSelectedValues() != null)
        {
            int[] indices = jList1.getSelectedIndices();
            for (int i=0; i<indices.length; ++i)
            {
                if (indices[i] == 0) continue;
                Object val = ((DefaultListModel)jList1.getModel()).remove( indices[i] );
                ((DefaultListModel)jList1.getModel()).insertElementAt(val, indices[i]-1);
                indices[i]--;
            }
            jList1.setSelectedIndices(indices);
        }
    }//GEN-LAST:event_jButtonMoveUpActionPerformed

    private void jList1ValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jList1ValueChanged

        
        if (jList1.getSelectedIndex() >= 0)
        {
            jButtonDelete.setEnabled(true);
            jButtonModify.setEnabled(true);
            jButtonMoveUp.setEnabled(jList1.getSelectedIndex() > 0);
            jButtonMoveDown.setEnabled(jList1.getSelectedIndex() < ((DefaultListModel)jList1.getModel()).size()-1);
        }
        else
        {
            jButtonModify.setEnabled(false);
            jButtonDelete.setEnabled(false);
            jButtonMoveUp.setEnabled(false);
            jButtonMoveDown.setEnabled(false);
        }
        
    }//GEN-LAST:event_jList1ValueChanged

    private void jList1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jList1MouseClicked

        if (evt.getButton() == evt.BUTTON1 && evt.getClickCount() == 2)
        {
            jButtonModifyActionPerformed(null);
        }
        
    }//GEN-LAST:event_jList1MouseClicked

    private void jButtonDeleteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeleteActionPerformed

        
        int[] indexes = jList1.getSelectedIndices();
        
        for (int i=indexes.length-1;  i>=0; --i)
        {
            ((DefaultListModel)jList1.getModel()).removeElementAt(indexes[i]);
        }
        
        
    }//GEN-LAST:event_jButtonDeleteActionPerformed

    private void jButtonModifyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModifyActionPerformed

        int index = jList1.getSelectedIndex();
        if (index >=0)
        {
                java.awt.Color c = (java.awt.Color)jList1.getSelectedValue();
                JColorChooser cc = new JColorChooser();
                c = cc.showDialog(this,"Pick a color",c);
                if (c != null)
                {
                    ((DefaultListModel)jList1.getModel()).setElementAt(c, index);
                }
        }
        
    }//GEN-LAST:event_jButtonModifyActionPerformed

    private void jButtonAddColorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAddColorActionPerformed
        
        JColorChooser cc = new JColorChooser();
        java.awt.Color c = cc.showDialog(this,"Pick a color",null);
        if (c != null)
        {
            ((DefaultListModel)jList1.getModel()).addElement(c);
        }
        
        
        
        
        
    }//GEN-LAST:event_jButtonAddColorActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new SeriesColorsDialog(new javax.swing.JFrame(), true).setVisible(true);
            }
        });
    }

    public int getDialogResult() {
        return dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public java.util.List getSeriescolors() {
        return seriescolors;
    }

    public void setSeriescolors(java.util.List seriescolors) {
        this.seriescolors = seriescolors;
        
        DefaultListModel dlm = (DefaultListModel)jList1.getModel();
        dlm.removeAllElements();
        
        for (int i=0; i<seriescolors.size(); ++i)
        {
            SeriesColor c = (SeriesColor)seriescolors.get(i);
            dlm.addElement(c.getColor());
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAddColor;
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonCopySeries;
    private javax.swing.JButton jButtonDelete;
    private javax.swing.JButton jButtonModify;
    private javax.swing.JButton jButtonMoveDown;
    private javax.swing.JButton jButtonMoveUp;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JButton jButtonPasteSeries;
    private javax.swing.JButton jButtonRandomColor;
    private javax.swing.JButton jButtonUseLast;
    private javax.swing.JList jList1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    // End of variables declaration//GEN-END:variables
    
}
