/*
 * ColorIcon.java
 *
 * Created on September 27, 2006, 10:35 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package it.businesslogic.ireport.gui.sheet;
import java.awt.*;
import javax.swing.*;

public class ColorIcon implements Icon, SwingConstants {
    private int width = 32;
    private int height = 14;
    private java.awt.Color theColor = java.awt.Color.WHITE;

    public ColorIcon(java.awt.Color c) {
    	theColor = c;
    }

    public int getIconHeight() {
        return height;
    }

    public int getIconWidth() {
        return width;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        
        Color c1 = theColor;
        Color c2 = Color.BLACK;
        
        if (theColor == null)
        {
            c1 = Color.WHITE;
            c2 = Color.GRAY;
        }
        g.setColor(c1);
        
        g.translate(x, y);
        g.fillRect(0, 0, width-1, height-1);
        g.setColor(c2);
        g.drawRect(0, 0, width-1, height-1);
        g.translate(-x, -y);   //Restore graphics object
    }
}
