/*
 * PageNumberObject.java
 *
 * Created on 17 settembre 2004, 19.15
 */

package it.businesslogic.ireport.gui.library.objects;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.gui.FieldPatternDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.library.*;
import javax.swing.JOptionPane;
/**
 *
 * @author  Administrator
 */
public class DateObject extends AbstractLibraryObject {
    
    private static javax.swing.ImageIcon defaultIcon;
    
    static {
        
        defaultIcon = new javax.swing.ImageIcon(AbstractLibraryObject.class.getResource("/it/businesslogic/ireport/icons/library/date.png"));
    }
    
    /** Creates a new instance of PageNumberObject */
    public DateObject() {
    }
    
    public String getName()
    {
        return it.businesslogic.ireport.util.I18n.getString("gui.library.objects.currentdate","Current date");
    }

    public void drop(java.awt.dnd.DropTargetDropEvent dtde) {
        
        FieldPatternDialog fpd = new FieldPatternDialog(MainFrame.getMainInstance(),true);
        fpd.setOnlyDate(true);
        fpd.setVisible(true);
        if (fpd.getDialogResult() == JOptionPane.OK_OPTION)
        {
            TextFieldReportElement re =  getReportFrame().dropNewTextField( dtde.getLocation(), "new java.util.Date()",  "java.util.Date", "Report");
            re.setPattern(fpd.getPattern());
            getReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(getReportFrame(), re, ReportElementChangedEvent.CHANGED));
        }
    }
    
     public javax.swing.ImageIcon getIcon()
    {
        return defaultIcon;
    }
    
}
