/*
 * JRParameterDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 9 maggio 2003, 17.25
 */
package it.businesslogic.ireport.crosstab.gui;

import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.crosstab.CrosstabCell;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.box.BoxPanel;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.util.Vector;


/**
 * @author Administrator
 */
public class CrosstabCellDialog
    extends javax.swing.JDialog
{
    private CrosstabCell tmpCell = null;
    private BoxPanel boxPanel = null;
    private java.awt.Color bgcolor = null;

    /**
     * Creates a new CrosstabGroupDialog object.
     * 
     * @param subDataset DOCUMENT ME!
     * @param parent DOCUMENT ME!
     * @param modal DOCUMENT ME!
     */
    public CrosstabCellDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initAll();
    }
    
    public CrosstabCellDialog(java.awt.Dialog parent, boolean modal)
    {
        super(parent, modal);
        initAll();
    }

    public void initAll()
    {
        initComponents();
        
        boxPanel = new BoxPanel();
        boxPanel.addActionListener( new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                boxActionPerformed(evt);
            }
        });
        
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = gridBagConstraints.BOTH;
        jPanelBorder.add(boxPanel, gridBagConstraints);
        
        //this.setSize(400, 400);
        pack();
        Misc.centerFrame(this);
        
        java.awt.Font font = jLabel1.getFont();
        jLabel1.setFont(new java.awt.Font(font.getFontName(), 1, 14));
        
        javax.swing.KeyStroke escape =  javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_ESCAPE, 0, false);
        javax.swing.Action escapeAction = new javax.swing.AbstractAction() {
            public void actionPerformed(java.awt.event.ActionEvent e) {
                jButtonCancelActionPerformed(e);
            }
        };
       
        getRootPane().getInputMap(javax.swing.JComponent.WHEN_IN_FOCUSED_WINDOW).put(escape, "ESCAPE");
        getRootPane().getActionMap().put("ESCAPE", escapeAction);


        //to make the default button ...
        this.getRootPane().setDefaultButton(this.jButtonOK);
        
    }


    public void  boxActionPerformed(java.awt.event.ActionEvent evt)
    {
       
        
    }

    /**
     * This method is called from within the constructor to initialize the
     * form. WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */


    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelWidth = new javax.swing.JLabel();
        jNumberFieldWidth = new it.businesslogic.ireport.gui.JNumberField();
        jLabelHeight = new javax.swing.JLabel();
        jNumberFieldHeight = new it.businesslogic.ireport.gui.JNumberField();
        jPanelBorder = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jLabelWidth1 = new javax.swing.JLabel();
        jButtonBackground = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jButtonOK = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        jCheckBoxTransparent = new javax.swing.JCheckBox();
        jLabelStyle = new javax.swing.JLabel();
        jComboBoxstyles = new javax.swing.JComboBox();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Modify cell");
        setModal(true);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jLabelWidth.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabelWidth.setText("Column width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        getContentPane().add(jLabelWidth, gridBagConstraints);

        jNumberFieldWidth.setColumns(4);
        jNumberFieldWidth.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        try {
            jNumberFieldWidth.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jNumberFieldWidth.setMinimumSize(new java.awt.Dimension(40, 21));
        jNumberFieldWidth.setPreferredSize(new java.awt.Dimension(38, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jNumberFieldWidth, gridBagConstraints);

        jLabelHeight.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabelHeight.setText("Row height");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        getContentPane().add(jLabelHeight, gridBagConstraints);

        jNumberFieldHeight.setColumns(4);
        jNumberFieldHeight.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        try {
            jNumberFieldHeight.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jNumberFieldHeight.setMinimumSize(new java.awt.Dimension(40, 21));
        jNumberFieldHeight.setPreferredSize(new java.awt.Dimension(38, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 6, 3);
        getContentPane().add(jNumberFieldHeight, gridBagConstraints);

        jPanelBorder.setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jPanelBorder, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jLabelWidth1.setText("Cell background color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(3, 14, 3, 3);
        jPanel2.add(jLabelWidth1, gridBagConstraints);

        jButtonBackground.setBackground(new java.awt.Color(0, 0, 0));
        jButtonBackground.setMaximumSize(new java.awt.Dimension(45, 20));
        jButtonBackground.setMinimumSize(new java.awt.Dimension(45, 20));
        jButtonBackground.setPreferredSize(new java.awt.Dimension(45, 20));
        jButtonBackground.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBackgroundActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jButtonBackground, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        getContentPane().add(jPanel2, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jPanel1.setMinimumSize(new java.awt.Dimension(126, 40));
        jPanel1.setPreferredSize(new java.awt.Dimension(126, 40));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jPanel4, gridBagConstraints);

        jButtonOK.setMnemonic('o');
        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        jPanel1.add(jButtonOK, gridBagConstraints);

        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
        jPanel1.add(jButtonCancel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jPanel1, gridBagConstraints);

        jLabel1.setText("Cell name");
        jLabel1.setMaximumSize(new java.awt.Dimension(34, 23));
        jLabel1.setMinimumSize(new java.awt.Dimension(34, 23));
        jLabel1.setPreferredSize(new java.awt.Dimension(34, 23));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jLabel1, gridBagConstraints);

        jSeparator1.setMinimumSize(new java.awt.Dimension(0, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 4, 0);
        getContentPane().add(jSeparator1, gridBagConstraints);

        jCheckBoxTransparent.setText("Transparent");
        jCheckBoxTransparent.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxTransparent.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 14, 0, 0);
        getContentPane().add(jCheckBoxTransparent, gridBagConstraints);

        jLabelStyle.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabelStyle.setText("Cell style");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 40;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        getContentPane().add(jLabelStyle, gridBagConstraints);

        jComboBoxstyles.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBoxstyles.setPreferredSize(new java.awt.Dimension(200, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 40;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        getContentPane().add(jComboBoxstyles, gridBagConstraints);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        java.awt.Dimension dialogSize = getSize();
        setLocation((screenSize.width-dialogSize.width)/2,(screenSize.height-dialogSize.height)/2);
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonBackgroundActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBackgroundActionPerformed
        
         bgcolor = javax.swing.JColorChooser.showDialog( null, "Select background color...",
                this.jButtonBackground.getBackground());
         
         if (bgcolor != null)
         {
             this.jButtonBackground.setBackground( bgcolor );
         }
         else
         {
             bgcolor = this.jButtonBackground.getBackground();
         }
         
    }//GEN-LAST:event_jButtonBackgroundActionPerformed
    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonCancelActionPerformed
    {
        setVisible(false);
        this.setDialogResult(javax.swing.JOptionPane.CANCEL_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonOKActionPerformed
    {
        
        tmpCell = new CrosstabCell();
        tmpCell.setBox( boxPanel.getBox() );
        tmpCell.setWidth( (int)this.jNumberFieldWidth.getValue());
        tmpCell.setHeight( (int)this.jNumberFieldHeight.getValue());
        tmpCell.setBackcolor( bgcolor );
        tmpCell.setMode( (jCheckBoxTransparent.isSelected()) ? "Transparent" : "Opaque" );
        if (jComboBoxstyles.getSelectedIndex() > 0)
        {
            tmpCell.setStyle( (Style)jComboBoxstyles.getSelectedItem() );
        }
        
        setVisible(false);
        this.setDialogResult(javax.swing.JOptionPane.OK_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed

    /**
     * Closes the dialog
     * @param evt DOCUMENT ME!
     */
    private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
    {
        setVisible(false);
        this.setDialogResult(javax.swing.JOptionPane.CLOSED_OPTION);
        dispose();
    }//GEN-LAST:event_closeDialog


    /**
     * Getter for property dialogResult.
     * 
     * @return Value of property dialogResult.
     */
    public int getDialogResult()
    {

        return dialogResult;
    }

    /**
     * Setter for property dialogResult.
     * 
     * @param dialogResult New value of property dialogResult.
     */
    public void setDialogResult(int dialogResult)
    {
        this.dialogResult = dialogResult;
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonBackground;
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JCheckBox jCheckBoxTransparent;
    private javax.swing.JComboBox jComboBoxstyles;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabelHeight;
    private javax.swing.JLabel jLabelStyle;
    private javax.swing.JLabel jLabelWidth;
    private javax.swing.JLabel jLabelWidth1;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldHeight;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldWidth;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanelBorder;
    private javax.swing.JSeparator jSeparator1;
    // End of variables declaration//GEN-END:variables
    private int dialogResult;

    public CrosstabCell getTmpCell() {
        return tmpCell;
    }

    public void setTmpCell(CrosstabCell selectedCell) {
        
        
        this.jComboBoxstyles.removeAllItems();
        
        this.jComboBoxstyles.addItem("");
        Vector styles = MainFrame.getMainInstance().getActiveReportFrame().getReport().getStyles();
        for (int i=0; i < styles.size(); ++i)
        {
            jComboBoxstyles.addItem( styles.elementAt(i));
        }
        
        this.setBgcolor( selectedCell.getBackcolor());
        if (bgcolor != null)  this.jButtonBackground.setBackground( bgcolor );
        else this.jButtonBackground.setBackground( Color.WHITE );
        
        this.jLabel1.setText( selectedCell.getName() );
        
        this.boxPanel.setBox( selectedCell.getBox().cloneMe());
        
        this.jCheckBoxTransparent.setSelected( selectedCell.getMode().equals("Transparent"));
                
        // If this cell spans on more than once row, we don't want modify the height 
        if (selectedCell.getTopIndex() < selectedCell.getBottomIndex() - 1)
        {
               this.jNumberFieldHeight.setEditable( false );
        }

        // If this cell spans on more than once column, we don't want modify the width 
        if (selectedCell.getLeftIndex() < selectedCell.getRightIndex() - 1)
        {
              this.jNumberFieldWidth.setEditable( false );
        }
        
        try {
           this.jNumberFieldWidth.setValue( selectedCell.getWidth());
            this.jNumberFieldHeight.setValue( selectedCell.getHeight());
        } catch (Exception ex)
        {
            
        }
        
        if (selectedCell.getStyle() != null)
        {
            jComboBoxstyles.setSelectedItem(selectedCell.getStyle());
        }
        else jComboBoxstyles.setSelectedIndex(0);
        
    }

    public BoxPanel getBoxPanel() {
        return boxPanel;
    }

    public void setBoxPanel(BoxPanel boxPanel) {
        this.boxPanel = boxPanel;
    }

    public java.awt.Color getBgcolor() {
        return bgcolor;
    }

    public void setBgcolor(java.awt.Color bgcolor) {
        this.bgcolor = bgcolor;
    }

}
