/*
 * JRCustomDataSource.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 4 giugno 2003, 18.15
 */

package it.businesslogic.ireport.connection;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.util.*;
import java.net.URLClassLoader;
import java.sql.*;
import java.util.HashMap;
import java.util.List;
import javax.swing.*;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

/**
 *
 * @author  Administrator
 */
public class EJBQLConnection extends it.businesslogic.ireport.IReportConnection {
    
    private String name;
    
    private java.util.HashMap map = null;
    private String persistenceUnit;
    
    private EntityManager em = null;
    private EntityManagerFactory emf = null;
    
    private int usedby = 0;
    
    /** Creates a new instance of JDBCConnection */
    
    
    public EJBQLConnection() {
        map = new java.util.HashMap();
    }
    
    /**  This method return an instanced connection to the database.
     *  If isJDBCConnection() return false => getConnection() return null
     *
     */
    public java.sql.Connection getConnection() {       
            return null;
    }
    
    public boolean isJDBCConnection() {
        return false;
    }
    
    public boolean isJRDataSource() {
        return false;
    }
    
    /*
     *  This method return all properties used by this connection
     */
    public java.util.HashMap getProperties()
    {    
        return map;
    }
    
    public void loadProperties(java.util.HashMap map)
    {
        this.map = map;
    }
    
    public String getDescription(){ return "EJBQL connection"; }
    
    
    /**
     *  This method return an instanced JRDataDource to the database.
     *  If isJDBCConnection() return true => getJRDataSource() return false
     */
    public net.sf.jasperreports.engine.JRDataSource getJRDataSource()
    { 
        return null;
    }
    
    public EntityManager getEntityManager() throws Exception 
    {           
            if (em == null)
            {
                if (emf == null)
                {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl instanceof ReportClassLoader)
                    {
                        List items = ((ReportClassLoader)cl).getCachedItems();
                        
                        java.net.URL[] urls = new java.net.URL[items.size()];
                        for (int i=0; i<items.size(); ++i)
                        {
                            urls[i] = new java.io.File(""+items.get(i)).toURL();
                        }
                        URLClassLoader urlClassLoader = new URLClassLoader(urls,  cl );
                        Thread.currentThread().setContextClassLoader(urlClassLoader  );
                    }
                    
                    
                    emf = Persistence.createEntityManagerFactory( 
                            Misc.nvl(getProperties().get("PersistenceUnit"), null), new HashMap());
                    //if (emf == null) throw new Exception("Unable to create the EntityManagerFactory for persistence unit " + Misc.nvl(getProperties().get("PersistenceUnit"), null));
                    //Thread.currentThread().setContextClassLoader().
                }
                em = emf.createEntityManager();
            }
            usedby ++;
            return em;
    }
    
    public void closeEntityManager()
    {
        try {
            if (em != null)
            {
                usedby--;
                if (usedby == 0)
                {
                    em.close();
                    em = null;
                }
            }
        } catch (Exception ex)
        {
        }
    }   
   
}
