/*
 * ComboBoxRenderer.java
 *
 * Created on 2 ottobre 2004, 16.59
 */

package it.businesslogic.ireport.chart.gui;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.Misc;
import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;

/**
 *
 * @author  Administrator
 */
public class TagComboBoxRenderer extends JComboBox implements TableCellRenderer {
        
         /*
          * Create a TagComboBoxRenderer with a set of Tag elements
          */
         public TagComboBoxRenderer(java.util.Vector tags) {
            super(tags);
            setEditable(true);
            setMinimumSize(new java.awt.Dimension(1,23));
            setPreferredSize(new java.awt.Dimension(1,23));
        
         }
    
        public Component getTableCellRendererComponent(JTable table, Object value,
                boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                setForeground(table.getForeground());
                setBackground(table.getBackground());
            }
    
            // Select the current value
            if (value instanceof Tag)
            {
                setSelectedItem(value);
            }
            else
            {
                Misc.setComboboxSelectedTagValue( this,  "" + value);
            }
            return this;
        }
    }

