/*
 * PiePlot.java
 *
 * Created on 16 agosto 2005, 10.19
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package it.businesslogic.ireport.chart;

/**
 *
 * @author Administrator
 */
public class BarPlot extends Plot{
    
    private boolean showLabels = false;
    private boolean showTickMarks = true;
    private boolean showTickLabels = true;
    
    private String categoryAxisLabelExpression = "";
    private String valueAxisLabelExpression = "";
    
    private AxisFormat categoryAxisFormat = new AxisFormat();
    private AxisFormat valueAxisFormat = new AxisFormat();
    
    /** Creates a new instance of PiePlot */
    public BarPlot() {
    }

    public boolean isShowLabels() {
        return showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    public boolean isShowTickMarks() {
        return showTickMarks;
    }

    public void setShowTickMarks(boolean showTickMarks) {
        this.showTickMarks = showTickMarks;
    }

    public boolean isShowTickLabels() {
        return showTickLabels;
    }

    public void setShowTickLabels(boolean showTickLabels) {
        this.showTickLabels = showTickLabels;
    }

    public String getCategoryAxisLabelExpression() {
        return categoryAxisLabelExpression;
    }

    public void setCategoryAxisLabelExpression(String categoryAxisLabelExpression) {
        this.categoryAxisLabelExpression = categoryAxisLabelExpression;
    }

    public String getValueAxisLabelExpression() {
        return valueAxisLabelExpression;
    }

    public void setValueAxisLabelExpression(String valueAxisLabelExpression) {
        this.valueAxisLabelExpression = valueAxisLabelExpression;
    }
    
     public Plot cloneMe()
    {
        BarPlot obj = new BarPlot();
        copyBasePlot(obj);
        obj.setShowLabels( this.isShowLabels());
        obj.setShowTickLabels( this.isShowTickLabels());
        obj.setShowTickMarks( this.isShowTickMarks());
        obj.setCategoryAxisLabelExpression( this.getCategoryAxisLabelExpression());
        obj.setValueAxisLabelExpression( this.getValueAxisLabelExpression());
        obj.setCategoryAxisFormat( getCategoryAxisFormat().cloneMe());
        obj.setValueAxisFormat( getValueAxisFormat().cloneMe());
       
        return obj;
    }

    public AxisFormat getCategoryAxisFormat() {
        return categoryAxisFormat;
    }

    public void setCategoryAxisFormat(AxisFormat categoryAxisFormat) {
        this.categoryAxisFormat = categoryAxisFormat;
    }

    public AxisFormat getValueAxisFormat() {
        return valueAxisFormat;
    }

    public void setValueAxisFormat(AxisFormat valueAxisFormat) {
        this.valueAxisFormat = valueAxisFormat;
    }
}
