/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.MemberFormatter;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.Visitor;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

public abstract class LevelBase
extends OlapElementBase
implements Level {
    protected final Hierarchy hierarchy;
    protected final String name;
    protected final String uniqueName;
    protected String description;
    protected final int depth;
    protected final mondrian.olap.LevelType levelType;
    protected MemberFormatter memberFormatter;

    protected LevelBase(Hierarchy hierarchy, String name, int depth, mondrian.olap.LevelType levelType) {
        this.hierarchy = hierarchy;
        this.name = name;
        this.uniqueName = Util.makeFqName(hierarchy, name);
        this.depth = depth;
        this.levelType = levelType;
    }

    public String getQualifiedName() {
        return MondrianResource.instance().MdxLevelName.str(this.getUniqueName());
    }

    public int getCategory() {
        return 4;
    }

    public Type getTypeX() {
        return new LevelType(this.hierarchy, this);
    }

    public mondrian.olap.LevelType getLevelType() {
        return this.levelType;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public Dimension getDimension() {
        return this.hierarchy.getDimension();
    }

    public int getDepth() {
        return this.depth;
    }

    public Level getChildLevel() {
        int childDepth = this.depth + 1;
        Level[] levels = this.hierarchy.getLevels();
        return childDepth < levels.length ? levels[childDepth] : null;
    }

    public Level getParentLevel() {
        int parentDepth = this.depth - 1;
        Level[] levels = this.hierarchy.getLevels();
        return parentDepth >= 0 ? levels[parentDepth] : null;
    }

    public abstract boolean isAll();

    public boolean isMeasure() {
        return this.hierarchy.getName().equals("Measures");
    }

    public OlapElement lookupChild(SchemaReader schemaReader, String s) {
        return this.areMembersUnique() ? Util.lookupHierarchyRootMember(schemaReader, this.hierarchy, s) : null;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
    }

    public MemberFormatter getMemberFormatter() {
        return this.memberFormatter;
    }
}

