/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.BarcodeReportElement;
import it.businesslogic.ireport.Box;
import it.businesslogic.ireport.BoxElement;
import it.businesslogic.ireport.ChartReportElement;
import it.businesslogic.ireport.ChartReportElement2;
import it.businesslogic.ireport.CompatibilitySupport;
import it.businesslogic.ireport.ConditionedStyle;
import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.EllipseReportElement;
import it.businesslogic.ireport.FrameReportElement;
import it.businesslogic.ireport.GraphicReportElement;
import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.HyperLinkableReportElement;
import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRLinkParameter;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRProperty;
import it.businesslogic.ireport.JRSubreportParameter;
import it.businesslogic.ireport.JRSubreportReturnValue;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.LineReportElement;
import it.businesslogic.ireport.RectangleReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.ScriptletCode;
import it.businesslogic.ireport.StaticTextReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.SubReportElement;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.TextReportElement;
import it.businesslogic.ireport.TransformationType;
import it.businesslogic.ireport.chart.AreaChart;
import it.businesslogic.ireport.chart.AreaPlot;
import it.businesslogic.ireport.chart.Bar3DChart;
import it.businesslogic.ireport.chart.Bar3DPlot;
import it.businesslogic.ireport.chart.BarChart;
import it.businesslogic.ireport.chart.BarPlot;
import it.businesslogic.ireport.chart.BubbleChart;
import it.businesslogic.ireport.chart.BubblePlot;
import it.businesslogic.ireport.chart.CandlestickChart;
import it.businesslogic.ireport.chart.CandlestickPlot;
import it.businesslogic.ireport.chart.CategoryDataset;
import it.businesslogic.ireport.chart.CategorySeries;
import it.businesslogic.ireport.chart.Dataset;
import it.businesslogic.ireport.chart.HighLowChart;
import it.businesslogic.ireport.chart.HighLowDataset;
import it.businesslogic.ireport.chart.HighLowPlot;
import it.businesslogic.ireport.chart.LineChart;
import it.businesslogic.ireport.chart.LinePlot;
import it.businesslogic.ireport.chart.Pie3DChart;
import it.businesslogic.ireport.chart.Pie3DPlot;
import it.businesslogic.ireport.chart.PieChart;
import it.businesslogic.ireport.chart.PieDataset;
import it.businesslogic.ireport.chart.PiePlot;
import it.businesslogic.ireport.chart.Plot;
import it.businesslogic.ireport.chart.ScatterChart;
import it.businesslogic.ireport.chart.ScatterPlot;
import it.businesslogic.ireport.chart.SectionItemHyperlink;
import it.businesslogic.ireport.chart.StackedBar3DChart;
import it.businesslogic.ireport.chart.StackedBarChart;
import it.businesslogic.ireport.chart.TimePeriodDataset;
import it.businesslogic.ireport.chart.TimePeriodSeries;
import it.businesslogic.ireport.chart.TimeSeries;
import it.businesslogic.ireport.chart.TimeSeriesChart;
import it.businesslogic.ireport.chart.TimeSeriesDataset;
import it.businesslogic.ireport.chart.TimeSeriesPlot;
import it.businesslogic.ireport.chart.XYAreaChart;
import it.businesslogic.ireport.chart.XYBarChart;
import it.businesslogic.ireport.chart.XYDataset;
import it.businesslogic.ireport.chart.XYLineChart;
import it.businesslogic.ireport.chart.XYSeries;
import it.businesslogic.ireport.chart.XYZDataset;
import it.businesslogic.ireport.chart.XYZSeries;
import it.businesslogic.ireport.crosstab.CrosstabCell;
import it.businesslogic.ireport.crosstab.CrosstabColumnGroup;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.crosstab.CrosstabParameter;
import it.businesslogic.ireport.crosstab.CrosstabRowGroup;
import it.businesslogic.ireport.crosstab.Measure;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportDocumentStatusChangedEvent;
import it.businesslogic.ireport.gui.event.ReportDocumentStatusChangedListener;
import it.businesslogic.ireport.gui.event.ReportSubDatasetChangedEvent;
import it.businesslogic.ireport.gui.event.ReportSubDatasetChangedListener;
import it.businesslogic.ireport.gui.event.StyleChangedEvent;
import it.businesslogic.ireport.gui.event.StyleChangedListener;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedEvent;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedListener;
import it.businesslogic.ireport.gui.sheet.ColorSelectorPanel;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import it.businesslogic.ireport.util.PageSize;
import it.businesslogic.ireport.util.TreeNode;
import java.awt.Color;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Report
extends SubDataset
implements SubDatasetObjectChangedListener {
    public static int SCRIPTLET_IREPORT_INTERNAL_HANDLING = 1;
    public static int SCRIPTLET_NOT_USED = 0;
    public static int SCRIPTLET_CLASSIC_HANDLING = 2;
    private int nextGroupId = 0;
    private IReportFont defaultFont = new IReportFont();
    private boolean readOnly = false;
    private int height = 0;
    private int width = 0;
    private Vector elements = new Vector();
    private Vector bands = new Vector();
    private Vector imports = new Vector();
    private String filename = "";
    private Vector subDatasets = new Vector();
    private String encoding = "UTF-8";
    private int columnCount = 1;
    private String printOrder = "Vertical";
    private String orientation = "Portrait";
    private String whenNoDataType = "NoPages";
    private int columnWidth = 535;
    private int columnSpacing = 0;
    private int leftMargin = 20;
    private int rightMargin = 20;
    private int topMargin = 30;
    private int bottomMargin = 30;
    private boolean isTitleNewPage = false;
    private boolean isSummaryNewPage = false;
    private long loadTime = 0L;
    private Vector fonts = new Vector();
    private Vector styles = new Vector();
    private JReportFrame reportFrame;
    private String reportFormat;
    static int untitledId = 1;
    private int reportChanges = 1;
    private boolean floatColumnFooter = false;
    private boolean ignorePagination = false;
    protected boolean usingMultiLineExpressions = false;
    private String language = "java";
    private ScriptletCode scripletCode;
    private int scriptletHandling = 2;
    private HashMap proposedValues = null;
    private boolean loadingFile = false;
    private EventListenerList listenerList = null;
    static /* synthetic */ Class class$it$businesslogic$ireport$gui$event$SubDatasetObjectChangedListener;

    public Report() {
        this.setName(I18n.getString("untitledReport", "untitled_report_") + untitledId);
        ++untitledId;
        this.proposedValues = new HashMap();
        this.getKeywordLookup().addKeyword("$R{*}");
        this.bands.addElement(new Band(this, "background", 0));
        this.bands.addElement(new Band(this, "title", 50));
        this.bands.addElement(new Band(this, "pageHeader", 50));
        this.bands.addElement(new Band(this, "columnHeader", 30));
        this.bands.addElement(new Band(this, "detail", 100));
        this.bands.addElement(new Band(this, "columnFooter", 30));
        this.bands.addElement(new Band(this, "pageFooter", 50));
        this.bands.addElement(new Band(this, "lastPageFooter", 50));
        this.bands.addElement(new Band(this, "summary", 50));
        this.addImport("java.util.*");
        this.addImport("net.sf.jasperreports.engine.*");
        this.addImport("net.sf.jasperreports.engine.data.*");
        try {
            this.scripletCode = new ScriptletCode(ScriptletCode.class.getClassLoader().getResourceAsStream("scriptlet_template.jav"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setLanguage(MainFrame.getMainInstance().getProperties().getProperty("DefaultScriptingLanguage", "java"));
        this.addSubDatasetObjectChangedListener(this);
    }

    public Report(String xmlFile) throws Exception {
        this();
        this.setLanguage("java");
        --untitledId;
        for (int i = 0; i < this.bands.size(); ++i) {
            ((Band)this.bands.elementAt(i)).setHeight(0);
        }
        try {
            int i;
            InputStream input_source = null;
            if (xmlFile.toLowerCase().endsWith(".jasper")) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                JasperReport jreport = JasperManager.loadReport((String)xmlFile);
                JasperCompileManager.writeReportToXmlStream((JRReport)jreport, (OutputStream)bos);
                input_source = new ByteArrayInputStream(bos.toByteArray());
            } else {
                this.setFilename(xmlFile);
                this.checkReadOnlyFlag();
                this.setLoadTime(Misc.getLastWriteTime(xmlFile));
                File ffile = new File(xmlFile);
                input_source = ffile.exists() ? new FileInputStream(ffile) : this.getClass().getClassLoader().getResourceAsStream(xmlFile);
            }
            DOMParser parser = new DOMParser();
            parser.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    InputSource inputSource = null;
                    if (systemId != null) {
                        InputStream is;
                        String dtd = null;
                        if (systemId.equals("http://jasperreports.sourceforge.net/dtds/jasperreport.dtd") || systemId.equals("http://www.jasperreports.com/dtds/jasperreport.dtd")) {
                            dtd = "net/sf/jasperreports/engine/dtds/jasperreport.dtd";
                        } else if (systemId.equals("http://jasperreports.sourceforge.net/dtds/jasperprint.dtd") || systemId.equals("http://www.jasperreports.com/dtds/jasperprint.dtd")) {
                            dtd = "net/sf/jasperreports/engine/dtds/jasperprint.dtd";
                        } else {
                            return new InputSource(systemId);
                        }
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        URL url = null;
                        if (classLoader != null && (url = classLoader.getResource(dtd)) == null) {
                            classLoader = this.getClass().getClassLoader();
                        }
                        if ((is = classLoader.getResourceAsStream(dtd)) != null) {
                            InputStreamReader isr = new InputStreamReader(is);
                            inputSource = new InputSource(isr);
                        } else {
                            throw new IOException("iReport Internal error in report.java: Could not find: " + dtd + "\n");
                        }
                    }
                    return inputSource;
                }
            });
            InputSource input_sss = new InputSource(input_source);
            input_sss.setSystemId("file:///" + this.getFilename());
            parser.parse(input_sss);
            Document document = parser.getDocument();
            this.setEncoding(Misc.nvl(input_sss.getEncoding(), "UTF-8"));
            this.traverse(document.getDocumentElement());
            this.setReportFormat(PageSize.deductPageFormat(this.getWidth(), this.getHeight()));
            for (i = 0; i < this.getGroups().size(); ++i) {
                Group grp = (Group)this.getGroups().elementAt(i);
                this.addGroup(grp, false);
            }
            for (i = 0; i < this.elements.size(); ++i) {
                ReportElement re = (ReportElement)this.elements.elementAt(i);
                if (re.getParentElement() != null) {
                    re.trasform(new Point((int)re.getParentElement().getPosition().getX(), (int)re.getParentElement().getPosition().getY()), TransformationType.TRANSFORMATION_MOVE);
                    continue;
                }
                re.trasform(new Point(this.getLeftMargin() + 10, this.getBandYLocation(re.getBand()) + 10), TransformationType.TRANSFORMATION_MOVE);
            }
            if (this.getScriptletFileName() != null) {
                this.setScriptletHandling(SCRIPTLET_CLASSIC_HANDLING);
            }
            for (int pk = 0; pk < this.getJRproperties().size(); ++pk) {
                JRProperty prop = (JRProperty)this.getJRproperties().elementAt(pk);
                if (prop.getName().equals("ireport.scriptlethandling")) {
                    if (prop.getValue().equals("0")) {
                        this.setScriptletHandling(0);
                    } else if (prop.getValue().equals("1")) {
                        this.setScriptletHandling(SCRIPTLET_IREPORT_INTERNAL_HANDLING);
                        File scriptletFile = new File(this.getScriptletFileName());
                        if (scriptletFile.exists()) {
                            this.scripletCode = new ScriptletCode(this.getScriptletFileName());
                        }
                    }
                }
                if (prop.getName().equals("ireport.encoding")) {
                    this.setEncoding(prop.getValue());
                }
                if (!prop.getValue().startsWith("ireport.")) continue;
                this.getJRproperties().remove(prop);
                --pk;
            }
            if (this.getScriptletHandling() == 2 && (this.getScriptletClass() == null || this.getScriptletClass().equals(""))) {
                this.setScriptletHandling(0);
            }
        }
        catch (IOException e) {
            System.out.println(e);
            e.printStackTrace();
            throw e;
        }
        catch (JRException e) {
            System.out.println((Object)e);
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
        this.setReportChanges(0);
    }

    private void traverse(Node node) {
        NodeList children;
        Band b;
        Node bandNode;
        boolean seeInside = false;
        if (node.getNodeType() == 1 && node.getNodeName().equals("jasperReport")) {
            seeInside = true;
            NamedNodeMap nnm = node.getAttributes();
            this.setName(nnm.getNamedItem("name") != null ? nnm.getNamedItem("name").getNodeValue() : "");
            if (nnm.getNamedItem("columnCount") != null) {
                this.setColumnCount(Integer.parseInt(nnm.getNamedItem("columnCount").getNodeValue()));
            }
            if (nnm.getNamedItem("printOrder") != null) {
                this.setPrintOrder(nnm.getNamedItem("printOrder").getNodeValue());
            }
            if (nnm.getNamedItem("orientation") != null) {
                this.setOrientation(nnm.getNamedItem("orientation").getNodeValue());
            }
            if (nnm.getNamedItem("scriptletClass") != null) {
                this.setScriptletClass(nnm.getNamedItem("scriptletClass").getNodeValue());
            }
            if (nnm.getNamedItem("resourceBundle") != null) {
                this.setResourceBundleBaseName(nnm.getNamedItem("resourceBundle").getNodeValue());
            }
            if (nnm.getNamedItem("pageWidth") != null) {
                this.setWidth(Integer.parseInt(nnm.getNamedItem("pageWidth").getNodeValue()));
            }
            if (nnm.getNamedItem("pageHeight") != null) {
                this.setHeight(Integer.parseInt(nnm.getNamedItem("pageHeight").getNodeValue()));
            }
            if (nnm.getNamedItem("columnWidth") != null) {
                this.setColumnWidth(Integer.parseInt(nnm.getNamedItem("columnWidth").getNodeValue()));
            }
            if (nnm.getNamedItem("columnSpacing") != null) {
                this.setColumnSpacing(Integer.parseInt(nnm.getNamedItem("columnSpacing").getNodeValue()));
            }
            if (nnm.getNamedItem("leftMargin") != null) {
                this.setLeftMargin(Integer.parseInt(nnm.getNamedItem("leftMargin").getNodeValue()));
            }
            if (nnm.getNamedItem("rightMargin") != null) {
                this.setRightMargin(Integer.parseInt(nnm.getNamedItem("rightMargin").getNodeValue()));
            }
            if (nnm.getNamedItem("topMargin") != null) {
                this.setTopMargin(Integer.parseInt(nnm.getNamedItem("topMargin").getNodeValue()));
            }
            if (nnm.getNamedItem("bottomMargin") != null) {
                this.setBottomMargin(Integer.parseInt(nnm.getNamedItem("bottomMargin").getNodeValue()));
            }
            if (nnm.getNamedItem("whenNoDataType") != null) {
                this.setWhenNoDataType(nnm.getNamedItem("whenNoDataType").getNodeValue());
            }
            if (nnm.getNamedItem("isTitleNewPage") != null) {
                this.setIsTitleNewPage(nnm.getNamedItem("isTitleNewPage").getNodeValue().equalsIgnoreCase("true"));
            }
            if (nnm.getNamedItem("isSummaryNewPage") != null) {
                this.setIsSummaryNewPage(nnm.getNamedItem("isSummaryNewPage").getNodeValue().equalsIgnoreCase("true"));
            }
            if (nnm.getNamedItem("isFloatColumnFooter") != null) {
                this.setFloatColumnFooter(nnm.getNamedItem("isFloatColumnFooter").getNodeValue().equalsIgnoreCase("true"));
            }
            if (nnm.getNamedItem("language") != null) {
                this.setLanguage(nnm.getNamedItem("language").getNodeValue());
            }
            if (nnm.getNamedItem("whenResourceMissingType") != null) {
                this.setWhenResourceMissingType(nnm.getNamedItem("whenResourceMissingType").getNodeValue());
            }
            if (nnm.getNamedItem("isIgnorePagination") != null) {
                this.setIgnorePagination(nnm.getNamedItem("isIgnorePagination").getNodeValue().equalsIgnoreCase("true"));
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("property")) {
            JRProperty property = this.readPropertyElement(node);
            if (property.getName() != null && property.getName().length() != 0) {
                this.addJRProperty(property);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("import")) {
            NamedNodeMap nnm = node.getAttributes();
            if (nnm.getNamedItem("value") != null) {
                this.addImport(nnm.getNamedItem("value").getNodeValue());
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("reportFont")) {
            boolean isDefaultFont = false;
            IReportFont font = new IReportFont();
            NamedNodeMap nnm = node.getAttributes();
            for (int kkk = 0; kkk < nnm.getLength(); ++kkk) {
                String propName = nnm.item(kkk).getNodeName();
                String propValue = nnm.item(kkk).getNodeValue();
                if (propName == null || propValue == null) continue;
                if (propName.equals("name")) {
                    font.setReportFont(propValue);
                }
                if (propName.equals("isDefault")) {
                    isDefaultFont = propValue.equals("true");
                    font.setDefaultFont(isDefaultFont);
                }
                if (propName.equals("fontName")) {
                    font.setFontName(propValue);
                    continue;
                }
                if (propName.equals("pdfFontName")) {
                    font.setPDFFontName(propValue);
                    continue;
                }
                if (propName.equals("size")) {
                    font.setFontSize(Integer.parseInt("" + propValue));
                    continue;
                }
                if (propName.equals("isBold")) {
                    font.setBold(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isItalic")) {
                    font.setItalic(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isUnderline")) {
                    font.setUnderline(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isStrikeThrough")) {
                    font.setStrikeTrought(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isPdfEmbedded")) {
                    font.setPdfEmbedded(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (!propName.equals("pdfEncoding")) continue;
                font.setPdfEncoding("" + propValue);
            }
            if (isDefaultFont) {
                this.defaultFont = (IReportFont)font.clone();
            }
            this.fonts.addElement(font);
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("style")) {
            Style style = this.readStyle(node);
            this.styles.addElement(style);
            for (int i = 0; i < this.getStyles().size(); ++i) {
                Style s = (Style)this.getStyles().elementAt(i);
                if (s.getAttribute("style") == null) continue;
                if (s.getAttribute("style") instanceof Style) continue;
                for (int j = 0; j < this.getStyles().size(); ++j) {
                    Style sparent = (Style)this.getStyles().elementAt(j);
                    if (!sparent.getName().equals(s.getAttribute("style") + "")) continue;
                    s.getAttributes().put("style", sparent);
                }
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("parameter")) {
            JRParameter parameter = this.readParameterElement(node);
            if (parameter.getName() != null && parameter.getName().length() != 0) {
                this.addParameter(parameter);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("queryString")) {
            NamedNodeMap nnm = node.getAttributes();
            if (nnm.getNamedItem("language") != null) {
                this.setQueryLanguage(nnm.getNamedItem("language").getNodeValue());
            }
            this.setQuery(Report.readPCDATA(node));
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("filterExpression")) {
            this.setFilterExpression(Report.readPCDATA(node));
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("field")) {
            JRField field = this.readFieldElement(node);
            if (field.getName() != null && field.getName().length() != 0) {
                this.addField(field);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("variable")) {
            JRVariable variable = this.readVariableElement(node);
            if (variable.getName() != null && variable.getName().length() != 0) {
                this.addVariable(variable);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("subDataset")) {
            SubDataset subDataset = new SubDataset();
            NamedNodeMap nnm = node.getAttributes();
            if (nnm.getNamedItem("scriptletClass") != null) {
                subDataset.setScriptletClass(nnm.getNamedItem("scriptletClass").getNodeValue());
            }
            if (nnm.getNamedItem("resourceBundle") != null) {
                subDataset.setResourceBundleBaseName(nnm.getNamedItem("resourceBundle").getNodeValue());
            }
            if (nnm.getNamedItem("whenResourceMissingType") != null) {
                subDataset.setWhenResourceMissingType(nnm.getNamedItem("whenResourceMissingType").getNodeValue());
            }
            subDataset.setName(nnm.getNamedItem("name") != null ? nnm.getNamedItem("name").getNodeValue() : "SubDataset");
            NodeList children2 = node.getChildNodes();
            if (children2 != null) {
                for (int k = 0; k < children2.getLength(); ++k) {
                    Node nodeChild = children2.item(k);
                    if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("property")) {
                        JRProperty property = this.readPropertyElement(nodeChild);
                        if (property.getName() == null || property.getName().length() == 0) continue;
                        subDataset.addJRProperty(property);
                        continue;
                    }
                    if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("parameter")) {
                        JRParameter parameter = this.readParameterElement(nodeChild);
                        if (parameter.getName() == null || parameter.getName().length() == 0) continue;
                        subDataset.addParameter(parameter);
                        continue;
                    }
                    if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("field")) {
                        JRField field = this.readFieldElement(nodeChild);
                        if (field.getName() == null || field.getName().length() == 0) continue;
                        subDataset.addField(field);
                        continue;
                    }
                    if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("variable")) {
                        JRVariable variable = this.readVariableElement(nodeChild);
                        if (variable.getName() == null || variable.getName().length() == 0) continue;
                        subDataset.addVariable(variable);
                        continue;
                    }
                    if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("queryString")) {
                        NamedNodeMap nnmChild = nodeChild.getAttributes();
                        if (nnmChild.getNamedItem("language") != null) {
                            subDataset.setQueryLanguage(nnmChild.getNamedItem("language").getNodeValue());
                        }
                        subDataset.setQuery(Report.readPCDATA(nodeChild));
                        continue;
                    }
                    if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("filterExpression")) {
                        subDataset.setFilterExpression(Report.readPCDATA(nodeChild));
                        continue;
                    }
                    if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("group")) continue;
                    Group group = this.readGroupElement(subDataset, nodeChild, false);
                    subDataset.getGroups().add(group);
                }
            }
            this.addSubDataset(subDataset);
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("group")) {
            Group group = this.readGroupElement(this, node, true);
            if (group.getName() != null && group.getName().length() != 0) {
                this.getGroups().addElement(group);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("background")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getBandByName("background");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("title")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getBandByName("title");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("pageHeader")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getBandByName("pageHeader");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("columnHeader")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getBandByName("columnHeader");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("detail")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getBandByName("detail");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("columnFooter")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getBandByName("columnFooter");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("pageFooter")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getBandByName("pageFooter");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("lastPageFooter")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getBandByName("lastPageFooter");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 1 && node.getNodeName().equals("summary")) {
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                bandNode = list_child.item(ck);
                if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                NamedNodeMap bandAttributes = bandNode.getAttributes();
                b = this.getBandByName("summary");
                if (bandAttributes.getNamedItem("height") != null) {
                    b.setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                }
                if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                    b.setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                }
                this.readBandElements(bandNode, b);
            }
        } else if (node.getNodeType() == 5) {
            seeInside = true;
        }
        if (seeInside && (children = node.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                this.traverse(children.item(i));
            }
        }
    }

    private void readBandElements(Node bandNode, Band band) {
        this.readBandElements("", bandNode, band, null, null, null);
    }

    private void readBandElements(String parentElementGroup, Node bandNode, Band band, ReportElement parent) {
        this.readBandElements(parentElementGroup, bandNode, band, parent, null, null);
    }

    public String createChildGroup(String parentElementGroup) {
        ++this.nextGroupId;
        if (parentElementGroup.length() > 0) {
            parentElementGroup = parentElementGroup + ".";
        }
        return parentElementGroup + this.nextGroupId;
    }

    private JRParameter readParameterElement(Node parameterNode) {
        NodeList children;
        JRParameter parameter = new JRParameter("", "java.lang.String", true, "");
        NamedNodeMap nnm = parameterNode.getAttributes();
        if (nnm.getNamedItem("name") != null) {
            parameter.setName(nnm.getNamedItem("name").getNodeValue());
        }
        if (nnm.getNamedItem("class") != null) {
            parameter.setClassType(nnm.getNamedItem("class").getNodeValue());
        }
        if (nnm.getNamedItem("isForPrompting") != null) {
            parameter.setIsForPrompting(nnm.getNamedItem("isForPrompting").getNodeValue().equalsIgnoreCase("true"));
        }
        if ((children = parameterNode.getChildNodes()) != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                Node child_child;
                int ck;
                NodeList list_child;
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("parameterDescription")) {
                    list_child = nodeChild.getChildNodes();
                    for (ck = 0; ck < list_child.getLength(); ++ck) {
                        child_child = list_child.item(ck);
                        if (child_child.getNodeType() != 4 && child_child.getNodeType() != 3) continue;
                        parameter.setDescription(child_child.getNodeValue());
                    }
                    continue;
                }
                if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("defaultValueExpression")) continue;
                list_child = nodeChild.getChildNodes();
                for (ck = 0; ck < list_child.getLength(); ++ck) {
                    child_child = list_child.item(ck);
                    if (child_child.getNodeType() != 4 && child_child.getNodeType() != 3) continue;
                    parameter.setDefaultValueExpression(child_child.getNodeValue());
                }
            }
        }
        return parameter;
    }

    private JRField readFieldElement(Node fieldNode) {
        NodeList children;
        JRField field = new JRField("", "java.lang.String");
        field.setDescription("");
        NamedNodeMap nnm = fieldNode.getAttributes();
        if (nnm.getNamedItem("name") != null) {
            field.setName(nnm.getNamedItem("name").getNodeValue());
        }
        if (nnm.getNamedItem("class") != null) {
            field.setClassType(nnm.getNamedItem("class").getNodeValue());
        }
        if ((children = fieldNode.getChildNodes()) != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("fieldDescription")) continue;
                NodeList list_child = nodeChild.getChildNodes();
                for (int ck = 0; ck < list_child.getLength(); ++ck) {
                    Node child_child = list_child.item(ck);
                    if (child_child.getNodeType() != 4 && child_child.getNodeType() != 3) continue;
                    field.setDescription(child_child.getNodeValue());
                }
            }
        }
        return field;
    }

    private JRProperty readPropertyElement(Node propertyNode) {
        JRProperty property = new JRProperty();
        NamedNodeMap nnm = propertyNode.getAttributes();
        if (nnm.getNamedItem("name") != null) {
            property.setName(nnm.getNamedItem("name").getNodeValue());
        }
        if (nnm.getNamedItem("value") != null) {
            property.setValue(nnm.getNamedItem("value").getNodeValue());
        }
        return property;
    }

    private JRVariable readVariableElement(Node variableNode) {
        NodeList children;
        JRVariable variable = new JRVariable("", false);
        variable.setResetType("Report");
        variable.setResetGroup("");
        variable.setIncrementType("None");
        variable.setIncrementGroup("");
        variable.setCalculation("Nothing");
        NamedNodeMap nnm = variableNode.getAttributes();
        if (nnm.getNamedItem("name") != null) {
            variable.setName(nnm.getNamedItem("name").getNodeValue());
        }
        if (nnm.getNamedItem("class") != null) {
            variable.setClassType(nnm.getNamedItem("class").getNodeValue());
        }
        if (nnm.getNamedItem("resetType") != null) {
            variable.setResetType(nnm.getNamedItem("resetType").getNodeValue());
        }
        if (nnm.getNamedItem("resetGroup") != null) {
            variable.setResetGroup(nnm.getNamedItem("resetGroup").getNodeValue());
        }
        if (nnm.getNamedItem("calculation") != null) {
            variable.setCalculation(nnm.getNamedItem("calculation").getNodeValue());
        }
        if (nnm.getNamedItem("incrementerFactoryClass") != null) {
            variable.setIncrementerFactoryClass(nnm.getNamedItem("incrementerFactoryClass").getNodeValue());
        }
        if (nnm.getNamedItem("incrementType") != null) {
            variable.setIncrementType(nnm.getNamedItem("incrementType").getNodeValue());
        }
        if (nnm.getNamedItem("incrementGroup") != null) {
            variable.setIncrementGroup(nnm.getNamedItem("incrementGroup").getNodeValue());
        }
        if ((children = variableNode.getChildNodes()) != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                Node child_child;
                int ck;
                NodeList list_child;
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("variableExpression")) {
                    list_child = nodeChild.getChildNodes();
                    for (ck = 0; ck < list_child.getLength(); ++ck) {
                        child_child = list_child.item(ck);
                        if (child_child.getNodeType() != 4 && child_child.getNodeType() != 3) continue;
                        variable.setExpression(child_child.getNodeValue());
                    }
                    continue;
                }
                if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("initialValueExpression")) continue;
                list_child = nodeChild.getChildNodes();
                for (ck = 0; ck < list_child.getLength(); ++ck) {
                    child_child = list_child.item(ck);
                    if (child_child.getNodeType() != 4 && child_child.getNodeType() != 3) continue;
                    variable.setInitialValueExpression(child_child.getNodeValue());
                }
            }
        }
        return variable;
    }

    private Measure readMeasureElement(Node measureNode) {
        NodeList children;
        Measure measure = new Measure("");
        NamedNodeMap nnm = measureNode.getAttributes();
        if (nnm.getNamedItem("name") != null) {
            measure.setName(nnm.getNamedItem("name").getNodeValue());
        }
        if (nnm.getNamedItem("class") != null) {
            measure.setClassType(nnm.getNamedItem("class").getNodeValue());
        }
        if (nnm.getNamedItem("calculation") != null) {
            measure.setCalculation(nnm.getNamedItem("calculation").getNodeValue());
        }
        if (nnm.getNamedItem("incrementerFactoryClass") != null) {
            measure.setIncrementerFactoryClass(nnm.getNamedItem("incrementerFactoryClass").getNodeValue());
        }
        if (nnm.getNamedItem("percentageOf") != null) {
            measure.setPercentageOf(nnm.getNamedItem("percentageOf").getNodeValue());
        }
        if (nnm.getNamedItem("percentageCalculatorClass") != null) {
            measure.setPercentageCalculatorClass(nnm.getNamedItem("percentageCalculatorClass").getNodeValue());
        }
        if ((children = measureNode.getChildNodes()) != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("measureExpression")) continue;
                measure.setExpression(Report.readPCDATA(nodeChild));
            }
        }
        return measure;
    }

    private Style readStyle(Node styleNode) {
        return this.readStyle(styleNode, null);
    }

    private Style readStyle(Node styleNode, ConditionedStyle cStyle) {
        Style style = new Style();
        if (cStyle != null) {
            style = cStyle;
        }
        NamedNodeMap nnm = styleNode.getAttributes();
        for (int i = 0; i < Style.JRXMLStyleAttributes.length; ++i) {
            if (nnm.getNamedItem(Style.JRXMLStyleAttributes[i]) == null) continue;
            style.getAttributes().put(Style.JRXMLStyleAttributes[i], nnm.getNamedItem(Style.JRXMLStyleAttributes[i]).getNodeValue());
        }
        NodeList children = styleNode.getChildNodes();
        if (children != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("conditionalStyle")) continue;
                ConditionedStyle childStyle = this.readConditionalStyle(nodeChild);
                style.getConditionedStyles().add(childStyle);
            }
        }
        return style;
    }

    private ConditionedStyle readConditionalStyle(Node styleNode) {
        ConditionedStyle style = new ConditionedStyle();
        NodeList children = styleNode.getChildNodes();
        if (children != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("conditionExpression")) {
                    style.setCondition(Report.readPCDATA(nodeChild));
                    continue;
                }
                if (nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("style")) continue;
                style = (ConditionedStyle)this.readStyle(nodeChild, style);
            }
        }
        return style;
    }

    private Group readGroupElement(SubDataset ds, Node groupNode, boolean fullRead) {
        NodeList children;
        NamedNodeMap nnm = groupNode.getAttributes();
        Group group = new Group(ds, "" + nnm.getNamedItem("name").getNodeValue());
        if (nnm.getNamedItem("isStartNewColumn") != null) {
            group.setIsStartNewColumn(nnm.getNamedItem("isStartNewColumn").getNodeValue().equals("true"));
        }
        if (nnm.getNamedItem("isStartNewPage") != null) {
            group.setIsStartNewPage(nnm.getNamedItem("isStartNewPage").getNodeValue().equals("true"));
        }
        if (nnm.getNamedItem("isResetPageNumber") != null) {
            group.setIsResetPageNumber(nnm.getNamedItem("isResetPageNumber").getNodeValue().equals("true"));
        }
        if (nnm.getNamedItem("isReprintHeaderOnEachPage") != null) {
            group.setIsReprintHeaderOnEachPage(nnm.getNamedItem("isReprintHeaderOnEachPage").getNodeValue().equals("true"));
        }
        if (nnm.getNamedItem("minHeightToStartNewPage") != null) {
            group.setMinHeightToStartNewPage(Integer.parseInt(nnm.getNamedItem("minHeightToStartNewPage").getNodeValue()));
        }
        if ((children = groupNode.getChildNodes()) != null) {
            for (int k = 0; k < children.getLength(); ++k) {
                NamedNodeMap bandAttributes;
                Node bandNode;
                int ck;
                NodeList list_child;
                Node nodeChild = children.item(k);
                if (nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("groupExpression")) {
                    list_child = nodeChild.getChildNodes();
                    for (ck = 0; ck < list_child.getLength(); ++ck) {
                        Node child_child = list_child.item(ck);
                        if (child_child.getNodeType() != 4 && child_child.getNodeType() != 3) continue;
                        group.setGroupExpression(child_child.getNodeValue());
                    }
                    continue;
                }
                if (fullRead && nodeChild.getNodeType() == 1 && nodeChild.getNodeName().equals("groupHeader")) {
                    list_child = nodeChild.getChildNodes();
                    for (ck = 0; ck < list_child.getLength(); ++ck) {
                        bandNode = list_child.item(ck);
                        if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                        bandAttributes = bandNode.getAttributes();
                        if (bandAttributes.getNamedItem("height") != null) {
                            group.getGroupHeader().setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                        }
                        if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                            group.getGroupHeader().setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                        }
                        this.readBandElements(bandNode, group.getGroupHeader());
                    }
                    continue;
                }
                if (!fullRead || nodeChild.getNodeType() != 1 || !nodeChild.getNodeName().equals("groupFooter")) continue;
                list_child = nodeChild.getChildNodes();
                for (ck = 0; ck < list_child.getLength(); ++ck) {
                    bandNode = list_child.item(ck);
                    if (bandNode.getNodeType() != 1 || !bandNode.getNodeName().equals("band")) continue;
                    bandAttributes = bandNode.getAttributes();
                    if (bandAttributes.getNamedItem("height") != null) {
                        group.getGroupFooter().setHeight(Integer.parseInt(bandAttributes.getNamedItem("height").getNodeValue()));
                    }
                    if (bandAttributes.getNamedItem("isSplitAllowed") != null) {
                        group.getGroupFooter().setSplitAllowed(bandAttributes.getNamedItem("isSplitAllowed").getNodeValue().equals("true"));
                    }
                    this.readBandElements(bandNode, group.getGroupFooter());
                }
            }
        }
        return group;
    }

    private void readBandElements(String parentElementGroup, Node bandNode, Band band, ReportElement parentElement, CrosstabReportElement crosstabReportElement, CrosstabCell cell) {
        ReportElement rElement = null;
        Style defualtStyle = this.getDefaultStyle();
        NodeList list_child = bandNode.getChildNodes();
        for (int ck = 0; ck < list_child.getLength(); ++ck) {
            String name;
            NamedNodeMap subNodeAttributes;
            Node child_child;
            ReportElement re;
            Node child = list_child.item(ck);
            if (child.getNodeType() == 1 && child.getNodeName().equals("printWhenExpression")) {
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    Node child_child2 = childsOfChild.item(c_count);
                    if (child_child2.getNodeType() != 4 && child_child2.getNodeType() != 3) continue;
                    band.setPrintWhenExpression(child_child2.getNodeValue());
                }
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("staticText")) {
                re = new StaticTextReportElement(0, 0, 0, 0);
                ((TextReportElement)re).setIReportFont(this.defaultFont);
                if (defualtStyle != null) {
                    ((TextReportElement)re).setStyle(defualtStyle);
                    ((TextReportElement)re).setStyle(null);
                }
                re.setBand(band);
                re.setCell(cell);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    Node child_child3 = childsOfChild.item(c_count);
                    if (child_child3.getNodeType() == 1 && child_child3.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child3, re);
                        continue;
                    }
                    if (child_child3.getNodeType() == 1 && child_child3.getNodeName().equals("textElement")) {
                        this.readXMLTextElement(child_child3, (TextReportElement)re);
                        continue;
                    }
                    if (child_child3.getNodeType() == 1 && child_child3.getNodeName().equals("text")) {
                        ((TextReportElement)re).setText(Report.readPCDATA(child_child3, false));
                        continue;
                    }
                    if (child_child3.getNodeType() != 1 || !child_child3.getNodeName().equals("box")) continue;
                    this.readBoxElement(child_child3, (BoxElement)((Object)re));
                }
                re.setPosition(((StaticTextReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("image")) {
                re = new ImageReportElement(0, 0, 0, 0);
                if (defualtStyle != null) {
                    ((ImageReportElement)re).setStyle(defualtStyle);
                    ((ImageReportElement)re).setStyle(null);
                }
                re.setBand(band);
                re.setCell(cell);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NamedNodeMap nodeAttributes = child.getAttributes();
                if (nodeAttributes.getNamedItem("isUsingCache") != null) {
                    ((ImageReportElement)re).setIsUsingCache(("" + nodeAttributes.getNamedItem("isUsingCache").getNodeValue()).equals("true"));
                }
                if (nodeAttributes.getNamedItem("isLazy") != null) {
                    ((ImageReportElement)re).setIsLazy(("" + nodeAttributes.getNamedItem("isLazy").getNodeValue()).equals("true"));
                }
                if (nodeAttributes.getNamedItem("onErrorType") != null) {
                    ((ImageReportElement)re).setOnErrorType("" + nodeAttributes.getNamedItem("onErrorType").getNodeValue());
                }
                if (nodeAttributes.getNamedItem("scaleImage") != null) {
                    ((ImageReportElement)re).setScaleImage("" + nodeAttributes.getNamedItem("scaleImage").getNodeValue());
                }
                if (nodeAttributes.getNamedItem("vAlign") != null) {
                    ((ImageReportElement)re).setVerticalAlignment("" + nodeAttributes.getNamedItem("vAlign").getNodeValue());
                }
                if (nodeAttributes.getNamedItem("hAlign") != null) {
                    ((ImageReportElement)re).setHorizontalAlignment("" + nodeAttributes.getNamedItem("hAlign").getNodeValue());
                }
                if (nodeAttributes.getNamedItem("evaluationTime") != null) {
                    ((ImageReportElement)re).setEvaluationTime("" + nodeAttributes.getNamedItem("evaluationTime").getNodeValue());
                }
                if (nodeAttributes.getNamedItem("evaluationGroup") != null) {
                    ((ImageReportElement)re).setEvaluationGroup("" + nodeAttributes.getNamedItem("evaluationGroup").getNodeValue());
                }
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("graphicElement")) {
                        if (subNodeAttributes.getNamedItem("pen") != null) {
                            ((GraphicReportElement)re).setGraphicElementPen("" + subNodeAttributes.getNamedItem("pen").getNodeValue());
                        }
                        if (subNodeAttributes.getNamedItem("fill") != null) {
                            re.setPropertyValue("FILL", "" + subNodeAttributes.getNamedItem("fill").getNodeValue());
                        }
                        if (subNodeAttributes.getNamedItem("stretchType") == null) continue;
                        re.setStretchType("" + subNodeAttributes.getNamedItem("stretchType").getNodeValue());
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("imageExpression")) {
                        if (subNodeAttributes.getNamedItem("class") != null) {
                            ((ImageReportElement)re).setImageClass("" + subNodeAttributes.getNamedItem("class").getNodeValue());
                        }
                        ((ImageReportElement)re).setImageExpression(Report.readPCDATA(child_child));
                        ((ImageReportElement)re).setReportDirectory(new File(this.filename).getParentFile());
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("box")) continue;
                    this.readBoxElement(child_child, (BoxElement)((Object)re));
                }
                this.readHyperlink(child, (HyperLinkableReportElement)((Object)re));
                re.setPosition(((ImageReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                if (((ImageReportElement)re).getImageExpression().indexOf("it.businesslogic.ireport.chart.DefaultChartFactory.drawChart(") >= 0) {
                    ChartReportElement chart = new ChartReportElement(re.getPosition().x, re.getPosition().y, re.getWidth(), re.getHeight());
                    chart.setBand(re.getBand());
                    chart.setElementGroup(re.getElementGroup());
                    chart.setParentElement(re.getParentElement());
                    chart.setHyperlinkReferenceExpression(((ImageReportElement)re).getHyperlinkReferenceExpression());
                    chart.setHyperlinkPageExpression(((ImageReportElement)re).getHyperlinkPageExpression());
                    chart.setHyperlinkAnchorExpression(((ImageReportElement)re).getHyperlinkAnchorExpression());
                    chart.setHyperlinkType(((ImageReportElement)re).getHyperlinkType());
                    chart.setBgcolor(re.getBgcolor());
                    chart.setEvaluationGroup(((ImageReportElement)re).getEvaluationGroup());
                    chart.setEvaluationTime(((ImageReportElement)re).getEvaluationTime());
                    chart.setFgcolor(re.getFgcolor());
                    chart.setFill(((GraphicReportElement)re).getFill());
                    chart.setHorizontalAlignment(((ImageReportElement)re).getHorizontalAlignment());
                    chart.setImageClass(((ImageReportElement)re).getImageClass());
                    chart.setImageExpression(((ImageReportElement)re).getImageExpression());
                    chart.setName(re.getName());
                    chart.setPositionType(re.getPositionType());
                    chart.setPrintWhenExpression(re.getPrintWhenExpression());
                    chart.setPrintWhenGroupChanges(re.getPrintWhenGroupChanges());
                    chart.setScaleImage(((ImageReportElement)re).getScaleImage());
                    chart.setStretchType(re.getStretchType());
                    chart.setTransparent(re.getTransparent());
                    chart.setVerticalAlignment(((ImageReportElement)re).getVerticalAlignment());
                    chart.parseProperties(this.getJRproperties());
                    re = chart;
                }
                if (((ImageReportElement)re).getImageExpression().indexOf("it.businesslogic.ireport.barcode.BcImage.getBarcodeImage(") >= 0) {
                    BarcodeReportElement bc = new BarcodeReportElement(re.getPosition().x, re.getPosition().y, re.getWidth(), re.getHeight());
                    bc.setBand(re.getBand());
                    bc.setCell(cell);
                    bc.setElementGroup(re.getElementGroup());
                    bc.setParentElement(re.getParentElement());
                    bc.setHyperlinkReferenceExpression(((ImageReportElement)re).getHyperlinkReferenceExpression());
                    bc.setHyperlinkPageExpression(((ImageReportElement)re).getHyperlinkPageExpression());
                    bc.setHyperlinkAnchorExpression(((ImageReportElement)re).getHyperlinkAnchorExpression());
                    bc.setHyperlinkType(((ImageReportElement)re).getHyperlinkType());
                    bc.setBgcolor(re.getBgcolor());
                    bc.setEvaluationGroup(((ImageReportElement)re).getEvaluationGroup());
                    bc.setEvaluationTime(((ImageReportElement)re).getEvaluationTime());
                    bc.setFgcolor(re.getFgcolor());
                    bc.setFill(((GraphicReportElement)re).getFill());
                    bc.setHorizontalAlignment(((ImageReportElement)re).getHorizontalAlignment());
                    bc.setImageClass(((ImageReportElement)re).getImageClass());
                    bc.setImageExpression(((ImageReportElement)re).getImageExpression());
                    bc.setName(re.getName());
                    bc.setPositionType(re.getPositionType());
                    bc.setPrintWhenExpression(re.getPrintWhenExpression());
                    bc.setPrintWhenGroupChanges(re.getPrintWhenGroupChanges());
                    bc.setScaleImage(((ImageReportElement)re).getScaleImage());
                    bc.setStretchType(re.getStretchType());
                    bc.setTransparent(re.getTransparent());
                    bc.setVerticalAlignment(((ImageReportElement)re).getVerticalAlignment());
                    re = bc;
                }
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("rectangle")) {
                re = new RectangleReportElement(0, 0, 0, 0);
                if (defualtStyle != null) {
                    ((RectangleReportElement)re).setStyle(defualtStyle);
                    ((RectangleReportElement)re).setStyle(null);
                }
                re.setBand(band);
                re.setCell(cell);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NamedNodeMap nodeAttributes = child.getAttributes();
                if (nodeAttributes.getNamedItem("radius") != null) {
                    ((RectangleReportElement)re).setRadius(Integer.parseInt("" + nodeAttributes.getNamedItem("radius").getNodeValue()));
                }
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("graphicElement")) continue;
                    if (subNodeAttributes.getNamedItem("pen") != null) {
                        ((GraphicReportElement)re).setGraphicElementPen("" + subNodeAttributes.getNamedItem("pen").getNodeValue());
                    }
                    if (subNodeAttributes.getNamedItem("fill") != null) {
                        re.setPropertyValue("FILL", "" + subNodeAttributes.getNamedItem("fill").getNodeValue());
                    }
                    if (subNodeAttributes.getNamedItem("stretchType") == null) continue;
                    re.setStretchType("" + subNodeAttributes.getNamedItem("stretchType").getNodeValue());
                }
                re.setPosition(((RectangleReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("line")) {
                re = new LineReportElement(0, 0, 0, 0);
                if (defualtStyle != null) {
                    ((GraphicReportElement)re).setStyle(defualtStyle);
                    ((GraphicReportElement)re).setStyle(null);
                }
                re.setBand(band);
                re.setCell(cell);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NamedNodeMap nodeAttributes = child.getAttributes();
                if (nodeAttributes.getNamedItem("direction") != null) {
                    ((LineReportElement)re).setDirection("" + nodeAttributes.getNamedItem("direction").getNodeValue());
                }
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("graphicElement")) continue;
                    if (subNodeAttributes.getNamedItem("pen") != null) {
                        ((GraphicReportElement)re).setGraphicElementPen("" + subNodeAttributes.getNamedItem("pen").getNodeValue());
                    }
                    if (subNodeAttributes.getNamedItem("fill") != null) {
                        re.setPropertyValue("FILL", "" + subNodeAttributes.getNamedItem("fill").getNodeValue());
                    }
                    if (subNodeAttributes.getNamedItem("stretchType") == null) continue;
                    re.setStretchType("" + subNodeAttributes.getNamedItem("stretchType").getNodeValue());
                }
                re.setPosition(((LineReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("ellipse")) {
                re = new EllipseReportElement(0, 0, 0, 0);
                if (defualtStyle != null) {
                    ((GraphicReportElement)re).setStyle(defualtStyle);
                    ((GraphicReportElement)re).setStyle(null);
                }
                re.setBand(band);
                re.setCell(cell);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NamedNodeMap nodeAttributes = child.getAttributes();
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("graphicElement")) continue;
                    if (subNodeAttributes.getNamedItem("pen") != null) {
                        ((GraphicReportElement)re).setGraphicElementPen("" + subNodeAttributes.getNamedItem("pen").getNodeValue());
                    }
                    if (subNodeAttributes.getNamedItem("fill") != null) {
                        re.setPropertyValue("FILL", "" + subNodeAttributes.getNamedItem("fill").getNodeValue());
                    }
                    if (subNodeAttributes.getNamedItem("stretchType") == null) continue;
                    re.setStretchType("" + subNodeAttributes.getNamedItem("stretchType").getNodeValue());
                }
                re.setPosition(((EllipseReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("textField")) {
                re = new TextFieldReportElement(0, 0, 0, 0);
                ((TextReportElement)re).setIReportFont(this.defaultFont);
                if (defualtStyle != null) {
                    ((TextFieldReportElement)re).setStyle(defualtStyle);
                    ((TextFieldReportElement)re).setStyle(null);
                }
                re.setBand(band);
                re.setCell(cell);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NamedNodeMap nodeAttributes = child.getAttributes();
                if (nodeAttributes.getNamedItem("evaluationTime") != null) {
                    ((TextFieldReportElement)re).setEvaluationTime("" + nodeAttributes.getNamedItem("evaluationTime").getNodeValue());
                }
                if (nodeAttributes.getNamedItem("evaluationGroup") != null) {
                    ((TextFieldReportElement)re).setGroup("" + nodeAttributes.getNamedItem("evaluationGroup").getNodeValue());
                }
                if (nodeAttributes.getNamedItem("isStretchWithOverflow") != null) {
                    ((TextFieldReportElement)re).setStretchWithOverflow(nodeAttributes.getNamedItem("isStretchWithOverflow").getNodeValue().equals("true"));
                }
                if (nodeAttributes.getNamedItem("isBlankWhenNull") != null) {
                    ((TextFieldReportElement)re).setBlankWhenNull(nodeAttributes.getNamedItem("isBlankWhenNull").getNodeValue().equals("true"));
                }
                if (nodeAttributes.getNamedItem("pattern") != null) {
                    ((TextFieldReportElement)re).setPattern("" + nodeAttributes.getNamedItem("pattern").getNodeValue());
                }
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("textElement")) {
                        this.readXMLTextElement(child_child, (TextReportElement)re);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("textFieldExpression")) {
                        if (subNodeAttributes.getNamedItem("class") != null) {
                            ((TextFieldReportElement)re).setClassExpression("" + subNodeAttributes.getNamedItem("class").getNodeValue());
                        }
                        ((TextReportElement)re).setText(Report.readPCDATA(child_child).trim());
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("box")) continue;
                    this.readBoxElement(child_child, (BoxElement)((Object)re));
                }
                this.readHyperlink(child, (HyperLinkableReportElement)((Object)re));
                re.setPosition(((TextFieldReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("frame")) {
                re = new FrameReportElement(0, 0, 0, 0);
                if (defualtStyle != null) {
                    ((FrameReportElement)re).setStyle(defualtStyle);
                    ((FrameReportElement)re).setStyle(null);
                }
                re.setBand(band);
                re.setCell(cell);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NamedNodeMap nodeAttributes = child.getAttributes();
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("box")) continue;
                    this.readBoxElement(child_child, (BoxElement)((Object)re));
                }
                re.setPosition(((FrameReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
                if (crosstabReportElement != null) {
                    crosstabReportElement.getElements().addElement(rElement);
                } else {
                    this.elements.addElement(rElement);
                }
                this.readBandElements("", child, band, re, crosstabReportElement, cell);
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("elementGroup")) {
                String newgroup = this.createChildGroup(parentElementGroup);
                this.readBandElements(newgroup, child, band, parentElement, crosstabReportElement, cell);
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("subreport")) {
                re = new SubReportElement(0, 0, 0, 0);
                if (defualtStyle != null) {
                    re.setStyle(defualtStyle);
                    re.setStyle(null);
                }
                re.setBand(band);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                NamedNodeMap nodeAttributes = child.getAttributes();
                if (nodeAttributes.getNamedItem("isUsingCache") != null) {
                    ((SubReportElement)re).setIsUsingCache(nodeAttributes.getNamedItem("isUsingCache").getNodeValue().equals("true"));
                }
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("parametersMapExpression")) {
                        ((SubReportElement)re).setParametersMapExpression(Report.readPCDATA(child_child));
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("returnValue")) {
                        JRSubreportReturnValue returnValue = new JRSubreportReturnValue();
                        if (subNodeAttributes.getNamedItem("subreportVariable") != null) {
                            returnValue.setSubreportVariable("" + subNodeAttributes.getNamedItem("subreportVariable").getNodeValue());
                        }
                        if (subNodeAttributes.getNamedItem("toVariable") != null) {
                            returnValue.setToVariable("" + subNodeAttributes.getNamedItem("toVariable").getNodeValue());
                        }
                        if (subNodeAttributes.getNamedItem("calculation") != null) {
                            returnValue.setCalculation("" + subNodeAttributes.getNamedItem("calculation").getNodeValue());
                        }
                        if (subNodeAttributes.getNamedItem("incrementerFactoryClass") != null) {
                            returnValue.setIncrementFactoryClass("" + subNodeAttributes.getNamedItem("incrementerFactoryClass").getNodeValue());
                        }
                        ((SubReportElement)re).getReturnValues().addElement(returnValue);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("subreportParameter")) {
                        name = "";
                        if (subNodeAttributes.getNamedItem("name") != null) {
                            name = "" + subNodeAttributes.getNamedItem("name").getNodeValue();
                        }
                        String expression = "";
                        NodeList childsOfChildOfChild = child_child.getChildNodes();
                        for (int c_count_2 = 0; c_count_2 < childsOfChildOfChild.getLength(); ++c_count_2) {
                            Node child_child_child = childsOfChildOfChild.item(c_count_2);
                            if (child_child_child.getNodeType() != 1 || !child_child_child.getNodeName().equals("subreportParameterExpression")) continue;
                            expression = Report.readPCDATA(child_child_child);
                            break;
                        }
                        ((SubReportElement)re).getSubreportParameters().addElement(new JRSubreportParameter(name, expression));
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("connectionExpression")) {
                        ((SubReportElement)re).setConnectionExpression(Report.readPCDATA(child_child));
                        ((SubReportElement)re).setUseConnection(true);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataSourceExpression")) {
                        ((SubReportElement)re).setDataSourceExpression(Report.readPCDATA(child_child));
                        ((SubReportElement)re).setUseConnection(false);
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("subreportExpression")) continue;
                    ((SubReportElement)re).setSubreportExpression(Report.readPCDATA(child_child));
                    if (subNodeAttributes.getNamedItem("class") == null) continue;
                    ((SubReportElement)re).setSubreportExpressionClass("" + subNodeAttributes.getNamedItem("class").getNodeValue());
                }
                re.setPosition(((SubReportElement)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("pieChart") || child.getNodeType() == 1 && child.getNodeName().equals("pie3DChart") || child.getNodeType() == 1 && child.getNodeName().equals("barChart") || child.getNodeType() == 1 && child.getNodeName().equals("bar3DChart") || child.getNodeType() == 1 && child.getNodeName().equals("xyBarChart") || child.getNodeType() == 1 && child.getNodeName().equals("stackedBarChart") || child.getNodeType() == 1 && child.getNodeName().equals("stackedBar3DChart") || child.getNodeType() == 1 && child.getNodeName().equals("lineChart") || child.getNodeType() == 1 && child.getNodeName().equals("xyLineChart") || child.getNodeType() == 1 && child.getNodeName().equals("areaChart") || child.getNodeType() == 1 && child.getNodeName().equals("xyAreaChart") || child.getNodeType() == 1 && child.getNodeName().equals("scatterChart") || child.getNodeType() == 1 && child.getNodeName().equals("bubbleChart") || child.getNodeType() == 1 && child.getNodeName().equals("timeSeriesChart") || child.getNodeType() == 1 && child.getNodeName().equals("highLowChart") || child.getNodeType() == 1 && child.getNodeName().equals("candlestickChart")) {
                re = new ChartReportElement2(0, 0, 0, 0);
                if (defualtStyle != null) {
                    ((ChartReportElement2)re).setStyle(defualtStyle);
                    ((ChartReportElement2)re).setStyle(null);
                }
                re.setBand(band);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                if (child.getNodeName().equals("pieChart")) {
                    ((ChartReportElement2)re).setChart(new PieChart());
                } else if (child.getNodeName().equals("pie3DChart")) {
                    ((ChartReportElement2)re).setChart(new Pie3DChart());
                } else if (child.getNodeName().equals("barChart")) {
                    ((ChartReportElement2)re).setChart(new BarChart());
                } else if (child.getNodeName().equals("bar3DChart")) {
                    ((ChartReportElement2)re).setChart(new Bar3DChart());
                } else if (child.getNodeName().equals("xyBarChart")) {
                    ((ChartReportElement2)re).setChart(new XYBarChart());
                } else if (child.getNodeName().equals("stackedBarChart")) {
                    ((ChartReportElement2)re).setChart(new StackedBarChart());
                } else if (child.getNodeName().equals("stackedBar3DChart")) {
                    ((ChartReportElement2)re).setChart(new StackedBar3DChart());
                } else if (child.getNodeName().equals("lineChart")) {
                    ((ChartReportElement2)re).setChart(new LineChart());
                } else if (child.getNodeName().equals("xyLineChart")) {
                    ((ChartReportElement2)re).setChart(new XYLineChart());
                } else if (child.getNodeName().equals("areaChart")) {
                    ((ChartReportElement2)re).setChart(new AreaChart());
                } else if (child.getNodeName().equals("xyAreaChart")) {
                    ((ChartReportElement2)re).setChart(new XYAreaChart());
                } else if (child.getNodeName().equals("scatterChart")) {
                    ((ChartReportElement2)re).setChart(new ScatterChart());
                } else if (child.getNodeName().equals("bubbleChart")) {
                    ((ChartReportElement2)re).setChart(new BubbleChart());
                } else if (child.getNodeName().equals("timeSeriesChart")) {
                    ((ChartReportElement2)re).setChart(new TimeSeriesChart());
                } else if (child.getNodeName().equals("highLowChart")) {
                    ((ChartReportElement2)re).setChart(new HighLowChart());
                } else if (child.getNodeName().equals("candlestickChart")) {
                    ((ChartReportElement2)re).setChart(new CandlestickChart());
                }
                NodeList childsOfChild = child.getChildNodes();
                for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    Node child_child4 = childsOfChild.item(c_count);
                    NamedNodeMap subNodeAttributes2 = child_child4.getAttributes();
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("chart")) {
                        this.readChartElement(child_child4, (ChartReportElement2)re);
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("pieDataset")) {
                        this.readPieDataset(child_child4, (ChartReportElement2)re);
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("categoryDataset")) {
                        this.readCategoryDataset(child_child4, (ChartReportElement2)re);
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("timePeriodDataset")) {
                        this.readTimePeriodDataset(child_child4, (ChartReportElement2)re);
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("timeSeriesDataset")) {
                        this.readTimeSeriesDataset(child_child4, (ChartReportElement2)re);
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("xyDataset")) {
                        this.readXYDataset(child_child4, (ChartReportElement2)re);
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("xyzDataset")) {
                        this.readXYZDataset(child_child4, (ChartReportElement2)re);
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("highLowDataset")) {
                        this.readHighLowDataset(child_child4, (ChartReportElement2)re);
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("piePlot")) {
                        this.readPiePlot(child_child4, (PiePlot)((ChartReportElement2)re).getChart().getPlot());
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("pie3DPlot")) {
                        this.readPie3DPlot(child_child4, (Pie3DPlot)((ChartReportElement2)re).getChart().getPlot());
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("barPlot")) {
                        this.readBarPlot(child_child4, (BarPlot)((ChartReportElement2)re).getChart().getPlot());
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("bar3DPlot")) {
                        this.readBar3DPlot(child_child4, (Bar3DPlot)((ChartReportElement2)re).getChart().getPlot());
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("linePlot")) {
                        this.readLinePlot(child_child4, (LinePlot)((ChartReportElement2)re).getChart().getPlot());
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("areaPlot")) {
                        this.readAreaPlot(child_child4, (AreaPlot)((ChartReportElement2)re).getChart().getPlot());
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("scatterPlot")) {
                        this.readScatterPlot(child_child4, (ScatterPlot)((ChartReportElement2)re).getChart().getPlot());
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("bubblePlot")) {
                        this.readBubblePlot(child_child4, (BubblePlot)((ChartReportElement2)re).getChart().getPlot());
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("timeSeriesPlot")) {
                        this.readTimeSeriesPlot(child_child4, (TimeSeriesPlot)((ChartReportElement2)re).getChart().getPlot());
                        continue;
                    }
                    if (child_child4.getNodeType() == 1 && child_child4.getNodeName().equals("highLowPlot")) {
                        this.readHighLowPlot(child_child4, (HighLowPlot)((ChartReportElement2)re).getChart().getPlot());
                        continue;
                    }
                    if (child_child4.getNodeType() != 1 || !child_child4.getNodeName().equals("candlestickPlot")) continue;
                    this.readCandlestickPlot(child_child4, (CandlestickPlot)((ChartReportElement2)re).getChart().getPlot());
                }
                re.setPosition(((ChartReportElement2)re).position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            } else if (child.getNodeType() == 1 && child.getNodeName().equals("crosstab")) {
                re = new CrosstabReportElement(0, 0, 0, 0);
                if (defualtStyle != null) {
                    re.setStyle(defualtStyle);
                    re.setStyle(null);
                }
                re.setBand(band);
                re.setElementGroup(parentElementGroup);
                re.setParentElement(parentElement);
                ((CrosstabReportElement)re).setReport(this);
                NamedNodeMap nodeAttributes = child.getAttributes();
                if (nodeAttributes.getNamedItem("isRepeatColumnHeaders") != null) {
                    ((CrosstabReportElement)re).setRepeatColumnHeaders(nodeAttributes.getNamedItem("isRepeatColumnHeaders").getNodeValue().equals("true"));
                }
                if (nodeAttributes.getNamedItem("isRepeatRowHeaders") != null) {
                    ((CrosstabReportElement)re).setRepeatRowHeaders(nodeAttributes.getNamedItem("isRepeatRowHeaders").getNodeValue().equals("true"));
                }
                if (nodeAttributes.getNamedItem("isRepeatRowHeaders") != null) {
                    try {
                        int columnBreakOffset = Integer.parseInt(nodeAttributes.getNamedItem("columnBreakOffset").getNodeValue());
                        ((CrosstabReportElement)re).setColumnBreakOffset(columnBreakOffset);
                    }
                    catch (Exception ex) {
                        System.out.println("Invalid columnBreakOffset, using default");
                    }
                }
                NodeList childsOfChild = child.getChildNodes();
                block14: for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
                    CrosstabCell detailCell;
                    child_child = childsOfChild.item(c_count);
                    subNodeAttributes = child_child.getAttributes();
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                        this.readXMLReportElement(child_child, re);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("parametersMapExpression")) {
                        ((CrosstabReportElement)re).setParametersMapExpression(Report.readPCDATA(child_child));
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("crosstabParameter")) {
                        name = "";
                        String clazz = "";
                        if (subNodeAttributes.getNamedItem("name") != null) {
                            name = "" + subNodeAttributes.getNamedItem("name").getNodeValue();
                        }
                        CrosstabParameter cp = new CrosstabParameter(name);
                        if (subNodeAttributes.getNamedItem("class") != null) {
                            clazz = "" + subNodeAttributes.getNamedItem("class").getNodeValue();
                            cp.setClassType(clazz);
                        }
                        String expression = "";
                        NodeList childsOfChildOfChild = child_child.getChildNodes();
                        for (int c_count_2 = 0; c_count_2 < childsOfChildOfChild.getLength(); ++c_count_2) {
                            Node child_child_child = childsOfChildOfChild.item(c_count_2);
                            if (child_child_child.getNodeType() != 1 || !child_child_child.getNodeName().equals("parameterValueExpression")) continue;
                            expression = Report.readPCDATA(child_child_child);
                            cp.setParameterValueExpression(expression);
                            break;
                        }
                        ((CrosstabReportElement)re).getCrosstabParameters().addElement(cp);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("crosstabDataset")) {
                        ((CrosstabReportElement)re).setUseDataset(true);
                        if (subNodeAttributes.getNamedItem("isDataPreSorted") != null) {
                            ((CrosstabReportElement)re).setPreSorted(subNodeAttributes.getNamedItem("isDataPreSorted").getNodeValue().equals("true"));
                        }
                        NodeList childsOfChildOfChild = child_child.getChildNodes();
                        for (int c_count_2 = 0; c_count_2 < childsOfChildOfChild.getLength(); ++c_count_2) {
                            Node child_child_child = childsOfChildOfChild.item(c_count_2);
                            if (child_child_child.getNodeType() != 1 || !child_child_child.getNodeName().equals("dataset")) continue;
                            this.readDataset(child_child_child, ((CrosstabReportElement)re).getDataset());
                            continue block14;
                        }
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("rowGroup")) {
                        this.readCrosstabRowGroup(child_child, (CrosstabReportElement)re);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("columnGroup")) {
                        this.readCrosstabColumnGroup(child_child, (CrosstabReportElement)re);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("measure")) {
                        Measure measure = this.readMeasureElement(child_child);
                        ((CrosstabReportElement)re).getMeasures().add(measure);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("crosstabCell")) {
                        detailCell = new CrosstabCell();
                        this.readCellContents(child_child, detailCell, (CrosstabReportElement)re);
                        detailCell.setType(0);
                        detailCell.setParent((CrosstabReportElement)re);
                        ((CrosstabReportElement)re).getCells().add(detailCell);
                        continue;
                    }
                    if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("whenNoDataCell")) {
                        detailCell = new CrosstabCell();
                        this.readCellContents(child_child, detailCell, (CrosstabReportElement)re);
                        detailCell.setType(2);
                        detailCell.setParent((CrosstabReportElement)re);
                        ((CrosstabReportElement)re).getCells().add(detailCell);
                        continue;
                    }
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("crosstabHeaderCell")) continue;
                    detailCell = new CrosstabCell();
                    this.readCellContents(child_child, detailCell, (CrosstabReportElement)re);
                    detailCell.setType(3);
                    detailCell.setParent((CrosstabReportElement)re);
                    ((CrosstabReportElement)re).getCells().add(detailCell);
                }
                re.setPosition(((CrosstabReportElement)re).position);
                ((CrosstabReportElement)re).trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                rElement = re;
            }
            if (rElement != null && !(rElement instanceof FrameReportElement)) {
                if (crosstabReportElement != null) {
                    crosstabReportElement.getElements().addElement(rElement);
                } else {
                    this.elements.addElement(rElement);
                }
            }
            rElement = null;
        }
    }

    private void readHyperlink(Node elementNode, HyperLinkableReportElement re) {
        NodeList childsOfChild = elementNode.getChildNodes();
        NamedNodeMap nodeAttributes = elementNode.getAttributes();
        if (nodeAttributes.getNamedItem("hyperlinkType") != null) {
            re.setHyperlinkType("" + nodeAttributes.getNamedItem("hyperlinkType").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("hyperlinkTarget") != null) {
            re.setHyperlinkTarget("" + nodeAttributes.getNamedItem("hyperlinkTarget").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("bookmarkLevel") != null) {
            re.setBookmarkLevel(Integer.parseInt(nodeAttributes.getNamedItem("bookmarkLevel").getNodeValue()));
        }
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            NamedNodeMap subNodeAttributes = child_child.getAttributes();
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("hyperlinkParameter")) {
                String name = "";
                if (subNodeAttributes.getNamedItem("name") != null) {
                    name = "" + subNodeAttributes.getNamedItem("name").getNodeValue();
                }
                String expression = "";
                NodeList childsOfChildOfChild = child_child.getChildNodes();
                for (int c_count_2 = 0; c_count_2 < childsOfChildOfChild.getLength(); ++c_count_2) {
                    Node child_child_child = childsOfChildOfChild.item(c_count_2);
                    if (child_child_child.getNodeType() != 1 || !child_child_child.getNodeName().equals("hyperlinkParameterExpression")) continue;
                    expression = Report.readPCDATA(child_child_child);
                    break;
                }
                re.getLinkParameters().add(new JRLinkParameter(name, expression));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("anchorNameExpression")) {
                re.setAnchorNameExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("hyperlinkAnchorExpression")) {
                re.setHyperlinkAnchorExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("hyperlinkPageExpression")) {
                re.setHyperlinkPageExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("hyperlinkReferenceExpression")) continue;
            re.setHyperlinkReferenceExpression(Report.readPCDATA(child_child));
        }
    }

    private void readCrosstabRowGroup(Node rowGroupXmlNode, CrosstabReportElement re) {
        CrosstabRowGroup group = new CrosstabRowGroup();
        NamedNodeMap nodeAttributes = rowGroupXmlNode.getAttributes();
        if (nodeAttributes.getNamedItem("name") != null) {
            group.setName(nodeAttributes.getNamedItem("name").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("width") != null) {
            try {
                group.setWidth(Integer.parseInt(nodeAttributes.getNamedItem("width").getNodeValue()));
            }
            catch (Exception ex) {
                System.out.println("Invalid width for crosstab row group " + group.getName());
            }
        }
        if (nodeAttributes.getNamedItem("totalPosition") != null) {
            group.setTotalPosition(nodeAttributes.getNamedItem("totalPosition").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("headerPosition") != null) {
            group.setHeaderPosition(nodeAttributes.getNamedItem("headerPosition").getNodeValue());
        }
        re.getRowGroups().add(group);
        NodeList list_child = rowGroupXmlNode.getChildNodes();
        for (int ck = 0; ck < list_child.getLength(); ++ck) {
            CrosstabCell cell;
            Node child = list_child.item(ck);
            NamedNodeMap subNodeAttributes = child.getAttributes();
            if (child.getNodeType() == 1 && child.getNodeName().equals("bucket")) {
                this.readBucket(child, group);
                continue;
            }
            if (child.getNodeType() == 1 && child.getNodeName().equals("crosstabRowHeader")) {
                cell = new CrosstabCell();
                cell.setName(group.getName() + " header");
                this.readCellContents(child, cell, re);
                group.setHeaderCell(cell);
                cell.setType(1);
                cell.setParent(re);
                re.getCells().add(cell);
                continue;
            }
            if (child.getNodeType() != 1 || !child.getNodeName().equals("crosstabTotalRowHeader")) continue;
            cell = new CrosstabCell();
            cell.setName(group.getName() + " total header");
            this.readCellContents(child, cell, re);
            group.setTotalCell(cell);
            cell.setType(1);
            cell.setParent(re);
            re.getCells().add(cell);
        }
        if (group.getHeaderCell() == null) {
            CrosstabCell cell = new CrosstabCell();
            cell.setName(group.getName() + " header");
            cell.setType(1);
            cell.setParent(re);
            cell.setWidth(group.getWidth());
            re.getCells().add(cell);
            group.setHeaderCell(cell);
        }
        if (group.getTotalCell() == null) {
            CrosstabCell cell = new CrosstabCell();
            cell.setType(1);
            cell.setName(group.getName() + " total header");
            cell.setParent(re);
            cell.setWidth(group.getWidth());
            re.getCells().add(cell);
            group.setTotalCell(cell);
        }
    }

    private void readCrosstabColumnGroup(Node columnGroupXmlNode, CrosstabReportElement re) {
        CrosstabColumnGroup group = new CrosstabColumnGroup();
        NamedNodeMap nodeAttributes = columnGroupXmlNode.getAttributes();
        if (nodeAttributes.getNamedItem("name") != null) {
            group.setName(nodeAttributes.getNamedItem("name").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("height") != null) {
            try {
                group.setHeight(Integer.parseInt(nodeAttributes.getNamedItem("height").getNodeValue()));
            }
            catch (Exception ex) {
                System.out.println("Invalid height for crosstab column group " + group.getName());
            }
        }
        if (nodeAttributes.getNamedItem("totalPosition") != null) {
            group.setTotalPosition(nodeAttributes.getNamedItem("totalPosition").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("headerPosition") != null) {
            group.setHeaderPosition(nodeAttributes.getNamedItem("headerPosition").getNodeValue());
        }
        re.getColumnGroups().add(group);
        NodeList list_child = columnGroupXmlNode.getChildNodes();
        for (int ck = 0; ck < list_child.getLength(); ++ck) {
            CrosstabCell cell;
            Node child = list_child.item(ck);
            NamedNodeMap subNodeAttributes = child.getAttributes();
            if (child.getNodeType() == 1 && child.getNodeName().equals("bucket")) {
                this.readBucket(child, group);
                continue;
            }
            if (child.getNodeType() == 1 && child.getNodeName().equals("crosstabColumnHeader")) {
                cell = new CrosstabCell();
                cell.setName(group.getName() + " header");
                this.readCellContents(child, cell, re);
                group.setHeaderCell(cell);
                cell.setType(1);
                cell.setParent(re);
                re.getCells().add(cell);
                continue;
            }
            if (child.getNodeType() != 1 || !child.getNodeName().equals("crosstabTotalColumnHeader")) continue;
            cell = new CrosstabCell();
            cell.setName(group.getName() + " total header");
            this.readCellContents(child, cell, re);
            group.setTotalCell(cell);
            cell.setType(1);
            cell.setParent(re);
            re.getCells().add(cell);
        }
        if (group.getHeaderCell() == null) {
            CrosstabCell cell = new CrosstabCell();
            cell.setName(group.getName() + " header");
            cell.setType(1);
            cell.setParent(re);
            cell.setHeight(group.getHeight());
            re.getCells().add(cell);
            group.setHeaderCell(cell);
        }
        if (group.getTotalCell() == null) {
            CrosstabCell cell = new CrosstabCell();
            cell.setType(1);
            cell.setName(group.getName() + " total header");
            cell.setParent(re);
            cell.setHeight(group.getHeight());
            re.getCells().add(cell);
            group.setTotalCell(cell);
        }
    }

    private void readCellContents(Node cellConetensNode, CrosstabCell cell, CrosstabReportElement re) {
        NamedNodeMap subNodeAttributes;
        Node child;
        int ck;
        NamedNodeMap nodeAttributes = cellConetensNode.getAttributes();
        if (nodeAttributes.getNamedItem("width") != null) {
            try {
                cell.setWidth(Integer.parseInt(nodeAttributes.getNamedItem("width").getNodeValue()));
            }
            catch (Exception ex) {
                System.out.println("Invalid width for crosstab cell");
            }
        }
        if (nodeAttributes.getNamedItem("height") != null) {
            try {
                cell.setHeight(Integer.parseInt(nodeAttributes.getNamedItem("height").getNodeValue()));
            }
            catch (Exception ex) {
                System.out.println("Invalid height for crosstab cell");
            }
        }
        if (nodeAttributes.getNamedItem("rowTotalGroup") != null) {
            cell.setRowTotalGroup(nodeAttributes.getNamedItem("rowTotalGroup").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("columnTotalGroup") != null) {
            cell.setColumnTotalGroup(nodeAttributes.getNamedItem("columnTotalGroup").getNodeValue());
        }
        Node cellContentsElementNode = null;
        NodeList list_child = cellConetensNode.getChildNodes();
        for (ck = 0; ck < list_child.getLength(); ++ck) {
            child = list_child.item(ck);
            subNodeAttributes = child.getAttributes();
            if (child.getNodeType() != 1 || !child.getNodeName().equals("cellContents")) continue;
            cellContentsElementNode = child;
            if (subNodeAttributes.getNamedItem("style") != null) {
                String sname = subNodeAttributes.getNamedItem("style").getNodeValue();
                for (int j = 0; j < this.getStyles().size(); ++j) {
                    Style sparent = (Style)this.getStyles().elementAt(j);
                    if (!sparent.getName().equals(sname)) continue;
                    cell.setStyle(sparent);
                    break;
                }
            }
            if (subNodeAttributes.getNamedItem("backcolor") != null) {
                cell.setBackcolor(Report.decodeColor(subNodeAttributes.getNamedItem("backcolor").getNodeValue()));
            }
            if (subNodeAttributes.getNamedItem("mode") == null) continue;
            cell.setMode(subNodeAttributes.getNamedItem("mode").getNodeValue());
        }
        if (cellContentsElementNode != null) {
            list_child = cellContentsElementNode.getChildNodes();
            for (ck = 0; ck < list_child.getLength(); ++ck) {
                child = list_child.item(ck);
                subNodeAttributes = child.getAttributes();
                if (child.getNodeType() != 1 || !child.getNodeName().equals("box")) continue;
                this.readBoxElement(child, cell);
            }
        }
        this.readBandElements("", cellContentsElementNode, null, null, re, cell);
    }

    private void readBucket(Node bucketXmlNode, CrosstabGroup grp) {
        NamedNodeMap nodeAttributes = bucketXmlNode.getAttributes();
        if (nodeAttributes.getNamedItem("order") != null) {
            grp.setBucketOrder(nodeAttributes.getNamedItem("order").getNodeValue());
        }
        NodeList list_child = bucketXmlNode.getChildNodes();
        for (int ck = 0; ck < list_child.getLength(); ++ck) {
            Node child = list_child.item(ck);
            NamedNodeMap subNodeAttributes = child.getAttributes();
            if (child.getNodeType() == 1 && child.getNodeName().equals("bucketExpression")) {
                if (subNodeAttributes.getNamedItem("class") != null) {
                    grp.setBucketExpressionClass(subNodeAttributes.getNamedItem("class").getNodeValue());
                }
                grp.setBucketExpression(Report.readPCDATA(child));
                continue;
            }
            if (child.getNodeType() != 1 || !child.getNodeName().equals("comparatorExpression")) continue;
            grp.setBucketComparatorExpression(Report.readPCDATA(child));
        }
    }

    private void readChartElement(Node xmlChart, ChartReportElement2 re) {
        NamedNodeMap nodeAttributes = xmlChart.getAttributes();
        if (nodeAttributes.getNamedItem("isShowLegend") != null) {
            re.getChart().setShowLegend(nodeAttributes.getNamedItem("isShowLegend").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("evaluationTime") != null) {
            re.setEvaluationTime(nodeAttributes.getNamedItem("evaluationTime").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("evaluationGroup") != null) {
            re.setEvaluationGroup(nodeAttributes.getNamedItem("evaluationGroup").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("customizerClass") != null) {
            re.getChart().setCustomizerClass(nodeAttributes.getNamedItem("customizerClass").getNodeValue());
        }
        NodeList childsOfChild = xmlChart.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("printWhenExpression")) {
                re.setPrintWhenExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("reportElement")) {
                this.readXMLReportElement(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("box")) {
                this.readBoxElement(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("chartTitle")) {
                this.readChartTitleElement(child_child, re);
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("chartSubtitle")) continue;
            this.readChartSubTitleElement(child_child, re);
        }
        this.readHyperlink(xmlChart, re);
    }

    private void readChartTitleElement(Node xmlElement, ChartReportElement2 re) {
        NamedNodeMap nodeAttributes = xmlElement.getAttributes();
        if (nodeAttributes.getNamedItem("position") != null) {
            re.getChart().getTitle().setPosition(nodeAttributes.getNamedItem("position").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("color") != null) {
            re.getChart().getTitle().setColor(Report.decodeColor("" + nodeAttributes.getNamedItem("color").getNodeValue()));
        }
        NodeList childsOfChild = xmlElement.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("titleExpression")) {
                re.getChart().getTitle().setTitleExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("font")) continue;
            re.getChart().getTitle().setFont(this.readFontElement(child_child));
        }
    }

    private IReportFont readFontElement(Node xmlElement) {
        NamedNodeMap nnm = xmlElement.getAttributes();
        IReportFont font = null;
        if (nnm.getNamedItem("reportFont") != null && (font = this.getReportFontByName(nnm.getNamedItem("reportFont").getNodeValue())) != null) {
            font = (IReportFont)font.clone();
            font.setReportFont(nnm.getNamedItem("reportFont").getNodeValue());
        }
        if (font == null) {
            font = this.defaultFont != null ? (IReportFont)this.defaultFont.clone() : new IReportFont();
        }
        for (int kkk = 0; kkk < nnm.getLength(); ++kkk) {
            String propName = nnm.item(kkk).getNodeName();
            String propValue = nnm.item(kkk).getNodeValue();
            if (propName == null || propValue == null) continue;
            if (propName.equals("fontName")) {
                font.setFontName(propValue);
                continue;
            }
            if (propName.equals("pdfFontName")) {
                font.setPDFFontName(propValue);
                continue;
            }
            if (propName.equals("size")) {
                font.setFontSize(Integer.parseInt("" + propValue));
                continue;
            }
            if (propName.equals("isBold")) {
                font.setBold(new String("" + propValue).equalsIgnoreCase("true"));
                continue;
            }
            if (propName.equals("isItalic")) {
                font.setItalic(new String("" + propValue).equalsIgnoreCase("true"));
                continue;
            }
            if (propName.equals("isUnderline")) {
                font.setUnderline(new String("" + propValue).equalsIgnoreCase("true"));
                continue;
            }
            if (propName.equals("isStrikeThrough")) {
                font.setStrikeTrought(new String("" + propValue).equalsIgnoreCase("true"));
                continue;
            }
            if (propName.equals("isPdfEmbedded")) {
                font.setPdfEmbedded(new String("" + propValue).equalsIgnoreCase("true"));
                continue;
            }
            if (!propName.equals("pdfEncoding")) continue;
            font.setPdfEncoding("" + propValue);
        }
        return font;
    }

    private void readDataset(Node xmlNode, ChartReportElement2 re) {
        this.readDataset(xmlNode, re.getChart().getDataset());
    }

    private void readDataset(Node xmlNode, Dataset dataset) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        if (nodeAttributes.getNamedItem("resetType") != null) {
            dataset.setResetType(nodeAttributes.getNamedItem("resetType").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("resetGroup") != null) {
            dataset.setResetGroup(nodeAttributes.getNamedItem("resetGroup").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("incrementType") != null) {
            dataset.setIncrementType(nodeAttributes.getNamedItem("incrementType").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("incrementGroup") != null) {
            dataset.setIncrementGroup(nodeAttributes.getNamedItem("incrementGroup").getNodeValue());
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            NamedNodeMap subNodeAttributes = child_child.getAttributes();
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("incrementWhenExpression")) {
                dataset.setIncrementWhenExpression(Report.readPCDATA(child_child));
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("datasetRun") || subNodeAttributes.getNamedItem("subDataset") == null) continue;
            String name = subNodeAttributes.getNamedItem("subDataset").getNodeValue();
            Enumeration enum_datasets = this.getSubDatasets().elements();
            while (enum_datasets.hasMoreElements()) {
                SubDataset subDataset = (SubDataset)enum_datasets.nextElement();
                if (!subDataset.getName().equals(name)) continue;
                dataset.setSubDataset(subDataset);
                break;
            }
            NodeList childsOfchild_child = child_child.getChildNodes();
            for (int c_count2 = 0; c_count2 < childsOfchild_child.getLength(); ++c_count2) {
                Node child_child2 = childsOfchild_child.item(c_count2);
                NamedNodeMap subNodeAttributes2 = child_child2.getAttributes();
                if (child_child2.getNodeType() == 1 && child_child2.getNodeName().equals("parametersMapExpression")) {
                    dataset.setParametersMapExpression(Report.readPCDATA(child_child2));
                    continue;
                }
                if (child_child2.getNodeType() == 1 && child_child2.getNodeName().equals("datasetParameter")) {
                    name = "";
                    if (subNodeAttributes2.getNamedItem("name") != null) {
                        name = "" + subNodeAttributes2.getNamedItem("name").getNodeValue();
                    }
                    String expression = "";
                    NodeList childsOfChildOfChild = child_child2.getChildNodes();
                    for (int c_count_2 = 0; c_count_2 < childsOfChildOfChild.getLength(); ++c_count_2) {
                        Node child_child_child = childsOfChildOfChild.item(c_count_2);
                        if (child_child_child.getNodeType() != 1 || !child_child_child.getNodeName().equals("datasetParameterExpression")) continue;
                        expression = Report.readPCDATA(child_child_child);
                        break;
                    }
                    dataset.getSubreportParameters().addElement(new JRSubreportParameter(name, expression));
                    continue;
                }
                if (child_child2.getNodeType() == 1 && child_child2.getNodeName().equals("connectionExpression")) {
                    dataset.setConnectionExpression(Report.readPCDATA(child_child2));
                    dataset.setUseConnection(true);
                    continue;
                }
                if (child_child2.getNodeType() != 1 || !child_child2.getNodeName().equals("dataSourceExpression")) continue;
                dataset.setDataSourceExpression(Report.readPCDATA(child_child2));
                dataset.setUseConnection(false);
            }
        }
    }

    private void readSectionItemHyperlink(Node elementNode, SectionItemHyperlink sih) {
        NodeList childsOfChild = elementNode.getChildNodes();
        NamedNodeMap nodeAttributes = elementNode.getAttributes();
        if (nodeAttributes.getNamedItem("hyperlinkType") != null) {
            sih.setHyperlinkType("" + nodeAttributes.getNamedItem("hyperlinkType").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("hyperlinkTarget") != null) {
            sih.setHyperlinkTarget("" + nodeAttributes.getNamedItem("hyperlinkTarget").getNodeValue());
        }
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            NamedNodeMap subNodeAttributes = child_child.getAttributes();
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("hyperlinkParameter")) {
                String name = "";
                if (subNodeAttributes.getNamedItem("name") != null) {
                    name = "" + subNodeAttributes.getNamedItem("name").getNodeValue();
                }
                String expression = "";
                NodeList childsOfChildOfChild = child_child.getChildNodes();
                for (int c_count_2 = 0; c_count_2 < childsOfChildOfChild.getLength(); ++c_count_2) {
                    Node child_child_child = childsOfChildOfChild.item(c_count_2);
                    if (child_child_child.getNodeType() != 1 || !child_child_child.getNodeName().equals("hyperlinkParameterExpression")) continue;
                    expression = Report.readPCDATA(child_child_child);
                    break;
                }
                sih.getHyperlinkParameters().add(new JRLinkParameter(name, expression));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("hyperlinkAnchorExpression")) {
                sih.setHyperlinkAnchorExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("hyperlinkPageExpression")) {
                sih.setHyperlinkPageExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("hyperlinkReferenceExpression")) {
                sih.setHyperlinkReferenceExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("hyperlinkTooltipExpression")) continue;
            sih.setHyperlinkTooltipExpression(Report.readPCDATA(child_child));
        }
    }

    private void readPieDataset(Node xmlNode, ChartReportElement2 re) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataset")) {
                this.readDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("keyExpression")) {
                ((PieDataset)re.getChart().getDataset()).setKeyExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueExpression")) {
                ((PieDataset)re.getChart().getDataset()).setValueExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("labelExpression")) {
                ((PieDataset)re.getChart().getDataset()).setLabelExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("sectionHyperlink")) continue;
            this.readSectionItemHyperlink(child_child, ((PieDataset)re.getChart().getDataset()).getSectionHyperLink());
        }
    }

    private void readCategoryDataset(Node xmlNode, ChartReportElement2 re) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        CategoryDataset cd = new CategoryDataset();
        re.getChart().setDataset(cd);
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataset")) {
                this.readDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("categorySeries")) continue;
            CategorySeries cs = this.readCategorySeries(child_child);
            cd.getCategorySeries().add(cs);
        }
    }

    private void readTimePeriodDataset(Node xmlNode, ChartReportElement2 re) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        TimePeriodDataset cd = new TimePeriodDataset();
        re.getChart().setDataset(cd);
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataset")) {
                this.readDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("timePeriodSeries")) continue;
            TimePeriodSeries cs = this.readTimePeriodSeries(child_child);
            cd.getTimePeriodSeries().add(cs);
        }
    }

    private void readXYDataset(Node xmlNode, ChartReportElement2 re) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        XYDataset cd = new XYDataset();
        re.getChart().setDataset(cd);
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataset")) {
                this.readDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("xySeries")) continue;
            XYSeries cs = this.readXYSeries(child_child);
            cd.getXYSeries().add(cs);
        }
    }

    private void readXYZDataset(Node xmlNode, ChartReportElement2 re) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        XYZDataset cd = new XYZDataset();
        re.getChart().setDataset(cd);
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataset")) {
                this.readDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("xyzSeries")) continue;
            XYZSeries cs = this.readXYZSeries(child_child);
            cd.getXYZSeries().add(cs);
        }
    }

    private void readTimeSeriesDataset(Node xmlNode, ChartReportElement2 re) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        NodeList childsOfChild = xmlNode.getChildNodes();
        TimeSeriesDataset cd = new TimeSeriesDataset();
        re.getChart().setDataset(cd);
        if (nodeAttributes.getNamedItem("timePeriod") != null) {
            cd.setTimePeriod(nodeAttributes.getNamedItem("timePeriod").getNodeValue());
        }
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataset")) {
                this.readDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("timeSeries")) continue;
            TimeSeries cs = this.readTimeSeries(child_child);
            cd.getTimeSeries().add(cs);
        }
    }

    private void readHighLowDataset(Node xmlNode, ChartReportElement2 re) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        HighLowDataset cd = new HighLowDataset();
        re.getChart().setDataset(cd);
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dataset")) {
                this.readDataset(child_child, re);
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("seriesExpression")) {
                cd.setSeriesExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("dateExpression")) {
                cd.setDateExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("highExpression")) {
                cd.setHighExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("lowExpression")) {
                cd.setLowExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("openExpression")) {
                cd.setOpenExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("closeExpression")) {
                cd.setCloseExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("volumeExpression")) {
                cd.setVolumeExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("sectionHyperlink")) continue;
            this.readSectionItemHyperlink(child_child, cd.getItemHyperLink());
        }
    }

    private CategorySeries readCategorySeries(Node xmlNode) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        CategorySeries cs = new CategorySeries();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("seriesExpression")) {
                cs.setSeriesExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("categoryExpression")) {
                cs.setCategoryExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueExpression")) {
                cs.setValueExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("labelExpression")) {
                cs.setLabelExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("sectionHyperlink")) continue;
            this.readSectionItemHyperlink(child_child, cs.getSectionItemHyperlink());
        }
        return cs;
    }

    private TimePeriodSeries readTimePeriodSeries(Node xmlNode) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        TimePeriodSeries cs = new TimePeriodSeries();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("seriesExpression")) {
                cs.setSeriesExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("startDateExpression")) {
                cs.setStartDateExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("endDateExpression")) {
                cs.setEndDateExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueExpression")) {
                cs.setValueExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("labelExpression")) {
                cs.setLabelExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("sectionHyperlink")) continue;
            this.readSectionItemHyperlink(child_child, cs.getSectionItemHyperlink());
        }
        return cs;
    }

    private TimeSeries readTimeSeries(Node xmlNode) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        TimeSeries cs = new TimeSeries();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("seriesExpression")) {
                cs.setSeriesExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("timePeriodExpression")) {
                cs.setTimePeriodExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("valueExpression")) {
                cs.setValueExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("labelExpression")) {
                cs.setLabelExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("sectionHyperlink")) continue;
            this.readSectionItemHyperlink(child_child, cs.getSectionItemHyperlink());
        }
        return cs;
    }

    private XYSeries readXYSeries(Node xmlNode) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        XYSeries cs = new XYSeries();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("seriesExpression")) {
                cs.setSeriesExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("xValueExpression")) {
                cs.setXValueExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("yValueExpression")) {
                cs.setYValueExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("labelExpression")) {
                cs.setLabelExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("sectionHyperlink")) continue;
            this.readSectionItemHyperlink(child_child, cs.getSectionItemHyperlink());
        }
        return cs;
    }

    private XYZSeries readXYZSeries(Node xmlNode) {
        NodeList childsOfChild = xmlNode.getChildNodes();
        XYZSeries cs = new XYZSeries();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("seriesExpression")) {
                cs.setSeriesExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("xValueExpression")) {
                cs.setXValueExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("yValueExpression")) {
                cs.setYValueExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("zValueExpression")) {
                cs.setZValueExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("sectionHyperlink")) continue;
            this.readSectionItemHyperlink(child_child, cs.getSectionItemHyperlink());
        }
        return cs;
    }

    private void readPiePlot(Node xmlNode, PiePlot plot) {
        this.readPlot(xmlNode, plot);
    }

    private void readPie3DPlot(Node xmlNode, Pie3DPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        if (nodeAttributes.getNamedItem("depthFactor") != null) {
            plot.setDepthFactor(Double.parseDouble(nodeAttributes.getNamedItem("depthFactor").getNodeValue()));
        }
        this.readPlot(xmlNode, plot);
    }

    private void readBarPlot(Node xmlNode, BarPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("isShowLabels") != null) {
            plot.setShowLabels(nodeAttributes.getNamedItem("isShowLabels").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("isShowTickMarks") != null) {
            plot.setShowTickMarks(nodeAttributes.getNamedItem("isShowTickMarks").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("isShowTickLabels") != null) {
            plot.setShowTickLabels(nodeAttributes.getNamedItem("isShowTickLabels").getNodeValue().equals("true"));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("categoryAxisLabelExpression")) {
                plot.setCategoryAxisLabelExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("valueAxisLabelExpression")) continue;
            plot.setValueAxisLabelExpression(Report.readPCDATA(child_child));
        }
    }

    private void readBar3DPlot(Node xmlNode, Bar3DPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("isShowLabels") != null) {
            plot.setShowLabels(nodeAttributes.getNamedItem("isShowLabels").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("xOffset") != null) {
            plot.setXOffset(Double.parseDouble(nodeAttributes.getNamedItem("xOffset").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("yOffset") != null) {
            plot.setYOffset(Double.parseDouble(nodeAttributes.getNamedItem("yOffset").getNodeValue()));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("categoryAxisLabelExpression")) {
                plot.setCategoryAxisLabelExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("valueAxisLabelExpression")) continue;
            plot.setValueAxisLabelExpression(Report.readPCDATA(child_child));
        }
    }

    private void readLinePlot(Node xmlNode, LinePlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("isShowLines") != null) {
            plot.setShowLines(nodeAttributes.getNamedItem("isShowLines").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("isShowShapes") != null) {
            plot.setShowShapes(nodeAttributes.getNamedItem("isShowShapes").getNodeValue().equals("true"));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("categoryAxisLabelExpression")) {
                plot.setCategoryAxisLabelExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("valueAxisLabelExpression")) continue;
            plot.setValueAxisLabelExpression(Report.readPCDATA(child_child));
        }
    }

    private void readAreaPlot(Node xmlNode, AreaPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("categoryAxisLabelExpression")) {
                plot.setCategoryAxisLabelExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("valueAxisLabelExpression")) continue;
            plot.setValueAxisLabelExpression(Report.readPCDATA(child_child));
        }
    }

    private void readScatterPlot(Node xmlNode, ScatterPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("isShowLines") != null) {
            plot.setShowLines(nodeAttributes.getNamedItem("isShowLines").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("isShowShapes") != null) {
            plot.setShowShapes(nodeAttributes.getNamedItem("isShowShapes").getNodeValue().equals("true"));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("xAxisLabelExpression")) {
                plot.setXAxisLabelExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("yAxisLabelExpression")) continue;
            plot.setYAxisLabelExpression(Report.readPCDATA(child_child));
        }
    }

    private void readBubblePlot(Node xmlNode, BubblePlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("scaleType") != null) {
            plot.setScaleType(nodeAttributes.getNamedItem("scaleType").getNodeValue());
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("xAxisLabelExpression")) {
                plot.setXAxisLabelExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("yAxisLabelExpression")) continue;
            plot.setYAxisLabelExpression(Report.readPCDATA(child_child));
        }
    }

    private void readTimeSeriesPlot(Node xmlNode, TimeSeriesPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("isShowLines") != null) {
            plot.setShowLines(nodeAttributes.getNamedItem("isShowLines").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("isShowShapes") != null) {
            plot.setShowShapes(nodeAttributes.getNamedItem("isShowShapes").getNodeValue().equals("true"));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("timeAxisLabelExpression")) {
                plot.setTimeAxisLabelExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("valueAxisLabelExpression")) continue;
            plot.setValueAxisLabelExpression(Report.readPCDATA(child_child));
        }
    }

    private void readHighLowPlot(Node xmlNode, HighLowPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("isShowCloseTicks") != null) {
            plot.setShowCloseTicks(nodeAttributes.getNamedItem("isShowCloseTicks").getNodeValue().equals("true"));
        }
        if (nodeAttributes.getNamedItem("isShowOpenTicks") != null) {
            plot.setShowOpenTicks(nodeAttributes.getNamedItem("isShowOpenTicks").getNodeValue().equals("true"));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("timeAxisLabelExpression")) {
                plot.setTimeAxisLabelExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("valueAxisLabelExpression")) continue;
            plot.setValueAxisLabelExpression(Report.readPCDATA(child_child));
        }
    }

    private void readCandlestickPlot(Node xmlNode, CandlestickPlot plot) {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        this.readPlot(xmlNode, plot);
        if (nodeAttributes.getNamedItem("isShowVolume") != null) {
            plot.setShowVolume(nodeAttributes.getNamedItem("isShowVolume").getNodeValue().equals("true"));
        }
        NodeList childsOfChild = xmlNode.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("timeAxisLabelExpression")) {
                plot.setTimeAxisLabelExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("valueAxisLabelExpression")) continue;
            plot.setValueAxisLabelExpression(Report.readPCDATA(child_child));
        }
    }

    private void readPlot(Node xmlNodeParent, Plot plot) {
        NodeList childsOfChild = xmlNodeParent.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node xmlNode = childsOfChild.item(c_count);
            if (xmlNode.getNodeType() != 1 || !xmlNode.getNodeName().equals("plot")) continue;
            NamedNodeMap nodeAttributes = xmlNode.getAttributes();
            if (nodeAttributes.getNamedItem("backcolor") != null) {
                plot.setBackcolor(Report.decodeColor("" + nodeAttributes.getNamedItem("backcolor").getNodeValue()));
            }
            if (nodeAttributes.getNamedItem("orientation") != null) {
                plot.setOrientation("" + nodeAttributes.getNamedItem("orientation").getNodeValue());
            }
            if (nodeAttributes.getNamedItem("backgroundAlpha") != null) {
                plot.setBackgroundAlpha(Double.parseDouble(nodeAttributes.getNamedItem("backgroundAlpha").getNodeValue()));
            }
            if (nodeAttributes.getNamedItem("foregroundAlpha") == null) break;
            plot.setForegroundAlpha(Double.parseDouble(nodeAttributes.getNamedItem("foregroundAlpha").getNodeValue()));
            break;
        }
    }

    private void readChartSubTitleElement(Node xmlElement, ChartReportElement2 re) {
        NamedNodeMap nodeAttributes = xmlElement.getAttributes();
        if (nodeAttributes.getNamedItem("color") != null) {
            re.getChart().getSubTitle().setColor(Report.decodeColor("" + nodeAttributes.getNamedItem("color").getNodeValue()));
        }
        NodeList childsOfChild = xmlElement.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() == 1 && child_child.getNodeName().equals("subtitleExpression")) {
                re.getChart().getSubTitle().setTitleExpression(Report.readPCDATA(child_child));
                continue;
            }
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("font")) continue;
            re.getChart().getSubTitle().setFont(this.readFontElement(child_child));
        }
    }

    private void readXMLReportElement(Node xmlReportElement, ReportElement re) {
        String color;
        NamedNodeMap nodeAttributes = xmlReportElement.getAttributes();
        if (nodeAttributes.getNamedItem("style") != null) {
            String sname = nodeAttributes.getNamedItem("style").getNodeValue();
            for (int j = 0; j < this.getStyles().size(); ++j) {
                Style sparent = (Style)this.getStyles().elementAt(j);
                if (!sparent.getName().equals(sname)) continue;
                re.setStyle(sparent);
                break;
            }
        }
        if (nodeAttributes.getNamedItem("x") != null) {
            re.getRelativePosition().x = re.getPosition().x = Integer.parseInt("" + nodeAttributes.getNamedItem("x").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("y") != null) {
            re.getRelativePosition().y = re.getPosition().y = Integer.parseInt("" + nodeAttributes.getNamedItem("y").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("width") != null) {
            re.setWidth(Integer.parseInt("" + nodeAttributes.getNamedItem("width").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("height") != null) {
            re.setHeight(Integer.parseInt("" + nodeAttributes.getNamedItem("height").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("key") != null) {
            re.setKey("" + nodeAttributes.getNamedItem("key").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("stretchType") != null) {
            re.setStretchType("" + nodeAttributes.getNamedItem("stretchType").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("isPrintRepeatedValues") != null) {
            re.setIsPrintRepeatedValues(("" + nodeAttributes.getNamedItem("isPrintRepeatedValues").getNodeValue()).equalsIgnoreCase("true"));
        }
        if (nodeAttributes.getNamedItem("positionType") != null) {
            re.setPositionType("" + nodeAttributes.getNamedItem("positionType").getNodeValue());
        } else {
            re.setPositionType("FixRelativeToTop");
        }
        if (nodeAttributes.getNamedItem("isPrintRepeatedValues") != null) {
            re.setIsPrintRepeatedValues(("" + nodeAttributes.getNamedItem("isPrintRepeatedValues").getNodeValue()).equalsIgnoreCase("true"));
        }
        if (nodeAttributes.getNamedItem("isRemoveLineWhenBlank") != null) {
            re.setIsRemoveLineWhenBlank(("" + nodeAttributes.getNamedItem("isRemoveLineWhenBlank").getNodeValue()).equalsIgnoreCase("true"));
        }
        if (nodeAttributes.getNamedItem("isPrintInFirstWholeBand") != null) {
            re.setIsPrintInFirstWholeBand(("" + nodeAttributes.getNamedItem("isPrintInFirstWholeBand").getNodeValue()).equalsIgnoreCase("true"));
        }
        if (nodeAttributes.getNamedItem("isPrintWhenDetailOverflows") != null) {
            re.setIsPrintWhenDetailOverflows(("" + nodeAttributes.getNamedItem("isPrintWhenDetailOverflows").getNodeValue()).equalsIgnoreCase("true"));
        }
        if (nodeAttributes.getNamedItem("printWhenGroupChanges") != null) {
            re.setPrintWhenGroupChanges("" + nodeAttributes.getNamedItem("printWhenGroupChanges").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("forecolor") != null) {
            color = "" + nodeAttributes.getNamedItem("forecolor").getNodeValue();
            re.setFgcolor(Report.decodeColor(color));
        }
        if (nodeAttributes.getNamedItem("backcolor") != null) {
            color = "" + nodeAttributes.getNamedItem("backcolor").getNodeValue();
            re.setBgcolor(Report.decodeColor(color));
        }
        if (nodeAttributes.getNamedItem("mode") != null) {
            re.setTransparent("" + nodeAttributes.getNamedItem("mode").getNodeValue());
        }
        NodeList childsOfChild = xmlReportElement.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("printWhenExpression")) continue;
            re.setPrintWhenExpression(Report.readPCDATA(child_child));
        }
    }

    private void readBoxElement(Node xmlReportElement, BoxElement re) {
        String color;
        NamedNodeMap nodeAttributes = xmlReportElement.getAttributes();
        Box box = new Box();
        if (nodeAttributes.getNamedItem("border") != null) {
            box.setBorder("" + nodeAttributes.getNamedItem("border").getNodeValue());
            box.setLeftBorder("" + nodeAttributes.getNamedItem("border").getNodeValue());
            box.setRightBorder("" + nodeAttributes.getNamedItem("border").getNodeValue());
            box.setTopBorder("" + nodeAttributes.getNamedItem("border").getNodeValue());
            box.setBottomBorder("" + nodeAttributes.getNamedItem("border").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("padding") != null) {
            box.setPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("padding").getNodeValue()));
            box.setLeftPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("padding").getNodeValue()));
            box.setRightPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("padding").getNodeValue()));
            box.setTopPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("padding").getNodeValue()));
            box.setBottomPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("padding").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("borderColor") != null) {
            color = "" + nodeAttributes.getNamedItem("borderColor").getNodeValue();
            Color colorObj = Report.decodeColor(color);
            box.setBorderColor(new Color(colorObj.getRGB()));
            box.setLeftBorderColor(new Color(colorObj.getRGB()));
            box.setRightBorderColor(new Color(colorObj.getRGB()));
            box.setTopBorderColor(new Color(colorObj.getRGB()));
            box.setBottomBorderColor(new Color(colorObj.getRGB()));
        }
        if (nodeAttributes.getNamedItem("topBorder") != null) {
            box.setTopBorder("" + nodeAttributes.getNamedItem("topBorder").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("topPadding") != null) {
            box.setTopPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("topPadding").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("topBorderColor") != null) {
            color = "" + nodeAttributes.getNamedItem("topBorderColor").getNodeValue();
            box.setTopBorderColor(Report.decodeColor(color));
        }
        if (nodeAttributes.getNamedItem("leftBorder") != null) {
            box.setLeftBorder("" + nodeAttributes.getNamedItem("leftBorder").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("leftPadding") != null) {
            box.setLeftPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("leftPadding").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("leftBorderColor") != null) {
            color = "" + nodeAttributes.getNamedItem("leftBorderColor").getNodeValue();
            box.setLeftBorderColor(Report.decodeColor(color));
        }
        if (nodeAttributes.getNamedItem("rightBorder") != null) {
            box.setRightBorder("" + nodeAttributes.getNamedItem("rightBorder").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("rightPadding") != null) {
            box.setRightPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("rightPadding").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("rightBorderColor") != null) {
            color = "" + nodeAttributes.getNamedItem("rightBorderColor").getNodeValue();
            box.setRightBorderColor(Report.decodeColor(color));
        }
        if (nodeAttributes.getNamedItem("bottomBorder") != null) {
            box.setBottomBorder("" + nodeAttributes.getNamedItem("bottomBorder").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("bottomPadding") != null) {
            box.setBottomPadding(Integer.parseInt("" + nodeAttributes.getNamedItem("bottomPadding").getNodeValue()));
        }
        if (nodeAttributes.getNamedItem("bottomBorderColor") != null) {
            color = "" + nodeAttributes.getNamedItem("bottomBorderColor").getNodeValue();
            box.setBottomBorderColor(Report.decodeColor(color));
        }
        if (re instanceof BoxElement) {
            re.setBox(box);
        }
    }

    public static String readPCDATA(Node textNode) {
        return Report.readPCDATA(textNode, true);
    }

    static Color decodeColor(String colorString) {
        Color color = null;
        char firstChar = colorString.charAt(0);
        color = firstChar == '#' ? new Color(Integer.parseInt(colorString.substring(1), 16)) : ('0' <= firstChar && firstChar <= '9' ? new Color(Integer.parseInt(colorString)) : (JRXmlConstants.getColorMap().containsKey(colorString) ? (Color)JRXmlConstants.getColorMap().get(colorString) : Color.black));
        return color;
    }

    public static String readPCDATA(Node textNode, boolean trim) {
        NodeList list_child = textNode.getChildNodes();
        for (int ck = 0; ck < list_child.getLength(); ++ck) {
            short nt;
            Node child_child = list_child.item(ck);
            Node ns = child_child.getNextSibling();
            if (ns != null) {
                child_child = ns;
            }
            if ((nt = child_child.getNodeType()) != 4 && nt != 3) continue;
            if (trim) {
                return child_child.getNodeValue().trim();
            }
            return child_child.getNodeValue();
        }
        return "";
    }

    private void readXMLTextElement(Node xmlReportElement, TextReportElement re) {
        NamedNodeMap nodeAttributes = xmlReportElement.getAttributes();
        if (nodeAttributes.getNamedItem("textAlignment") != null) {
            re.setAlign("" + nodeAttributes.getNamedItem("textAlignment").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("verticalAlignment") != null) {
            re.setVerticalAlign("" + nodeAttributes.getNamedItem("verticalAlignment").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("lineSpacing") != null) {
            re.setLineSpacing("" + nodeAttributes.getNamedItem("lineSpacing").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("rotation") != null) {
            re.setRotate("" + nodeAttributes.getNamedItem("rotation").getNodeValue());
        }
        if (nodeAttributes.getNamedItem("isStyledText") != null) {
            re.setIsStyledText(("" + nodeAttributes.getNamedItem("isStyledText").getNodeValue()).equals("true"));
        }
        NodeList childsOfChild = xmlReportElement.getChildNodes();
        for (int c_count = 0; c_count < childsOfChild.getLength(); ++c_count) {
            Node child_child = childsOfChild.item(c_count);
            if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("font")) continue;
            NamedNodeMap subNodeAttributes = child_child.getAttributes();
            if (subNodeAttributes.getNamedItem("reportFont") != null) {
                IReportFont baseFont = null;
                re.setReportFont(subNodeAttributes.getNamedItem("reportFont").getNodeValue());
                for (int fn = 0; !(fn >= this.fonts.size() || (baseFont = (IReportFont)this.fonts.elementAt(fn)) != null && baseFont.getReportFont().equals(re.getReportFont())); ++fn) {
                    baseFont = null;
                }
                if (baseFont != null) {
                    // empty if block
                }
            }
            for (int kkk = 0; kkk < subNodeAttributes.getLength(); ++kkk) {
                String propName = subNodeAttributes.item(kkk).getNodeName();
                String propValue = subNodeAttributes.item(kkk).getNodeValue();
                if (propName == null || propValue == null) continue;
                if (propName.equals("fontName")) {
                    re.setFontName(propValue);
                    continue;
                }
                if (propName.equals("pdfFontName")) {
                    re.setPDFFontName(propValue);
                    continue;
                }
                if (propName.equals("size")) {
                    re.setFontSize(Integer.parseInt("" + propValue));
                    continue;
                }
                if (propName.equals("isBold")) {
                    re.setBold(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isItalic")) {
                    re.setItalic(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isUnderline")) {
                    re.setUnderline(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isStrikeThrough")) {
                    re.setStrikeTrought(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (propName.equals("isPdfEmbedded")) {
                    re.setPdfEmbedded(new String("" + propValue).equalsIgnoreCase("true"));
                    continue;
                }
                if (!propName.equals("pdfEncoding")) continue;
                re.setPdfEncoding("" + propValue);
            }
            re.setFont(null);
        }
    }

    private Node findNextNode(Node node) {
        int i;
        short type = node.getNodeType();
        if (type == 1) {
            return node;
        }
        NodeList children = node.getChildNodes();
        if (children != null && (i = 0) < children.getLength()) {
            return this.findNextNode(children.item(i));
        }
        return null;
    }

    public Vector getBands() {
        return this.bands;
    }

    public void setBands(Vector bands) {
        this.bands = bands;
        this.incrementReportChanges();
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(int bottomMargin) {
        if (this.bottomMargin == bottomMargin) {
            return;
        }
        this.bottomMargin = bottomMargin;
        this.incrementReportChanges();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        if (this.columnCount == columnCount) {
            return;
        }
        this.columnCount = columnCount;
        this.incrementReportChanges();
    }

    public int getColumnSpacing() {
        return this.columnSpacing;
    }

    public void setColumnSpacing(int columnSpacing) {
        if (this.columnSpacing == columnSpacing) {
            return;
        }
        this.columnSpacing = columnSpacing;
        this.incrementReportChanges();
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(int columnWidth) {
        if (this.columnWidth == columnWidth) {
            return;
        }
        this.columnWidth = columnWidth;
        this.incrementReportChanges();
    }

    public Vector getElements() {
        return this.elements;
    }

    public void setElements(Vector elements) {
        this.elements = elements;
        this.incrementReportChanges();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (this.encoding == null ? encoding == null : this.encoding.equals(encoding)) {
            return;
        }
        this.encoding = encoding;
        this.incrementReportChanges();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Vector getFonts() {
        return this.fonts;
    }

    public void setFonts(Vector fonts) {
        this.fonts = fonts;
        this.incrementReportChanges();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        if (this.height == height) {
            return;
        }
        this.height = height;
        this.incrementReportChanges();
    }

    public boolean isIsSummaryNewPage() {
        return this.isSummaryNewPage;
    }

    public void setIsSummaryNewPage(boolean isSummaryNewPage) {
        if (this.isSummaryNewPage == isSummaryNewPage) {
            return;
        }
        this.isSummaryNewPage = isSummaryNewPage;
        this.incrementReportChanges();
    }

    public boolean isIsTitleNewPage() {
        return this.isTitleNewPage;
    }

    public void setIsTitleNewPage(boolean isTitleNewPage) {
        if (this.isTitleNewPage == isTitleNewPage) {
            return;
        }
        this.isTitleNewPage = isTitleNewPage;
        this.incrementReportChanges();
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(int leftMargin) {
        if (this.leftMargin == leftMargin) {
            return;
        }
        this.leftMargin = leftMargin;
        this.incrementReportChanges();
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public void setLoadTime(long loadTime) {
        this.loadTime = loadTime;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        if (this.orientation == null ? orientation == null : this.orientation.equals(orientation)) {
            return;
        }
        this.orientation = orientation;
        this.incrementReportChanges();
    }

    public String getPrintOrder() {
        return this.printOrder;
    }

    public void setPrintOrder(String printOrder) {
        if (this.printOrder == null ? printOrder == null : this.printOrder.equals(printOrder)) {
            return;
        }
        this.printOrder = printOrder;
        this.incrementReportChanges();
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(int rightMargin) {
        if (this.rightMargin == rightMargin) {
            return;
        }
        this.rightMargin = rightMargin;
        this.incrementReportChanges();
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int topMargin) {
        if (this.topMargin == topMargin) {
            return;
        }
        this.topMargin = topMargin;
        this.incrementReportChanges();
    }

    public void addImport(String _import) {
        if (!this.imports.contains(_import)) {
            this.imports.add(_import);
            this.incrementReportChanges();
        }
    }

    public String getWhenNoDataType() {
        return this.whenNoDataType;
    }

    public void setWhenNoDataType(String whenNoDataType) {
        if (this.whenNoDataType == null ? whenNoDataType == null : this.whenNoDataType.equals(whenNoDataType)) {
            return;
        }
        this.whenNoDataType = whenNoDataType;
        this.incrementReportChanges();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (this.width == width) {
            return;
        }
        this.width = width;
        this.incrementReportChanges();
    }

    public int getBandYLocation(Band b) {
        Band band;
        int y = this.topMargin;
        Iterator i = this.bands.iterator();
        while (i.hasNext() && (band = (Band)i.next()) != b) {
            y += band.getHeight();
        }
        return y;
    }

    public JReportFrame getReportFrame() {
        return this.reportFrame;
    }

    public void setReportFrame(JReportFrame reportFrame) {
        this.reportFrame = reportFrame;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    public int getDesignHeight() {
        int y = this.topMargin + this.bottomMargin;
        Iterator i = this.bands.iterator();
        while (i.hasNext()) {
            y += ((Band)i.next()).getHeight();
        }
        return y;
    }

    public int getDesignHeightNoBG() {
        int y = 0;
        y += this.topMargin;
        y += this.bottomMargin;
        Iterator i = this.bands.iterator();
        while (i.hasNext()) {
            Band b = (Band)i.next();
            if (b.getName().equals("background")) continue;
            y += b.getHeight();
        }
        return y;
    }

    public void addGroup(Group grp) {
        this.addGroup(grp, true);
    }

    public void addGroup(Group grp, boolean adjust) {
        this.incrementReportChanges();
        if (!this.getGroups().contains(grp)) {
            this.getGroups().addElement(grp);
        }
        String bandsstr = "";
        for (int i = 0; i < this.bands.size(); ++i) {
            Band b = (Band)this.bands.elementAt(i);
            if (!b.getName().equals("detail")) continue;
            if (adjust) {
                int bandYLocation = this.getBandYLocation(b);
                Iterator i2 = this.elements.iterator();
                while (i2.hasNext()) {
                    ReportElement elem = (ReportElement)i2.next();
                    int delta_y = grp.getGroupHeader().getHeight();
                    if (elem.band == grp.getGroupHeader() || elem.band == grp.getGroupFooter()) continue;
                    if (elem.position.y >= bandYLocation + 10 + b.getHeight()) {
                        elem.trasform(new Point(0, delta_y += grp.getGroupFooter().getHeight()), TransformationType.TRANSFORMATION_MOVE);
                        continue;
                    }
                    if (elem.position.y < bandYLocation + 10) continue;
                    elem.trasform(new Point(0, delta_y), TransformationType.TRANSFORMATION_MOVE);
                }
            }
            this.bands.insertElementAt(grp.getGroupHeader(), i);
            this.bands.insertElementAt(grp.getGroupFooter(), i + 2);
            break;
        }
        this.addVariable(new JRVariable(grp.getName() + "_COUNT", "java.lang.Integer", true));
    }

    public synchronized void moveGroup(Group grp, int direction) {
        Group grpOne = null;
        Group grpTwo = null;
        if (this.getGroups().size() <= 1) {
            return;
        }
        this.incrementReportChanges();
        if (direction == 1) {
            if (this.getGroups().lastElement() == grp) {
                return;
            }
            grpOne = grp;
            grpTwo = (Group)this.getGroups().get(this.getGroups().indexOf(grp) + 1);
        } else {
            if (this.getGroups().firstElement() == grp) {
                return;
            }
            grpTwo = grp;
            grpOne = (Group)this.getGroups().get(this.getGroups().indexOf(grp) - 1);
        }
        Band bandGrpOneHeader = this.getBandByName(grpOne.getGroupHeader().getName());
        Band bandGrpTwoHeader = this.getBandByName(grpTwo.getGroupHeader().getName());
        Band bandGrpOneFooter = this.getBandByName(grpOne.getGroupFooter().getName());
        Band bandGrpTwoFooter = this.getBandByName(grpTwo.getGroupFooter().getName());
        int delta1 = bandGrpOneHeader.getHeight();
        int delta2 = bandGrpTwoHeader.getHeight();
        int delta3 = bandGrpOneFooter.getHeight();
        int delta4 = bandGrpTwoFooter.getHeight();
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            ReportElement re = (ReportElement)i.next();
            if (re.band == bandGrpOneHeader) {
                re.trasform(new Point(0, delta2), TransformationType.TRANSFORMATION_MOVE);
                continue;
            }
            if (re.band == bandGrpTwoHeader) {
                re.trasform(new Point(0, -delta1), TransformationType.TRANSFORMATION_MOVE);
                continue;
            }
            if (re.band == bandGrpTwoFooter) {
                re.trasform(new Point(0, delta3), TransformationType.TRANSFORMATION_MOVE);
                continue;
            }
            if (re.band != bandGrpOneFooter) continue;
            re.trasform(new Point(0, -delta4), TransformationType.TRANSFORMATION_MOVE);
        }
        int pos1 = this.bands.indexOf(bandGrpOneHeader);
        Band bandBuffer = (Band)this.bands.get(pos1);
        this.bands.remove(pos1);
        this.bands.insertElementAt(bandBuffer, pos1 + 1);
        int pos3 = this.bands.indexOf(bandGrpTwoFooter);
        bandBuffer = (Band)this.bands.get(pos3);
        this.bands.remove(pos3);
        this.bands.insertElementAt(bandBuffer, pos3 + 1);
        int groupPos = this.getGroups().indexOf(grpOne);
        Group groupBuffer = (Group)this.getGroups().get(groupPos);
        this.getGroups().remove(groupPos);
        this.getGroups().insertElementAt(groupBuffer, groupPos + 1);
    }

    public void delGroup(Group grp) {
        int i;
        if (!this.getGroups().contains(grp)) {
            return;
        }
        this.incrementReportChanges();
        String bandsstr = "";
        for (i = 0; i < this.getVariables().size(); ++i) {
            JRVariable var = (JRVariable)this.getVariables().elementAt(i);
            if (!var.isBuiltin() || !var.getName().equalsIgnoreCase(grp.getName() + "_COUNT")) continue;
            this.removeVariable(var);
            break;
        }
        for (i = 0; i < this.elements.size(); ++i) {
            ReportElement elem = (ReportElement)this.elements.elementAt(i);
            if (elem.getBand() == grp.getGroupHeader() || elem.getBand() == grp.getGroupFooter()) {
                this.elements.removeElementAt(i);
                --i;
                continue;
            }
            int delta_y = grp.getGroupHeader().getHeight();
            if (elem.position.y >= this.getBandYLocation(grp.getGroupFooter()) + 10 + grp.getGroupFooter().getHeight()) {
                elem.trasform(new Point(0, -(delta_y += grp.getGroupFooter().getHeight())), TransformationType.TRANSFORMATION_MOVE);
                continue;
            }
            if (elem.position.y < this.getBandYLocation(grp.getGroupHeader()) + 10 + grp.getGroupHeader().getHeight()) continue;
            elem.trasform(new Point(0, -delta_y), TransformationType.TRANSFORMATION_MOVE);
        }
        this.bands.removeElement(grp.getGroupHeader());
        this.bands.removeElement(grp.getGroupFooter());
        this.getGroups().removeElement(grp);
    }

    public Group getGroupByName(String name) {
        for (int i = 0; i < this.getGroups().size(); ++i) {
            Group grp = (Group)this.getGroups().elementAt(i);
            if (!grp.getName().equals(name)) continue;
            return grp;
        }
        return null;
    }

    public Band getBandByName(String name) {
        for (int i = 0; i < this.bands.size(); ++i) {
            Band band = (Band)this.bands.elementAt(i);
            if (!band.getName().equals(name)) continue;
            return band;
        }
        return null;
    }

    public void saveXMLFile() {
        this.saveXMLFile(this.getFilename());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveXMLFile(String aFilename) {
        StringWriter s;
        if (this.isReadOnly()) {
            JOptionPane.showMessageDialog(this.getReportFrame().getMainFrame(), I18n.getString("fileReadOnly", "File is read only and cannot be saved."), I18n.getString("save", "Save"), 1);
            return;
        }
        String scriptletFileName = this.getScriptletFileName(aFilename);
        String className = "";
        File classFile = new File(scriptletFileName);
        className = classFile.getName().substring(0, classFile.getName().length() - 5);
        if (this.getScriptletHandling() == SCRIPTLET_IREPORT_INTERNAL_HANDLING) {
            this.setScriptletClass(className);
        }
        for (int pk = 0; pk < this.getJRproperties().size(); ++pk) {
            JRProperty prop = (JRProperty)this.getJRproperties().elementAt(pk);
            if (!prop.getName().equals("ireport.scriptlethandling") && !prop.getName().equals("ireport.encoding")) continue;
            this.getJRproperties().remove(prop);
            --pk;
        }
        JRProperty prop = new JRProperty();
        prop.setName("ireport.scriptlethandling");
        prop.setValue("" + this.getScriptletHandling());
        this.getJRproperties().add(prop);
        prop = new JRProperty();
        prop.setName("ireport.encoding");
        prop.setValue("" + this.getEncoding());
        this.getJRproperties().add(prop);
        try {
            String fileencoding = "UTF-8";
            if (this.encoding != null && !this.encoding.trim().equals("")) {
                fileencoding = this.encoding;
                if (fileencoding.equalsIgnoreCase("UTF-8")) {
                    fileencoding = "UTF8";
                }
            } else {
                this.encoding = "UTF-8";
            }
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(aFilename), fileencoding));
            pw.print("<?xml version=\"1.0\"");
            if (this.encoding != null && this.encoding.length() > 0) {
                pw.print(" encoding=\"" + this.encoding + "\" ");
            }
            pw.println(" ?>");
            pw.println("<!-- Created with iReport - A designer for JasperReports -->");
            pw.println("<!DOCTYPE jasperReport PUBLIC \"//JasperReports//DTD Report Design//EN\" \"http://jasperreports.sourceforge.net/dtds/jasperreport.dtd\">");
            pw.println("<jasperReport");
            pw.println("\t\t name=\"" + this.getName() + "\"");
            if (CompatibilitySupport.version >= 66 && this.getLanguage() != null && !this.getLanguage().trim().equals("") && !this.getLanguage().equals("java")) {
                pw.print("\n\t\t language=\"" + this.getLanguage().trim() + "\"");
            }
            pw.println("\t\t columnCount=\"" + this.columnCount + "\"");
            pw.println("\t\t printOrder=\"" + this.printOrder + "\"");
            pw.println("\t\t orientation=\"" + this.getOrientation() + "\"");
            pw.println("\t\t pageWidth=\"" + this.getWidth() + "\"");
            pw.println("\t\t pageHeight=\"" + this.getHeight() + "\"");
            pw.println("\t\t columnWidth=\"" + this.columnWidth + "\"");
            pw.println("\t\t columnSpacing=\"" + this.columnSpacing + "\"");
            pw.println("\t\t leftMargin=\"" + this.leftMargin + "\"");
            pw.println("\t\t rightMargin=\"" + this.rightMargin + "\"");
            pw.println("\t\t topMargin=\"" + this.topMargin + "\"");
            pw.println("\t\t bottomMargin=\"" + this.bottomMargin + "\"");
            pw.println("\t\t whenNoDataType=\"" + this.whenNoDataType + "\"");
            if (CompatibilitySupport.version >= 63 && this.isFloatColumnFooter()) {
                pw.println("\t\t isFloatColumnFooter=\"true\"");
            }
            if (this.getScriptletClass() != null && this.getScriptletClass().length() > 0) {
                pw.println("\t\t scriptletClass=\"" + this.getScriptletClass() + "\"");
            }
            pw.println("\t\t isTitleNewPage=\"" + this.isTitleNewPage + "\"");
            pw.print("\t\t isSummaryNewPage=\"" + this.isSummaryNewPage + "\"");
            if (CompatibilitySupport.version >= 62 && this.getResourceBundleBaseName() != null && !this.getResourceBundleBaseName().trim().equals("")) {
                pw.print("\n\t\t resourceBundle=\"" + this.getResourceBundleBaseName().trim() + "\"");
            }
            if (CompatibilitySupport.version >= 100 && this.getWhenResourceMissingType() != null && !this.getWhenResourceMissingType().trim().equals("Null")) {
                pw.print("\n\t\t whenResourceMissingType=\"" + this.getWhenResourceMissingType().trim() + "\"");
            }
            if (CompatibilitySupport.version >= 111 && this.isIgnorePagination()) {
                pw.print("\n\t\t isIgnorePagination=\"true\"");
            }
            pw.println(">");
            Enumeration e = null;
            e = this.getJRproperties().elements();
            while (e.hasMoreElements()) {
                JRProperty property = (JRProperty)e.nextElement();
                if (property.getName().startsWith("chart.")) continue;
                pw.print("\t<property name=\"" + Misc.xmlEscape(property.getName()) + "\" ");
                pw.println("value=\"" + Misc.xmlEscape(property.getValue()) + "\" />");
            }
            Enumeration enum_chartElements = this.getElements().elements();
            while (enum_chartElements.hasMoreElements()) {
                ReportElement re = (ReportElement)enum_chartElements.nextElement();
                if (!(re instanceof ChartReportElement)) continue;
                Properties props = ((ChartReportElement)re).getProps();
                String name = re.getName();
                Iterator<Object> keys = props.keySet().iterator();
                boolean i = false;
                while (keys.hasNext()) {
                    String key = "" + keys.next();
                    String val = props.getProperty(key);
                    pw.print("\t<property name=\"chart." + name + "." + key + "\" ");
                    pw.println("value=\"" + Misc.xmlEscape(val) + "\" />");
                }
            }
            if (CompatibilitySupport.version >= 62) {
                e = this.imports.elements();
                while (e.hasMoreElements()) {
                    String _import = (String)e.nextElement();
                    pw.print("\t<import ");
                    pw.println("value=\"" + _import + "\" />");
                }
            }
            e = this.fonts.elements();
            while (e.hasMoreElements()) {
                IReportFont font = (IReportFont)e.nextElement();
                pw.print("\t<reportFont name=\"" + font.getReportFont() + "\" ");
                pw.print("isDefault=\"" + font.isDefaultFont() + "\" ");
                pw.print("fontName=\"" + font.getFontName() + "\" ");
                pw.print("size=\"" + font.getFontSize() + "\" ");
                pw.print("isBold=\"" + font.isBold() + "\" ");
                pw.print("isItalic=\"" + font.isItalic() + "\" ");
                pw.print("isUnderline=\"" + font.isUnderline() + "\" ");
                pw.print("isStrikeThrough=\"" + font.isStrikeTrought() + "\" ");
                if (Misc.nvl(font.getPDFFontName(), "").indexOf("TTF") > 0) {
                    pw.print("pdfFontName=\"" + font.getTTFFont() + "\" ");
                } else {
                    pw.print("pdfFontName=\"" + font.getPDFFontName() + "\" ");
                }
                pw.print("pdfEncoding=\"" + font.getPdfEncoding() + "\" ");
                pw.println("isPdfEmbedded=\"" + font.isPdfEmbedded() + "\"/>");
            }
            if (CompatibilitySupport.version >= 111) {
                this.writeXMLStyles(this.getStyles(), pw, "\t");
            }
            if (CompatibilitySupport.version >= 110) {
                this.writeXMLSubDatasets(this.getSubDatasets(), pw, "\t");
            }
            this.writeXMLParameters(this.getParameters(), pw, "\t");
            if (this.getQuery() != null && this.getQuery().trim().length() > 0) {
                pw.print("\t<queryString");
                if (CompatibilitySupport.version >= 120 && !this.getQueryLanguage().equals("sql")) {
                    pw.print(" language=\"" + this.getQueryLanguage() + "\"");
                }
                pw.println(">" + Report.getCDATAString(this.getQuery(), 1) + "</queryString>");
            }
            this.writeXMLFields(this.getFields(), pw, "\t");
            this.writeXMLVariables(this.getVariables(), pw, "\t");
            if (CompatibilitySupport.version >= 125 && this.getFilterExpression() != null && this.getFilterExpression().trim().length() > 0) {
                pw.println("\t<filterExpression>" + Report.getCDATAString(this.getFilterExpression(), 1) + "</filterExpression>");
            }
            this.writeXMLGroups(this.getGroups(), pw, true, 2);
            this.writeXMLSection("background", pw);
            this.writeXMLSection("title", pw);
            this.writeXMLSection("pageHeader", pw);
            this.writeXMLSection("columnHeader", pw);
            this.writeXMLSection("detail", pw);
            this.writeXMLSection("columnFooter", pw);
            this.writeXMLSection("pageFooter", pw);
            if (CompatibilitySupport.version >= 61) {
                this.writeXMLSection("lastPageFooter", pw);
            }
            this.writeXMLSection("summary", pw);
            pw.println("</jasperReport>");
            pw.close();
            if (aFilename == null) {
                // empty if block
            }
        }
        catch (Exception ex) {
            s = new StringWriter();
            ex.printStackTrace(new PrintWriter(s));
            JOptionPane.showMessageDialog(this.getReportFrame().getMainFrame(), ex.getMessage() + " " + s, "Exception", 0);
        }
        this.setLoadTime(Misc.getLastWriteTime(this.getFilename()));
        if (this.getScriptletHandling() == SCRIPTLET_IREPORT_INTERNAL_HANDLING) {
            try {
                String allcode = new String(this.scripletCode.getAll() + "");
                allcode = Misc.string_replace(className, "<ScriptletClassName>", allcode);
                FileOutputStream fos = new FileOutputStream(scriptletFileName);
                fos.write(allcode.getBytes());
                fos.close();
            }
            catch (Exception ex) {
                s = new StringWriter();
                ex.printStackTrace(new PrintWriter(s));
                JOptionPane.showMessageDialog(this.getReportFrame().getMainFrame(), ex.getMessage() + " " + s, "Exception", 0);
            }
        }
        this.setReportChanges(0);
    }

    void writeXMLSection(String section, PrintWriter pw) {
        Band band = null;
        Iterator i = this.bands.iterator();
        while (i.hasNext() && !(band = (Band)i.next()).getName().equalsIgnoreCase(section)) {
        }
        if (band == null) {
            return;
        }
        if (section.equals("lastPageFooter") && band.getHeight() == 0) {
            return;
        }
        pw.println("\t\t<" + section + ">");
        this.writeXMLBand(band, pw);
        pw.println("\t\t</" + section + ">");
    }

    void writeXMLSubDatasets(Vector subDatasets, PrintWriter pw, String tabs) {
        Enumeration e = subDatasets.elements();
        while (e.hasMoreElements()) {
            pw.println("");
            SubDataset subDataset = (SubDataset)e.nextElement();
            pw.print(tabs + "<subDataset name=\"" + subDataset.getName() + "\" ");
            if (subDataset.getScriptletClass() != null && subDataset.getScriptletClass().length() > 0) {
                pw.println(tabs + "\t scriptletClass=\"" + subDataset.getScriptletClass() + "\"");
            }
            if (subDataset.getResourceBundleBaseName() != null && !subDataset.getResourceBundleBaseName().trim().equals("")) {
                pw.print("\n" + tabs + "\t resourceBundle=\"" + this.getResourceBundleBaseName().trim() + "\"");
            }
            if (subDataset.getWhenResourceMissingType() != null && !subDataset.getWhenResourceMissingType().trim().equals("Null")) {
                pw.print("\n" + tabs + "\t whenResourceMissingType=\"" + this.getWhenResourceMissingType().trim() + "\"");
            }
            pw.println(">");
            if (CompatibilitySupport.version >= 120) {
                Enumeration eProperties = subDataset.getJRproperties().elements();
                while (eProperties.hasMoreElements()) {
                    JRProperty property = (JRProperty)eProperties.nextElement();
                    pw.print(tabs + "\t<property name=\"" + Misc.xmlEscape(property.getName()) + "\" ");
                    pw.println("value=\"" + Misc.xmlEscape(property.getValue()) + "\" />");
                }
            }
            this.writeXMLParameters(subDataset.getParameters(), pw, "\t\t");
            if (subDataset.getQuery() != null && subDataset.getQuery().trim().length() > 0) {
                pw.print(tabs + "\t<queryString");
                if (CompatibilitySupport.version >= 120 && !subDataset.getQueryLanguage().equals("sql")) {
                    pw.print(" language=\"" + subDataset.getQueryLanguage() + "\"");
                }
                pw.println(">" + Report.getCDATAString(subDataset.getQuery(), 1) + "</queryString>");
            }
            this.writeXMLFields(subDataset.getFields(), pw, "\t\t");
            this.writeXMLVariables(subDataset.getVariables(), pw, "\t\t");
            if (CompatibilitySupport.version >= 125 && subDataset.getFilterExpression() != null && subDataset.getFilterExpression().trim().length() > 0) {
                pw.println("\t\t<filterExpression>" + Report.getCDATAString(subDataset.getFilterExpression(), 2) + "</filterExpression>");
            }
            this.writeXMLGroups(subDataset.getGroups(), pw, false, 2);
            pw.println(tabs + "</subDataset>");
        }
    }

    void writeXMLParameters(Vector parameters, PrintWriter pw, String tabs) {
        Enumeration e = parameters.elements();
        if (parameters.size() > 0) {
            pw.println("");
        }
        while (e.hasMoreElements()) {
            JRParameter p = (JRParameter)e.nextElement();
            if (p.isBuiltin()) continue;
            pw.print(tabs + "<parameter name=\"" + p.getName() + "\" ");
            if (p.getClassType() == null) {
                p.setClassType("java.lang.String");
            }
            pw.print("isForPrompting=\"" + p.isIsForPrompting() + "\" ");
            pw.print("class=\"" + p.getClassType() + "\"");
            if (p.getDefaultValueExpression().trim().length() > 0 || p.getDescription().trim().length() > 0) {
                pw.println(">");
                if (p.getDescription().trim().length() > 0) {
                    pw.println(tabs + "\t<parameterDescription>" + Report.getCDATAString(p.getDescription(), 2) + "</parameterDescription>");
                }
                if (p.getDefaultValueExpression().trim().length() > 0) {
                    pw.print(tabs + "\t<defaultValueExpression ");
                    pw.println(">" + Report.getCDATAString(p.getDefaultValueExpression(), 2) + "</defaultValueExpression>");
                }
                pw.println(tabs + "</parameter>");
                continue;
            }
            pw.println("/>");
        }
    }

    void writeXMLFields(Vector fields, PrintWriter pw, String tabs) {
        Enumeration e = fields.elements();
        if (fields.size() > 0) {
            pw.println("");
        }
        while (e.hasMoreElements()) {
            JRField f = (JRField)e.nextElement();
            pw.print(tabs + "<field name=\"" + f.getName() + "\" ");
            if (f.getClassType() == null) {
                f.setClassType("java.lang.String");
            }
            pw.print("class=\"" + f.getClassType() + "\"");
            if (f.getDescription().trim().length() > 0) {
                pw.println(">");
                if (f.getDescription().trim().length() > 0) {
                    pw.println(tabs + "\t<fieldDescription>" + Report.getCDATAString(f.getDescription(), 2) + "</fieldDescription>");
                }
                pw.println(tabs + "</field>");
                continue;
            }
            pw.println("/>");
        }
    }

    void writeXMLVariables(Vector variables, PrintWriter pw, String tabs) {
        Enumeration e = variables.elements();
        if (variables.size() > 0) {
            pw.println("");
        }
        while (e.hasMoreElements()) {
            JRVariable f = (JRVariable)e.nextElement();
            if (f.isBuiltin()) continue;
            pw.print(tabs + "<variable name=\"" + f.getName() + "\" ");
            if (f.getClassType() == null) {
                f.setClassType("java.lang.String");
            }
            pw.print("class=\"" + f.getClassType() + "\" ");
            pw.print("resetType=\"" + f.getResetType() + "\" ");
            if (f.getIncrementerFactoryClass() != null && f.getIncrementerFactoryClass().trim().length() > 0) {
                pw.print("incrementerFactoryClass=\"" + f.getIncrementerFactoryClass() + "\" ");
            }
            if (CompatibilitySupport.version >= 66 && f.getIncrementType() != null && !f.getIncrementType().trim().equals("None")) {
                pw.print("incrementType=\"" + f.getIncrementType().trim() + "\" ");
                if (f.getIncrementType().equals("Group")) {
                    pw.print("incrementGroup=\"" + f.getIncrementGroup().trim() + "\" ");
                }
            }
            if (f.getResetGroup().length() > 0) {
                pw.print("resetGroup=\"" + f.getResetGroup() + "\" ");
            }
            pw.println("calculation=\"" + f.getCalculation() + "\">");
            if (f.getExpression().length() > 0) {
                pw.print(tabs + "\t<variableExpression");
                pw.println(">" + Report.getCDATAString(f.getExpression(), 2) + "</variableExpression>");
            }
            if (f.getInitialValueExpression().length() > 0) {
                pw.print(tabs + "\t<initialValueExpression");
                pw.println(">" + Report.getCDATAString(f.getInitialValueExpression(), 2) + "</initialValueExpression>");
            }
            pw.println(tabs + "</variable>");
        }
    }

    void writeXMLMeasures(Vector measures, PrintWriter pw, String tabs) {
        Enumeration e = measures.elements();
        if (measures.size() > 0) {
            pw.println("");
        }
        while (e.hasMoreElements()) {
            Measure f = (Measure)e.nextElement();
            pw.print(tabs + "<measure name=\"" + f.getName() + "\"");
            if (f.getClassType() == null) {
                f.setClassType("java.lang.String");
            }
            pw.print(" class=\"" + f.getClassType() + "\"");
            if (!f.getCalculation().equals("Nothing")) {
                pw.print(" calculation=\"" + f.getCalculation() + "\"");
            }
            if (f.getIncrementerFactoryClass().trim().length() > 0) {
                pw.print(" incrementerFactoryClass=\"" + f.getIncrementerFactoryClass() + "\"");
            }
            if (!f.getPercentageOf().equals("None")) {
                pw.print(" percentageOf=\"" + f.getPercentageOf() + "\"");
            }
            if (f.getPercentageCalculatorClass().trim().length() > 0) {
                pw.print(" percentageCalculatorClass=\"" + f.getPercentageCalculatorClass() + "\"");
            }
            pw.println(">");
            if (f.getExpression().length() > 0) {
                pw.print(tabs + "\t<measureExpression>");
                pw.println(Report.getCDATAString(f.getExpression(), 2) + "</measureExpression>");
            }
            pw.println(tabs + "</measure>");
        }
    }

    void writeXMLCrosstabParameters(Vector parameters, PrintWriter pw, String tabs) {
        Enumeration e = parameters.elements();
        if (parameters.size() > 0) {
            pw.println("");
        }
        while (e.hasMoreElements()) {
            CrosstabParameter f = (CrosstabParameter)e.nextElement();
            pw.print(tabs + "<crosstabParameter name=\"" + f.getName() + "\" ");
            if (f.getClassType() == null) {
                f.setClassType("java.lang.String");
            }
            pw.print("class=\"" + f.getClassType() + "\" ");
            pw.print(">");
            if (f.getParameterValueExpression().length() > 0) {
                pw.print(tabs + "\t<parameterValueExpression>");
                pw.println("" + Report.getCDATAString(f.getParameterValueExpression(), tabs.length() + 1) + "</parameterValueExpression>");
            }
            pw.println(tabs + "</crosstabParameter>");
        }
    }

    void writeXMLHyperlinkParameters(List parameters, PrintWriter pw, String tabs) {
        Iterator e = parameters.iterator();
        if (parameters.size() > 0) {
            pw.println("");
        }
        while (e.hasNext()) {
            JRLinkParameter f = (JRLinkParameter)e.next();
            pw.println(tabs + "<hyperlinkParameter name=\"" + f.getName() + "\">");
            pw.print(tabs + "\t<hyperlinkParameterExpression>");
            pw.println("" + Report.getCDATAString(f.getExpression(), tabs.length() + 1) + "</hyperlinkParameterExpression>");
            pw.println(tabs + "</hyperlinkParameter>");
        }
    }

    void writeXMLGroups(Vector groups, PrintWriter pw, boolean writeAll, int tabCount) {
        if (groups.size() > 0) {
            pw.println("");
        }
        for (int i = 0; i < groups.size(); ++i) {
            int t;
            Group grp = (Group)groups.elementAt(i);
            for (t = 0; t < tabCount; ++t) {
                pw.print("\t");
            }
            pw.print("<group ");
            pw.print(" name=\"" + grp.getName() + "\"");
            if (grp.isIsStartNewColumn()) {
                pw.print(" isStartNewColumn=\"" + grp.isIsStartNewColumn() + "\"");
            }
            if (grp.isIsStartNewPage()) {
                pw.print(" isStartNewPage=\"" + grp.isIsStartNewPage() + "\"");
            }
            if (grp.isIsResetPageNumber()) {
                pw.print(" isResetPageNumber=\"" + grp.isIsResetPageNumber() + "\"");
            }
            if (grp.isIsReprintHeaderOnEachPage()) {
                pw.print(" isReprintHeaderOnEachPage=\"" + grp.isIsReprintHeaderOnEachPage() + "\"");
            }
            if (grp.getMinHeightToStartNewPage() != 0) {
                pw.print(" minHeightToStartNewPage=\"" + grp.getMinHeightToStartNewPage() + "\"");
            }
            pw.println(" >");
            pw.print("\t\t\t<groupExpression");
            pw.println(">" + Report.getCDATAString(grp.getGroupExpression(), tabCount + 1) + "</groupExpression>");
            if (writeAll) {
                pw.println("\t\t\t<groupHeader>");
                this.writeXMLBand(grp.getGroupHeader(), pw);
                pw.println("\t\t\t</groupHeader>");
                pw.println("\t\t\t<groupFooter>");
                this.writeXMLBand(grp.getGroupFooter(), pw);
                pw.println("\t\t\t</groupFooter>");
            }
            for (t = 0; t < tabCount; ++t) {
                pw.print("\t");
            }
            pw.println("</group>");
        }
    }

    void writeXMLStyles(Vector styles, PrintWriter pw, String tabs) {
        Enumeration e = styles.elements();
        if (styles.size() > 0) {
            pw.println("");
        }
        while (e.hasMoreElements()) {
            Style style = (Style)e.nextElement();
            String tabs2 = tabs;
            if (CompatibilitySupport.version >= 120 && style instanceof ConditionedStyle) {
                pw.println(tabs2 + "<conditionalStyle>");
                tabs = tabs + "\t";
                pw.print(tabs + "<conditionExpression");
                pw.println(">" + Report.getCDATAString(((ConditionedStyle)style).getCondition(), tabs2.length() + 1) + "</conditionExpression>");
            }
            pw.println(tabs + "<style ");
            for (int i = 0; i < Style.JRXMLStyleAttributes.length; ++i) {
                if (!style.getAttributes().containsKey(Style.JRXMLStyleAttributes[i]) || style.getAttributes().get(Style.JRXMLStyleAttributes[i]) == null) continue;
                Object obj = style.getAttributes().get(Style.JRXMLStyleAttributes[i]);
                String value = "" + obj;
                if (obj instanceof Color) {
                    value = Report.writeEncodedColor((Color)obj);
                }
                if (Style.JRXMLStyleAttributes[i].toLowerCase().endsWith("color") && value.startsWith("[")) {
                    try {
                        value = Report.writeEncodedColor(ColorSelectorPanel.parseColorString(value));
                    }
                    catch (Exception ex) {
                        value = "black";
                    }
                }
                if (Style.JRXMLStyleAttributes[i].equals("style") && (value == null || value.trim().length() == 0)) continue;
                pw.println(tabs + "\t" + Style.JRXMLStyleAttributes[i] + "=\"" + value + "\"");
            }
            if (CompatibilitySupport.version < 120 || style.getConditionedStyles().size() == 0) {
                pw.println(tabs + "/>");
            } else {
                pw.println(tabs + ">");
                this.writeXMLStyles(style.getConditionedStyles(), pw, tabs + "\t");
                pw.println(tabs + "</style>");
            }
            if (CompatibilitySupport.version < 120 || !(style instanceof ConditionedStyle)) continue;
            pw.println(tabs2 + "</conditionalStyle>");
        }
    }

    void writeXMLBand(Band band, PrintWriter pw) {
        pw.print("\t\t\t<band height=\"" + band.getHeight() + "\" ");
        pw.print(" isSplitAllowed=\"" + band.isSplitAllowed() + "\" ");
        pw.println(">");
        if (band.getPrintWhenExpression().trim().length() > 0) {
            pw.print("\t\t\t\t<printWhenExpression");
            pw.println(">" + Report.getCDATAString(band.getPrintWhenExpression(), 4) + "</printWhenExpression>");
        }
        this.writeBandElements(pw, band, null);
        pw.println("\t\t\t</band>");
    }

    public void writeBandElements(PrintWriter pw, Band band, ReportElement parent) {
        String actualElementGroup = "";
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            ReportElement re = (ReportElement)i.next();
            if (re.band != band || re.getParentElement() != parent) continue;
            actualElementGroup = this.writeOpenCloseGroup(pw, re.getElementGroup(), actualElementGroup);
            this.writeXMLReportElement(re, pw);
        }
        this.writeOpenCloseGroup(pw, "", actualElementGroup);
    }

    public String writeOpenCloseGroup(PrintWriter pw, String newGroup, String oldGroup) {
        if (oldGroup.equals(newGroup)) {
            return newGroup;
        }
        while (!newGroup.startsWith(oldGroup) && oldGroup.length() > 0) {
            pw.println("\t\t\t\t</elementGroup><!-- End " + oldGroup + " !-->");
            if (oldGroup.lastIndexOf(".") >= 0) {
                oldGroup = oldGroup.substring(0, oldGroup.lastIndexOf("."));
                continue;
            }
            oldGroup = "";
        }
        String remainNewGroup = newGroup;
        if (oldGroup.length() > 0 && newGroup.startsWith(oldGroup)) {
            remainNewGroup = newGroup.substring(oldGroup.length() + 1);
        }
        String groupName = remainNewGroup;
        while (remainNewGroup.length() > 0) {
            pw.print("\t\t\t\t<elementGroup>");
            if (remainNewGroup.indexOf(".") >= 0) {
                groupName = (oldGroup.length() > 0 ? oldGroup + "." : "") + remainNewGroup.substring(0, remainNewGroup.indexOf("."));
                oldGroup = remainNewGroup.substring(0, remainNewGroup.indexOf("."));
                remainNewGroup = remainNewGroup.substring(remainNewGroup.indexOf(".") + 1);
            } else {
                groupName = (oldGroup.length() > 0 ? oldGroup + "." : "") + remainNewGroup;
                remainNewGroup = "";
            }
            pw.println("<!--  Start: " + groupName + " !-->");
        }
        return newGroup;
    }

    void writeXMLReportElement(ReportElement re, PrintWriter pw) {
        if (re instanceof StaticTextReportElement) {
            pw.println("\t\t\t\t<staticText>");
            this.writeXMLReportElementElement(re, pw);
            this.writeXMLBox(((TextReportElement)re).getBox(), pw);
            this.writeXMLTextElementElement((TextReportElement)re, pw);
            pw.println("\t\t\t\t<text>" + Report.getCDATAString(((StaticTextReportElement)re).getText(), 4) + "</text>");
            pw.println("\t\t\t\t</staticText>");
        } else if (re instanceof FrameReportElement) {
            FrameReportElement fre = (FrameReportElement)re;
            pw.print("\t\t\t\t<frame>");
            this.writeXMLReportElementElement(fre, pw);
            this.writeXMLBox(fre.getBox(), pw);
            if (re instanceof FrameReportElement) {
                this.writeBandElements(pw, re.getBand(), re);
            }
            pw.print("\t\t\t\t</frame>");
        } else if (re instanceof TextFieldReportElement) {
            TextFieldReportElement tfre = (TextFieldReportElement)re;
            pw.print("\t\t\t\t<textField");
            pw.print(" isStretchWithOverflow=\"" + tfre.isStretchWithOverflow() + "\"");
            if (tfre.getPropertyValue("PATTERN") != null) {
                pw.print(" pattern=\"" + tfre.getPattern() + "\"");
            }
            pw.print(" isBlankWhenNull=\"" + tfre.isBlankWhenNull() + "\"");
            pw.print(" evaluationTime=\"" + tfre.getEvaluationTime() + "\"");
            if (tfre.getEvaluationTime().equals("Group")) {
                pw.print(" evaluationGroup=\"" + tfre.getGroup() + "\" ");
            }
            pw.print(" hyperlinkType=\"" + tfre.getHyperlinkType() + "\" ");
            if (CompatibilitySupport.version >= 62) {
                pw.print(" hyperlinkTarget=\"" + tfre.getHyperlinkTarget() + "\" ");
            }
            if (CompatibilitySupport.version >= 100 && tfre.getBookmarkLevel() != 0) {
                pw.print(" bookmarkLevel=\"" + tfre.getBookmarkLevel() + "\" ");
            }
            pw.println(">");
            this.writeXMLReportElementElement(tfre, pw);
            this.writeXMLBox(((TextReportElement)re).getBox(), pw);
            this.writeXMLTextElementElement(tfre, pw);
            pw.print("\t\t\t\t<textFieldExpression ");
            if (tfre.getClassExpression().length() > 0) {
                pw.print("  class=\"" + tfre.getClassExpression() + "\"");
            }
            pw.println(">" + Report.getCDATAString(((TextFieldReportElement)re).getText(), 4) + "</textFieldExpression>");
            this.writeHyperLinkExpressions(tfre, pw);
            pw.println("\t\t\t\t</textField>");
        } else if (re instanceof ImageReportElement) {
            ImageReportElement ire = (ImageReportElement)re;
            pw.print("\t\t\t\t<image ");
            if (ire.getPropertyValue("SCALE") != null) {
                pw.print(" scaleImage=\"" + ire.getScaleImage() + "\"");
            }
            if (ire.getPropertyValue("VERTICAL_ALIGN") != null) {
                pw.print(" vAlign=\"" + ire.getVerticalAlignment() + "\"");
            }
            if (ire.getPropertyValue("HORIZONTAL_ALIGN") != null) {
                pw.print(" hAlign=\"" + ire.getHorizontalAlignment() + "\"");
            }
            if (CompatibilitySupport.version >= 65 && ire.isIsLazy()) {
                pw.print(" isLazy=\"" + ire.isIsLazy() + "\"");
            }
            if (CompatibilitySupport.version >= 103 && !ire.getOnErrorType().equals("Error")) {
                pw.print(" onErrorType=\"" + ire.getOnErrorType() + "\"");
            }
            if (ire.getPropertyValue("USING_CACHE") != null) {
                pw.print(" isUsingCache=\"" + ire.isIsUsingCache() + "\"");
            }
            pw.print(" evaluationTime=\"" + ire.getEvaluationTime() + "\"");
            if (((ImageReportElement)re).getEvaluationTime().equals("Group")) {
                pw.print(" evaluationGroup=\"" + ire.getEvaluationGroup() + "\" ");
            }
            pw.print(" hyperlinkType=\"" + ire.getHyperlinkType() + "\" ");
            if (CompatibilitySupport.version >= 62) {
                pw.print(" hyperlinkTarget=\"" + ire.getHyperlinkTarget() + "\" ");
            }
            if (CompatibilitySupport.version >= 100 && ire.getBookmarkLevel() != 0) {
                pw.print(" bookmarkLevel=\"" + ire.getBookmarkLevel() + "\" ");
            }
            pw.println(">");
            this.writeXMLReportElementElement(re, pw);
            this.writeXMLBox(((ImageReportElement)re).getBox(), pw);
            this.writeXMLGraphicElement(ire, pw);
            if (re instanceof ChartReportElement) {
                pw.print("\t\t\t\t\t<imageExpression class=\"java.awt.Image\"");
                pw.print(">" + Report.getCDATAString(this.writeChartExpression((ChartReportElement)re), 5) + "</imageExpression>\n");
            } else {
                pw.print("\t\t\t\t\t<imageExpression class=\"" + ire.getImageClass() + "\"");
                pw.println(">" + Report.getCDATAString(ire.getImageExpression(), 5) + "</imageExpression>");
            }
            this.writeHyperLinkExpressions(ire, pw);
            pw.println("\t\t\t\t</image>");
        } else if (re instanceof LineReportElement) {
            LineReportElement lre = (LineReportElement)re;
            pw.println("\t\t\t\t<line direction=\"" + lre.getDirection() + "\">");
            this.writeXMLReportElementElement(re, pw);
            this.writeXMLGraphicElement(lre, pw);
            pw.println("\t\t\t\t</line>");
        } else if (re instanceof RectangleReportElement) {
            RectangleReportElement rre = (RectangleReportElement)re;
            pw.print("\t\t\t\t<rectangle");
            if (rre.getPropertyValue("RADIUS") != null) {
                pw.print(" radius=\"" + rre.getRadius() + "\" ");
            }
            pw.println(">");
            this.writeXMLReportElementElement(re, pw);
            this.writeXMLGraphicElement(rre, pw);
            pw.println("\t\t\t\t</rectangle>");
        } else if (re instanceof EllipseReportElement) {
            EllipseReportElement ere = (EllipseReportElement)re;
            pw.println("\t\t\t\t<ellipse>");
            this.writeXMLReportElementElement(ere, pw);
            this.writeXMLGraphicElement(ere, pw);
            pw.println("\t\t\t\t</ellipse>");
        } else if (re instanceof SubReportElement) {
            SubReportElement sre = (SubReportElement)re;
            pw.println("\t\t\t\t<subreport  isUsingCache=\"" + sre.isIsUsingCache() + "\">");
            this.writeXMLReportElementElement(re, pw);
            if (sre.getParametersMapExpression() != null && sre.getParametersMapExpression().trim().length() > 0) {
                pw.print("\t\t\t\t\t<parametersMapExpression");
                pw.println(">" + Report.getCDATAString(sre.getParametersMapExpression(), 5) + "</parametersMapExpression>");
            }
            Enumeration e = sre.getSubreportParameters().elements();
            while (e.hasMoreElements()) {
                JRSubreportParameter je = (JRSubreportParameter)e.nextElement();
                pw.println("\t\t\t\t\t<subreportParameter  name=\"" + je.getName() + "\">");
                pw.print("\t\t\t\t\t\t<subreportParameterExpression");
                pw.println(">" + Report.getCDATAString(je.getExpression(), 6) + "</subreportParameterExpression>");
                pw.println("\t\t\t\t\t</subreportParameter>");
            }
            if (sre.isUseConnection() && sre.getConnectionExpression().trim().length() > 0) {
                pw.print("\t\t\t\t\t<connectionExpression");
                pw.println(">" + Report.getCDATAString(sre.getConnectionExpression(), 5) + "</connectionExpression>");
            } else if (!sre.isUseConnection() && sre.getDataSourceExpression().length() > 0) {
                pw.print("\t\t\t\t\t<dataSourceExpression");
                pw.println(">" + Report.getCDATAString(sre.getDataSourceExpression(), 5) + "</dataSourceExpression>");
            }
            if (CompatibilitySupport.version >= 100) {
                Enumeration e_sr = sre.getReturnValues().elements();
                while (e_sr.hasMoreElements()) {
                    JRSubreportReturnValue jerv = (JRSubreportReturnValue)e_sr.nextElement();
                    pw.print("\t\t\t\t\t<returnValue");
                    if (jerv.getSubreportVariable() != null && jerv.getSubreportVariable().length() > 0) {
                        pw.print(" subreportVariable=\"" + jerv.getSubreportVariable() + "\"");
                    }
                    if (jerv.getToVariable() != null && jerv.getToVariable().length() > 0) {
                        pw.print(" toVariable=\"" + jerv.getToVariable() + "\"");
                    }
                    if (jerv.getCalculation() != null && !jerv.getCalculation().equals("Nothing")) {
                        pw.print(" calculation=\"" + jerv.getCalculation() + "\"");
                    }
                    if (jerv.getIncrementFactoryClass() != null && jerv.getIncrementFactoryClass().length() > 0) {
                        pw.print(" incrementerFactoryClass=\"" + jerv.getIncrementFactoryClass() + "\"");
                    }
                    pw.println("/>");
                }
            }
            if (sre.getSubreportExpression() != null && sre.getSubreportExpression().trim().length() > 0) {
                pw.print("\t\t\t\t\t<subreportExpression  class=\"" + sre.getSubreportExpressionClass() + "\"");
                pw.println(">" + Report.getCDATAString(sre.getSubreportExpression(), 5) + "</subreportExpression>");
            }
            pw.println("\t\t\t\t</subreport>");
        } else if (re instanceof ChartReportElement2) {
            this.writeChartElement((ChartReportElement2)re, pw);
        } else if (re instanceof CrosstabReportElement) {
            CrosstabReportElement cre = (CrosstabReportElement)re;
            if (CompatibilitySupport.version >= 111) {
                CrosstabCell cell;
                int i;
                pw.print("\t\t\t\t<crosstab ");
                if (!cre.isRepeatColumnHeaders()) {
                    pw.print("isRepeatColumnHeaders=\"" + cre.isRepeatColumnHeaders() + "\" ");
                }
                if (!cre.isRepeatRowHeaders()) {
                    pw.print("isRepeatRowHeaders=\"" + cre.isRepeatRowHeaders() + "\" ");
                }
                if (cre.getColumnBreakOffset() != 10) {
                    pw.print("columnBreakOffset=\"" + cre.getColumnBreakOffset() + "\" ");
                }
                pw.println(">");
                this.writeXMLReportElementElement(re, pw);
                this.writeXMLCrosstabParameters(cre.getCrosstabParameters(), pw, "\t\t\t\t\t");
                if (cre.getParametersMapExpression() != null && cre.getParametersMapExpression().trim().length() > 0) {
                    pw.print("\t\t\t\t\t<parametersMapExpression>");
                    pw.println(Report.getCDATAString(cre.getParametersMapExpression(), 5) + "</parametersMapExpression>");
                }
                if (cre.isUseDataset()) {
                    pw.print("\t\t\t\t\t<crosstabDataset");
                    if (cre.isPreSorted()) {
                        pw.print(" isDataPreSorted=\"" + cre.isPreSorted() + "\" ");
                    }
                    pw.println(">");
                    if (cre.getDataset() != null) {
                        this.writeDatasetDataset(cre.getDataset(), pw);
                    }
                    pw.println("\t\t\t\t\t</crosstabDataset>");
                }
                if (CompatibilitySupport.version >= 120) {
                    for (i = 0; i < cre.getCells().size(); ++i) {
                        cell = (CrosstabCell)cre.getCells().elementAt(i);
                        if (cell.getType() != 3) continue;
                        pw.print("\t\t\t\t\t<crosstabHeaderCell>");
                        this.writeXMLCrosstabCellcontents(cell, cre.getElements(), pw, "\t\t\t\t\t\t");
                        pw.print("\t\t\t\t\t</crosstabHeaderCell>");
                    }
                }
                this.writeXMLCrosstabRowGroups(cre.getRowGroups(), cre.getElements(), pw);
                this.writeXMLCrosstabColumnGroups(cre.getColumnGroups(), cre.getElements(), pw);
                this.writeXMLMeasures(cre.getMeasures(), pw, "\t\t\t\t\t");
                this.writeXMLCrosstabCells(cre.getCells(), cre.getElements(), pw, "\t\t\t\t\t");
                for (i = 0; i < cre.getCells().size(); ++i) {
                    cell = (CrosstabCell)cre.getCells().elementAt(i);
                    if (cell.getType() != 2) continue;
                    pw.print("\t\t\t\t\t<whenNoDataCell>");
                    this.writeXMLCrosstabCellcontents(cell, cre.getElements(), pw, "\t\t\t\t\t\t");
                    pw.print("\t\t\t\t\t</whenNoDataCell>");
                }
                pw.println("\t\t\t\t\t</crosstab>");
            }
        }
    }

    void writeXMLBox(Box box, PrintWriter pw) {
        if (CompatibilitySupport.version >= 63) {
            if (box == null) {
                return;
            }
            pw.print("\t\t\t\t\t<box");
            if (box.getTopBorder() != null) {
                pw.print(" topBorder=\"" + box.getTopBorder() + "\"");
            }
            if (box.getTopBorderColor() != null) {
                pw.print(" topBorderColor=\"" + Report.writeEncodedColor(box.getTopBorderColor()) + "\"");
            }
            if (box.getTopPadding() > 0) {
                pw.print(" topPadding=\"" + box.getTopPadding() + "\"");
            }
            if (box.getLeftBorder() != null) {
                pw.print(" leftBorder=\"" + box.getLeftBorder() + "\"");
            }
            if (box.getLeftBorderColor() != null) {
                pw.print(" leftBorderColor=\"" + Report.writeEncodedColor(box.getLeftBorderColor()) + "\"");
            }
            if (box.getLeftPadding() > 0) {
                pw.print(" leftPadding=\"" + box.getLeftPadding() + "\"");
            }
            if (box.getRightBorder() != null) {
                pw.print(" rightBorder=\"" + box.getRightBorder() + "\"");
            }
            if (box.getRightBorderColor() != null) {
                pw.print(" rightBorderColor=\"" + Report.writeEncodedColor(box.getRightBorderColor()) + "\"");
            }
            if (box.getRightPadding() > 0) {
                pw.print(" rightPadding=\"" + box.getRightPadding() + "\"");
            }
            if (box.getBottomBorder() != null) {
                pw.print(" bottomBorder=\"" + box.getBottomBorder() + "\"");
            }
            if (box.getBottomBorderColor() != null) {
                pw.print(" bottomBorderColor=\"" + Report.writeEncodedColor(box.getBottomBorderColor()) + "\"");
            }
            if (box.getBottomPadding() > 0) {
                pw.print(" bottomPadding=\"" + box.getBottomPadding() + "\"");
            }
            pw.println("/>");
        }
    }

    void writeFontElement(IReportFont font, PrintWriter pw) {
        if (font == null) {
            return;
        }
        pw.print("\t\t\t\t\t<font");
        IReportFont base = this.getReportFontByName(font.getReportFont());
        if (font.getReportFont() != null && font.getReportFont().length() > 0) {
            pw.print(" reportFont=\"" + font.getReportFont() + "\"");
        }
        if (!(base != null && base.getFontName().equals(font.getFontName()) || font.getFontName() == null || font.getFontName().length() <= 0)) {
            pw.print(" fontName=\"" + font.getFontName() + "\"");
        }
        if (!(base != null && base.getPDFFontName().equals(font.getPDFFontName()) || font.getPDFFontName() == null || font.getPDFFontName().length() <= 0)) {
            pw.print(" pdfFontName=\"" + font.getPDFFontName() + "\"");
        }
        if (base == null || base.getFontSize() != font.getFontSize()) {
            pw.print(" size=\"" + font.getFontSize() + "\"");
        }
        if (base == null || base.isBold() != font.isBold()) {
            pw.print(" isBold=\"" + (font.isBold() ? "true" : "false") + "\"");
        }
        if (base == null || base.isItalic() != font.isItalic()) {
            pw.print(" isItalic=\"" + (font.isItalic() ? "true" : "false") + "\"");
        }
        if (base == null || base.isUnderline() != font.isUnderline()) {
            pw.print(" isUnderline=\"" + (font.isUnderline() ? "true" : "false") + "\"");
        }
        if (base == null || base.isStrikeTrought() != font.isStrikeTrought()) {
            pw.print(" isStrikeThrough=\"" + (font.isStrikeTrought() ? "true" : "false") + "\"");
        }
        if (base == null || base.isPdfEmbedded() != font.isPdfEmbedded()) {
            pw.print(" isPdfEmbedded=\"" + (font.isPdfEmbedded() ? "true" : "false") + "\"");
        }
        if (!(base != null && base.getPdfEncoding().equals(font.getPdfEncoding()) || font.getPdfEncoding() == null || font.getPdfEncoding().length() <= 0)) {
            pw.print(" pdfEncoding=\"" + font.getPdfEncoding() + "\"");
        }
        pw.println("/>");
    }

    void writeXMLReportElementElement(ReportElement re, PrintWriter pw) {
        pw.print("\t\t\t\t\t<reportElement");
        if (CompatibilitySupport.version >= 111 && re.getStyle() != null) {
            pw.print("\n\t\t\t\t\t\tstyle=\"" + re.getStyle() + "\"");
        }
        if (re.getPropertyValue("MODE") != null) {
            pw.print("\n\t\t\t\t\t\tmode=\"" + re.getTransparent() + "\"");
        }
        int position_x = re.getPosition().x;
        position_x = re.getParentElement() != null ? (position_x -= re.getParentElement().getPosition().x) : (re.getCell() != null ? position_x - re.getCell().getLeft() - 10 : position_x - this.leftMargin - 10);
        pw.print("\n\t\t\t\t\t\tx=\"" + position_x + "\"");
        int position_y = re.getPosition().y;
        position_y = re.getParentElement() != null ? (position_y -= re.getParentElement().getPosition().y) : (re.getCell() != null ? position_y - re.getCell().getTop() - 10 : position_y - 10 - this.getBandYLocation(re.getBand()));
        pw.print("\n\t\t\t\t\t\ty=\"" + position_y + "\"");
        pw.print("\n\t\t\t\t\t\twidth=\"" + re.getWidth() + "\"");
        pw.print("\n\t\t\t\t\t\theight=\"" + re.getHeight() + "\"");
        if (re.getColorValue("FGCOLOR", null) != null) {
            pw.print("\n\t\t\t\t\t\tforecolor=\"" + Report.writeEncodedColor(re.getColorValue("FGCOLOR", null)) + "\"");
        }
        if (re.getColorValue("BGCOLOR", null) != null) {
            pw.print("\n\t\t\t\t\t\tbackcolor=\"" + Report.writeEncodedColor(re.getColorValue("BGCOLOR", null)) + "\"");
        }
        if (!re.getKey().equals("")) {
            pw.print("\n\t\t\t\t\t\tkey=\"" + re.getKey() + "\"");
        }
        if (!re.getStretchType().equals("NoStretch")) {
            pw.print("\n\t\t\t\t\t\tstretchType=\"" + re.getStretchType() + "\"");
        }
        if (!re.getPositionType().equals("FixRelativeToTop")) {
            pw.print("\n\t\t\t\t\t\tpositionType=\"" + re.getPositionType() + "\"");
        }
        if (!re.isIsPrintRepeatedValues()) {
            pw.print("\n\t\t\t\t\t\tisPrintRepeatedValues=\"" + re.isIsPrintRepeatedValues() + "\"");
        }
        if (re.isIsRemoveLineWhenBlank()) {
            pw.print("\n\t\t\t\t\t\tisRemoveLineWhenBlank=\"" + re.isIsRemoveLineWhenBlank() + "\"");
        }
        if (re.isIsPrintInFirstWholeBand()) {
            pw.print("\n\t\t\t\t\t\tisPrintInFirstWholeBand=\"" + re.isIsPrintInFirstWholeBand() + "\"");
        }
        if (re.getPrintWhenGroupChanges() != null && re.getPrintWhenGroupChanges().trim().length() > 0) {
            pw.print("\n\t\t\t\t\t\tprintWhenGroupChanges=\"" + re.getPrintWhenGroupChanges() + "\"");
        }
        if (re.isIsPrintWhenDetailOverflows()) {
            pw.print("\n\t\t\t\t\t\tisPrintWhenDetailOverflows=\"" + re.isIsPrintWhenDetailOverflows() + "\"");
        }
        if (re.getPrintWhenExpression().length() > 0) {
            pw.println(">");
            pw.print("\t\t\t\t\t\t\t<printWhenExpression");
            pw.println(">" + Report.getCDATAString(re.getPrintWhenExpression(), 7) + "</printWhenExpression>");
            pw.println("\t\t\t\t\t\t</reportElement>");
        } else {
            pw.println("/>");
        }
    }

    public static String getCDATAString(String string, int tabCount) {
        String CRLF = System.getProperty("line.separator");
        String tab = "";
        for (int i = 0; i < tabCount; ++i) {
            tab = tab + "\t";
        }
        return "<![CDATA[" + string + "]]>";
    }

    void writeXMLGraphicElement(GraphicReportElement re, PrintWriter pw) {
        pw.print("\t\t\t\t\t<graphicElement");
        pw.print(" stretchType=\"" + re.getStretchType() + "\"");
        if (re.getPropertyValue("PEN") != null) {
            pw.print(" pen=\"" + re.getGraphicElementPen() + "\"");
        }
        if (re.getPropertyValue("FILL") != null) {
            pw.print(" fill=\"" + re.getFill() + "\" ");
        }
        pw.println("/>");
    }

    void writeXMLCrosstabRowGroups(Vector crosstabRowGroups, Vector crosstabElements, PrintWriter pw) {
        for (int i = 0; i < crosstabRowGroups.size(); ++i) {
            CrosstabRowGroup group = (CrosstabRowGroup)crosstabRowGroups.elementAt(i);
            pw.print("\t\t\t\t\t<rowGroup");
            pw.print(" name=\"" + group.getName() + "\"");
            pw.print(" width=\"" + group.getWidth() + "\"");
            if (!group.getTotalPosition().equals("None")) {
                pw.print(" totalPosition=\"" + group.getTotalPosition() + "\"");
            }
            if (!group.getHeaderPosition().equals("Top")) {
                pw.print(" headerPosition=\"" + group.getHeaderPosition() + "\"");
            }
            pw.println(">");
            this.writeXMLBucket(group, pw);
            if (group.getHeaderCell().getHeight() > 0 && group.getHeaderCell().getWidth() > 0) {
                pw.println("\t\t\t\t\t\t<crosstabRowHeader>");
                this.writeXMLCrosstabCellcontents(group.getHeaderCell(), crosstabElements, pw, "\t\t\t\t\t\t\t");
                pw.println("\t\t\t\t\t\t</crosstabRowHeader>");
            }
            if (group.getTotalCell().getHeight() > 0 && group.getTotalCell().getWidth() > 0) {
                pw.println("\t\t\t\t\t\t<crosstabTotalRowHeader>");
                this.writeXMLCrosstabCellcontents(group.getTotalCell(), crosstabElements, pw, "\t\t\t\t\t\t\t");
                pw.println("\t\t\t\t\t\t</crosstabTotalRowHeader>");
            }
            pw.println("\t\t\t\t\t</rowGroup>");
        }
    }

    void writeXMLCrosstabColumnGroups(Vector crosstabColumnGroups, Vector crosstabElements, PrintWriter pw) {
        for (int i = 0; i < crosstabColumnGroups.size(); ++i) {
            CrosstabColumnGroup group = (CrosstabColumnGroup)crosstabColumnGroups.elementAt(i);
            pw.print("\t\t\t\t\t<columnGroup");
            pw.print(" name=\"" + group.getName() + "\"");
            pw.print(" height=\"" + group.getHeight() + "\"");
            if (!group.getTotalPosition().equals("None")) {
                pw.print(" totalPosition=\"" + group.getTotalPosition() + "\"");
            }
            if (!group.getHeaderPosition().equals("Left")) {
                pw.print(" headerPosition=\"" + group.getHeaderPosition() + "\"");
            }
            pw.println(">");
            this.writeXMLBucket(group, pw);
            if (group.getHeaderCell().getHeight() > 0 && group.getHeaderCell().getWidth() > 0) {
                pw.println("\t\t\t\t\t\t<crosstabColumnHeader>");
                this.writeXMLCrosstabCellcontents(group.getHeaderCell(), crosstabElements, pw, "\t\t\t\t\t\t\t");
                pw.println("\t\t\t\t\t\t</crosstabColumnHeader>");
            }
            if (group.getTotalCell().getHeight() > 0 && group.getTotalCell().getWidth() > 0) {
                pw.println("\t\t\t\t\t\t<crosstabTotalColumnHeader>");
                this.writeXMLCrosstabCellcontents(group.getTotalCell(), crosstabElements, pw, "\t\t\t\t\t\t\t");
                pw.println("\t\t\t\t\t\t</crosstabTotalColumnHeader>");
            }
            pw.println("\t\t\t\t\t</columnGroup>");
        }
    }

    void writeXMLCrosstabCellcontents(CrosstabCell cell, Vector elements, PrintWriter pw, String tabs) {
        pw.print("\t\t\t\t\t\t<cellContents");
        if (cell.getBackcolor() != null) {
            pw.print(" backcolor=\"" + Report.writeEncodedColor(cell.getBackcolor()) + "\"");
        }
        if (CompatibilitySupport.version >= 120) {
            pw.print(" mode=\"" + cell.getMode() + "\"");
        }
        if (CompatibilitySupport.version >= 120 && cell.getStyle() != null) {
            pw.print(" style=\"" + cell.getStyle() + "\"");
        }
        pw.println(">");
        if (cell.getBox() != null) {
            this.writeXMLBox(cell.getBox(), pw);
        }
        for (int i = 0; i < elements.size(); ++i) {
            ReportElement re = (ReportElement)elements.elementAt(i);
            if (re.getCell() != cell) continue;
            this.writeXMLReportElement(re, pw);
        }
        pw.println("\t\t\t\t\t\t</cellContents>");
    }

    void writeXMLCrosstabCells(Vector cells, Vector elements, PrintWriter pw, String tabs) {
        for (int i = 0; i < cells.size(); ++i) {
            CrosstabCell cell = (CrosstabCell)cells.elementAt(i);
            if (cell.getType() != 0) continue;
            pw.print(tabs + "<crosstabCell");
            pw.print(" width=\"" + cell.getWidth() + "\"");
            pw.print(" height=\"" + cell.getHeight() + "\"");
            if (cell.getRowTotalGroup().trim().length() > 0) {
                pw.print(" rowTotalGroup=\"" + cell.getRowTotalGroup() + "\"");
            }
            if (cell.getColumnTotalGroup().trim().length() > 0) {
                pw.print(" columnTotalGroup=\"" + cell.getColumnTotalGroup() + "\"");
            }
            pw.println(">");
            this.writeXMLCrosstabCellcontents(cell, elements, pw, tabs + "\t");
            pw.println(tabs + "</crosstabCell>");
        }
    }

    void writeXMLBucket(CrosstabGroup group, PrintWriter pw) {
        pw.print("\t\t\t\t\t\t<bucket");
        if (!group.getBucketOrder().equals("Ascending")) {
            pw.print(" order=\"" + group.getBucketOrder() + "\"");
        }
        pw.println(">");
        pw.print("\t\t\t\t\t\t\t<bucketExpression");
        pw.print(" class=\"" + group.getBucketExpressionClass() + "\"");
        pw.print(">");
        pw.print(Report.getCDATAString(group.getBucketExpression(), 8));
        pw.println("</bucketExpression>");
        if (group.getBucketComparatorExpression().trim().length() > 0) {
            pw.print("\t\t\t\t\t\t\t<comparatorExpression>");
            pw.print(Report.getCDATAString(group.getBucketComparatorExpression(), 8));
            pw.println("</comparatorExpression>");
        }
        pw.println("\t\t\t\t\t\t</bucket>");
    }

    void writeXMLTextElementElement(TextReportElement re, PrintWriter pw) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(0);
        pw.print("\t\t\t\t\t<textElement");
        if (re.getPropertyValue(TextReportElement.ALIGN) != null) {
            pw.print(" textAlignment=\"" + re.getAlign() + "\"");
        }
        if (re.getPropertyValue(TextReportElement.VERTICAL_ALIGN) != null) {
            pw.print(" verticalAlignment=\"" + re.getVerticalAlign() + "\"");
        }
        if (re.getPropertyValue(TextReportElement.ROTATE) != null) {
            pw.print(" rotation=\"" + re.getRotate() + "\"");
        }
        if (re.getPropertyValue(TextReportElement.IS_STYLED_TEXT) != null && re.isIsStyledText()) {
            pw.print(" isStyledText=\"true\"");
        }
        if (re.getPropertyValue(TextReportElement.LINE_SPACING) != null) {
            pw.print(" lineSpacing=\"" + re.getLineSpacing() + "\"");
        }
        pw.println(">");
        pw.print("\t\t\t\t\t\t<font");
        IReportFont font = null;
        if (re.getReportFont() != null && re.getReportFont().length() > 0) {
            for (int fn = 0; !(fn >= this.fonts.size() || (font = (IReportFont)this.fonts.elementAt(fn)) != null && font.getReportFont().equals(re.getReportFont())); ++fn) {
                font = null;
            }
            pw.print(" reportFont=\"" + re.getReportFont() + "\"");
        }
        if (!(font != null && font.getFontName().equals(re.getFontName()) || re.getIReportFont().getPropertyValue("fontName") == null)) {
            pw.print(" fontName=\"" + re.getFontName() + "\"");
        }
        if (!(font != null && font.getPDFFontName().equalsIgnoreCase(re.getPDFFontName()) || re.getIReportFont().getPropertyValue("PDFFontName") == null)) {
            pw.print(" pdfFontName=\"" + re.getPDFFontName() + "\"");
        }
        if ((font == null || font.getFontSize() != re.getFontSize()) && re.getIReportFont().getPropertyValue("fontSize") != null) {
            pw.print(" size=\"" + re.getFontSize() + "\"");
        }
        if ((font == null || font.isBold() != re.isBold()) && re.getIReportFont().getPropertyValue("bold") != null) {
            pw.print(" isBold=\"" + (re.isBold() ? "true" : "false") + "\"");
        }
        if ((font == null || font.isItalic() != re.isItalic()) && re.getIReportFont().getPropertyValue("italic") != null) {
            pw.print(" isItalic=\"" + (re.isItalic() ? "true" : "false") + "\"");
        }
        if ((font == null || font.isUnderline() != re.isUnderline()) && re.getIReportFont().getPropertyValue("underline") != null) {
            pw.print(" isUnderline=\"" + (re.isUnderline() ? "true" : "false") + "\"");
        }
        if ((font == null || font.isPdfEmbedded() != re.isPdfEmbedded()) && re.getIReportFont().getPropertyValue("pdfEmbedded") != null) {
            pw.print(" isPdfEmbedded =\"" + (re.isPdfEmbedded() ? "true" : "false") + "\"");
        }
        if ((font == null || font.getPdfEncoding() == null || font.getPdfEncoding().length() == 0) && re.getIReportFont().getPropertyValue("pdfEncoding") != null && re.getPdfEncoding().length() > 0) {
            pw.print(" pdfEncoding =\"" + re.getPdfEncoding() + "\"");
        }
        if ((font == null || font.isStrikeTrought() != re.isStrikeTrought()) && re.getIReportFont().getPropertyValue("strikeTrought") != null) {
            pw.print(" isStrikeThrough=\"" + (re.isStrikeTrought() ? "true" : "false") + "\" ");
        }
        pw.println("/>");
        pw.println("\t\t\t\t\t</textElement>");
    }

    public static String writeEncodedColor(Color c) {
        String nums = "0123456789ABCDEF";
        String s = "#";
        s = s + nums.charAt(c.getRed() / 16);
        s = s + nums.charAt(c.getRed() % 16);
        s = s + nums.charAt(c.getGreen() / 16);
        s = s + nums.charAt(c.getGreen() % 16);
        s = s + nums.charAt(c.getBlue() / 16);
        s = s + nums.charAt(c.getBlue() % 16);
        return s;
    }

    private String writeChartExpression(ChartReportElement chartElement) {
        String expression = "";
        expression = "(java.awt.Image)it.businesslogic.ireport.chart.DefaultChartFactory.drawChart(new String[]{";
        Properties props = chartElement.getProps();
        Iterator<Object> keys = props.keySet().iterator();
        int i = 0;
        while (keys.hasNext()) {
            String key = "" + keys.next();
            String val = props.getProperty(key);
            if (i > 0) {
                expression = expression + ",";
            }
            val = Misc.string_replace("\\\"", "\"", val);
            expression = expression + "\"" + key + "=" + val + "\"";
            ++i;
        }
        expression = expression + "}, (it.businesslogic.ireport.IReportScriptlet)$P{REPORT_SCRIPTLET})";
        return expression;
    }

    private void writeChartElement(ChartReportElement2 chartElement, PrintWriter pw) {
        if (CompatibilitySupport.version >= 100) {
            String chartType = "";
            if (chartElement.getChart() instanceof PieChart) {
                chartType = "pieChart";
            } else if (chartElement.getChart() instanceof Pie3DChart) {
                chartType = "pie3DChart";
            } else if (chartElement.getChart() instanceof BarChart) {
                chartType = "barChart";
            } else if (chartElement.getChart() instanceof Bar3DChart) {
                chartType = "bar3DChart";
            } else if (chartElement.getChart() instanceof XYBarChart) {
                chartType = "xyBarChart";
            } else if (chartElement.getChart() instanceof StackedBarChart) {
                chartType = "stackedBarChart";
            } else if (chartElement.getChart() instanceof StackedBar3DChart) {
                chartType = "stackedBar3DChart";
            } else if (chartElement.getChart() instanceof LineChart) {
                chartType = "lineChart";
            } else if (chartElement.getChart() instanceof XYLineChart) {
                chartType = "xyLineChart";
            } else if (chartElement.getChart() instanceof AreaChart) {
                chartType = "areaChart";
            } else if (chartElement.getChart() instanceof XYAreaChart) {
                chartType = "xyAreaChart";
            } else if (chartElement.getChart() instanceof ScatterChart) {
                chartType = "scatterChart";
            } else if (chartElement.getChart() instanceof BubbleChart) {
                chartType = "bubbleChart";
            } else if (chartElement.getChart() instanceof TimeSeriesChart) {
                chartType = "timeSeriesChart";
            } else if (chartElement.getChart() instanceof HighLowChart) {
                chartType = "highLowChart";
            } else if (chartElement.getChart() instanceof CandlestickChart) {
                chartType = "candlestickChart";
            }
            pw.println("\t\t\t\t<" + chartType + ">");
            this.writeChartNode(chartElement, pw);
            this.writeDataset(chartElement, pw);
            this.writePlot(chartElement, pw);
            pw.println("\t\t\t\t</" + chartType + ">");
        }
    }

    private void writeChartNode(ChartReportElement2 chartElement, PrintWriter pw) {
        pw.print("\t\t\t\t\t<chart ");
        if (!chartElement.getChart().isShowLegend()) {
            pw.print("isShowLegend=\"false\" ");
        }
        if (!chartElement.getEvaluationTime().equals("Now")) {
            pw.print("evaluationTime=\"" + chartElement.getEvaluationTime() + "\" ");
        }
        if (!chartElement.getEvaluationGroup().equals("")) {
            pw.print("evaluationGroup=\"" + chartElement.getEvaluationGroup() + "\" ");
        }
        if (!chartElement.getChart().getHyperlinkType().equals("None")) {
            pw.print(" hyperlinkType=\"" + chartElement.getChart().getHyperlinkType() + "\" ");
        }
        if (!chartElement.getChart().getHyperlinkTarget().equals("None")) {
            pw.print(" hyperlinkTarget=\"" + chartElement.getChart().getHyperlinkTarget() + "\" ");
        }
        if (chartElement.getChart().getBookmarkLevel() != 0) {
            pw.print(" bookmarkLevel=\"" + chartElement.getChart().getBookmarkLevel() + "\" ");
        }
        if (chartElement.getChart().getCustomizerClass().length() != 0) {
            pw.print(" customizerClass=\"" + chartElement.getChart().getCustomizerClass() + "\" ");
        }
        pw.println(">");
        this.writeXMLReportElementElement(chartElement, pw);
        this.writeXMLBox(chartElement.getBox(), pw);
        this.writeChartTitleNode(chartElement, pw);
        this.writeChartSubTitleNode(chartElement, pw);
        this.writeHyperLinkExpressions(chartElement.getChart(), pw);
        pw.println("\t\t\t\t\t</chart>");
    }

    private void writeSectionItemHyperLinkExpressions(SectionItemHyperlink hlink, boolean isItem, PrintWriter pw) {
        String tag = "sectionHyperlink";
        if (isItem) {
            tag = "itemHyperlink";
        }
        if (CompatibilitySupport.version >= 126) {
            pw.print("\t\t\t\t<" + tag + " ");
            if (hlink.getHyperlinkType() != null && !hlink.getHyperlinkType().equals("None") && hlink.getHyperlinkType().length() > 0) {
                pw.print("  hyperlinkType=\"" + hlink.getHyperlinkType() + "\"");
            }
            if (hlink.getHyperlinkTarget() != null && !hlink.getHyperlinkTarget().equals("Self")) {
                pw.print("  hyperlinkTarget=\"" + hlink.getHyperlinkTarget() + "\"");
            }
            pw.println(">");
            if (hlink.getHyperlinkType() != null && hlink.getHyperlinkType().length() > 0) {
                if (hlink.getHyperlinkReferenceExpression().length() > 0) {
                    pw.println("\t\t\t\t\t\t<hyperlinkReferenceExpression>" + Report.getCDATAString(hlink.getHyperlinkReferenceExpression(), 6) + "</hyperlinkReferenceExpression>");
                }
                if (hlink.getHyperlinkAnchorExpression().length() > 0) {
                    pw.println("\t\t\t\t\t\t<hyperlinkAnchorExpression>" + Report.getCDATAString(hlink.getHyperlinkAnchorExpression(), 6) + "</hyperlinkAnchorExpression>");
                }
                if (hlink.getHyperlinkPageExpression().length() > 0) {
                    pw.println("\t\t\t\t\t\t<hyperlinkPageExpression>" + Report.getCDATAString(hlink.getHyperlinkPageExpression(), 6) + "</hyperlinkPageExpression>");
                }
                if (hlink.getHyperlinkTooltipExpression().length() > 0) {
                    pw.println("\t\t\t\t\t\t<hyperlinkTooltipExpression>" + Report.getCDATAString(hlink.getHyperlinkTooltipExpression(), 6) + "</hyperlinkTooltipExpression>");
                }
                this.writeXMLHyperlinkParameters(hlink.getHyperlinkParameters(), pw, "\t\t\t\t\t\t");
            }
            pw.println("\t\t\t\t</" + tag + ">");
        }
    }

    private void writeHyperLinkExpressions(HyperLinkableReportElement hlink, PrintWriter pw) {
        if (hlink.getAnchorNameExpression() != null && hlink.getAnchorNameExpression().length() > 0) {
            pw.println("\t\t\t\t\t\t<anchorNameExpression>" + Report.getCDATAString(hlink.getAnchorNameExpression(), 6) + "</anchorNameExpression>");
        }
        if (hlink.getHyperlinkType() != null && hlink.getHyperlinkType().length() > 0) {
            if (hlink.getHyperlinkReferenceExpression().length() > 0) {
                pw.println("\t\t\t\t\t\t<hyperlinkReferenceExpression>" + Report.getCDATAString(hlink.getHyperlinkReferenceExpression(), 6) + "</hyperlinkReferenceExpression>");
            }
            if (hlink.getHyperlinkAnchorExpression().length() > 0) {
                pw.println("\t\t\t\t\t\t<hyperlinkAnchorExpression>" + Report.getCDATAString(hlink.getHyperlinkAnchorExpression(), 6) + "</hyperlinkAnchorExpression>");
            }
            if (hlink.getHyperlinkPageExpression().length() > 0) {
                pw.println("\t\t\t\t\t\t<hyperlinkPageExpression>" + Report.getCDATAString(hlink.getHyperlinkPageExpression(), 6) + "</hyperlinkPageExpression>");
            }
            if (CompatibilitySupport.version >= 126) {
                this.writeXMLHyperlinkParameters(hlink.getLinkParameters(), pw, "\t\t\t\t\t\t");
            }
        }
    }

    private void writeChartTitleNode(ChartReportElement2 chartElement, PrintWriter pw) {
        if (chartElement.getChart().getTitle().getTitleExpression().trim().length() > 0) {
            pw.print("\t\t\t\t\t\t<chartTitle ");
            if (!chartElement.getChart().getTitle().getPosition().equals("Top")) {
                pw.print("position=\"" + chartElement.getChart().getTitle().getPosition() + "\" ");
            }
            if (chartElement.getChart().getTitle().getColor() != null) {
                pw.print("color=\"" + Report.writeEncodedColor(chartElement.getChart().getTitle().getColor()) + "\" ");
            }
            pw.println(">");
            this.writeFontElement(chartElement.getChart().getTitle().getFont(), pw);
            pw.println("\t\t\t\t\t\t\t\t<titleExpression>" + Report.getCDATAString(chartElement.getChart().getTitle().getTitleExpression(), 8) + "</titleExpression>");
            pw.println("\t\t\t\t\t</chartTitle>");
        }
    }

    private void writeChartSubTitleNode(ChartReportElement2 chartElement, PrintWriter pw) {
        if (chartElement.getChart().getSubTitle().getTitleExpression().trim().length() > 0) {
            pw.print("\t\t\t\t\t\t<chartSubtitle ");
            if (chartElement.getChart().getSubTitle().getColor() != null) {
                pw.print("color=\"" + Report.writeEncodedColor(chartElement.getChart().getSubTitle().getColor()) + "\" ");
            }
            pw.println(">");
            this.writeFontElement(chartElement.getChart().getSubTitle().getFont(), pw);
            pw.println("\t\t\t\t\t\t\t\t<subtitleExpression>" + Report.getCDATAString(chartElement.getChart().getSubTitle().getTitleExpression(), 8) + "</subtitleExpression>");
            pw.println("\t\t\t\t\t</chartSubtitle>");
        }
    }

    private void writeDataset(ChartReportElement2 chartElement, PrintWriter pw) {
        if (chartElement.getChart().getDataset() instanceof PieDataset) {
            PieDataset pdataset = (PieDataset)chartElement.getChart().getDataset();
            pw.println("\t\t\t\t\t<pieDataset>");
            this.writeDatasetDataset(chartElement.getChart().getDataset(), pw);
            pw.println("\t\t\t\t\t\t<keyExpression>" + Report.getCDATAString(pdataset.getKeyExpression(), 6) + "</keyExpression>");
            pw.println("\t\t\t\t\t\t<valueExpression>" + Report.getCDATAString(pdataset.getValueExpression(), 6) + "</valueExpression>");
            if (pdataset.getLabelExpression().trim().length() > 0) {
                pw.println("\t\t\t\t\t\t<labelExpression>" + Report.getCDATAString(pdataset.getLabelExpression(), 6) + "</labelExpression>");
            }
            this.writeSectionItemHyperLinkExpressions(pdataset.getSectionHyperLink(), false, pw);
            pw.println("\t\t\t\t\t</pieDataset>");
        } else if (chartElement.getChart().getDataset() instanceof CategoryDataset) {
            CategoryDataset pdataset = (CategoryDataset)chartElement.getChart().getDataset();
            pw.println("\t\t\t\t\t<categoryDataset>");
            this.writeDatasetDataset(chartElement.getChart().getDataset(), pw);
            for (int i = 0; i < pdataset.getCategorySeries().size(); ++i) {
                this.writeCategorySeries((CategorySeries)pdataset.getCategorySeries().elementAt(i), pw);
            }
            pw.println("\t\t\t\t\t</categoryDataset>");
        } else if (chartElement.getChart().getDataset() instanceof TimePeriodDataset) {
            TimePeriodDataset pdataset = (TimePeriodDataset)chartElement.getChart().getDataset();
            pw.println("\t\t\t\t\t<timePeriodDataset>");
            this.writeDatasetDataset(chartElement.getChart().getDataset(), pw);
            for (int i = 0; i < pdataset.getTimePeriodSeries().size(); ++i) {
                this.writeTimePeriodSeries((TimePeriodSeries)pdataset.getTimePeriodSeries().elementAt(i), pw);
            }
            pw.println("\t\t\t\t\t</timePeriodDataset>");
        } else if (chartElement.getChart().getDataset() instanceof TimeSeriesDataset) {
            TimeSeriesDataset pdataset = (TimeSeriesDataset)chartElement.getChart().getDataset();
            pw.print("\t\t\t\t\t<timeSeriesDataset");
            if (!pdataset.getTimePeriod().equals("Day")) {
                pw.println(" timePeriod=\"" + pdataset.getTimePeriod() + "\"");
            }
            pw.println(">");
            this.writeDatasetDataset(chartElement.getChart().getDataset(), pw);
            for (int i = 0; i < pdataset.getTimeSeries().size(); ++i) {
                this.writeTimeSeries((TimeSeries)pdataset.getTimeSeries().elementAt(i), pw);
            }
            pw.println("\t\t\t\t\t</timeSeriesDataset>");
        } else if (chartElement.getChart().getDataset() instanceof XYDataset) {
            XYDataset pdataset = (XYDataset)chartElement.getChart().getDataset();
            pw.println("\t\t\t\t\t<xyDataset>");
            this.writeDatasetDataset(chartElement.getChart().getDataset(), pw);
            for (int i = 0; i < pdataset.getXYSeries().size(); ++i) {
                this.writeXYSeries((XYSeries)pdataset.getXYSeries().elementAt(i), pw);
            }
            pw.println("\t\t\t\t\t</xyDataset>");
        } else if (chartElement.getChart().getDataset() instanceof XYZDataset) {
            XYZDataset pdataset = (XYZDataset)chartElement.getChart().getDataset();
            pw.println("\t\t\t\t\t<xyzDataset>");
            this.writeDatasetDataset(chartElement.getChart().getDataset(), pw);
            for (int i = 0; i < pdataset.getXYZSeries().size(); ++i) {
                this.writeXYZSeries((XYZSeries)pdataset.getXYZSeries().elementAt(i), pw);
            }
            pw.println("\t\t\t\t\t</xyzDataset>");
        } else if (chartElement.getChart().getDataset() instanceof HighLowDataset) {
            HighLowDataset pdataset = (HighLowDataset)chartElement.getChart().getDataset();
            pw.println("\t\t\t\t\t<highLowDataset>");
            this.writeDatasetDataset(chartElement.getChart().getDataset(), pw);
            pw.println("\t\t\t\t\t\t<seriesExpression>" + Report.getCDATAString(pdataset.getSeriesExpression(), 6) + "</seriesExpression>");
            pw.println("\t\t\t\t\t\t<dateExpression>" + Report.getCDATAString(pdataset.getDateExpression(), 6) + "</dateExpression>");
            pw.println("\t\t\t\t\t\t<highExpression>" + Report.getCDATAString(pdataset.getHighExpression(), 6) + "</highExpression>");
            pw.println("\t\t\t\t\t\t<lowExpression>" + Report.getCDATAString(pdataset.getLowExpression(), 6) + "</lowExpression>");
            pw.println("\t\t\t\t\t\t<openExpression>" + Report.getCDATAString(pdataset.getOpenExpression(), 6) + "</openExpression>");
            pw.println("\t\t\t\t\t\t<closeExpression>" + Report.getCDATAString(pdataset.getCloseExpression(), 6) + "</closeExpression>");
            pw.println("\t\t\t\t\t\t<volumeExpression>" + Report.getCDATAString(pdataset.getVolumeExpression(), 6) + "</volumeExpression>");
            this.writeSectionItemHyperLinkExpressions(pdataset.getItemHyperLink(), true, pw);
            pw.println("\t\t\t\t\t</highLowDataset>");
        }
    }

    private void writeCategorySeries(CategorySeries cs, PrintWriter pw) {
        pw.println("\t\t\t\t\t\t<categorySeries>");
        pw.println("\t\t\t\t\t\t\t<seriesExpression>" + Report.getCDATAString(cs.getSeriesExpression(), 7) + "</seriesExpression>");
        pw.println("\t\t\t\t\t\t\t<categoryExpression>" + Report.getCDATAString(cs.getCategoryExpression(), 7) + "</categoryExpression>");
        pw.println("\t\t\t\t\t\t\t<valueExpression>" + Report.getCDATAString(cs.getValueExpression(), 7) + "</valueExpression>");
        if (cs.getLabelExpression().trim().length() != 0) {
            pw.println("\t\t\t\t\t\t\t<labelExpression>" + Report.getCDATAString(cs.getLabelExpression(), 7) + "</labelExpression>");
        }
        this.writeSectionItemHyperLinkExpressions(cs.getSectionItemHyperlink(), true, pw);
        pw.println("\t\t\t\t\t\t</categorySeries>");
    }

    private void writeXYSeries(XYSeries cs, PrintWriter pw) {
        pw.println("\t\t\t\t\t\t<xySeries>");
        pw.println("\t\t\t\t\t\t\t<seriesExpression>" + Report.getCDATAString(cs.getSeriesExpression(), 7) + "</seriesExpression>");
        pw.println("\t\t\t\t\t\t\t<xValueExpression>" + Report.getCDATAString(cs.getXValueExpression(), 7) + "</xValueExpression>");
        pw.println("\t\t\t\t\t\t\t<yValueExpression>" + Report.getCDATAString(cs.getYValueExpression(), 7) + "</yValueExpression>");
        if (cs.getLabelExpression().trim().length() != 0) {
            pw.println("\t\t\t\t\t\t\t<labelExpression>" + Report.getCDATAString(cs.getLabelExpression(), 7) + "</labelExpression>");
        }
        this.writeSectionItemHyperLinkExpressions(cs.getSectionItemHyperlink(), true, pw);
        pw.println("\t\t\t\t\t\t</xySeries>");
    }

    private void writeXYZSeries(XYZSeries cs, PrintWriter pw) {
        pw.println("\t\t\t\t\t\t<xyzSeries>");
        pw.println("\t\t\t\t\t\t\t<seriesExpression>" + Report.getCDATAString(cs.getSeriesExpression(), 7) + "</seriesExpression>");
        pw.println("\t\t\t\t\t\t\t<xValueExpression>" + Report.getCDATAString(cs.getXValueExpression(), 7) + "</xValueExpression>");
        pw.println("\t\t\t\t\t\t\t<yValueExpression>" + Report.getCDATAString(cs.getYValueExpression(), 7) + "</yValueExpression>");
        if (cs.getZValueExpression().trim().length() != 0) {
            pw.println("\t\t\t\t\t\t\t<zValueExpression>" + Report.getCDATAString(cs.getZValueExpression(), 7) + "</zValueExpression>");
        }
        this.writeSectionItemHyperLinkExpressions(cs.getSectionItemHyperlink(), true, pw);
        pw.println("\t\t\t\t\t\t</xyzSeries>");
    }

    private void writeTimePeriodSeries(TimePeriodSeries cs, PrintWriter pw) {
        pw.println("\t\t\t\t\t\t<timePeriodSeries>");
        pw.println("\t\t\t\t\t\t\t<seriesExpression>" + Report.getCDATAString(cs.getSeriesExpression(), 7) + "</seriesExpression>");
        pw.println("\t\t\t\t\t\t\t<startDateExpression>" + Report.getCDATAString(cs.getStartDateExpression(), 7) + "</startDateExpression>");
        pw.println("\t\t\t\t\t\t\t<endDateExpression>" + Report.getCDATAString(cs.getStartDateExpression(), 7) + "</endDateExpression>");
        pw.println("\t\t\t\t\t\t\t<valueExpression>" + Report.getCDATAString(cs.getValueExpression(), 7) + "</valueExpression>");
        if (cs.getLabelExpression().trim().length() != 0) {
            pw.println("\t\t\t\t\t\t\t<labelExpression>" + Report.getCDATAString(cs.getLabelExpression(), 7) + "</labelExpression>");
        }
        this.writeSectionItemHyperLinkExpressions(cs.getSectionItemHyperlink(), true, pw);
        pw.println("\t\t\t\t\t\t</timePeriodSeries>");
    }

    private void writeTimeSeries(TimeSeries cs, PrintWriter pw) {
        pw.println("\t\t\t\t\t\t<timeSeries>");
        pw.println("\t\t\t\t\t\t\t<seriesExpression>" + Report.getCDATAString(cs.getSeriesExpression(), 7) + "</seriesExpression>");
        pw.println("\t\t\t\t\t\t\t<timePeriodExpression>" + Report.getCDATAString(cs.getTimePeriodExpression(), 7) + "</timePeriodExpression>");
        pw.println("\t\t\t\t\t\t\t<valueExpression>" + Report.getCDATAString(cs.getValueExpression(), 7) + "</valueExpression>");
        if (cs.getLabelExpression().trim().length() != 0) {
            pw.println("\t\t\t\t\t\t\t<labelExpression>" + Report.getCDATAString(cs.getLabelExpression(), 7) + "</labelExpression>");
        }
        this.writeSectionItemHyperLinkExpressions(cs.getSectionItemHyperlink(), true, pw);
        pw.println("\t\t\t\t\t\t</timeSeries>");
    }

    private void writeDatasetDataset(Dataset dataset, PrintWriter pw) {
        pw.print("\t\t\t\t\t\t<dataset ");
        if (!dataset.getResetType().equals("Report")) {
            pw.print("resetType=\"" + dataset.getResetType() + "\" ");
        }
        if (!dataset.getResetGroup().equals("")) {
            pw.print("resetGroup=\"" + dataset.getResetGroup() + "\" ");
        }
        if (!dataset.getIncrementType().equals("None")) {
            pw.print("incrementType=\"" + dataset.getIncrementType() + "\" ");
        }
        if (!dataset.getIncrementGroup().equals("")) {
            pw.print("incrementGroup=\"" + dataset.getIncrementGroup() + "\" ");
        }
        pw.println(">");
        if (CompatibilitySupport.version >= 125 && dataset.getIncrementWhenExpression().length() > 0) {
            pw.println("\t\t\t\t\t\t\t<incrementWhenExpression>" + Report.getCDATAString(dataset.getIncrementWhenExpression().trim(), 9) + "</incrementWhenExpression>");
        }
        if (CompatibilitySupport.version >= 110 && dataset.getSubDataset() != null) {
            pw.println("\t\t\t\t\t\t\t<datasetRun subDataset=\"" + dataset.getSubDataset().getName() + "\">");
            if (dataset.getParametersMapExpression() != null && dataset.getParametersMapExpression().trim().length() > 0) {
                pw.println("\t\t\t\t\t\t\t\t<parametersMapExpression>" + Report.getCDATAString(dataset.getParametersMapExpression().trim(), 9) + "</parametersMapExpression>");
            }
            Enumeration e = dataset.getSubreportParameters().elements();
            while (e.hasMoreElements()) {
                JRSubreportParameter je = (JRSubreportParameter)e.nextElement();
                pw.println("\t\t\t\t\t\t\t\t<datasetParameter  name=\"" + je.getName() + "\">");
                pw.print("\t\t\t\t\t\t\t\t\t<datasetParameterExpression");
                pw.println(">" + Report.getCDATAString(je.getExpression(), 9) + "</datasetParameterExpression>");
                pw.println("\t\t\t\t\t\t\t\t</datasetParameter>");
            }
            if (dataset.isUseConnection() && dataset.getConnectionExpression().trim().length() > 0) {
                pw.print("\t\t\t\t\t\t\t\t<connectionExpression");
                pw.println(">" + Report.getCDATAString(dataset.getConnectionExpression(), 8) + "</connectionExpression>");
            } else if (!dataset.isUseConnection() && dataset.getDataSourceExpression().length() > 0) {
                pw.print("\t\t\t\t\t<dataSourceExpression");
                pw.println(">" + Report.getCDATAString(dataset.getDataSourceExpression(), 8) + "</dataSourceExpression>");
            }
            pw.println("\t\t\t\t\t\t\t</datasetRun>");
        }
        pw.println("\t\t\t\t\t\t</dataset>");
    }

    private void writePlot(ChartReportElement2 chartElement, PrintWriter pw) {
        if (chartElement.getChart().getPlot() instanceof PiePlot) {
            PiePlot plot = (PiePlot)chartElement.getChart().getPlot();
            pw.println("\t\t\t\t\t<piePlot>");
            this.writePlotPlot(chartElement, pw);
            pw.println("\t\t\t\t\t</piePlot>");
        } else if (chartElement.getChart().getPlot() instanceof Pie3DPlot) {
            Pie3DPlot plot = (Pie3DPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<pie3DPlot ");
            if (plot.getDepthFactor() != 0.2) {
                pw.print("depthFactor=\"" + plot.getDepthFactor() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            pw.println("\t\t\t\t\t</pie3DPlot>");
        } else if (chartElement.getChart().getPlot() instanceof BarPlot) {
            BarPlot plot = (BarPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<barPlot ");
            if (plot.isShowLabels()) {
                pw.print("isShowLabels=\"" + plot.isShowLabels() + "\" ");
            }
            if (!plot.isShowTickMarks()) {
                pw.print("isShowTickMarks=\"" + plot.isShowTickMarks() + "\" ");
            }
            if (!plot.isShowTickLabels()) {
                pw.print("isShowTickLabels=\"" + plot.isShowTickLabels() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getCategoryAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<categoryAxisLabelExpression>" + Report.getCDATAString(plot.getCategoryAxisLabelExpression(), 6) + "</categoryAxisLabelExpression>");
            }
            if (plot.getValueAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<valueAxisLabelExpression>" + Report.getCDATAString(plot.getValueAxisLabelExpression(), 6) + "</valueAxisLabelExpression>");
            }
            pw.println("\t\t\t\t\t</barPlot>");
        } else if (chartElement.getChart().getPlot() instanceof Bar3DPlot) {
            Bar3DPlot plot = (Bar3DPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<bar3DPlot ");
            if (plot.isShowLabels()) {
                pw.print("isShowLabels=\"" + plot.isShowLabels() + "\" ");
            }
            if (plot.getXOffset() != 12.0) {
                pw.print("xOffset=\"" + plot.getXOffset() + "\" ");
            }
            if (plot.getYOffset() != 8.0) {
                pw.print("yOffset=\"" + plot.getYOffset() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getCategoryAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<categoryAxisLabelExpression>" + Report.getCDATAString(plot.getCategoryAxisLabelExpression(), 6) + "</categoryAxisLabelExpression>");
            }
            if (plot.getValueAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<valueAxisLabelExpression>" + Report.getCDATAString(plot.getValueAxisLabelExpression(), 6) + "</valueAxisLabelExpression>");
            }
            pw.println("\t\t\t\t\t</bar3DPlot>");
        } else if (chartElement.getChart().getPlot() instanceof LinePlot) {
            LinePlot plot = (LinePlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<linePlot ");
            if (!plot.isShowLines()) {
                pw.print("isShowLines=\"" + plot.isShowLines() + "\" ");
            }
            if (!plot.isShowShapes()) {
                pw.print("isShowShapes=\"" + plot.isShowShapes() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getCategoryAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<categoryAxisLabelExpression>" + Report.getCDATAString(plot.getCategoryAxisLabelExpression(), 6) + "</categoryAxisLabelExpression>");
            }
            if (plot.getValueAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<valueAxisLabelExpression>" + Report.getCDATAString(plot.getValueAxisLabelExpression(), 6) + "</valueAxisLabelExpression>");
            }
            pw.println("\t\t\t\t\t</linePlot>");
        } else if (chartElement.getChart().getPlot() instanceof AreaPlot) {
            AreaPlot plot = (AreaPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<areaPlot>");
            this.writePlotPlot(chartElement, pw);
            if (plot.getCategoryAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<categoryAxisLabelExpression>" + Report.getCDATAString(plot.getCategoryAxisLabelExpression(), 6) + "</categoryAxisLabelExpression>");
            }
            if (plot.getValueAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<valueAxisLabelExpression>" + Report.getCDATAString(plot.getValueAxisLabelExpression(), 6) + "</valueAxisLabelExpression>");
            }
            pw.println("\t\t\t\t\t</areaPlot>");
        } else if (chartElement.getChart().getPlot() instanceof ScatterPlot) {
            ScatterPlot plot = (ScatterPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<scatterPlot ");
            if (!plot.isShowLines()) {
                pw.print("isShowLines=\"" + plot.isShowLines() + "\" ");
            }
            if (!plot.isShowShapes()) {
                pw.print("isShowShapes=\"" + plot.isShowShapes() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getXAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<xAxisLabelExpression>" + Report.getCDATAString(plot.getXAxisLabelExpression(), 6) + "</xAxisLabelExpression>");
            }
            if (plot.getYAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<yAxisLabelExpression>" + Report.getCDATAString(plot.getYAxisLabelExpression(), 6) + "</yAxisLabelExpression>");
            }
            pw.println("\t\t\t\t\t</scatterPlot>");
        } else if (chartElement.getChart().getPlot() instanceof BubblePlot) {
            BubblePlot plot = (BubblePlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<bubblePlot ");
            if (!plot.getScaleType().equals("RangeAxis")) {
                pw.print("scaleType=\"" + plot.getScaleType() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getXAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<xAxisLabelExpression>" + Report.getCDATAString(plot.getXAxisLabelExpression(), 6) + "</xAxisLabelExpression>");
            }
            if (plot.getYAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<yAxisLabelExpression>" + Report.getCDATAString(plot.getYAxisLabelExpression(), 6) + "</yAxisLabelExpression>");
            }
            pw.println("\t\t\t\t\t</bubblePlot>");
        } else if (chartElement.getChart().getPlot() instanceof TimeSeriesPlot) {
            TimeSeriesPlot plot = (TimeSeriesPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<timeSeriesPlot ");
            if (!plot.isShowLines()) {
                pw.print("isShowLines=\"" + plot.isShowLines() + "\" ");
            }
            if (!plot.isShowShapes()) {
                pw.print("isShowShapes=\"" + plot.isShowShapes() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getTimeAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<timeAxisLabelExpression>" + Report.getCDATAString(plot.getTimeAxisLabelExpression(), 6) + "</timeAxisLabelExpression>");
            }
            if (plot.getValueAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<valueAxisLabelExpression>" + Report.getCDATAString(plot.getValueAxisLabelExpression(), 6) + "</valueAxisLabelExpression>");
            }
            pw.println("\t\t\t\t\t</timeSeriesPlot>");
        } else if (chartElement.getChart().getPlot() instanceof HighLowPlot) {
            HighLowPlot plot = (HighLowPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<highLowPlot ");
            if (!plot.isShowCloseTicks()) {
                pw.print("isShowCloseTicks=\"" + plot.isShowCloseTicks() + "\" ");
            }
            if (!plot.isShowOpenTicks()) {
                pw.print("isShowOpenTicks=\"" + plot.isShowOpenTicks() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getTimeAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<timeAxisLabelExpression>" + Report.getCDATAString(plot.getTimeAxisLabelExpression(), 6) + "</timeAxisLabelExpression>");
            }
            if (plot.getValueAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<valueAxisLabelExpression>" + Report.getCDATAString(plot.getValueAxisLabelExpression(), 6) + "</valueAxisLabelExpression>");
            }
            pw.println("\t\t\t\t\t</highLowPlot>");
        } else if (chartElement.getChart().getPlot() instanceof CandlestickPlot) {
            CandlestickPlot plot = (CandlestickPlot)chartElement.getChart().getPlot();
            pw.print("\t\t\t\t\t<candlestickPlot ");
            if (!plot.isShowVolume()) {
                pw.print("isShowVolume=\"" + plot.isShowVolume() + "\" ");
            }
            pw.println(">");
            this.writePlotPlot(chartElement, pw);
            if (plot.getTimeAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<timeAxisLabelExpression>" + Report.getCDATAString(plot.getTimeAxisLabelExpression(), 6) + "</timeAxisLabelExpression>");
            }
            if (plot.getValueAxisLabelExpression().trim().length() != 0) {
                pw.println("\t\t\t\t\t<valueAxisLabelExpression>" + Report.getCDATAString(plot.getValueAxisLabelExpression(), 6) + "</valueAxisLabelExpression>");
            }
            pw.println("\t\t\t\t\t</candlestickPlot>");
        }
    }

    private void writePlotPlot(ChartReportElement2 chartElement, PrintWriter pw) {
        pw.print("\t\t\t\t\t\t<plot ");
        if (chartElement.getChart().getPlot().getBackcolor() != null) {
            pw.print("backcolor=\"" + Report.writeEncodedColor(chartElement.getChart().getPlot().getBackcolor()) + "\" ");
        }
        if (!chartElement.getChart().getPlot().getOrientation().equals("Vertical")) {
            pw.print("orientation=\"" + chartElement.getChart().getPlot().getOrientation() + "\" ");
        }
        if (chartElement.getChart().getPlot().getBackgroundAlpha() != 1.0) {
            pw.print("backgroundAlpha=\"" + chartElement.getChart().getPlot().getBackgroundAlpha() + "\" ");
        }
        if (chartElement.getChart().getPlot().getBackgroundAlpha() != 1.0) {
            pw.print("foregroundAlpha=\"" + chartElement.getChart().getPlot().getForegroundAlpha() + "\" ");
        }
        pw.println("/>");
    }

    public boolean isUsingMultiLineExpressions() {
        return false;
    }

    public void setUsingMultiLineExpressions(boolean usingMultiLineExpressions) {
        this.usingMultiLineExpressions = false;
    }

    public ScriptletCode getScripletCode() {
        return this.scripletCode;
    }

    public void setScripletCode(ScriptletCode scripletCode) {
        this.scripletCode = scripletCode;
    }

    public int getScriptletHandling() {
        return this.scriptletHandling;
    }

    public void setScriptletHandling(int scriptletHandling) {
        if (this.scriptletHandling == scriptletHandling) {
            return;
        }
        this.scriptletHandling = scriptletHandling;
        this.incrementReportChanges();
    }

    public String getScriptletFileName() {
        return this.getScriptletFileName(this.getFilename());
    }

    public String getScriptletFileName(String file) {
        if (file == null) {
            return "Scriptlet.java";
        }
        if (file.length() > 3) {
            file = Misc.changeFileExtension(file, "");
            file = file.substring(0, file.length() - 1);
            File f = new File(file);
            String className = f.getName() + "Scriptlet";
            className = Misc.string_replace("_", ".", className);
            if (Character.isDigit((className = Misc.string_replace("_", " ", className)).charAt(0))) {
                className = "_" + className;
            }
            className = className + ".java";
            return f.getPath().substring(0, f.getPath().length() - f.getName().length()) + className;
        }
        return "Scriptlet.java";
    }

    public IReportFont getDefaultFont() {
        return this.defaultFont;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void checkReadOnlyFlag() {
        this.checkReadOnlyFlag(this.getFilename());
    }

    public void checkReadOnlyFlag(String oF) {
        if (oF == null) {
            return;
        }
        File f = new File(oF);
        try {
            this.readOnly = !f.exists() ? false : !f.canWrite();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.readOnly = false;
    }

    public Band getBandByPosition(int originY) {
        Band bname = null;
        Iterator i = this.getBands().iterator();
        while (i.hasNext()) {
            Band b = (Band)i.next();
            if (this.getBandYLocation(b) + 10 > originY) continue;
            bname = b;
        }
        if (bname != null && this.getBandYLocation(bname) + 10 + bname.getHeight() < originY) {
            return null;
        }
        return bname;
    }

    public Vector getImports() {
        return this.imports;
    }

    public void setImports(Vector imports) {
        this.imports = imports;
        this.incrementReportChanges();
    }

    public boolean isFloatColumnFooter() {
        return this.floatColumnFooter;
    }

    public void setFloatColumnFooter(boolean floatColumnFooter) {
        if (this.floatColumnFooter == floatColumnFooter) {
            return;
        }
        this.floatColumnFooter = floatColumnFooter;
        this.incrementReportChanges();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        if (this.language == null ? language == null : this.language.equals(language)) {
            return;
        }
        this.language = language;
        this.incrementReportChanges();
    }

    public HashMap getProposedValues() {
        return this.proposedValues;
    }

    public void setProposedValues(HashMap proposedValues) {
        this.proposedValues = proposedValues;
    }

    public void recalcColumnWidth() {
        int avail;
        int dim = avail = this.getWidth() - this.getLeftMargin() - this.getRightMargin() - (this.getColumnCount() - 1) * this.getColumnSpacing();
        dim = (int)((double)dim / (double)this.getColumnCount());
        while (dim * this.getColumnCount() > avail) {
            --dim;
        }
        this.setColumnWidth(dim);
    }

    public IReportFont getReportFontByName(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        for (int i = 0; i < this.getFonts().size(); ++i) {
            IReportFont font = (IReportFont)this.getFonts().elementAt(i);
            if (!font.getReportFont().equals(name)) continue;
            return font;
        }
        return null;
    }

    public Vector getStyles() {
        return this.styles;
    }

    public void setStyles(Vector styles) {
        this.styles = styles;
        this.incrementReportChanges();
    }

    public void elementGroupResort(Band band) {
        TreeNode root = this.extractBandElementsTree(band, true);
        this.addElementsTree(root);
        this.incrementReportChanges();
    }

    public TreeNode extractBandElementsTree(Band band, boolean remove) {
        ReportElement element;
        int i;
        ArrayList<ReportElement> tmpElements = new ArrayList<ReportElement>();
        TreeNode root = new TreeNode("");
        for (i = 0; i < this.getElements().size(); ++i) {
            element = (ReportElement)this.getElements().elementAt(i);
            if (element.getBand() != band) continue;
            tmpElements.add(element);
            if (!remove) continue;
            this.getElements().removeElementAt(i);
            --i;
        }
        if (tmpElements.size() > 0) {
            for (i = 0; i < tmpElements.size(); ++i) {
                element = (ReportElement)tmpElements.get(i);
                String elementGroup = element.getElementGroup();
                try {
                    if (element.getParentElement() != null) {
                        TreeNode tmpRoot = this.findElementInTreeNode(root, element.getParentElement());
                        if (tmpRoot == null) continue;
                        this.addElementToGroup(tmpRoot, elementGroup, element);
                        continue;
                    }
                    this.addElementToGroup(root, elementGroup, element);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return root;
    }

    public void moveElementDown(ReportElement element) {
        this.incrementReportChanges();
        TreeNode root = this.extractBandElementsTree(element.getBand(), true);
        root.moveDown(element);
        this.addElementsTree(root);
    }

    public void moveElementUp(ReportElement element) {
        this.incrementReportChanges();
        TreeNode root = this.extractBandElementsTree(element.getBand(), true);
        root.moveUp(element);
        this.addElementsTree(root);
    }

    private void addElementsTree(TreeNode root) {
        for (int i = 0; i < root.getChilds().size(); ++i) {
            TreeNode node = (TreeNode)root.getChilds().get(i);
            Object obj = node.getUserObject();
            if (obj instanceof ReportElement) {
                this.getElements().add(obj);
                if (!(obj instanceof FrameReportElement)) continue;
                this.addElementsTree(node);
                continue;
            }
            this.addElementsTree(node);
        }
    }

    public void addElementToGroup(TreeNode parentNode, String subGroup, ReportElement element) {
        this.incrementReportChanges();
        if (subGroup.equals("")) {
            parentNode.addChild(new TreeNode(element));
            return;
        }
        String levelGroupName = "";
        if (subGroup.indexOf(".") >= 0) {
            levelGroupName = subGroup.substring(0, subGroup.indexOf("."));
            subGroup = subGroup.substring(subGroup.indexOf(".") + 1);
        } else {
            levelGroupName = subGroup;
            subGroup = "";
        }
        for (int i = 0; i < parentNode.getChilds().size(); ++i) {
            TreeNode node = (TreeNode)parentNode.getChilds().get(i);
            if (!node.getName().equals(levelGroupName)) continue;
            this.addElementToGroup(node, subGroup, element);
            return;
        }
        TreeNode nl = new TreeNode(levelGroupName);
        this.addElementToGroup(nl, subGroup, element);
        parentNode.addChild(nl);
    }

    public TreeNode findElementInTreeNode(TreeNode parentNode, ReportElement re) {
        for (int k = 0; k < parentNode.getChilds().size(); ++k) {
            TreeNode newchild;
            TreeNode child = (TreeNode)parentNode.getChilds().get(k);
            if (child.getUserObject() == re) {
                return child;
            }
            if (!re.getElementGroup().equals("") && re.getParentElement() == null || !(child.getUserObject() instanceof FrameReportElement) && !(child.getUserObject() instanceof String) || (newchild = this.findElementInTreeNode(child, re)) == null) continue;
            return newchild;
        }
        return null;
    }

    public Vector getSubDatasets() {
        return this.subDatasets;
    }

    public void setSubDatasets(Vector subDatasets) {
        this.subDatasets = subDatasets;
        this.incrementReportChanges();
    }

    public boolean isIgnorePagination() {
        return this.ignorePagination;
    }

    public void setIgnorePagination(boolean ignorePagination) {
        if (this.ignorePagination == ignorePagination) {
            return;
        }
        this.ignorePagination = ignorePagination;
        this.incrementReportChanges();
    }

    public void addSubDataset(SubDataset subDataset) {
        this.getSubDatasets().add(subDataset);
        this.incrementReportChanges();
        this.fireReportSubDatasetChangedListenerReportSubDatasetChanged(new ReportSubDatasetChangedEvent(this, subDataset, 2, 1));
        subDataset.addSubDatasetObjectChangedListener(this);
    }

    public void removeSubDataset(SubDataset subDataset) {
        this.getSubDatasets().remove(subDataset);
        this.fireReportSubDatasetChangedListenerReportSubDatasetChanged(new ReportSubDatasetChangedEvent(this, subDataset, 1, 1));
        subDataset.removeSubDatasetObjectChangedListener(this);
        this.incrementReportChanges();
    }

    public void removeStyle(Style s) {
        this.getStyles().remove(s);
        this.removeStyleFromElements(s, this.getElements());
        this.fireStyleChangedListenerStyleChanged(new StyleChangedEvent(this, 2, s, s));
        this.incrementReportChanges();
    }

    public void addStyle(Style s) {
        this.getStyles().add(s);
        this.incrementReportChanges();
        this.fireStyleChangedListenerStyleChanged(new StyleChangedEvent(this, 0, s, s));
    }

    private void removeStyleFromElements(Style s, Vector thisElements) {
        for (int i = 0; i < thisElements.size(); ++i) {
            ReportElement re = (ReportElement)thisElements.elementAt(i);
            if (re.getStyle() == s) {
                re.setStyle(null);
            }
            if (!(re instanceof CrosstabReportElement)) continue;
            this.removeStyleFromElements(s, ((CrosstabReportElement)re).getElements());
        }
        this.incrementReportChanges();
    }

    public synchronized void addReportSubDatasetChangedListener(ReportSubDatasetChangedListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ReportSubDatasetChangedListener.class, listener);
    }

    public synchronized void removeReportSubDatasetChangedListener(ReportSubDatasetChangedListener listener) {
        this.listenerList.remove(ReportSubDatasetChangedListener.class, listener);
    }

    public void fireReportSubDatasetChangedListenerReportSubDatasetChanged(ReportSubDatasetChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$it$businesslogic$ireport$gui$event$ReportSubDatasetChangedListener == null ? Report.class$("it.businesslogic.ireport.gui.event.ReportSubDatasetChangedListener") : class$it$businesslogic$ireport$gui$event$ReportSubDatasetChangedListener)) continue;
            ((ReportSubDatasetChangedListener)listeners[i + 1]).reportSubDatasetChanged(event);
        }
    }

    public void subDatasetObjectChanged(SubDatasetObjectChangedEvent evt) {
        if (this.getListenerList() != null && evt.getSource() != this) {
            Object[] listeners = this.getListenerList().getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i + 1] == this || listeners[i] != (class$it$businesslogic$ireport$gui$event$SubDatasetObjectChangedListener == null ? Report.class$("it.businesslogic.ireport.gui.event.SubDatasetObjectChangedListener") : class$it$businesslogic$ireport$gui$event$SubDatasetObjectChangedListener)) continue;
                ((SubDatasetObjectChangedListener)listeners[i + 1]).subDatasetObjectChanged(evt);
            }
        }
        this.incrementReportChanges();
    }

    public synchronized void addStyleChangedListener(StyleChangedListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(StyleChangedListener.class, listener);
    }

    public synchronized void removeStyleChangedListener(StyleChangedListener listener) {
        this.listenerList.remove(StyleChangedListener.class, listener);
    }

    public void fireStyleChangedListenerStyleChanged(StyleChangedEvent event) {
        Enumeration enum_elements = this.getElements().elements();
        while (enum_elements.hasMoreElements()) {
            ReportElement re = (ReportElement)enum_elements.nextElement();
            if (re.getStyle() != event.getNewValue()) continue;
            re.setStyle(event.getNewValue());
        }
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$it$businesslogic$ireport$gui$event$StyleChangedListener == null ? Report.class$("it.businesslogic.ireport.gui.event.StyleChangedListener") : class$it$businesslogic$ireport$gui$event$StyleChangedListener)) continue;
            ((StyleChangedListener)listeners[i + 1]).styleChanged(event);
        }
    }

    public Style getDefaultStyle() {
        for (int i = 0; i < this.getStyles().size(); ++i) {
            Style s = (Style)this.getStyles().elementAt(i);
            if (!s.getAttributeBoolean("isDefault", false)) continue;
            return s;
        }
        return null;
    }

    public int getReportChanges() {
        return this.reportChanges;
    }

    public void setReportChanges(int newChanges) {
        boolean fireEvent = false;
        if (this.reportChanges == 0 && newChanges > 0) {
            fireEvent = true;
        } else if (this.reportChanges > 0 && newChanges == 0) {
            fireEvent = true;
        }
        this.reportChanges = newChanges;
        if (fireEvent) {
            this.fireReportDocumentStatusChangedListenerReportDocumentStatusChanged(new ReportDocumentStatusChangedEvent(this));
        }
    }

    public void incrementReportChanges() {
        this.setReportChanges(this.getReportChanges() + 1);
    }

    public void decrementReportChanges() {
        if (this.getReportChanges() > 0) {
            this.setReportChanges(this.getReportChanges() - 1);
        }
    }

    public boolean isModified() {
        return this.getReportChanges() > 0;
    }

    public boolean isLoadingFile() {
        return this.loadingFile;
    }

    public void setLoadingFile(boolean loading) {
        this.loadingFile = loading;
    }

    public synchronized void addReportDocumentStatusChangedListener(ReportDocumentStatusChangedListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ReportDocumentStatusChangedListener.class, listener);
    }

    public synchronized void removeReportDocumentStatusChangedListener(ReportDocumentStatusChangedListener listener) {
        this.listenerList.remove(ReportDocumentStatusChangedListener.class, listener);
    }

    private void fireReportDocumentStatusChangedListenerReportDocumentStatusChanged(ReportDocumentStatusChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$it$businesslogic$ireport$gui$event$ReportDocumentStatusChangedListener == null ? Report.class$("it.businesslogic.ireport.gui.event.ReportDocumentStatusChangedListener") : class$it$businesslogic$ireport$gui$event$ReportDocumentStatusChangedListener)) continue;
            ((ReportDocumentStatusChangedListener)listeners[i + 1]).reportDocumentStatusChanged(event);
        }
    }

    public int getAvailableVerticalSpace() {
        int ph = this.getHeight();
        ph -= this.getTopMargin();
        ph -= this.getBottomMargin();
        for (int i = 0; i < this.getBands().size(); ++i) {
            Band b = (Band)this.getBands().elementAt(i);
            if (b.getName().equals("title") && this.isTitleNewPage || b.getName().equals("background") || b.getName().equals("summary") && this.isSummaryNewPage) continue;
            ph -= b.getHeight();
        }
        return ph;
    }
}

