/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.ToggleButtonUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class RadioButtonUI
extends ToggleButtonUI {
    private static Color focusColor;
    private static Rectangle prefViewRect;
    private static Rectangle prefIconRect;
    private static Rectangle prefTextRect;
    private static Insets prefInsets;
    private static Dimension size;
    private static Rectangle viewRect;
    private static Rectangle iconRect;
    private static Rectangle textRect;
    private static final RadioButtonUI radioButtonUI;
    protected Icon icon;
    private boolean defaults_initialized = false;
    private static final String propertyPrefix = "RadioButton.";
    protected static Icon selectedEnabledIcon;
    protected static Icon selectedDisabledIcon;
    protected static Icon unselectedEnabledIcon;
    protected static Icon unselectedDisabledIcon;

    static {
        prefViewRect = new Rectangle();
        prefIconRect = new Rectangle();
        prefTextRect = new Rectangle();
        prefInsets = new Insets(0, 0, 0, 0);
        size = new Dimension();
        viewRect = new Rectangle();
        iconRect = new Rectangle();
        textRect = new Rectangle();
        radioButtonUI = new RadioButtonUI();
    }

    public static ComponentUI createUI(JComponent component) {
        return radioButtonUI;
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            this.icon = UIManager.getIcon(String.valueOf(this.getPropertyPrefix()) + "icon");
            selectedEnabledIcon = UIManager.getIcon(String.valueOf(this.getPropertyPrefix()) + "selectedEnabledIcon");
            selectedDisabledIcon = UIManager.getIcon(String.valueOf(this.getPropertyPrefix()) + "selectedDisabledIcon");
            unselectedEnabledIcon = UIManager.getIcon(String.valueOf(this.getPropertyPrefix()) + "unselectedEnabledIcon");
            unselectedDisabledIcon = UIManager.getIcon(String.valueOf(this.getPropertyPrefix()) + "unselectedDisabledIcon");
            this.defaults_initialized = true;
        }
    }

    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }

    public Icon getSelectedEnabledIcon() {
        return selectedEnabledIcon;
    }

    public Icon getSelectedDisabledIcon() {
        return selectedDisabledIcon;
    }

    public Icon getUnselectedEnabledIcon() {
        return unselectedEnabledIcon;
    }

    public Icon getUnselectedDisabledIcon() {
        return unselectedDisabledIcon;
    }

    public Icon getDefaultIcon() {
        return this.icon;
    }

    public synchronized void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        size = b.getSize(size);
        RadioButtonUI.viewRect.y = 0;
        RadioButtonUI.viewRect.x = 0;
        RadioButtonUI.viewRect.width = RadioButtonUI.size.width;
        RadioButtonUI.viewRect.height = RadioButtonUI.size.height;
        RadioButtonUI.iconRect.height = 0;
        RadioButtonUI.iconRect.width = 0;
        RadioButtonUI.iconRect.y = 0;
        RadioButtonUI.iconRect.x = 0;
        RadioButtonUI.textRect.height = 0;
        RadioButtonUI.textRect.width = 0;
        RadioButtonUI.textRect.y = 0;
        RadioButtonUI.textRect.x = 0;
        Icon altIcon = b.getIcon();
        Object selectedIcon = null;
        Object disabledIcon = null;
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, RadioButtonUI.size.width, RadioButtonUI.size.height);
        }
        if (b.getIcon() != null) {
            altIcon = b.getIcon();
            if (!model.isEnabled()) {
                altIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if (altIcon == null) {
                    altIcon = b.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    altIcon = b.getRolloverSelectedIcon();
                    if (altIcon == null) {
                        altIcon = b.getSelectedIcon();
                    }
                } else {
                    altIcon = b.getSelectedIcon();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                altIcon = b.getRolloverIcon();
            }
            if (altIcon == null) {
                altIcon = b.getIcon();
            }
            altIcon.paintIcon(c, g, RadioButtonUI.iconRect.x, RadioButtonUI.iconRect.y);
        } else {
            Icon icon = null;
            icon = model.isEnabled() ? (model.isSelected() ? this.getSelectedEnabledIcon() : this.getUnselectedEnabledIcon()) : (model.isSelected() ? this.getSelectedDisabledIcon() : this.getUnselectedDisabledIcon());
            icon.paintIcon(c, g, RadioButtonUI.iconRect.x, RadioButtonUI.iconRect.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
                if (b.hasFocus() && b.isFocusPainted() && RadioButtonUI.textRect.width > 0 && RadioButtonUI.textRect.height > 0) {
                    this.paintFocus(g, textRect, size);
                }
            }
        }
    }

    protected void paintFocus(Graphics g, Rectangle textRect, Dimension size) {
        int left = textRect.x - 2;
        int top = textRect.y + 1;
        int right = textRect.x + textRect.width;
        int bottom = textRect.y + textRect.height - 2;
        if (focusColor == null) {
            focusColor = UIManager.getColor("RadioButton.focusColor");
        }
        if (focusColor != null) {
            g.setColor(focusColor);
            BasicGraphicsUtils.drawDashedRect(g, left, top, right - left + 1, bottom - top + 1);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        if (c.getComponentCount() > 0) {
            return null;
        }
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        Icon buttonIcon = b.getIcon();
        if (buttonIcon == null) {
            buttonIcon = this.getDefaultIcon();
        }
        Font font = b.getFont();
        FontMetrics fm = b.getToolkit().getFontMetrics(font);
        RadioButtonUI.prefViewRect.y = 0;
        RadioButtonUI.prefViewRect.x = 0;
        RadioButtonUI.prefViewRect.width = Short.MAX_VALUE;
        RadioButtonUI.prefViewRect.height = Short.MAX_VALUE;
        RadioButtonUI.prefIconRect.height = 0;
        RadioButtonUI.prefIconRect.width = 0;
        RadioButtonUI.prefIconRect.y = 0;
        RadioButtonUI.prefIconRect.x = 0;
        RadioButtonUI.prefTextRect.height = 0;
        RadioButtonUI.prefTextRect.width = 0;
        RadioButtonUI.prefTextRect.y = 0;
        RadioButtonUI.prefTextRect.x = 0;
        SwingUtilities.layoutCompoundLabel(c, fm, text, buttonIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), prefViewRect, prefIconRect, prefTextRect, text == null ? 0 : b.getIconTextGap());
        RadioButtonUI.prefTextRect.width += 2;
        int x1 = Math.min(RadioButtonUI.prefIconRect.x, RadioButtonUI.prefTextRect.x);
        int x2 = Math.max(RadioButtonUI.prefIconRect.x + RadioButtonUI.prefIconRect.width, RadioButtonUI.prefTextRect.x + RadioButtonUI.prefTextRect.width);
        int y1 = Math.min(RadioButtonUI.prefIconRect.y, RadioButtonUI.prefTextRect.y);
        int y2 = Math.max(RadioButtonUI.prefIconRect.y + RadioButtonUI.prefIconRect.height, RadioButtonUI.prefTextRect.y + RadioButtonUI.prefTextRect.height);
        int width = x2 - x1;
        int height = y2 - y1;
        return new Dimension(width += RadioButtonUI.prefInsets.left + RadioButtonUI.prefInsets.right, height += RadioButtonUI.prefInsets.top + RadioButtonUI.prefInsets.bottom);
    }
}

