/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

class CrossJoinFunDef
extends FunDefBase {
    public CrossJoinFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Type getResultType(Validator validator, Exp[] args) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            Exp arg = args[i];
            Type type = arg.getTypeX();
            if (type instanceof SetType) {
                SetType setType = (SetType)type;
                CrossJoinFunDef.addTypes(setType.getElementType(), list);
                continue;
            }
            if (this.getName().equals("*")) {
                CrossJoinFunDef.addTypes(type, list);
                continue;
            }
            throw Util.newInternal("arg to crossjoin must be a set");
        }
        Type[] types = list.toArray(new Type[list.size()]);
        TupleType tupleType = new TupleType(types);
        return new SetType(tupleType);
    }

    private static void addTypes(Type type, ArrayList list) {
        if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            for (int i = 0; i < tupleType.elementTypes.length; ++i) {
                CrossJoinFunDef.addTypes(tupleType.elementTypes[i], list);
            }
        } else {
            list.add(type);
        }
    }

    public Object evaluate(Evaluator evaluator, Exp[] args) {
        SchemaReader schemaReader = evaluator.getSchemaReader();
        NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(this, evaluator, args);
        if (nativeEvaluator != null) {
            return nativeEvaluator.execute();
        }
        int resultLimit = MondrianProperties.instance().ResultLimit.get();
        List set0 = CrossJoinFunDef.getArgAsList(evaluator, args, 0);
        if (set0.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List set1 = this.getNonEmptyArgAsList(set0, evaluator, args, 1);
        if (set1.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        long size = (long)set0.size() * (long)set1.size();
        if (size > 1000L && evaluator.isNonEmpty()) {
            set0 = CrossJoinFunDef.nonEmptyList(evaluator, set0);
            set1 = CrossJoinFunDef.nonEmptyList(evaluator, set1);
            size = (long)set0.size() * (long)set1.size();
        }
        if (set0.isEmpty() || set1.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (resultLimit > 0 && (long)resultLimit < size) {
            throw MondrianResource.instance().LimitExceededDuringCrossjoin.ex(new Long(size), new Long(resultLimit));
        }
        boolean neitherSideIsTuple = true;
        int arity0 = 1;
        int arity1 = 1;
        if (set0.get(0) instanceof Member[]) {
            arity0 = ((Member[])set0.get(0)).length;
            neitherSideIsTuple = false;
        }
        if (set1.get(0) instanceof Member[]) {
            arity1 = ((Member[])set1.get(0)).length;
            neitherSideIsTuple = false;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (neitherSideIsTuple) {
            int m = set0.size();
            for (int i = 0; i < m; ++i) {
                Member o0 = (Member)set0.get(i);
                int n = set1.size();
                for (int j = 0; j < n; ++j) {
                    Member o1 = (Member)set1.get(j);
                    result.add(new Member[]{o0, o1});
                }
            }
        } else {
            Member[] row = new Member[arity0 + arity1];
            int m = set0.size();
            for (int i = 0; i < m; ++i) {
                int x = 0;
                Object o0 = set0.get(i);
                if (o0 instanceof Member) {
                    row[x++] = (Member)o0;
                } else {
                    CrossJoinFunDef.assertTrue(o0 instanceof Member[]);
                    Member[] members = (Member[])o0;
                    for (int k = 0; k < members.length; ++k) {
                        row[x++] = members[k];
                    }
                }
                int n = set1.size();
                for (int j = 0; j < n; ++j) {
                    Object o1 = set1.get(j);
                    if (o1 instanceof Member) {
                        row[x++] = (Member)o1;
                    } else {
                        CrossJoinFunDef.assertTrue(o1 instanceof Member[]);
                        Member[] members = (Member[])o1;
                        for (int k = 0; k < members.length; ++k) {
                            row[x++] = members[k];
                        }
                    }
                    result.add(row.clone());
                    x = arity0;
                }
            }
        }
        return result;
    }

    private List getNonEmptyArgAsList(List left, Evaluator evaluator, Exp[] args, int index) {
        Object obj;
        if (left.size() == 1 && evaluator.isNonEmpty() && (obj = left.get(0)) instanceof Member) {
            evaluator = evaluator.push((Member)obj);
        }
        return CrossJoinFunDef.getArgAsList(evaluator, args, index);
    }

    private static List getArgAsList(Evaluator evaluator, Exp[] args, int index) {
        Object arg = CrossJoinFunDef.getArg(evaluator, args, index);
        if (arg == null) {
            return Collections.EMPTY_LIST;
        }
        if (arg instanceof List) {
            return (List)arg;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(arg);
        return list;
    }

    protected static List nonEmptyList(Evaluator evaluator, List list) {
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        evaluator = evaluator.push();
        if (list.get(0) instanceof Member[]) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Member[] m = (Member[])it.next();
                evaluator.setContext(m);
                Object value = evaluator.evaluateCurrent();
                if (value == Util.nullValue || value instanceof Throwable) continue;
                result.add(m);
            }
        } else {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Member m = (Member)it.next();
                evaluator.setContext(m);
                Object value = evaluator.evaluateCurrent();
                if (value == Util.nullValue || value instanceof Throwable) continue;
                result.add(m);
            }
        }
        return result;
    }
}

