/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.eigenbase.xom.XMLUtil;
import org.eigenbase.xom.XOMUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXWriter
implements ContentHandler {
    private final PrintWriter pw;
    private int indent;
    private String indentString = "  ";
    private int state = 1;
    private static final int STATE_IN_TAG = 0;
    private static final int STATE_END_ELEMENT = 1;
    private static final int STATE_AFTER_TAG = 2;
    private static final int STATE_CHARACTERS = 3;

    public SAXWriter(OutputStream stream) {
        this.pw = new PrintWriter(new OutputStreamWriter(stream));
    }

    public SAXWriter(Writer writer) {
        this.pw = new PrintWriter(writer);
    }

    public SAXWriter(PrintWriter writer) {
        this.pw = writer;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.pw.println("<?xml version=\"1.0\"?>");
    }

    public void endDocument() throws SAXException {
        this.pw.flush();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        int i;
        this.checkTag();
        if (this.indent > 0) {
            this.pw.println();
        }
        for (i = 0; i < this.indent; ++i) {
            this.pw.write(this.indentString);
        }
        ++this.indent;
        this.pw.write(60);
        this.pw.write(qName);
        for (i = 0; i < atts.getLength(); ++i) {
            XMLUtil.printAtt((PrintWriter)this.pw, (String)atts.getQName(i), (String)atts.getValue(i));
        }
        this.state = 0;
    }

    private void checkTag() {
        if (this.state == 0) {
            this.state = 2;
            this.pw.print(">");
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        --this.indent;
        if (this.state == 0) {
            this.pw.write("/>");
        } else {
            if (this.state != 3) {
                this.pw.println();
                for (int i = 0; i < this.indent; ++i) {
                    this.pw.write(this.indentString);
                }
            }
            this.pw.write("</");
            this.pw.write(qName);
            this.pw.write(62);
        }
        this.state = 1;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.checkTag();
        String s = new String(ch, start, length);
        if (XOMUtil.stringHasXMLSpecials((String)s)) {
            if (s.indexOf("]]>") < 0) {
                this.pw.print("<![CDATA[");
                this.pw.print(s);
                this.pw.print("]]>");
            } else {
                XMLUtil.stringEncodeXML((String)s, (PrintWriter)this.pw);
            }
        } else {
            this.pw.print(s);
        }
        this.state = 3;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }
}

