/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import mondrian.rolap.RolapStar;
import mondrian.rolap.agg.ColumnConstraint;
import mondrian.rolap.agg.QuerySpec;
import mondrian.rolap.sql.SqlQuery;

public abstract class AbstractQuerySpec
implements QuerySpec {
    private final RolapStar star;

    protected AbstractQuerySpec(RolapStar star) {
        this.star = star;
    }

    protected SqlQuery newSqlQuery() {
        return this.getStar().getSqlQuery();
    }

    public RolapStar getStar() {
        return this.star;
    }

    public abstract int getMeasureCount();

    public abstract RolapStar.Measure getMeasure(int var1);

    public abstract String getMeasureAlias(int var1);

    public abstract RolapStar.Column[] getColumns();

    public abstract String getColumnAlias(int var1);

    public abstract ColumnConstraint[] getConstraints(int var1);

    public abstract String generateSqlQuery();

    protected abstract void addMeasure(int var1, SqlQuery var2);

    protected abstract boolean isAggregate();

    protected void nonDistinctGenerateSQL(SqlQuery sqlQuery) {
        int i;
        RolapStar.Column[] columns = this.getColumns();
        int arity = columns.length;
        for (i = 0; i < arity; ++i) {
            RolapStar.Column column = columns[i];
            RolapStar.Table table = column.getTable();
            if (table.isFunky()) continue;
            table.addToFrom(sqlQuery, false, true);
            String expr = column.getExpression(sqlQuery);
            ColumnConstraint[] constraints = this.getConstraints(i);
            if (constraints != null) {
                sqlQuery.addWhere(RolapStar.Column.createInExpr(expr, constraints, column.isNumeric()));
            }
            if (sqlQuery.getDialect().isAS400()) {
                sqlQuery.addSelect(expr, null);
            } else {
                sqlQuery.addSelect(expr, this.getColumnAlias(i));
            }
            if (!this.isAggregate()) continue;
            sqlQuery.addGroupBy(expr);
        }
        int count = this.getMeasureCount();
        for (i = 0; i < count; ++i) {
            this.addMeasure(i, sqlQuery);
        }
    }
}

