/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.Borders;
import com.digitprop.tonic.TonicLookAndFeel;
import com.digitprop.tonic.ToolBarBorder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalButtonUI;

public class ButtonUI
extends MetalButtonUI {
    private static final BorderUIResource defaultBorder = new BorderUIResource(Borders.getButtonBorder());
    private static Hashtable opaqueTable = new Hashtable();
    private Color highlightColor = UIManager.getColor("Button.highlight");
    private Color focusColor = UIManager.getColor("Button.focusBorderColor");

    public static ComponentUI createUI(JComponent c) {
        if (c instanceof JButton) {
            return new ButtonUI();
        }
        return MetalButtonUI.createUI(c);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new BasicButtonListener(b);
    }

    protected int getTextShiftOffset() {
        return 1;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c.getBorder() == null || c.getBorder() instanceof UIResource) {
            c.setBorder(defaultBorder);
        }
        if (opaqueTable.get(c) == null) {
            opaqueTable.put(c, new Boolean(c.isOpaque()));
        }
        c.setOpaque(false);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        Boolean isOpaque = (Boolean)opaqueTable.get(c);
        if (isOpaque != null) {
            c.setOpaque(isOpaque);
        }
    }

    public void paint(Graphics g, JComponent c) {
        g.setColor(c.getBackground());
        Insets insets = c.getInsets();
        g.fillRect(insets.left, insets.top, c.getWidth() - insets.left - insets.right, c.getHeight() - insets.top - insets.bottom);
        if (c instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)c;
            if (!button.getModel().isPressed() && button.isEnabled() && !button.isSelected()) {
                Border border = button.getBorder();
                if (border == null || !(border instanceof ToolBarBorder)) {
                    g.setColor(this.highlightColor);
                    g.drawLine(insets.left, insets.top, c.getWidth() - insets.left - insets.right, insets.top);
                    g.drawLine(insets.left, insets.top, insets.left, c.getHeight() - insets.top - insets.bottom);
                }
            } else if (button.isSelected()) {
                this.paintButtonPressed(g, button);
            }
        }
        super.paint(g, c);
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension result = super.getPreferredSize(c);
        if (c.getBorder() != null && c.getBorder() instanceof ToolBarBorder) {
            result.width += 4;
            result.height += 4;
        } else {
            Insets m;
            result.width += 4;
            result.height += 6;
            if (c instanceof JButton && (m = ((JButton)c).getMargin()) != null) {
                result.width += m.left + m.right;
                result.height += m.top + m.bottom;
            }
        }
        return result;
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        Border border = b.getBorder();
        if (border == null || !(border instanceof ToolBarBorder)) {
            Insets insets = b.getInsets();
            g.setColor(this.highlightColor);
            g.drawLine(insets.left, b.getHeight() - insets.top - insets.bottom, b.getWidth() - insets.left - insets.right, b.getHeight() - insets.top - insets.bottom);
            g.drawLine(b.getWidth() - insets.left - insets.right, insets.top, b.getWidth() - insets.left - insets.right, b.getHeight() - insets.top - insets.bottom);
        }
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        Border border;
        if (!(b.getModel().isPressed() || (border = b.getBorder()) != null && border instanceof ToolBarBorder)) {
            Insets insets = b.getInsets();
            int left = insets.left + 2;
            int top = insets.top + 2;
            int right = b.getWidth() - insets.left - insets.right - 2;
            int bottom = b.getHeight() - insets.top - insets.bottom - 2;
            g.setColor(this.focusColor);
            BasicGraphicsUtils.drawDashedRect(g, left, top, right - left + 1, bottom - top + 1);
        }
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        if (c instanceof AbstractButton) {
            this.paintText(g, (AbstractButton)c, textRect, text);
        }
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = b.getDisplayedMnemonicIndex();
        if (model.isPressed()) {
            textRect.x += this.getTextShiftOffset();
            textRect.y += this.getTextShiftOffset();
        }
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        } else {
            g.setColor(Color.WHITE);
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x + 1, textRect.y + fm.getAscent() + 1);
            g.setColor(this.getDisabledTextColor());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(new TonicLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        JWindow win = new JWindow();
        win.getContentPane().setLayout(new FlowLayout());
        win.setBounds(10, 10, 300, 300);
        ImageIcon icon = TonicLookAndFeel.getTonicIcon("open.gif");
        JButton button = new JButton(icon);
        button.setEnabled(false);
        win.getContentPane().add(button);
        win.setVisible(true);
    }
}

