/*
 * FormatCommandRemoveSpaceV.java
 *
 * Created on 9 mei 2005, 21:36
 * Original code: Giulio
 * Redesigned code: Robert Lamping
 */

package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.ReportElement;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;


/**
 *
 *
 */
public class FormatCommandRemoveSpaceV extends FormatCommand {
    int actual_y;
    int available_height;
    Band activeBand ;
    ReportElement bottomElement;
    Vector myElements = null;
    Vector bands = null;
    
    {
        operationType = OperationType.EQUALS_SPACE_V;
    }
    
    boolean preCondition(){
        activeBand = (Band) ((ReportElement) this.getSelectedElements().firstElement()).getBand();
        int counter = 0;
        
        for (Iterator i = this.getSelectedElements().iterator(); i.hasNext(); ) {
            ReportElement re = (ReportElement) i.next();
            if (re.getBand() == activeBand) {
                counter++;
            }
        }
        return ( counter > 1 );
        
    }
    
    void preparation(){
        available_height = 0;
    }
    void executeDeeper(){
        // resetEnumeration();
        preparation();
        
        bands = getBands();
        
        for (Iterator h = bands.iterator(); h.hasNext(); ) {
            Band b = (Band) h.next();
            Vector bandElements = getBandElements(b);
            bandElements = sortYX( bandElements.elements());
            
            if (bandElements.size()>1) {
                ReportElement re = (ReportElement) bandElements.firstElement();
                actual_y = re.getPosition().y + re.getHeight() + available_height;
                
                // the highest element in the band doesn't have to be moved
                bandElements.removeElement(re);
                
                processElements(bandElements.elements());
            }
        }
    }
    
    public void modify() {
        re.setPosition(new Point(re.getPosition().x, actual_y) );
        actual_y += re.getHeight() + available_height;
    }
    
}
