/*
 * ProjectExplorerTreeCellRenderer.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 1 giugno 2003, 16.04
 */

package it.businesslogic.ireport.data.olap;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.data.olap.WalkableWrapper;
import  javax.swing.tree.*;
import  javax.swing.*;
import  java.awt.*;
import mondrian.olap.QueryAxis;
/**
 *
 * @author  Administrator
 */
public class OlapTreeCellRenderer extends DefaultTreeCellRenderer {

    
    static ImageIcon measureIcon;
    static ImageIcon dimensionIcon;
    static ImageIcon hierarchyIcon;
    
    public OlapTreeCellRenderer() {
        super();

        if (measureIcon == null) measureIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/olap/measure.png"));
        if (dimensionIcon == null) dimensionIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/olap/axis.png"));
        if (hierarchyIcon == null) hierarchyIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/olap/hierarchy.png"));
        
    }

    public Component getTreeCellRendererComponent(
                        JTree tree,
                        Object value,
                        boolean sel,
                        boolean expanded,
                        boolean leaf,
                        int row,
                        boolean hasFocus) {

        super.getTreeCellRendererComponent(
                        tree, value, sel,
                        expanded, leaf, row,
                        hasFocus);
            this.setForeground( Color.BLACK);
            ImageIcon icon = getElementIcon(value);
            setIcon(icon);

            setToolTipText(null);

        return this;
    }

    protected ImageIcon getElementIcon(Object value) {
        
        if (!(value instanceof DefaultMutableTreeNode)) return null; // ?!!!
        
        DefaultMutableTreeNode node =
                (DefaultMutableTreeNode)value;

        try {
            WalkableWrapper ww = (WalkableWrapper)node.getUserObject();

            if (node.getParent() != null && node.getParent() instanceof DefaultMutableTreeNode) 
            {
                if (ww.isMeasure()) return measureIcon;
                if (ww.getWalkable() instanceof QueryAxis) return dimensionIcon;
                return hierarchyIcon;
            }
            
        } catch (Exception ex)
        {
            
        }
        return null;
    }
}

