/*
 * JRParameter.java
 *
 * 
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *  Created on 12 febbraio 2003, 21.47
 *
 */
package it.businesslogic.ireport;

public class JRParameter
{
	private String name;
	private String classType;
	private String description="";
	private String defaultValueExpression="";
	private boolean isForPrompting = true;
	private boolean builtin = false;
        private String lastDefaultValue = "";
    
	public  JRParameter(String name, String classType, boolean isForPrompting, String description, boolean builtin)
	{
		this.name = name;
		this.classType = classType;
		this.isForPrompting = isForPrompting;
		this.description = description;
                this.builtin = builtin;
	}
        
	public  JRParameter(String name, String classType, boolean isForPrompting, String description)
	{
                this(name, classType, isForPrompting, description, false);
	}
	
	public  JRParameter(String name, String classType, boolean isForPrompting)
	{
		this(name, classType, isForPrompting, "", false);
	}
	
	public  JRParameter(String name, String classType)
	{
                this(name, classType, true, "", false);
	}
		
	public String toString()
	{
		return name;
	}
        
        /** Getter for property classType.
         * @return Value of property classType.
         *
         */
        public java.lang.String getClassType() {
            return classType;
        }
        
        /** Setter for property classType.
         * @param classType New value of property classType.
         *
         */
        public void setClassType(java.lang.String classType) {
            this.classType = classType;
        }
        
        /** Getter for property defaultValueExpression.
         * @return Value of property defaultValueExpression.
         *
         */
        public java.lang.String getDefaultValueExpression() {
            return defaultValueExpression;
        }
        
        /** Setter for property defaultValueExpression.
         * @param defaultValueExpression New value of property defaultValueExpression.
         *
         */
        public void setDefaultValueExpression(java.lang.String defaultValueExpression) {
            this.defaultValueExpression = defaultValueExpression;
        }
        
        /** Getter for property description.
         * @return Value of property description.
         *
         */
        public java.lang.String getDescription() {
            return description;
        }
        
        /** Setter for property description.
         * @param description New value of property description.
         *
         */
        public void setDescription(java.lang.String description) {
            this.description = description;
        }
        
        /** Getter for property isForPrompting.
         * @return Value of property isForPrompting.
         *
         */
        public boolean isIsForPrompting() {
            return isForPrompting;
        }
        
        /** Setter for property isForPrompting.
         * @param isForPrompting New value of property isForPrompting.
         *
         */
        public void setIsForPrompting(boolean isForPrompting) {
            this.isForPrompting = isForPrompting;
        }
        
        /** Getter for property name.
         * @return Value of property name.
         *
         */
        public java.lang.String getName() {
            return name;
        }
        
        /** Setter for property name.
         * @param name New value of property name.
         *
         */
        public void setName(java.lang.String name) {
            this.name = name;
        }
        
        public JRParameter cloneMe()
        {
        	JRParameter jrp = new JRParameter(name, classType, isForPrompting, description);
        	
        	jrp.setDefaultValueExpression( defaultValueExpression );
		jrp.setBuiltin( isBuiltin());
        	
        	return jrp;
        }

    public boolean isBuiltin() {
        return builtin;
    }

    public void setBuiltin(boolean builtin) {
        this.builtin = builtin;
    }
    
    public String getLastDefaultValue() {
        return lastDefaultValue;
    }

    public void setLastDefaultValue(String lastDefaultValue) {
        this.lastDefaultValue = lastDefaultValue;
    }
        
}
