/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedListener;
import it.businesslogic.ireport.gui.sheet.CategorySheetPanel;
import it.businesslogic.ireport.gui.sheet.ColorSelectorPanel;
import it.businesslogic.ireport.gui.sheet.NumberComboBoxSheetProperty;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import it.businesslogic.ireport.util.LocaleAdapter;
import it.businesslogic.ireport.util.Misc;
import it.businesslogic.ireport.util.Unit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class OptionsDialog
extends JDialog
implements LanguageChangedListener,
SheetPropertyValueChangedListener {
    MainFrame mf = null;
    Unit[] units;
    List listOfLanguages;
    List listOfPLAF;
    private CategorySheetPanel categorySheetPanel = null;
    private ButtonGroup buttonGroup1;
    private JButton jButtonApply;
    private JButton jButtonBackupDirectory;
    private JButton jButtonBrowseEditor;
    private JButton jButtonBrowseEditor1;
    private JButton jButtonBrowseEditor2;
    private JButton jButtonBrowseEditor3;
    private JButton jButtonBrowseEditor4;
    private JButton jButtonBrowseEditor5;
    private JButton jButtonBrowseEditor6;
    private JButton jButtonCancel;
    private JButton jButtonCompilationDir;
    private JButton jButtonOK;
    private JButton jButtonTemplate;
    private JButton jButtonVirtualizerDirBrowse;
    private JCheckBox jCheckBoxAutosave;
    private JCheckBox jCheckBoxKeepJavaFile;
    private JCheckBox jCheckBoxUseCurrentFilesDirectoryForCompiles;
    private JComboBox jComboBox1;
    private JComboBox jComboBoxVirtualizer;
    private JLabel jLabel1;
    private JLabel jLabelCSVViewer;
    private JLabel jLabelDefaultBackupDir;
    private JLabel jLabelHTMLViewer;
    private JLabel jLabelPDFViewer;
    private JLabel jLabelRTFViewer;
    private JLabel jLabelReportVirtualizerDirectory;
    private JLabel jLabelReportVirtualizerMinGrowCount;
    private JLabel jLabelReportVirtualizerSize;
    private JLabel jLabelReportVirtualizerSize1;
    private JLabel jLabelTXTViewer;
    private JLabel jLabelTemplateForNewDocs;
    private JLabel jLabelXLSViewer;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanelBackup;
    private JPanel jPanelComper;
    private JPanel jPanelCompileDir;
    private JPanel jPanelCompileDir1;
    private JPanel jPanelCompileDir2;
    private JPanel jPanelExternalEditor;
    private JPanel jPanelExternalPrograms;
    private JPanel jPanelGeneral;
    private JPanel jPanelViewers;
    private JRadioButton jRadioButton1_NoBackup;
    private JRadioButton jRadioButton2_ReplaceExtension;
    private JRadioButton jRadioButton3_AppendExtension;
    private JSpinner jSpinnerVirtualizerBlockSize;
    private JSpinner jSpinnerVirtualizerGrownCount;
    private JSpinner jSpinnerVirtualizerSize;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldBackupDirectory;
    private JTextField jTextFieldCSVViewer;
    private JTextField jTextFieldCompilationDir;
    private JTextField jTextFieldEditor;
    private JTextField jTextFieldHTMLViewer;
    private JTextField jTextFieldPDFViewer;
    private JTextField jTextFieldRTFViewer;
    private JTextField jTextFieldTXTViewer;
    private JTextField jTextFieldTemplate;
    private JTextField jTextFieldVirtualizerDir;
    private JTextField jTextFieldXLSViewer;

    public OptionsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.mf = (MainFrame)parent;
        this.initComponents();
        DocumentListener listener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                OptionsDialog.this.enableApplyAndOk();
            }

            public void insertUpdate(DocumentEvent evt) {
                OptionsDialog.this.enableApplyAndOk();
            }

            public void removeUpdate(DocumentEvent evt) {
                OptionsDialog.this.enableApplyAndOk();
            }
        };
        this.jTextFieldBackupDirectory.getDocument().addDocumentListener(listener);
        this.jTextFieldCSVViewer.getDocument().addDocumentListener(listener);
        this.jTextFieldCompilationDir.getDocument().addDocumentListener(listener);
        this.jTextFieldEditor.getDocument().addDocumentListener(listener);
        this.jTextFieldHTMLViewer.getDocument().addDocumentListener(listener);
        this.jTextFieldPDFViewer.getDocument().addDocumentListener(listener);
        this.jTextFieldTemplate.getDocument().addDocumentListener(listener);
        this.jTextFieldXLSViewer.getDocument().addDocumentListener(listener);
        this.jTextFieldVirtualizerDir.getDocument().addDocumentListener(listener);
        this.jTextFieldTXTViewer.getDocument().addDocumentListener(listener);
        this.jTextFieldRTFViewer.getDocument().addDocumentListener(listener);
        this.jComboBoxVirtualizer.addItem(new Tag("JRFileVirtualizer", "File virtualizer"));
        this.jComboBoxVirtualizer.addItem(new Tag("JRSwapFileVirtualizer", "Single swap/file virtualizer"));
        this.jComboBoxVirtualizer.addItem(new Tag("JRGzipVirtualizer", "GZIP in-memory virtualizer"));
        this.units = Unit.getStandardUnits();
        this.jSpinnerVirtualizerSize.setModel(new SpinnerNumberModel(100, 1, 100000000, 10));
        this.jSpinnerVirtualizerBlockSize.setModel(new SpinnerNumberModel(100, 1, 100000000, 10));
        this.jSpinnerVirtualizerGrownCount.setModel(new SpinnerNumberModel(1, 1, 100000000, 10));
        I18n.addOnLanguageChangedListener(this);
        this.categorySheetPanel = new CategorySheetPanel();
        this.categorySheetPanel.setShowResetButton(false);
        this.createSheet();
        this.applyI18n();
        this.jPanel8.add("Center", this.categorySheetPanel);
        this.pack();
    }

    private void createSheet() {
        if (this.categorySheetPanel == null) {
            return;
        }
        this.categorySheetPanel.removeAllProperties();
        String category_name = I18n.getString("gui.OptionsDialog.TabGeneral", "General");
        this.categorySheetPanel.addSheetProperty(category_name, new SheetProperty("RecentFilesLength", I18n.getString("gui.OptionsDialog.LabelRecentFileListLength", "Num of recent files in file menu"), 6));
        this.units = Unit.getStandardUnits();
        SheetProperty sp = new SheetProperty("DefaultUnit", I18n.getString("gui.OptionsDialog.LabelDefaultUnit", "Default unit"), 2);
        Vector<Tag> tags = new Vector<Tag>();
        for (int i = 0; i < this.units.length; ++i) {
            Tag t = new Tag(this.units[i].getKeyName(), this.units[i] + "");
            tags.add(t);
        }
        sp.setTags(tags);
        this.categorySheetPanel.addSheetProperty(category_name, sp);
        this.categorySheetPanel.addSheetProperty(category_name, new SheetProperty("showGrid", I18n.getString("gui.OptionsDialog.LabelViewGrid", "View grid"), 4));
        this.categorySheetPanel.addSheetProperty(category_name, new SheetProperty("ViewRules", I18n.getString("gui.OptionsDialog.LabelViewRules", "View rules"), 4));
        this.categorySheetPanel.addSheetProperty(category_name, new SheetProperty("GridSize", I18n.getString("gui.OptionsDialog.LabelGridSize", "Grid size"), 6));
        this.categorySheetPanel.addSheetProperty(category_name, new SheetProperty("ViewBorderForTextElements", I18n.getString("gui.OptionsDialog.LabelViewBorderForTextElements", "View border for text elements"), 4));
        this.categorySheetPanel.addSheetProperty(category_name, new SheetProperty("ViewBorderColor", I18n.getString("gui.OptionsDialog.LabelTextBorderColor", "Text border color"), 3));
        this.categorySheetPanel.addSheetProperty(category_name, new SheetProperty("Antialias", I18n.getString("gui.OptionsDialog.LabelAntialias", "Use antialiasing"), 4));
        this.categorySheetPanel.addSheetProperty(category_name, new SheetProperty("ShowToolTipsInDesign", I18n.getString("gui.OptionsDialog.LabelShowToolTipsInDesign", "Show ToolTips in design"), 4));
        SheetProperty sp_language = new SheetProperty("Language", I18n.getString("gui.OptionsDialog.LabelLanguage", "Language"), 2);
        Vector<Tag> tags_language = new Vector<Tag>();
        this.listOfLanguages = I18n.getListOfAvailLanguages();
        this.listOfLanguages.add(0, Locale.getDefault());
        Object languageModel = null;
        String selectedLanguage = this.mf.getProperties().getProperty("Language");
        String selectedCountry = this.mf.getProperties().getProperty("Country");
        String selectedVariant = this.mf.getProperties().getProperty("Variant");
        String def_language = "";
        for (int i = 0; i < this.listOfLanguages.size(); ++i) {
            Locale lang = (Locale)this.listOfLanguages.get(i);
            LocaleAdapter adapter = new LocaleAdapter(lang);
            Tag t = new Tag("" + adapter);
            tags_language.add(t);
            if (!lang.getCountry().equals(selectedCountry) || !lang.getLanguage().equals(selectedLanguage) || !lang.getVariant().equals(selectedVariant)) continue;
            def_language = "" + adapter;
        }
        sp_language.setTags(tags_language);
        if (def_language.length() > 0) {
            sp_language.setValue(def_language);
        } else {
            sp_language.setValue("" + new LocaleAdapter(Locale.getDefault()));
        }
        this.categorySheetPanel.addSheetProperty(category_name, sp_language);
        this.categorySheetPanel.addSheetProperty(category_name, new SheetProperty("UseAutoRegiesterFields", I18n.getString("gui.OptionsDialog.LabelAutoRegisterFields", "Auto register SQL fields"), 4));
        this.categorySheetPanel.addSheetProperty(category_name, new SheetProperty("EnableTextResizeClick", I18n.getString("gui.OptionsDialog.LabelEnableTextResizeClick", "Enable text fields resize click"), 4));
        this.categorySheetPanel.addSheetProperty(category_name, new SheetProperty("SynchronizeReportName", I18n.getString("gui.OptionsDialog.LabelSynchronizeReportName", "Synchronize report name with file name"), 4));
        this.categorySheetPanel.addSheetProperty(category_name, new SheetProperty("AutoReload", I18n.getString("gui.OptionsDialog.AutoReload", "Reload externally modified files without ask"), 4));
        this.categorySheetPanel.addSheetProperty(category_name, new SheetProperty("AskToSave", I18n.getString("gui.OptionsDialog.AskToSave", "Ask to save modified files before close them"), 4));
        SheetProperty sp_script_language = new SheetProperty("DefaultScriptingLanguage", I18n.getString("gui.OptionsDialog.DefaultScriptingLanguage", "Default language for expressions"), 2);
        Vector<Tag> tags_script_languages = new Vector<Tag>();
        tags_script_languages.add(new Tag("groovy", "Groovy"));
        tags_script_languages.add(new Tag("java", "Java"));
        sp_script_language.setTags(tags_script_languages);
        this.categorySheetPanel.addSheetProperty(category_name, sp_script_language);
        SheetProperty sp_laf = new SheetProperty("LookAndFeel", I18n.getString("gui.OptionsDialog.LabelLookAndFeel", "Look & Feel"), 2);
        Vector<Tag> tags_laf = new Vector<Tag>();
        this.listOfPLAF = Misc.getAvailablePLAF();
        String selectedPAF = this.mf.getProperties().getProperty("LookAndFeel");
        for (int i = 0; i < this.listOfPLAF.size(); ++i) {
            String pnf = (String)this.listOfPLAF.get(i);
            Tag t = new Tag(pnf + "");
            tags_laf.add(t);
        }
        sp_laf.setTags(tags_laf);
        sp_laf.setValue(selectedPAF);
        this.categorySheetPanel.addSheetProperty("LookAndFeel", sp_laf);
        this.categorySheetPanel.addSheetProperty("LookAndFeel", new SheetProperty("overrideDefaultFont", I18n.getString("gui.OptionsDialog.OverrideDefaultFont", "Override default font"), 4));
        NumberComboBoxSheetProperty spFontSize = null;
        spFontSize = new NumberComboBoxSheetProperty("overrideDefaultFontSize", I18n.getString("gui.elementpropertiessheet.fontSize", "Font size"));
        spFontSize.addEntry("3", 3);
        spFontSize.addEntry("5", 5);
        spFontSize.addEntry("8", 8);
        spFontSize.addEntry("10", 10);
        spFontSize.addEntry("11", 11);
        spFontSize.addEntry("12", 13);
        spFontSize.addEntry("13", 13);
        spFontSize.addEntry("14", 14);
        spFontSize.addEntry("15", 15);
        spFontSize.addEntry("16", 16);
        SheetProperty spFontName = new SheetProperty("overrideDefaultFontName", I18n.getString("gui.elementpropertiessheet.fontName", "Font"), 2);
        Vector<Tag> fontsVec = new Vector<Tag>();
        String[] fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < fontFamilies.length; ++i) {
            fontsVec.add(new Tag(fontFamilies[i]));
        }
        spFontName.setTags(fontsVec);
        spFontName.setDefaultValue("Tahoma");
        this.categorySheetPanel.addSheetProperty("LookAndFeel", spFontName);
        this.categorySheetPanel.addSheetProperty("LookAndFeel", spFontSize);
        this.categorySheetPanel.addSheetProperty("LookAndFeel", new SheetProperty("overrideDefaultFontAttrs", I18n.getString("gui.elementpropertiessheet.Bold", "Bold"), 4));
        this.categorySheetPanel.setShowResetButton(false);
        this.categorySheetPanel.recreateSheet();
        this.categorySheetPanel.addSheetPropertyValueChangedListener(this);
    }

    public void applyI18n() {
        this.jLabelTemplateForNewDocs.setText(I18n.getString("gui.OptionsDialog.LabelTemplateForNewDocs", "Use this file as template for new documents"));
        this.jButtonTemplate.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jButtonOK.setText(I18n.getString("gui.OptionsDialog.ButtonSave", "Save"));
        this.jButtonApply.setText(I18n.getString("gui.OptionsDialog.ButtonApply", "Apply"));
        this.jButtonCancel.setText(I18n.getString("gui.OptionsDialog.ButtonCancel", "Cancel"));
        this.jTabbedPane1.setTitleAt(0, I18n.getString("gui.OptionsDialog.TabGeneral", "General"));
        this.jTabbedPane1.setTitleAt(1, I18n.getString("gui.OptionsDialog.TabCompiler", "Compiler"));
        ((TitledBorder)this.jPanelCompileDir.getBorder()).setTitle(I18n.getString("gui.OptionsDialog.DefaultCompileDir", "Default compilation directory"));
        this.jCheckBoxUseCurrentFilesDirectoryForCompiles.setText(I18n.getString("gui.OptionsDialog.UseCurrentFilesDirectoryForCompiles", "Use the reports directory for compiles"));
        this.jCheckBoxAutosave.setText(I18n.getString("gui.OptionsDialog.Autosave", "Autosave before compiling"));
        this.jButtonCompilationDir.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jTabbedPane1.setTitleAt(2, I18n.getString("gui.OptionsDialog.TabBackup", "Backup"));
        this.jTabbedPane1.setTitleAt(3, I18n.getString("gui.OptionsDialog.TabExternalPrograms", "External programs"));
        ((TitledBorder)this.jPanel6.getBorder()).setTitle(I18n.getString("gui.OptionsDialog.BackupFilesOnSave", "Backup files on save"));
        this.jRadioButton1_NoBackup.setText(I18n.getString("gui.OptionsDialog.NoBackup", "No backup"));
        this.jRadioButton2_ReplaceExtension.setText(I18n.getString("gui.OptionsDialog.ReplaceExtension", "Replace extension with .bak"));
        this.jRadioButton3_AppendExtension.setText(I18n.getString("gui.OptionsDialog.AppendExtension", "Append .bak to existing extension"));
        this.jLabelDefaultBackupDir.setText(I18n.getString("gui.OptionsDialog.LabelDefaultBackupDir", "Default backup directory"));
        this.jButtonBackupDirectory.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jButtonBrowseEditor.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jButtonBrowseEditor1.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jButtonBrowseEditor2.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jButtonBrowseEditor3.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jButtonBrowseEditor4.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jButtonBrowseEditor5.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jButtonBrowseEditor6.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        ((TitledBorder)this.jPanelExternalEditor.getBorder()).setTitle(I18n.getString("gui.OptionsDialog.ExternalEditor", "External editor"));
        ((TitledBorder)this.jPanelViewers.getBorder()).setTitle(I18n.getString("gui.OptionsDialog.Viewers", "Viewers"));
        this.jLabelPDFViewer.setText(I18n.getString("gui.OptionsDialog.PDFViewer", "PDF Viewer"));
        this.jLabelCSVViewer.setText(I18n.getString("gui.OptionsDialog.CSVViewer", "CSV Viewer"));
        this.jLabelHTMLViewer.setText(I18n.getString("gui.OptionsDialog.HTMLViewer", "HTML Viewer"));
        this.jLabelXLSViewer.setText(I18n.getString("gui.OptionsDialog.XLSViewer", "XLS Viewer"));
        this.jLabelTXTViewer.setText(I18n.getString("gui.OptionsDialog.TXTViewer", "TXT Viewer"));
        this.jLabelRTFViewer.setText(I18n.getString("gui.OptionsDialog.RTFViewer", "RTF Viewer"));
        this.jButtonVirtualizerDirBrowse.setText(I18n.getString("gui.OptionsDialog.Browse", "Browse"));
        this.jLabelReportVirtualizerDirectory.setText(I18n.getString("gui.OptionsDialog.ReportVirtualizerDir", "Directory where the paged out data is to be stored"));
        this.jLabelReportVirtualizerSize.setText(I18n.getString("gui.OptionsDialog.ReportVirtualizerSize", "Maximum size (in JRVirtualizable objects) of the paged in cache"));
        this.createSheet();
        this.loadConfiguration();
        this.setTitle("iReport - " + I18n.getString("gui.OptionsDialog.title", "Options"));
        this.getRootPane().updateUI();
    }

    public void loadConfiguration() {
        if (this.mf == null || this.mf.getProperties() == null) {
            return;
        }
        try {
            this.categorySheetPanel.setPropertyValue("Antialias", Misc.nvl(this.mf.getProperties().getProperty("Antialias"), "true"));
            this.categorySheetPanel.setPropertyValue("ShowToolTipsInDesign", Misc.nvl(this.mf.getProperties().getProperty("ShowToolTipsInDesign"), "false"));
            this.categorySheetPanel.setPropertyValue("RecentFilesLength", Misc.nvl(this.mf.getProperties().getProperty("RecentFilesLength"), "10"));
            this.categorySheetPanel.setPropertyValue("DefaultUnit", Misc.nvl(this.mf.getProperties().getProperty("DefaultUnit"), "cm"));
            this.categorySheetPanel.setPropertyValue("showGrid", Misc.nvl(this.mf.getProperties().getProperty("showGrid"), "false"));
            this.categorySheetPanel.setPropertyValue("ViewRules", Misc.nvl(this.mf.getProperties().getProperty("ViewRules"), "true"));
            this.categorySheetPanel.setPropertyValue("ViewBorderForTextElements", Misc.nvl(this.mf.getProperties().getProperty("ViewBorderForTextElements"), "true"));
            this.categorySheetPanel.setPropertyValue("AutoReload", Misc.nvl(this.mf.getProperties().getProperty("AutoReload"), "false"));
            this.categorySheetPanel.setPropertyValue("AskToSave", Misc.nvl(this.mf.getProperties().getProperty("AskToSave"), "true"));
            Color color = new Color(Integer.parseInt(Misc.nvl(this.mf.getProperties().getProperty("ViewBorderColor"), "1")));
            String color_str = "[" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "]";
            this.categorySheetPanel.setPropertyValue("ViewBorderColor", color_str);
            String size = Misc.nvl(this.mf.getProperties().getProperty("GridSize"), "10");
            if (size.equals("null") || size.trim().length() == 0) {
                size = "10";
            }
            this.categorySheetPanel.setPropertyValue("GridSize", size);
            this.categorySheetPanel.setPropertyValue("UseAutoRegiesterFields", Misc.nvl(this.mf.getProperties().getProperty("UseAutoRegiesterFields"), "true"));
            this.categorySheetPanel.setPropertyValue("EnableTextResizeClick", Misc.nvl(this.mf.getProperties().getProperty("EnableTextResizeClick"), "true"));
            this.categorySheetPanel.setPropertyValue("SynchronizeReportName", Misc.nvl(this.mf.getProperties().getProperty("SynchronizeReportName"), "true"));
            this.categorySheetPanel.setPropertyValue("DefaultScriptingLanguage", Misc.nvl(this.mf.getProperties().getProperty("DefaultScriptingLanguage"), "java"));
            this.categorySheetPanel.setPropertyValue("overrideDefaultFont", Misc.nvl(this.mf.getProperties().getProperty("overrideDefaultFont"), "true"));
            this.categorySheetPanel.setPropertyValue("overrideDefaultFontSize", Misc.nvl(this.mf.getProperties().getProperty("overrideDefaultFontSize", "11"), "11"));
            this.categorySheetPanel.setPropertyValue("overrideDefaultFontName", this.mf.getProperties().getProperty("overrideDefaultFontName", "Tahoma"));
            this.categorySheetPanel.setPropertyValue("overrideDefaultFontAttrs", "" + Misc.nvl(this.mf.getProperties().getProperty("overrideDefaultFontAttrs"), "0").equals("1"));
            this.jTextFieldTemplate.setText(Misc.nvl(this.mf.getProperties().getProperty("DefaultTemplate"), ""));
            this.jTextFieldCompilationDir.setText(this.mf.getDefaultCompilationDirectory());
            this.jCheckBoxUseCurrentFilesDirectoryForCompiles.setSelected(this.mf.isUsingCurrentFilesDirectoryForCompiles());
            this.jCheckBoxAutosave.setSelected(Misc.nvl(this.mf.getProperties().getProperty("SaveBeforeCompiling"), "true").equals("true"));
            this.jComboBox1.setSelectedIndex(Integer.parseInt(Misc.nvl(this.mf.getProperties().getProperty("DefaultCompiler"), "0")));
            this.jCheckBoxKeepJavaFile.setSelected(Misc.nvl(this.mf.getProperties().getProperty("KeepJavaFile"), "true").equals("true"));
            this.jTextFieldBackupDirectory.setText(Misc.nvl(this.mf.getProperties().getProperty("DefaultBackupDirectory"), ""));
            this.jRadioButton1_NoBackup.setSelected(Misc.nvl(this.mf.getProperties().getProperty("BackupPolicy"), "3").equals("1"));
            this.jRadioButton2_ReplaceExtension.setSelected(Misc.nvl(this.mf.getProperties().getProperty("BackupPolicy"), "3").equals("2"));
            this.jRadioButton3_AppendExtension.setSelected(Misc.nvl(this.mf.getProperties().getProperty("BackupPolicy"), "3").equals("3"));
            if (this.mf.isUsingCurrentFilesDirectoryForCompiles()) {
                this.disableCompileDirectoryBrowse();
            }
            this.jTextFieldEditor.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalEditor"), ""));
            this.jTextFieldPDFViewer.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalPDFViewer"), ""));
            this.jTextFieldHTMLViewer.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalHTMLViewer"), ""));
            this.jTextFieldXLSViewer.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalXLSViewer"), ""));
            this.jTextFieldCSVViewer.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalCSVViewer"), ""));
            this.jTextFieldTXTViewer.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalTXTViewer"), ""));
            this.jTextFieldRTFViewer.setText(Misc.nvl(this.mf.getProperties().getProperty("ExternalRTFViewer"), ""));
            this.jTextFieldVirtualizerDir.setText(this.mf.getProperties().getProperty("ReportVirtualizerDirectory", this.mf.getDefaultCompilationDirectory()));
            this.jSpinnerVirtualizerSize.setValue(new Integer(this.mf.getProperties().getProperty("ReportVirtualizerSize", "100")));
            Misc.setComboboxSelectedTagValue(this.jComboBoxVirtualizer, this.mf.getProperties().getProperty("ReportVirtualizer", "JRFileVirtualizer"));
            this.jSpinnerVirtualizerBlockSize.setValue(new Integer(this.mf.getProperties().getProperty("ReportVirtualizerBlockSize", "100")));
            this.jSpinnerVirtualizerGrownCount.setValue(new Integer(this.mf.getProperties().getProperty("ReportVirtualizerMinGrownCount", "100")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.disableApplyAndOk();
        this.pack();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelGeneral = new JPanel();
        this.jPanel8 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabelTemplateForNewDocs = new JLabel();
        this.jTextFieldTemplate = new JTextField();
        this.jButtonTemplate = new JButton();
        this.jPanelComper = new JPanel();
        this.jPanelCompileDir = new JPanel();
        this.jTextFieldCompilationDir = new JTextField();
        this.jButtonCompilationDir = new JButton();
        this.jCheckBoxAutosave = new JCheckBox();
        this.jCheckBoxUseCurrentFilesDirectoryForCompiles = new JCheckBox();
        this.jCheckBoxKeepJavaFile = new JCheckBox();
        this.jPanelCompileDir1 = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jPanelCompileDir2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxVirtualizer = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jLabelReportVirtualizerDirectory = new JLabel();
        this.jTextFieldVirtualizerDir = new JTextField();
        this.jButtonVirtualizerDirBrowse = new JButton();
        this.jLabelReportVirtualizerSize = new JLabel();
        this.jSpinnerVirtualizerSize = new JSpinner();
        this.jPanel7 = new JPanel();
        this.jLabelReportVirtualizerSize1 = new JLabel();
        this.jSpinnerVirtualizerBlockSize = new JSpinner();
        this.jLabelReportVirtualizerMinGrowCount = new JLabel();
        this.jSpinnerVirtualizerGrownCount = new JSpinner();
        this.jPanel3 = new JPanel();
        this.jPanelBackup = new JPanel();
        this.jPanel6 = new JPanel();
        this.jTextFieldBackupDirectory = new JTextField();
        this.jButtonBackupDirectory = new JButton();
        this.jRadioButton1_NoBackup = new JRadioButton();
        this.jRadioButton2_ReplaceExtension = new JRadioButton();
        this.jRadioButton3_AppendExtension = new JRadioButton();
        this.jLabelDefaultBackupDir = new JLabel();
        this.jPanelExternalPrograms = new JPanel();
        this.jPanelExternalEditor = new JPanel();
        this.jTextFieldEditor = new JTextField();
        this.jButtonBrowseEditor = new JButton();
        this.jPanelViewers = new JPanel();
        this.jTextFieldPDFViewer = new JTextField();
        this.jButtonBrowseEditor1 = new JButton();
        this.jTextFieldHTMLViewer = new JTextField();
        this.jButtonBrowseEditor2 = new JButton();
        this.jTextFieldXLSViewer = new JTextField();
        this.jButtonBrowseEditor3 = new JButton();
        this.jLabelPDFViewer = new JLabel();
        this.jLabelHTMLViewer = new JLabel();
        this.jLabelXLSViewer = new JLabel();
        this.jLabelCSVViewer = new JLabel();
        this.jTextFieldCSVViewer = new JTextField();
        this.jButtonBrowseEditor4 = new JButton();
        this.jLabelTXTViewer = new JLabel();
        this.jTextFieldTXTViewer = new JTextField();
        this.jButtonBrowseEditor5 = new JButton();
        this.jLabelRTFViewer = new JLabel();
        this.jTextFieldRTFViewer = new JTextField();
        this.jButtonBrowseEditor6 = new JButton();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonApply = new JButton();
        this.jButtonCancel = new JButton();
        this.setTitle("iReport Options");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                OptionsDialog.this.closeDialog(evt);
            }
        });
        this.jTabbedPane1.setMinimumSize(new Dimension(332, 430));
        this.jTabbedPane1.setPreferredSize(new Dimension(505, 430));
        this.jPanelGeneral.setLayout(new BorderLayout());
        this.jPanel8.setLayout(new BorderLayout());
        this.jPanel8.setMinimumSize(new Dimension(250, 325));
        this.jPanel8.setPreferredSize(new Dimension(500, 330));
        this.jPanelGeneral.add((Component)this.jPanel8, "Center");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabelTemplateForNewDocs.setHorizontalAlignment(2);
        this.jLabelTemplateForNewDocs.setText("Use this file as template for new documents");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.jPanel2.add((Component)this.jLabelTemplateForNewDocs, gridBagConstraints);
        this.jTextFieldTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jTextFieldTemplateActionPerformed(evt);
            }
        });
        this.jTextFieldTemplate.addInputMethodListener(new InputMethodListener(){

            public void caretPositionChanged(InputMethodEvent evt) {
            }

            public void inputMethodTextChanged(InputMethodEvent evt) {
                OptionsDialog.this.jTextFieldTemplateInputMethodTextChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.insets = new Insets(0, 7, 3, 0);
        this.jPanel2.add((Component)this.jTextFieldTemplate, gridBagConstraints);
        this.jButtonTemplate.setText("Browse");
        this.jButtonTemplate.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonTemplateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 6);
        this.jPanel2.add((Component)this.jButtonTemplate, gridBagConstraints);
        this.jPanelGeneral.add((Component)this.jPanel2, "South");
        this.jTabbedPane1.addTab("General", this.jPanelGeneral);
        this.jPanelComper.setLayout(new GridBagLayout());
        this.jPanelCompileDir.setLayout(new GridBagLayout());
        this.jPanelCompileDir.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Default compilation directory"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelCompileDir.add((Component)this.jTextFieldCompilationDir, gridBagConstraints);
        this.jButtonCompilationDir.setText("Browse");
        this.jButtonCompilationDir.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonCompilationDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonCompilationDirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelCompileDir.add((Component)this.jButtonCompilationDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelComper.add((Component)this.jPanelCompileDir, gridBagConstraints);
        this.jCheckBoxAutosave.setText("Autosave before compiling");
        this.jCheckBoxAutosave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jCheckBoxAutosaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanelComper.add((Component)this.jCheckBoxAutosave, gridBagConstraints);
        this.jCheckBoxUseCurrentFilesDirectoryForCompiles.setText("Use the reports directory for compiles");
        this.jCheckBoxUseCurrentFilesDirectoryForCompiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanelComper.add((Component)this.jCheckBoxUseCurrentFilesDirectoryForCompiles, gridBagConstraints);
        this.jCheckBoxKeepJavaFile.setSelected(true);
        this.jCheckBoxKeepJavaFile.setText("keep .java file (if available)");
        this.jCheckBoxKeepJavaFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jCheckBoxKeepJavaFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanelComper.add((Component)this.jCheckBoxKeepJavaFile, gridBagConstraints);
        this.jPanelCompileDir1.setLayout(new GridBagLayout());
        this.jPanelCompileDir1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Compiler"));
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"JasperReports default", "Java Compiler (need tools.jar)", "JDT Compiler  (need jdt-compiler.jar)", "Bean shell compiler (need bsh-1.3.0.jar)", "Jikes compiler (need jikes command)"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jComboBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelCompileDir1.add((Component)this.jComboBox1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelComper.add((Component)this.jPanelCompileDir1, gridBagConstraints);
        this.jPanelCompileDir2.setLayout(new GridBagLayout());
        this.jPanelCompileDir2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Report Virtualizer"));
        this.jLabel1.setText("Use this virtualizer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelCompileDir2.add((Component)this.jLabel1, gridBagConstraints);
        this.jComboBoxVirtualizer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jComboBoxVirtualizerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 8, 3);
        this.jPanelCompileDir2.add((Component)this.jComboBoxVirtualizer, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabelReportVirtualizerDirectory.setText("Directory where the paged out data is to be stored");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel4.add((Component)this.jLabelReportVirtualizerDirectory, gridBagConstraints);
        this.jTextFieldVirtualizerDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jTextFieldVirtualizerDirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel4.add((Component)this.jTextFieldVirtualizerDir, gridBagConstraints);
        this.jButtonVirtualizerDirBrowse.setText("Browse");
        this.jButtonVirtualizerDirBrowse.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonVirtualizerDirBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonVirtualizerDirBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel4.add((Component)this.jButtonVirtualizerDirBrowse, gridBagConstraints);
        this.jLabelReportVirtualizerSize.setText("Maximum size (in JRVirtualizable objects) of the paged in cache");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 0, 4);
        this.jPanel4.add((Component)this.jLabelReportVirtualizerSize, gridBagConstraints);
        this.jSpinnerVirtualizerSize.setMinimumSize(new Dimension(127, 20));
        this.jSpinnerVirtualizerSize.setPreferredSize(new Dimension(127, 20));
        this.jSpinnerVirtualizerSize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                OptionsDialog.this.jSpinnerVirtualizerSizeStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel4.add((Component)this.jSpinnerVirtualizerSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelCompileDir2.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel7.setLayout(new GridBagLayout());
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Swap file"));
        this.jLabelReportVirtualizerSize1.setText("Block size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel7.add((Component)this.jLabelReportVirtualizerSize1, gridBagConstraints);
        this.jSpinnerVirtualizerBlockSize.setMinimumSize(new Dimension(127, 20));
        this.jSpinnerVirtualizerBlockSize.setPreferredSize(new Dimension(127, 20));
        this.jSpinnerVirtualizerBlockSize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                OptionsDialog.this.jSpinnerVirtualizerSizeStateChanged2(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel7.add((Component)this.jSpinnerVirtualizerBlockSize, gridBagConstraints);
        this.jLabelReportVirtualizerMinGrowCount.setText("Min. grow count");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel7.add((Component)this.jLabelReportVirtualizerMinGrowCount, gridBagConstraints);
        this.jSpinnerVirtualizerGrownCount.setMinimumSize(new Dimension(127, 20));
        this.jSpinnerVirtualizerGrownCount.setPreferredSize(new Dimension(127, 20));
        this.jSpinnerVirtualizerGrownCount.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                OptionsDialog.this.jSpinnerVirtualizerSize1jSpinnerVirtualizerSizeStateChanged2(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel7.add((Component)this.jSpinnerVirtualizerGrownCount, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelCompileDir2.add((Component)this.jPanel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelComper.add((Component)this.jPanelCompileDir2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 99;
        gridBagConstraints.weighty = 1.0;
        this.jPanelComper.add((Component)this.jPanel3, gridBagConstraints);
        this.jTabbedPane1.addTab("Compiler", this.jPanelComper);
        this.jPanelBackup.setLayout(new GridBagLayout());
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Backup files on save"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel6.add((Component)this.jTextFieldBackupDirectory, gridBagConstraints);
        this.jButtonBackupDirectory.setText("Browse");
        this.jButtonBackupDirectory.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBackupDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBackupDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel6.add((Component)this.jButtonBackupDirectory, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButton1_NoBackup);
        this.jRadioButton1_NoBackup.setText("No backup");
        this.jRadioButton1_NoBackup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jRadioButton1_NoBackupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel6.add((Component)this.jRadioButton1_NoBackup, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButton2_ReplaceExtension);
        this.jRadioButton2_ReplaceExtension.setText("Replace extension with .bak");
        this.jRadioButton2_ReplaceExtension.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jRadioButton2_ReplaceExtensionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel6.add((Component)this.jRadioButton2_ReplaceExtension, gridBagConstraints);
        this.buttonGroup1.add(this.jRadioButton3_AppendExtension);
        this.jRadioButton3_AppendExtension.setSelected(true);
        this.jRadioButton3_AppendExtension.setText("Append .bak to existing extension");
        this.jRadioButton3_AppendExtension.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jRadioButton3_AppendExtensionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanel6.add((Component)this.jRadioButton3_AppendExtension, gridBagConstraints);
        this.jLabelDefaultBackupDir.setText("Default backup directory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel6.add((Component)this.jLabelDefaultBackupDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelBackup.add((Component)this.jPanel6, gridBagConstraints);
        this.jTabbedPane1.addTab("Backup", this.jPanelBackup);
        this.jPanelExternalPrograms.setLayout(new GridBagLayout());
        this.jPanelExternalEditor.setLayout(new GridBagLayout());
        this.jPanelExternalEditor.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "External editor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelExternalEditor.add((Component)this.jTextFieldEditor, gridBagConstraints);
        this.jButtonBrowseEditor.setText("Browse");
        this.jButtonBrowseEditor.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelExternalEditor.add((Component)this.jButtonBrowseEditor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelExternalPrograms.add((Component)this.jPanelExternalEditor, gridBagConstraints);
        this.jPanelViewers.setLayout(new GridBagLayout());
        this.jPanelViewers.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Viewers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1000.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jTextFieldPDFViewer, gridBagConstraints);
        this.jButtonBrowseEditor1.setText("Browse");
        this.jButtonBrowseEditor1.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditor1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jButtonBrowseEditor1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jTextFieldHTMLViewer, gridBagConstraints);
        this.jButtonBrowseEditor2.setText("Browse");
        this.jButtonBrowseEditor2.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditor2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jButtonBrowseEditor2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jTextFieldXLSViewer, gridBagConstraints);
        this.jButtonBrowseEditor3.setText("Browse");
        this.jButtonBrowseEditor3.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditor3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jButtonBrowseEditor3, gridBagConstraints);
        this.jLabelPDFViewer.setText("PDF viewer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jLabelPDFViewer, gridBagConstraints);
        this.jLabelHTMLViewer.setText("HTML viewer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jLabelHTMLViewer, gridBagConstraints);
        this.jLabelXLSViewer.setText("XLS viewer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jLabelXLSViewer, gridBagConstraints);
        this.jLabelCSVViewer.setText("CSV viewer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jLabelCSVViewer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jTextFieldCSVViewer, gridBagConstraints);
        this.jButtonBrowseEditor4.setText("Browse");
        this.jButtonBrowseEditor4.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditor4ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jButtonBrowseEditor4, gridBagConstraints);
        this.jLabelTXTViewer.setText("Text viewer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jLabelTXTViewer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jTextFieldTXTViewer, gridBagConstraints);
        this.jButtonBrowseEditor5.setText("Browse");
        this.jButtonBrowseEditor5.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditor5ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jButtonBrowseEditor5, gridBagConstraints);
        this.jLabelRTFViewer.setText("CSV viewer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jLabelRTFViewer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jTextFieldRTFViewer, gridBagConstraints);
        this.jButtonBrowseEditor6.setText("Browse");
        this.jButtonBrowseEditor6.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonBrowseEditor6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonBrowseEditor6ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanelViewers.add((Component)this.jButtonBrowseEditor6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 6, 3);
        this.jPanelExternalPrograms.add((Component)this.jPanelViewers, gridBagConstraints);
        this.jTabbedPane1.addTab("External programs", this.jPanelExternalPrograms);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jPanel1.setMinimumSize(new Dimension(10, 30));
        this.jButtonOK.setMnemonic('s');
        this.jButtonOK.setText("Save");
        this.jButtonOK.setEnabled(false);
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonApply.setMnemonic('a');
        this.jButtonApply.setText("Apply");
        this.jButtonApply.setEnabled(false);
        this.jButtonApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonApplyActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonApply);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jComboBoxVirtualizerActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jSpinnerVirtualizerSize1jSpinnerVirtualizerSizeStateChanged2(ChangeEvent evt) {
        this.enableApplyAndOk();
    }

    private void jSpinnerVirtualizerSizeStateChanged2(ChangeEvent evt) {
        this.enableApplyAndOk();
    }

    private void jButtonBrowseEditor6ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose a RTF viewer...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldRTFViewer.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBrowseEditor5ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose an Text viewer...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldTXTViewer.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jTextFieldVirtualizerDirActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jSpinnerVirtualizerSizeStateChanged(ChangeEvent evt) {
        this.enableApplyAndOk();
    }

    private void jButtonVirtualizerDirBrowseActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(1);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldVirtualizerDir.setText(jfc.getSelectedFile().getPath());
        }
        this.enableApplyAndOk();
    }

    private void jCheckBoxKeepJavaFileActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxUseCurrentFilesDirectoryForCompiles.isSelected()) {
            this.disableCompileDirectoryBrowse();
        } else {
            this.enableCompileDirectoryBrowse();
        }
        this.enableApplyAndOk();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jButtonApply.isEnabled()) {
            this.jButtonApplyActionPerformed(evt);
        }
        if (this.mf != null) {
            this.mf.saveiReportConfiguration();
        }
        this.jButtonOK.setEnabled(false);
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        this.applyConfiguration();
        this.jButtonApply.setEnabled(false);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonBrowseEditor4ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose a CSV viewer...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldCSVViewer.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBrowseEditor3ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose a XLS viewer...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldXLSViewer.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBrowseEditor2ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose a HTML viewer...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldHTMLViewer.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBrowseEditor1ActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose a PDF viewer...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldPDFViewer.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBrowseEditorActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setDialogTitle("Choose an editor...");
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldEditor.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonBackupDirectoryActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(1);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldBackupDirectory.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonCompilationDirActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(1);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldCompilationDir.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jButtonTemplateActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.endsWith(".xml") || file.isDirectory();
            }

            public String getDescription() {
                return "JasperReports XML *.xml";
            }
        });
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldTemplate.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jRadioButton3_AppendExtensionActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jRadioButton2_ReplaceExtensionActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jRadioButton1_NoBackupActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jCheckBoxAutosaveActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void jTextFieldTemplateInputMethodTextChanged(InputMethodEvent evt) {
        this.enableApplyAndOk();
    }

    private void jTextFieldTemplateActionPerformed(ActionEvent evt) {
        this.enableApplyAndOk();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new OptionsDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public void applyConfiguration() {
        if (this.mf == null || this.mf.getProperties() == null) {
            return;
        }
        Properties prop = this.mf.getProperties();
        try {
            prop.put("RecentFilesLength", "" + this.categorySheetPanel.getPropertyValue("RecentFilesLength"));
            prop.put("DefaultUnit", "" + this.categorySheetPanel.getPropertyValue("DefaultUnit"));
            prop.put("GridSize", "" + this.categorySheetPanel.getPropertyValue("GridSize"));
            prop.put("ViewRules", "" + this.categorySheetPanel.getPropertyValue("ViewRules"));
            prop.put("showGrid", "" + this.categorySheetPanel.getPropertyValue("showGrid"));
            prop.put("Antialias", "" + this.categorySheetPanel.getPropertyValue("Antialias"));
            prop.put("AutoReload", "" + this.categorySheetPanel.getPropertyValue("AutoReload"));
            prop.put("AskToSave", "" + this.categorySheetPanel.getPropertyValue("AskToSave"));
            prop.put("ShowToolTipsInDesign", "" + this.categorySheetPanel.getPropertyValue("ShowToolTipsInDesign"));
            this.mf.updateAntialiasMode();
            prop.put("ViewBorderForTextElements", "" + this.categorySheetPanel.getPropertyValue("ViewBorderForTextElements"));
            Color color = null;
            color = ColorSelectorPanel.parseColorString("" + this.categorySheetPanel.getPropertyValue("ViewBorderColor"));
            prop.put("ViewBorderColor", "" + (color != null ? color.getRGB() : Color.GRAY.getRGB()));
            String currentLAF = prop.getProperty("LookAndFeel", "");
            prop.put("LookAndFeel", "" + this.categorySheetPanel.getPropertyValue("LookAndFeel"));
            prop.put("UseAutoRegiesterFields", "" + this.categorySheetPanel.getPropertyValue("UseAutoRegiesterFields"));
            prop.put("EnableTextResizeClick", "" + this.categorySheetPanel.getPropertyValue("EnableTextResizeClick"));
            prop.put("SynchronizeReportName", "" + this.categorySheetPanel.getPropertyValue("SynchronizeReportName"));
            prop.put("DefaultScriptingLanguage", "" + this.categorySheetPanel.getPropertyValue("DefaultScriptingLanguage"));
            String currentOverrideDefaultFont = prop.getProperty("overrideDefaultFont", "");
            String currentOverrideDefaultFontSize = prop.getProperty("overrideDefaultFontSize", "");
            prop.put("overrideDefaultFont", "" + this.categorySheetPanel.getPropertyValue("overrideDefaultFont"));
            try {
                Integer.parseInt("" + this.categorySheetPanel.getPropertyValue("overrideDefaultFontSize"));
                prop.put("overrideDefaultFontSize", "" + this.categorySheetPanel.getPropertyValue("overrideDefaultFontSize"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String currentOverrideDefaultFontName = prop.getProperty("overrideDefaultFontName", "");
            String currentOverrideDefaultFontAttrs = prop.getProperty("overrideDefaultFontAttrs", "");
            prop.put("overrideDefaultFontName", "" + this.categorySheetPanel.getPropertyValue("overrideDefaultFontName"));
            prop.put("overrideDefaultFontAttrs", "" + this.categorySheetPanel.getPropertyValue("overrideDefaultFontAttrs"));
            String lang_str = (String)this.categorySheetPanel.getPropertyValue("Language");
            Locale selectedLang = null;
            for (int i = 0; i < this.listOfLanguages.size(); ++i) {
                Locale lang = (Locale)this.listOfLanguages.get(i);
                LocaleAdapter adapter = new LocaleAdapter(lang);
                if (!lang_str.equals("" + adapter)) continue;
                selectedLang = adapter.getLocale();
                prop.put("Language", selectedLang.getLanguage());
                prop.put("Country", selectedLang.getCountry());
                prop.put("Variant", selectedLang.getVariant());
                break;
            }
            prop.put("DefaultBackupDirectory", "" + this.jTextFieldBackupDirectory.getText());
            prop.put("ExternalCSVViewer", "" + this.jTextFieldCSVViewer.getText());
            prop.put("ExternalPDFViewer", "" + this.jTextFieldPDFViewer.getText());
            prop.put("ExternalXLSViewer", "" + this.jTextFieldXLSViewer.getText());
            prop.put("ExternalHTMLViewer", "" + this.jTextFieldHTMLViewer.getText());
            prop.put("ExternalTXTViewer", "" + this.jTextFieldTXTViewer.getText());
            prop.put("ExternalRTFViewer", "" + this.jTextFieldRTFViewer.getText());
            prop.put("ExternalEditor", "" + this.jTextFieldEditor.getText());
            prop.put("DefaultTemplate", "" + this.jTextFieldTemplate.getText());
            prop.put("SaveBeforeCompiling", "" + this.jCheckBoxAutosave.isSelected());
            this.mf.setUsingMultiLineExpressions(false);
            this.mf.setUsingCurrentFilesDirectoryForCompiles(this.jCheckBoxUseCurrentFilesDirectoryForCompiles.isSelected());
            prop.put("useCurrentFilesDirectoryForCompiles", this.jCheckBoxUseCurrentFilesDirectoryForCompiles.isSelected() + "");
            this.mf.setDefaultCompilationDirectory(this.jTextFieldCompilationDir.getText());
            prop.put("DefaultCompilationDirectory", this.jTextFieldCompilationDir.getText());
            String policy = "3";
            if (this.jRadioButton1_NoBackup.isSelected()) {
                policy = "1";
            }
            if (this.jRadioButton2_ReplaceExtension.isSelected()) {
                policy = "2";
            }
            if (this.jRadioButton3_AppendExtension.isSelected()) {
                policy = "3";
            }
            prop.put("BackupPolicy", policy);
            prop.put("DefaultCompiler", "" + this.jComboBox1.getSelectedIndex());
            prop.put("KeepJavaFile", this.jCheckBoxKeepJavaFile.isSelected() + "");
            prop.put("ReportVirtualizer", "" + ((Tag)this.jComboBoxVirtualizer.getSelectedItem()).getValue());
            prop.put("ReportVirtualizerDirectory", "" + this.jTextFieldVirtualizerDir.getText().trim());
            prop.put("ReportVirtualizerSize", "" + this.jSpinnerVirtualizerSize.getValue());
            prop.put("ReportVirtualizerBlockSize", "" + this.jSpinnerVirtualizerBlockSize.getValue());
            prop.put("ReportVirtualizerMinGrownCount", "" + this.jSpinnerVirtualizerGrownCount.getValue());
            if (!(currentLAF.equals(prop.getProperty("LookAndFeel", "")) && currentOverrideDefaultFontName.equals(prop.getProperty("overrideDefaultFontName", "")) && currentOverrideDefaultFontAttrs.equals(prop.getProperty("overrideDefaultFontAttrs", "")) && currentOverrideDefaultFont.equals(prop.getProperty("overrideDefaultFont", "")) && currentOverrideDefaultFontSize.equals(prop.getProperty("overrideDefaultFontSize", "")))) {
                Misc.setPLAF(prop.getProperty("LookAndFeel", ""));
                SwingUtilities.updateComponentTreeUI(this);
                MainFrame.getMainInstance().upadateLAF();
            }
            if (selectedLang != null) {
                I18n.setCurrentLocale(selectedLang);
            }
            JInternalFrame[] frames = this.mf.getJMDIDesktopPane().getAllFrames();
            for (int i = 0; i < frames.length; ++i) {
                JInternalFrame f = frames[i];
                if (!(f instanceof JReportFrame)) continue;
                JReportFrame jrf = (JReportFrame)f;
                jrf.repaint();
                jrf.repaintRules();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.jButtonApply.setEnabled(false);
    }

    protected void enableCompileDirectoryBrowse() {
        this.jTextFieldCompilationDir.setEnabled(true);
        this.jButtonCompilationDir.setEnabled(true);
    }

    protected void disableCompileDirectoryBrowse() {
        this.jTextFieldCompilationDir.setEnabled(false);
        this.jButtonCompilationDir.setEnabled(false);
    }

    protected void disableApplyAndOk() {
        this.jButtonApply.setEnabled(false);
        this.jButtonOK.setEnabled(false);
    }

    protected void disableApply() {
        this.jButtonOK.setEnabled(false);
    }

    protected void enableApplyAndOk() {
        this.jButtonApply.setEnabled(true);
        this.jButtonOK.setEnabled(true);
    }

    protected void enableApply() {
        this.jButtonOK.setEnabled(true);
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void sheetPropertyValueChanged(SheetPropertyValueChangedEvent evt) {
        this.enableApplyAndOk();
    }
}

