package it.businesslogic.ireport.examples;

import net.sf.jasperreports.engine.*;
import net.sf.jasperreports.engine.data.*;
import it.businesslogic.ireport.examples.beans.*;
import java.util.*;

public class PersonBeansDataSource extends JRAbstractBeanDataSourceProvider {
  
  	public PersonBeansDataSource() {
  		super(PersonBean.class);
                
        }
        
        public JRField[] getFields(JasperReport report) throws JRException
        {
            
            System.out.println(report);
            JRParameter[] params = report.getParameters();
            for (int i=0; i<params.length; ++i)
            {
                System.out.println(params[i].getName()+" "+params[i].getDefaultValueExpression());
            }
            
            String[] properties = report.getPropertyNames();
            for (int i=0; i<properties.length; ++i)
            {
                System.out.println(properties[i] + " = " + report.getProperty(properties[i]));
            }
            return super.getFields(report);
        }
  
        
        
  	public JRDataSource create(JasperReport report) throws JRException {
  		
  		ArrayList list = new ArrayList();
  		list.add(new PersonBean("Aldo"));
  		list.add(new PersonBean("Giovanni"));
  		list.add(new PersonBean("Giacomo"));
                
               return new JRBeanCollectionDataSource(list);
  	
  	}
 	
  	public void dispose(JRDataSource dataSource) throws JRException {
 		// nothing to do
  	}
  }