/*
 * IRFont.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 22 maggio 2003, 23.45
 */

package it.businesslogic.ireport;

/**
 *
 * @author  Administrator
 */
public class IRFont {
    
    private java.awt.Font font;
    
    private java.lang.String file;
    
    /** Creates a new instance of IRFont */
    public IRFont() {
    }
    
     public IRFont(java.awt.Font font, java.lang.String file) {
         this.font = font;
         this.file = file;
    }
    
    /** Getter for property file.
     * @return Value of property file.
     *
     */
    public java.lang.String getFile() {
        return file;
    }
    
    /** Setter for property file.
     * @param file New value of property file.
     *
     */
    public void setFile(java.lang.String file) {
        this.file = file;
    }
    
    /** Getter for property font.
     * @return Value of property font.
     *
     */
    public java.awt.Font getFont() {
        return font;
    }
    
    /** Setter for property font.
     * @param font New value of property font.
     *
     */
    public void setFont(java.awt.Font font) {
        this.font = font;
    }
    
    
    public String toString()
    {
        if (font == null || file == null) return "Not initialized font";
        return font.getFontName()+" ("+file+")";
    }    
}
