/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.w3c.tools.codec.Base64Encoder;

public class JRXmlExporter
extends JRAbstractExporter {
    protected JRXmlWriteHelper xmlWriter = null;
    protected String encoding = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected Map rendererToImagePathMap = null;
    protected Map imageNameToImageDataMap = null;
    protected Map fontsMap = new HashMap();
    protected Map stylesMap = new HashMap();
    protected String dtdLocation = null;
    protected boolean isEmbeddingImages = true;
    protected File destFile = null;
    protected File imagesDir = null;
    protected static final int colorMask = Integer.parseInt("FFFFFF", 16);
    private static int imageId = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block16: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                StringBuffer sb;
                this.setExportContext();
                this.setInput();
                this.setPageRange();
                this.dtdLocation = (String)this.parameters.get(JRXmlExporterParameter.DTD_LOCATION);
                if (this.dtdLocation == null) {
                    this.dtdLocation = "http://jasperreports.sourceforge.net/dtds/jasperprint.dtd";
                }
                this.encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING);
                if (this.encoding == null) {
                    this.encoding = "UTF-8";
                }
                if ((sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
                    StringBuffer buffer = this.exportReportToBuffer();
                    sb.append(buffer.toString());
                    break block16;
                }
                Writer outWriter = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (outWriter != null) {
                    try {
                        this.exportReportToStream(outWriter);
                        break block16;
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e);
                    }
                }
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.exportReportToStream(new OutputStreamWriter(os, this.encoding));
                        break block16;
                    }
                    catch (Exception e) {
                        throw new JRException("Error writing to OutputStream : " + this.jasperPrint.getName(), e);
                    }
                }
                this.destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (this.destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        this.destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                this.imagesDir = new File(this.destFile.getParent(), this.destFile.getName() + "_files");
                Boolean isEmbeddingImagesParameter = (Boolean)this.parameters.get(JRXmlExporterParameter.IS_EMBEDDING_IMAGES);
                if (isEmbeddingImagesParameter == null) {
                    isEmbeddingImagesParameter = Boolean.TRUE;
                }
                this.isEmbeddingImages = isEmbeddingImagesParameter;
                this.exportReportToFile();
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void exportReportToFile() throws JRException {
        block16: {
            this.rendererToImagePathMap = new HashMap();
            this.imageNameToImageDataMap = new HashMap();
            Writer writer = null;
            try {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.destFile);
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, this.encoding));
                    this.exportReportToStream(writer);
                }
                catch (IOException e) {
                    throw new JRException("Error writing to file : " + this.destFile, e);
                }
                Object var4_4 = null;
                if (writer == null) break block16;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            writer.close();
        }
        if (this.isEmbeddingImages) return;
        Set imageNames = this.imageNameToImageDataMap.keySet();
        if (imageNames == null) return;
        if (imageNames.size() <= 0) return;
        if (!this.imagesDir.exists()) {
            this.imagesDir.mkdir();
        }
        Iterator it = imageNames.iterator();
        while (it.hasNext()) {
            IOException e3;
            Object var10_12;
            String imageName = (String)it.next();
            byte[] imageData = (byte[])this.imageNameToImageDataMap.get(imageName);
            File imageFile = new File(this.imagesDir, imageName);
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(imageFile);
                    ((OutputStream)fos).write(imageData, 0, imageData.length);
                }
                catch (IOException e2) {
                    throw new JRException("Error writing to image file : " + imageFile, e2);
                }
                var10_12 = null;
                if (fos == null) continue;
                {
                }
            }
            catch (Throwable throwable) {
                var10_12 = null;
                if (fos == null) throw throwable;
                try {
                    ((OutputStream)fos).close();
                    throw throwable;
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e3) {}
            ((OutputStream)fos).close();
        }
    }

    protected StringBuffer exportReportToBuffer() throws JRException {
        StringWriter buffer = new StringWriter();
        try {
            this.exportReportToStream(buffer);
        }
        catch (IOException e) {
            throw new JRException("Error while exporting report to buffer", e);
        }
        return buffer.getBuffer();
    }

    protected void exportReportToStream(Writer writer) throws JRException, IOException {
        List pages;
        JRStyle[] styles;
        this.xmlWriter = new JRXmlWriteHelper(writer);
        this.xmlWriter.writeProlog(this.encoding);
        this.xmlWriter.writePublicDoctype("jasperPrint", "-//JasperReports//DTD Report Design//EN", this.dtdLocation);
        this.xmlWriter.startElement("jasperPrint");
        this.xmlWriter.addAttribute("name", this.jasperPrint.getName());
        this.xmlWriter.addAttribute("pageWidth", this.jasperPrint.getPageWidth());
        this.xmlWriter.addAttribute("pageHeight", this.jasperPrint.getPageHeight());
        this.xmlWriter.addAttribute("orientation", this.jasperPrint.getOrientation(), JRXmlConstants.getOrientationMap(), (byte)1);
        JRReportFont[] fonts = this.jasperPrint.getFonts();
        if (fonts != null && fonts.length > 0) {
            for (int i = 0; i < fonts.length; ++i) {
                this.fontsMap.put(fonts[i].getName(), fonts[i]);
                this.exportReportFont(fonts[i]);
            }
        }
        if ((styles = this.jasperPrint.getStyles()) != null && styles.length > 0) {
            for (int i = 0; i < styles.length; ++i) {
                this.stylesMap.put(styles[i].getName(), styles[i]);
                this.exportStyle(styles[i]);
            }
        }
        if ((pages = this.jasperPrint.getPages()) != null && pages.size() > 0) {
            JRPrintPage page = null;
            for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                page = (JRPrintPage)pages.get(i);
                this.exportPage(page);
            }
        }
        this.xmlWriter.closeElement();
        writer.flush();
    }

    protected void exportReportFont(JRReportFont font) throws IOException {
        this.xmlWriter.startElement("reportFont");
        this.xmlWriter.addAttribute("name", font.getName());
        this.xmlWriter.addAttribute("isDefault", font.isDefault());
        this.xmlWriter.addAttribute("fontName", font.getFontName());
        this.xmlWriter.addAttribute("size", font.getFontSize());
        this.xmlWriter.addAttribute("isBold", font.isBold());
        this.xmlWriter.addAttribute("isItalic", font.isItalic());
        this.xmlWriter.addAttribute("isUnderline", font.isUnderline());
        this.xmlWriter.addAttribute("isStrikeThrough", font.isStrikeThrough());
        this.xmlWriter.addAttribute("pdfFontName", font.getPdfFontName());
        this.xmlWriter.addAttribute("pdfEncoding", font.getPdfEncoding());
        this.xmlWriter.addAttribute("isPdfEmbedded", font.isPdfEmbedded());
        this.xmlWriter.closeElement();
    }

    protected void exportStyle(JRStyle style) throws IOException {
        this.xmlWriter.startElement("style");
        this.xmlWriter.addAttribute("name", style.getName());
        this.xmlWriter.addAttribute("isDefault", style.isDefault());
        if (style.getStyle() != null) {
            JRStyle baseStyle = (JRStyle)this.stylesMap.get(style.getStyle().getName());
            if (baseStyle != null) {
                this.xmlWriter.addAttribute("style", style.getStyle().getName());
            } else {
                throw new JRRuntimeException("Referenced report style not found : " + style.getStyle().getName());
            }
        }
        this.xmlWriter.addAttribute("mode", style.getOwnMode(), JRXmlConstants.getModeMap());
        this.xmlWriter.addAttribute("forecolor", style.getOwnForecolor());
        this.xmlWriter.addAttribute("backcolor", style.getOwnBackcolor());
        this.xmlWriter.addAttribute("pen", style.getOwnPen(), JRXmlConstants.getPenMap());
        this.xmlWriter.addAttribute("fill", style.getOwnFill(), JRXmlConstants.getFillMap());
        this.xmlWriter.addAttribute("radius", style.getOwnRadius());
        this.xmlWriter.addAttribute("scaleImage", style.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.xmlWriter.addAttribute("hAlign", style.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.xmlWriter.addAttribute("vAlign", style.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.xmlWriter.addAttribute("rotation", style.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.xmlWriter.addAttribute("lineSpacing", style.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.xmlWriter.addAttribute("isStyledText", style.isOwnStyledText());
        this.xmlWriter.addAttribute("border", style.getOwnBorder(), JRXmlConstants.getPenMap());
        this.xmlWriter.addAttribute("borderColor", style.getOwnBorderColor());
        this.xmlWriter.addAttribute("padding", style.getOwnPadding());
        this.xmlWriter.addAttribute("topBorder", style.getOwnTopBorder(), JRXmlConstants.getPenMap());
        this.xmlWriter.addAttribute("topBorderColor", style.getOwnTopBorderColor());
        this.xmlWriter.addAttribute("topPadding", style.getOwnTopPadding());
        this.xmlWriter.addAttribute("leftBorder", style.getOwnLeftBorder(), JRXmlConstants.getPenMap());
        this.xmlWriter.addAttribute("leftBorderColor", style.getOwnLeftBorderColor());
        this.xmlWriter.addAttribute("leftPadding", style.getOwnLeftPadding());
        this.xmlWriter.addAttribute("bottomBorder", style.getOwnBottomBorder(), JRXmlConstants.getPenMap());
        this.xmlWriter.addAttribute("bottomBorderColor", style.getOwnBottomBorderColor());
        this.xmlWriter.addAttribute("bottomPadding", style.getOwnBottomPadding());
        this.xmlWriter.addAttribute("rightBorder", style.getOwnRightBorder(), JRXmlConstants.getPenMap());
        this.xmlWriter.addAttribute("rightBorderColor", style.getOwnRightBorderColor());
        this.xmlWriter.addAttribute("rightPadding", style.getOwnRightPadding());
        this.xmlWriter.addAttribute("fontName", style.getOwnFontName());
        this.xmlWriter.addAttribute("fontSize", style.getOwnFontSize());
        this.xmlWriter.addAttribute("isBold", style.isOwnBold());
        this.xmlWriter.addAttribute("isItalic", style.isOwnItalic());
        this.xmlWriter.addAttribute("isUnderline", style.isOwnUnderline());
        this.xmlWriter.addAttribute("isStrikeThrough", style.isOwnStrikeThrough());
        this.xmlWriter.addAttribute("pdfFontName", style.getOwnPdfFontName());
        this.xmlWriter.addAttribute("pdfEncoding", style.getOwnPdfEncoding());
        this.xmlWriter.addAttribute("isPdfEmbedded", style.isOwnPdfEmbedded());
        this.xmlWriter.closeElement();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        this.xmlWriter.startElement("page");
        List elements = page.getElements();
        this.exportElements(elements);
        this.xmlWriter.closeElement();
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection elements) throws IOException, JRException {
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                JRPrintElement element = (JRPrintElement)it.next();
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (element instanceof JRPrintText) {
                    this.exportText((JRPrintText)element);
                    continue;
                }
                if (!(element instanceof JRPrintFrame)) continue;
                this.exportFrame((JRPrintFrame)element);
            }
        }
    }

    protected void exportLine(JRPrintLine line) throws IOException {
        this.xmlWriter.startElement("line");
        this.xmlWriter.addAttribute("direction", line.getDirection(), JRXmlConstants.getDirectionMap(), (byte)1);
        this.exportReportElement(line);
        this.exportGraphicElement(line);
        this.xmlWriter.closeElement();
    }

    protected void exportReportElement(JRPrintElement element) throws IOException {
        this.xmlWriter.startElement("reportElement");
        JRStyle style = element.getStyle();
        if (style != null) {
            this.xmlWriter.addAttribute("style", style.getName());
        }
        this.xmlWriter.addAttribute("mode", element.getOwnMode(), JRXmlConstants.getModeMap());
        this.xmlWriter.addAttribute("x", element.getX() + this.getOffsetX());
        this.xmlWriter.addAttribute("y", element.getY() + this.getOffsetY());
        this.xmlWriter.addAttribute("width", element.getWidth());
        this.xmlWriter.addAttribute("height", element.getHeight());
        this.xmlWriter.addAttribute("forecolor", element.getOwnForecolor());
        this.xmlWriter.addAttribute("backcolor", element.getOwnBackcolor());
        this.xmlWriter.closeElement();
    }

    protected void exportGraphicElement(JRPrintGraphicElement element) throws IOException {
        this.xmlWriter.startElement("graphicElement");
        this.xmlWriter.addAttribute("pen", element.getOwnPen(), JRXmlConstants.getPenMap());
        this.xmlWriter.addAttribute("fill", element.getOwnFill(), JRXmlConstants.getFillMap());
        this.xmlWriter.closeElement();
    }

    protected void exportRectangle(JRPrintRectangle rectangle) throws IOException {
        this.xmlWriter.startElement("rectangle");
        this.xmlWriter.addAttribute("radius", rectangle.getOwnRadius());
        this.exportReportElement(rectangle);
        this.exportGraphicElement(rectangle);
        this.xmlWriter.closeElement();
    }

    protected void exportEllipse(JRPrintEllipse ellipse) throws IOException {
        this.xmlWriter.startElement("ellipse");
        this.exportReportElement(ellipse);
        this.exportGraphicElement(ellipse);
        this.xmlWriter.closeElement();
    }

    protected void exportImage(JRPrintImage image) throws JRException, IOException {
        this.xmlWriter.startElement("image");
        this.xmlWriter.addAttribute("scaleImage", image.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.xmlWriter.addAttribute("hAlign", image.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.xmlWriter.addAttribute("vAlign", image.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.xmlWriter.addAttribute("isLazy", image.isLazy(), false);
        this.xmlWriter.addAttribute("onErrorType", image.getOnErrorType(), JRXmlConstants.getOnErrorTypeMap(), (byte)1);
        this.xmlWriter.addAttribute("hyperlinkType", image.getHyperlinkType(), JRXmlConstants.getHyperlinkTypeMap(), (byte)1);
        this.xmlWriter.addAttribute("hyperlinkTarget", image.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.xmlWriter.addAttribute("anchorName", image.getAnchorName());
        this.xmlWriter.addAttribute("hyperlinkReference", image.getHyperlinkReference());
        this.xmlWriter.addAttribute("hyperlinkAnchor", image.getHyperlinkAnchor());
        this.xmlWriter.addAttribute("hyperlinkPage", image.getHyperlinkPage());
        this.xmlWriter.addAttribute("bookmarkLevel", image.getBookmarkLevel(), 0);
        this.exportReportElement(image);
        this.exportBox(image);
        this.exportGraphicElement(image);
        JRRenderable renderer = image.getRenderer();
        if (renderer != null) {
            this.xmlWriter.startElement("imageSource");
            this.xmlWriter.addAttribute("isEmbedded", this.isEmbeddingImages && !image.isLazy(), false);
            String imageSource = "";
            if (renderer.getType() == 1) {
                renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), image.getBackcolor());
            }
            if (this.isEmbeddingImages && !image.isLazy()) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(renderer.getImageData());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Base64Encoder encoder = new Base64Encoder(bais, baos);
                    encoder.process();
                    imageSource = new String(baos.toByteArray(), "UTF-8");
                }
                catch (IOException e) {
                    throw new JRException("Error embedding image into XML.", e);
                }
            } else if (renderer.getType() == 0 && this.rendererToImagePathMap.containsKey(renderer)) {
                imageSource = (String)this.rendererToImagePathMap.get(renderer);
            } else {
                if (image.isLazy()) {
                    imageSource = ((JRImageRenderer)renderer).getImageLocation();
                } else {
                    imageSource = "img_" + JRXmlExporter.getNextImageId();
                    this.imageNameToImageDataMap.put(imageSource, renderer.getImageData());
                    imageSource = new File(this.imagesDir, imageSource).getPath();
                }
                this.rendererToImagePathMap.put(renderer, imageSource);
            }
            this.xmlWriter.writeCDATA(imageSource);
            this.xmlWriter.closeElement();
        }
        this.xmlWriter.closeElement();
    }

    protected void exportText(JRPrintText text) throws IOException {
        this.xmlWriter.startElement("text");
        this.xmlWriter.addAttribute("textAlignment", text.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.xmlWriter.addAttribute("verticalAlignment", text.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.xmlWriter.addAttribute("textHeight", text.getTextHeight());
        this.xmlWriter.addAttribute("rotation", text.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.xmlWriter.addAttribute("runDirection", text.getRunDirection(), JRXmlConstants.getRunDirectionMap(), (byte)0);
        this.xmlWriter.addAttribute("lineSpacing", text.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.xmlWriter.addAttribute("isStyledText", text.isOwnStyledText());
        this.xmlWriter.addAttribute("lineSpacingFactor", text.getLineSpacingFactor());
        this.xmlWriter.addAttribute("leadingOffset", text.getLeadingOffset());
        this.xmlWriter.addAttribute("hyperlinkType", text.getHyperlinkType(), JRXmlConstants.getHyperlinkTypeMap(), (byte)1);
        this.xmlWriter.addAttribute("hyperlinkTarget", text.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.xmlWriter.addAttribute("anchorName", text.getAnchorName());
        this.xmlWriter.addAttribute("hyperlinkReference", text.getHyperlinkReference());
        this.xmlWriter.addAttribute("hyperlinkAnchor", text.getHyperlinkAnchor());
        this.xmlWriter.addAttribute("hyperlinkPage", text.getHyperlinkPage());
        this.xmlWriter.addAttribute("bookmarkLevel", text.getBookmarkLevel(), 0);
        this.exportReportElement(text);
        this.exportBox(text);
        this.exportFont(text);
        if (text.getText() != null) {
            this.xmlWriter.writeCDATAElement("textContent", text.getText());
        }
        this.xmlWriter.closeElement();
    }

    private void exportBox(JRBox box) throws IOException {
        if (box != null) {
            this.xmlWriter.startElement("box");
            this.xmlWriter.addAttribute("border", box.getOwnBorder(), JRXmlConstants.getPenMap());
            this.xmlWriter.addAttribute("borderColor", box.getOwnBorderColor());
            this.xmlWriter.addAttribute("padding", box.getOwnPadding());
            this.xmlWriter.addAttribute("topBorder", box.getOwnTopBorder(), JRXmlConstants.getPenMap());
            this.xmlWriter.addAttribute("topBorderColor", box.getOwnTopBorderColor());
            this.xmlWriter.addAttribute("topPadding", box.getOwnTopPadding());
            this.xmlWriter.addAttribute("leftBorder", box.getOwnLeftBorder(), JRXmlConstants.getPenMap());
            this.xmlWriter.addAttribute("leftBorderColor", box.getOwnLeftBorderColor());
            this.xmlWriter.addAttribute("leftPadding", box.getOwnLeftPadding());
            this.xmlWriter.addAttribute("bottomBorder", box.getOwnBottomBorder(), JRXmlConstants.getPenMap());
            this.xmlWriter.addAttribute("bottomBorderColor", box.getOwnBottomBorderColor());
            this.xmlWriter.addAttribute("bottomPadding", box.getOwnBottomPadding());
            this.xmlWriter.addAttribute("rightBorder", box.getOwnRightBorder(), JRXmlConstants.getPenMap());
            this.xmlWriter.addAttribute("rightBorderColor", box.getOwnRightBorderColor());
            this.xmlWriter.addAttribute("rightPadding", box.getOwnRightPadding());
            this.xmlWriter.closeElement(true);
        }
    }

    protected void exportFont(JRFont font) throws IOException {
        if (font != null) {
            this.xmlWriter.startElement("font");
            if (font.getReportFont() != null) {
                JRFont baseFont = (JRFont)this.fontsMap.get(font.getReportFont().getName());
                if (baseFont != null) {
                    this.xmlWriter.addAttribute("reportFont", font.getReportFont().getName());
                } else {
                    throw new JRRuntimeException("Referenced report font not found : " + font.getReportFont().getName());
                }
            }
            this.xmlWriter.addAttribute("fontName", font.getOwnFontName());
            this.xmlWriter.addAttribute("size", font.getOwnFontSize());
            this.xmlWriter.addAttribute("isBold", font.isOwnBold());
            this.xmlWriter.addAttribute("isItalic", font.isOwnItalic());
            this.xmlWriter.addAttribute("isUnderline", font.isOwnUnderline());
            this.xmlWriter.addAttribute("isStrikeThrough", font.isOwnStrikeThrough());
            this.xmlWriter.addAttribute("pdfFontName", font.getOwnPdfFontName());
            this.xmlWriter.addAttribute("pdfEncoding", font.getOwnPdfEncoding());
            this.xmlWriter.addAttribute("isPdfEmbedded", font.isOwnPdfEmbedded());
            this.xmlWriter.closeElement(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(JRPrintFrame frame) throws IOException, JRException {
        this.xmlWriter.startElement("frame");
        this.setFrameElementsOffset(frame, true);
        try {
            this.exportReportElement(frame);
            this.exportBox(frame);
            this.exportElements(frame.getElements());
            this.xmlWriter.closeElement();
        }
        finally {
            this.restoreElementOffsets();
        }
    }

    private static synchronized int getNextImageId() {
        return imageId++;
    }
}

