/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.IReportScriptlet;
import it.businesslogic.ireport.chart.ChartFactory;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.util.Properties;
import java.util.Vector;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleEdge;

public class DefaultChartFactory
extends ChartFactory {
    static final String PIE3D = "Pie3D";
    static final String PIE = "Pie";
    static final String BAR = "Bar";
    static final String BAR3D = "Bar3D";
    static final String LINE = "Line";
    static final String AREA = "Area";
    static final String CANDLESTICK = "Candlestick";

    public static Image drawChart(String[] parameters, IReportScriptlet scriptlet) {
        Properties props = DefaultChartFactory.parseProperties(parameters);
        int width = DefaultChartFactory.getParameterAsInteger("width", props, 250);
        int height = DefaultChartFactory.getParameterAsInteger("height", props, 100);
        int quality = DefaultChartFactory.getParameterAsInteger("quality", props, 1);
        String chartName = props.getProperty("chartName");
        boolean showLegend = DefaultChartFactory.getParameterAsBoolean("legend", props, false);
        boolean showTooltips = DefaultChartFactory.getParameterAsBoolean("tooltips", props, false);
        if (chartName.equals(PIE3D)) {
            Vector labels = DefaultChartFactory.getSeries("serie0", props, scriptlet);
            Vector values = DefaultChartFactory.getSeries("serie1", props, scriptlet);
            DefaultKeyedValues dkv = new DefaultKeyedValues();
            for (int i = 0; i < values.size(); ++i) {
                String key = i + 1 + "";
                if (labels != null) {
                    key = "" + labels.get(i);
                }
                dkv.addValue((Comparable)((Object)key), (Number)new Double("" + (values.get(i) != null ? values.get(i) : "0")));
            }
            double depthFactor = DefaultChartFactory.getParameterAsDouble("depthFactor", props, 0.2);
            JFreeChart chart = org.jfree.chart.ChartFactory.createPieChart3D((String)"", (PieDataset)new DefaultPieDataset((KeyedValues)dkv), (boolean)showLegend, (boolean)showTooltips, (boolean)false);
            ((PiePlot3D)chart.getPlot()).setDepthFactor(depthFactor);
            ((PiePlot3D)chart.getPlot()).setForegroundAlpha((float)DefaultChartFactory.getParameterAsDouble("foregroundAlpha", props, 0.0));
            DefaultChartFactory.setChartProperties(props, chart);
            return chart.createBufferedImage(width * quality, height * quality);
        }
        if (chartName.equals(PIE)) {
            Vector labels = DefaultChartFactory.getSeries("serie0", props, scriptlet);
            Vector values = DefaultChartFactory.getSeries("serie1", props, scriptlet);
            DefaultKeyedValues dkv = new DefaultKeyedValues();
            for (int i = 0; i < values.size(); ++i) {
                String key = i + 1 + "";
                if (labels != null) {
                    key = "" + labels.get(i);
                }
                dkv.addValue((Comparable)((Object)key), (Number)new Double("" + (values.get(i) != null ? values.get(i) : "0")));
            }
            JFreeChart chart = org.jfree.chart.ChartFactory.createPieChart((String)"", (PieDataset)new DefaultPieDataset((KeyedValues)dkv), (boolean)showLegend, (boolean)showTooltips, (boolean)false);
            DefaultChartFactory.setChartProperties(props, chart);
            return chart.createBufferedImage(width * quality, height * quality);
        }
        if (chartName.equals(BAR) || chartName.equals(BAR3D)) {
            Vector values = DefaultChartFactory.getSeries("serie0", props, scriptlet);
            Vector theCategories = DefaultChartFactory.getSeries("serie1", props, scriptlet);
            Vector theSeries = DefaultChartFactory.getSeries("serie2", props, scriptlet);
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            if (scriptlet == null) {
                dataset = DefaultChartFactory.getSampleCategoryDataset();
            } else {
                for (int i = 0; i < values.size(); ++i) {
                    String category = i + 1 + "";
                    if (theCategories != null && theCategories.size() > i) {
                        category = "" + theCategories.get(i);
                    }
                    String theSerie = "";
                    if (theSeries != null && theSeries.size() > i) {
                        theSerie = "" + theSeries.get(i);
                    }
                    dataset.addValue((Number)new Double("" + (values.get(i) != null ? values.get(i) : "0")), (Comparable)((Object)theSerie), (Comparable)((Object)category));
                }
            }
            int plotOrientation = DefaultChartFactory.getParameterAsInteger("plotOrientation", props, 1);
            JFreeChart chart = null;
            chart = chartName.equals(BAR) ? org.jfree.chart.ChartFactory.createBarChart((String)"", (String)Misc.nvl(props.getProperty("categoryLabel"), ""), (String)Misc.nvl(props.getProperty("valueLabel"), ""), (CategoryDataset)dataset, (PlotOrientation)(plotOrientation == 1 ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)showLegend, (boolean)showTooltips, (boolean)false) : org.jfree.chart.ChartFactory.createBarChart3D((String)"", (String)Misc.nvl(props.getProperty("categoryLabel"), ""), (String)Misc.nvl(props.getProperty("valueLabel"), ""), (CategoryDataset)dataset, (PlotOrientation)(plotOrientation == 1 ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)showLegend, (boolean)showTooltips, (boolean)false);
            DefaultChartFactory.setChartProperties(props, chart);
            return chart.createBufferedImage(width * quality, height * quality);
        }
        if (chartName.equals(LINE)) {
            Vector valuesX = DefaultChartFactory.getSeries("serie0", props, scriptlet);
            Vector valuesY = DefaultChartFactory.getSeries("serie1", props, scriptlet);
            Vector theSeries = DefaultChartFactory.getSeries("serie2", props, scriptlet);
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            int plotOrientation = DefaultChartFactory.getParameterAsInteger("plotOrientation", props, 1);
            if (scriptlet == null) {
                dataset = DefaultChartFactory.getSampleCategoryDataset();
            } else {
                for (int i = 0; i < valuesX.size(); ++i) {
                    String theSerie = "";
                    if (theSeries != null && theSeries.size() > i) {
                        theSerie = "" + theSeries.get(i);
                    }
                    dataset.addValue((Number)new Double("" + (valuesX.get(i) != null ? valuesX.get(i) : "0")), (Comparable)((Object)theSerie), (Comparable)new Double("" + (valuesY.get(i) != null ? valuesY.get(i) : "0")));
                }
            }
            JFreeChart chart = null;
            chart = org.jfree.chart.ChartFactory.createLineChart((String)"", (String)Misc.nvl(props.getProperty("categoryLabel"), ""), (String)Misc.nvl(props.getProperty("valueLabel"), ""), (CategoryDataset)dataset, (PlotOrientation)(plotOrientation == 1 ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)showLegend, (boolean)showTooltips, (boolean)false);
            DefaultChartFactory.setChartProperties(props, chart);
            return chart.createBufferedImage(width * quality, height * quality);
        }
        if (chartName.equals(AREA)) {
            Vector valuesX = DefaultChartFactory.getSeries("serie0", props, scriptlet);
            Vector valuesY = DefaultChartFactory.getSeries("serie1", props, scriptlet);
            Vector theSeries = DefaultChartFactory.getSeries("serie2", props, scriptlet);
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            int plotOrientation = DefaultChartFactory.getParameterAsInteger("plotOrientation", props, 1);
            if (scriptlet == null) {
                dataset = DefaultChartFactory.getSampleCategoryDataset();
            } else {
                for (int i = 0; i < valuesX.size(); ++i) {
                    String theSerie = "";
                    if (theSeries != null && theSeries.size() > i) {
                        theSerie = "" + theSeries.get(i);
                    }
                    dataset.addValue((Number)new Double("" + (valuesX.get(i) != null ? valuesX.get(i) : "0")), (Comparable)((Object)theSerie), (Comparable)new Double("" + (valuesY.get(i) != null ? valuesY.get(i) : "0")));
                }
            }
            JFreeChart chart = null;
            chart = org.jfree.chart.ChartFactory.createAreaChart((String)"", (String)Misc.nvl(props.getProperty("categoryLabel"), ""), (String)Misc.nvl(props.getProperty("valueLabel"), ""), (CategoryDataset)dataset, (PlotOrientation)(plotOrientation == 1 ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL), (boolean)showLegend, (boolean)showTooltips, (boolean)false);
            DefaultChartFactory.setChartProperties(props, chart);
            CategoryPlot cplot = (CategoryPlot)chart.getPlot();
            cplot.setForegroundAlpha((float)DefaultChartFactory.getParameterAsDouble("foregroundAlpha", props, 0.0));
            return chart.createBufferedImage(width * quality, height * quality);
        }
        return null;
    }

    protected static void setChartProperties(Properties props, JFreeChart chart) {
        Color bgColor;
        String title = props.getProperty("title");
        if (title != null && title.length() > 0) {
            chart.setTitle(title);
            int titlePosition = DefaultChartFactory.getParameterAsInteger("titlePosition", props, 1);
            if (titlePosition == 1) {
                chart.getTitle().setPosition(RectangleEdge.TOP);
            }
            if (titlePosition == 2) {
                chart.getTitle().setPosition(RectangleEdge.BOTTOM);
            }
            if (titlePosition == 3) {
                chart.getTitle().setPosition(RectangleEdge.LEFT);
            }
            if (titlePosition == 4) {
                chart.getTitle().setPosition(RectangleEdge.RIGHT);
            }
        }
        if ((title = props.getProperty("subtitle")) != null && title.length() > 0) {
            TextTitle subtitle1 = new TextTitle(title);
            chart.addSubtitle((Title)subtitle1);
        }
        if ((bgColor = DefaultChartFactory.getParameterAsColor("chartBackground", props, Color.WHITE)) != null) {
            chart.setBackgroundPaint((Paint)bgColor);
        }
        if ((bgColor = DefaultChartFactory.getParameterAsColor("plotBackground", props, Color.WHITE)) != null) {
            chart.getPlot().setBackgroundPaint((Paint)bgColor);
        }
    }

    protected static Properties parseProperties(String[] properties) {
        Properties props = new Properties();
        for (int i = 0; i < properties.length; ++i) {
            String key = properties[i].substring(0, properties[i].indexOf("="));
            String val = properties[i].substring(key.length() + 1);
            props.setProperty(key, val);
        }
        return props;
    }

    protected static DefaultCategoryDataset getSampleCategoryDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(1.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 1"));
        dataset.addValue(4.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 2"));
        dataset.addValue(3.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 3"));
        dataset.addValue(5.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 4"));
        dataset.addValue(5.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 5"));
        dataset.addValue(7.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 6"));
        dataset.addValue(7.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 7"));
        dataset.addValue(8.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 8"));
        dataset.addValue(5.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 1"));
        dataset.addValue(7.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 2"));
        dataset.addValue(6.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 3"));
        dataset.addValue(8.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 4"));
        dataset.addValue(4.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 5"));
        dataset.addValue(4.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 6"));
        dataset.addValue(2.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 7"));
        dataset.addValue(1.0, (Comparable)((Object)"Series 2"), (Comparable)((Object)"Type 8"));
        dataset.addValue(4.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 1"));
        dataset.addValue(3.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 2"));
        dataset.addValue(2.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 3"));
        dataset.addValue(3.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 4"));
        dataset.addValue(6.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 5"));
        dataset.addValue(3.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 6"));
        dataset.addValue(4.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 7"));
        dataset.addValue(3.0, (Comparable)((Object)"Series 3"), (Comparable)((Object)"Type 8"));
        return dataset;
    }
}

