/*
 * ComboBoxSheetProperty.java
 *
 * Created on 16 febbraio 2005, 19.13
 */

package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent;
import java.util.*;
import javax.swing.*;
import it.businesslogic.ireport.util.*;

public class ComboBoxSheetProperty extends SheetProperty {
    
    public ComboBoxSheetProperty(String key, String name) {
        super( key, name, SheetProperty.COMBOBOX);
    }
    
    public Object getEditorValue(JComponent component)
    {
        return ((JComboBox)component).getSelectedItem();
    }
    
    public void setEditorValue(JComponent component, Object str)
    {
        try {
            ((JComboBox)component).setSelectedItem(str);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
    
     public void actionPerformed(java.awt.event.ActionEvent event)
    {
        if (isSetting()) return;
        Object new_value = getEditorValue( this.getEditor() );
        if (new_value != null && new_value.equals(value)) return;
        
        Object oldValue = value;
        value = new_value;
        //System.out.println(this.getName() + ": " + getValue());
        if(oldValue == null || value == null)
        {
            updateLabel();
        }
        
        fireSheetPropertyValueChangedListenerSheetPropertyValueChanged(
            new SheetPropertyValueChangedEvent(getKeyName(),oldValue,value, this));
    }
     
     public void updateValues(Vector values, boolean addNullEntry){
     
         
        Misc.updateComboBox( (JComboBox)getEditor(), values, addNullEntry);
     
     }
}