/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.IntelligentLineBorder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class ButtonBorder
extends IntelligentLineBorder {
    public ButtonBorder() {
        super(false);
    }

    public Insets getBorderInsets(Component c) {
        Insets m = null;
        if (c instanceof JButton) {
            m = ((JButton)c).getMargin();
        }
        int left = (!this.isTouchingLeftEdge(c) ? 4 : 3) + m.left;
        int right = (!this.isTouchingRightEdge(c) ? 4 : 3) + m.right;
        int top = (!this.isTouchingTopEdge(c) ? 4 : 3) + m.top;
        int bottom = (!this.isTouchingBottomEdge(c) ? 4 : 3) + m.bottom;
        return new Insets(top, left, bottom, right);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (c instanceof AbstractButton) {
            boolean drawPressed;
            int bottom;
            AbstractButton b = (AbstractButton)c;
            int left = !this.isTouchingLeftEdge(c) ? 1 : 0;
            int right = !this.isTouchingRightEdge(c) ? 1 : 0;
            int top = !this.isTouchingTopEdge(c) ? 1 : 0;
            int n = bottom = !this.isTouchingBottomEdge(c) ? 1 : 0;
            if (!(b.getModel().isPressed() || c instanceof JToggleButton && ((JToggleButton)c).isSelected())) {
                ++right;
                ++bottom;
            }
            g.setColor(c.getBackground());
            g.fillRect(x + left, y + top, width - left - right, 3);
            g.fillRect(x + left, y + top, 3, height - top - bottom);
            g.fillRect(x + width - 4, y + top, 3, height - top - bottom);
            g.fillRect(x + left, y + height - 4, width - left - right, 3);
            if (b.hasFocus()) {
                g.setColor(UIManager.getColor("Button.focusBorderColor"));
            } else if (b.isEnabled()) {
                g.setColor(UIManager.getColor("Button.borderColor"));
            } else {
                g.setColor(UIManager.getColor("Button.disabledBorderColor"));
            }
            boolean bl = drawPressed = b.getModel().isPressed() || c instanceof JToggleButton && ((JToggleButton)c).isSelected();
            if (!this.isTouchingLeftEdge(c)) {
                if (drawPressed) {
                    g.drawLine(x + 1, y + 1, x + 1, y + height - 2);
                } else {
                    g.drawLine(x, y, x, y + height - 2);
                }
            }
            if (!this.isTouchingTopEdge(c)) {
                if (drawPressed) {
                    g.drawLine(x + 1, y + 1, x + width - 2, y + 1);
                } else {
                    g.drawLine(x, y, x + width - 2, y);
                }
            }
            if (!this.isTouchingRightEdge(c)) {
                if (drawPressed) {
                    g.drawLine(x + width - 1, y + 1, x + width - 1, y + height);
                } else {
                    g.drawLine(x + width - 2, y + 1, x + width - 2, y + height);
                }
            }
            if (!this.isTouchingBottomEdge(c)) {
                if (drawPressed) {
                    g.drawLine(x + 1, y + height - 1, x + width, y + height - 1);
                } else {
                    g.drawLine(x + 1, y + height - 2, x + width - 1, y + height - 2);
                }
            }
            if (!(b.getModel().isPressed() || c instanceof JToggleButton && ((JToggleButton)c).isSelected())) {
                g.setColor(UIManager.getColor("Button.borderColor2"));
                g.drawLine(x + 1, y + height - 1, x + width, y + height - 1);
                g.drawLine(x + width - 1, y + 1, x + width - 1, x + height);
            }
        }
    }
}

