/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.documentstructure;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.ChartReportElement2;
import it.businesslogic.ireport.ElementGroup;
import it.businesslogic.ireport.FrameReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.chart.gui.ChartPropertiesDialog;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.docking.GenericDragTargetListener;
import it.businesslogic.ireport.gui.documentstructure.DocumentStructureTreeCellRenderer;
import it.businesslogic.ireport.gui.documentstructure.DocumentStructureTreeNode;
import it.businesslogic.ireport.gui.event.ReportBandChangedEvent;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.event.ReportElementsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportListener;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedEvent;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedListener;
import it.businesslogic.ireport.undo.UnGroupEmentsOperation;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class DocumentStructurePanel
extends JPanel
implements ReportListener,
SubDatasetObjectChangedListener,
LanguageChangedListener {
    private boolean dontHandleEvent = false;
    private JReportFrame oldJReportFrame = null;
    private JMenuItem jMenuItemDSB_properties;
    private JMenuItem jMenuItemDS_chartProperties;
    private JMenuItem jMenuItemDS_copy;
    private JMenuItem jMenuItemDS_cut;
    private JMenuItem jMenuItemDS_delete;
    private JMenuItem jMenuItemDS_paste;
    private JMenuItem jMenuItemDS_properties;
    private JMenuItem jMenuItemMoveDown;
    private JMenuItem jMenuItemMoveUp;
    private JMenuItem jMenuItemUngroup;
    private JPopupMenu jPopupMenuDocumentStructure;
    private JPopupMenu jPopupMenuDocumentStructureBand;
    private JPopupMenu jPopupMenuDocumentStructureGroup;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator22;
    private JSeparator jSeparator23;
    private JTree jTreeDocument;

    public DocumentStructurePanel() {
        this.initComponents();
        DefaultTreeSelectionModel dtsm = (DefaultTreeSelectionModel)this.jTreeDocument.getSelectionModel();
        dtsm.setSelectionMode(4);
        this.jTreeDocument.setDropTarget(new DropTarget(this, new GenericDragTargetListener()));
        DocumentStructureTreeNode rootDoc = new DocumentStructureTreeNode(I18n.getString("document", "Document"));
        DefaultTreeModel modelDoc = new DefaultTreeModel(rootDoc);
        this.jTreeDocument.setModel(modelDoc);
        this.jTreeDocument.setCellRenderer(new DocumentStructureTreeCellRenderer());
    }

    private void initComponents() {
        this.jPopupMenuDocumentStructure = new JPopupMenu();
        this.jMenuItemDS_properties = new JMenuItem();
        this.jMenuItemDS_chartProperties = new JMenuItem();
        this.jSeparator22 = new JSeparator();
        this.jMenuItemMoveUp = new JMenuItem();
        this.jMenuItemMoveDown = new JMenuItem();
        this.jSeparator23 = new JSeparator();
        this.jMenuItemDS_cut = new JMenuItem();
        this.jMenuItemDS_copy = new JMenuItem();
        this.jMenuItemDS_paste = new JMenuItem();
        this.jMenuItemDS_delete = new JMenuItem();
        this.jPopupMenuDocumentStructureBand = new JPopupMenu();
        this.jMenuItemDSB_properties = new JMenuItem();
        this.jPopupMenuDocumentStructureGroup = new JPopupMenu();
        this.jMenuItemUngroup = new JMenuItem();
        this.jScrollPane2 = new JScrollPane();
        this.jTreeDocument = new JTree();
        this.jMenuItemDS_properties.setText("Properties");
        this.jMenuItemDS_properties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemDS_propertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemDS_properties);
        this.jMenuItemDS_chartProperties.setIcon(new ImageIcon(""));
        this.jMenuItemDS_chartProperties.setText("Chart properties");
        this.jMenuItemDS_chartProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemDS_chartPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemDS_chartProperties);
        this.jPopupMenuDocumentStructure.add(this.jSeparator22);
        this.jMenuItemMoveUp.setText("Move up");
        this.jMenuItemMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemMoveUpActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemMoveUp);
        this.jMenuItemMoveDown.setText("Move down");
        this.jMenuItemMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemMoveDownActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemMoveDown);
        this.jPopupMenuDocumentStructure.add(this.jSeparator23);
        this.jMenuItemDS_cut.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/cut.png")));
        this.jMenuItemDS_cut.setText("Cut");
        this.jMenuItemDS_cut.setEnabled(false);
        this.jMenuItemDS_cut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemDS_cutActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemDS_cut);
        this.jMenuItemDS_copy.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/copy.png")));
        this.jMenuItemDS_copy.setText("Copy");
        this.jMenuItemDS_copy.setEnabled(false);
        this.jMenuItemDS_copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemDS_copyActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemDS_copy);
        this.jMenuItemDS_paste.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/paste.png")));
        this.jMenuItemDS_paste.setText("Paste");
        this.jMenuItemDS_paste.setEnabled(false);
        this.jMenuItemDS_paste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemDS_pasteActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemDS_paste);
        this.jMenuItemDS_delete.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/delete.png")));
        this.jMenuItemDS_delete.setText("Delete");
        this.jMenuItemDS_delete.setEnabled(false);
        this.jMenuItemDS_delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemDS_deleteActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructure.add(this.jMenuItemDS_delete);
        this.jMenuItemDSB_properties.setText("Band properties");
        this.jMenuItemDSB_properties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemDSB_propertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructureBand.add(this.jMenuItemDSB_properties);
        this.jMenuItemUngroup.setText("Ungroup");
        this.jMenuItemUngroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentStructurePanel.this.jMenuItemUngroupActionPerformed(evt);
            }
        });
        this.jPopupMenuDocumentStructureGroup.add(this.jMenuItemUngroup);
        this.setLayout(new BorderLayout());
        this.jTreeDocument.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent evt) {
                DocumentStructurePanel.this.jTreeDocumentTreeCollapsed(evt);
            }

            public void treeExpanded(TreeExpansionEvent evt) {
                DocumentStructurePanel.this.jTreeDocumentTreeExpanded(evt);
            }
        });
        this.jTreeDocument.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                DocumentStructurePanel.this.jTreeDocumentValueChanged(evt);
            }
        });
        this.jTreeDocument.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                DocumentStructurePanel.this.jTreeDocumentMousePressed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTreeDocument);
        this.add((Component)this.jScrollPane2, "Center");
        I18n.addOnLanguageChangedListener(this);
    }

    private void jMenuItemUngroupActionPerformed(ActionEvent evt) {
        DocumentStructureTreeNode elementNode;
        if (this.jTreeDocument.getSelectionCount() > 0 && (elementNode = (DocumentStructureTreeNode)this.jTreeDocument.getSelectionPath().getLastPathComponent()).getUserObject() instanceof ElementGroup) {
            String elementGroupName = ((ElementGroup)elementNode.getUserObject()).getName();
            while (((DocumentStructureTreeNode)elementNode.getParent()).getUserObject() instanceof ElementGroup) {
                elementNode = (DocumentStructureTreeNode)elementNode.getParent();
                elementGroupName = ((ElementGroup)elementNode.getUserObject()).getName() + "." + elementGroupName;
            }
            String newElementGroupName = elementGroupName;
            newElementGroupName = newElementGroupName.lastIndexOf(".") >= 0 ? newElementGroupName.substring(0, newElementGroupName.lastIndexOf(".")) : "";
            UnGroupEmentsOperation undoOp = new UnGroupEmentsOperation(MainFrame.getMainInstance().getActiveReportFrame());
            Vector elements = MainFrame.getMainInstance().getActiveReportFrame().getReport().getElements();
            for (int i = 0; i < elements.size(); ++i) {
                ReportElement element = (ReportElement)elements.elementAt(i);
                String oldElementGroupName = element.getElementGroup();
                if (!element.getElementGroup().startsWith(elementGroupName + ".") && !element.getElementGroup().equals(elementGroupName)) continue;
                String tmpElementGroupName = element.getElementGroup().substring(elementGroupName.length());
                if (tmpElementGroupName.length() == 0) {
                    tmpElementGroupName = newElementGroupName;
                }
                if ((tmpElementGroupName = newElementGroupName + tmpElementGroupName).startsWith(".")) {
                    tmpElementGroupName = tmpElementGroupName.substring(1);
                }
                element.setElementGroup(tmpElementGroupName);
                undoOp.addElement(element, i, i, oldElementGroupName, tmpElementGroupName);
            }
            MainFrame.getMainInstance().getActiveReportFrame().addUndoOperation(undoOp);
            MainFrame.getMainInstance().getActiveReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(MainFrame.getMainInstance().getActiveReportFrame(), new Vector(), 1));
        }
    }

    private void jTreeDocumentTreeCollapsed(TreeExpansionEvent evt) {
    }

    private void jTreeDocumentTreeExpanded(TreeExpansionEvent evt) {
    }

    private void jMenuItemDSB_propertiesActionPerformed(ActionEvent evt) {
        DocumentStructureTreeNode elementNode;
        if (this.jTreeDocument.getSelectionCount() > 0 && (elementNode = (DocumentStructureTreeNode)this.jTreeDocument.getSelectionPath().getLastPathComponent()).getUserObject() instanceof Band) {
            String thisBand = ((Band)elementNode.getUserObject()).getName();
            MainFrame.getMainInstance().jMenuItemBandsActionPerformed(evt);
            MainFrame.getMainInstance().getBandsDialog().setSelectedBand(thisBand);
        }
    }

    private void jMenuItemDS_deleteActionPerformed(ActionEvent evt) {
        MainFrame.getMainInstance().getActiveReportFrame().deleteSelectedElements();
    }

    private void jMenuItemDS_pasteActionPerformed(ActionEvent evt) {
        MainFrame.getMainInstance().getActiveReportFrame().paste();
    }

    private void jMenuItemDS_copyActionPerformed(ActionEvent evt) {
        MainFrame.getMainInstance().getActiveReportFrame().copy();
    }

    private void jMenuItemDS_cutActionPerformed(ActionEvent evt) {
        MainFrame.getMainInstance().getActiveReportFrame().cut();
    }

    private void jMenuItemMoveDownActionPerformed(ActionEvent evt) {
        if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
            JReportFrame jrf = MainFrame.getMainInstance().getActiveReportFrame();
            jrf.moveDown();
            if (jrf.getSelectedElements().size() > 0) {
                this.updateDocumentStructureTree(jrf);
            }
        }
    }

    private void jMenuItemMoveUpActionPerformed(ActionEvent evt) {
        if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
            JReportFrame jrf = MainFrame.getMainInstance().getActiveReportFrame();
            jrf.moveUp();
            this.jTreeDocument.updateUI();
            this.printSelectedPaths("Prima");
            if (jrf.getSelectedElements().size() > 0) {
                this.updateDocumentStructureTree(jrf);
            }
            this.printSelectedPaths("Dopo");
        }
    }

    private void jMenuItemDS_chartPropertiesActionPerformed(ActionEvent evt) {
        if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
            DocumentStructureTreeNode elementNode;
            JReportFrame jrf = MainFrame.getMainInstance().getActiveReportFrame();
            if (this.jTreeDocument.getSelectionCount() > 0 && (elementNode = (DocumentStructureTreeNode)this.jTreeDocument.getSelectionPath().getLastPathComponent()).getUserObject() instanceof ChartReportElement2) {
                ChartPropertiesDialog cpd = new ChartPropertiesDialog((Frame)MainFrame.getMainInstance(), true);
                cpd.setChartElement((ChartReportElement2)elementNode.getUserObject());
                cpd.setVisible(true);
            }
        }
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    private void jMenuItemDS_propertiesActionPerformed(ActionEvent evt) {
        MainFrame.getMainInstance().getElementPropertiesDialog().setVisible(true);
        MainFrame.getMainInstance().getElementPropertiesDialog().updateSelection();
    }

    private void jTreeDocumentValueChanged(TreeSelectionEvent evt) {
        if (this.isDontHandleEvent()) {
            return;
        }
        if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
            try {
                JReportFrame jrf = MainFrame.getMainInstance().getActiveReportFrame();
                Vector<ReportElement> elementsToSelect = new Vector<ReportElement>();
                TreePath[] path = this.jTreeDocument.getSelectionPaths();
                for (int i = 0; i < path.length; ++i) {
                    DocumentStructureTreeNode elementNode = (DocumentStructureTreeNode)path[i].getLastPathComponent();
                    if (elementNode.getUserObject() instanceof ReportElement) {
                        elementsToSelect.addElement((ReportElement)elementNode.getUserObject());
                        continue;
                    }
                    if (path.length == 1) {
                        jrf.setSelectedElement(null);
                        return;
                    }
                    if (!(elementNode.getUserObject() instanceof ElementGroup)) continue;
                    jrf.setSelectedElement(null);
                    return;
                }
                jrf.setSelectedElement(null);
                Enumeration e = elementsToSelect.elements();
                while (e.hasMoreElements()) {
                    jrf.addSelectedElement((ReportElement)e.nextElement(), false);
                }
                jrf.fireSelectionChangedEvent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void jTreeDocumentMousePressed(MouseEvent evt) {
        JReportFrame jrf;
        if (evt.getButton() == 3) {
            if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
                JReportFrame jrf2 = MainFrame.getMainInstance().getActiveReportFrame();
                if (this.jTreeDocument.getSelectionCount() > 0) {
                    DocumentStructureTreeNode elementNode = (DocumentStructureTreeNode)this.jTreeDocument.getSelectionPath().getLastPathComponent();
                    if (elementNode.getUserObject() instanceof ReportElement) {
                        this.jMenuItemDS_chartProperties.setVisible(elementNode.getUserObject() instanceof ChartReportElement2);
                        this.jPopupMenuDocumentStructure.show(this.jTreeDocument, evt.getPoint().x, evt.getPoint().y);
                    } else if (elementNode.getUserObject() instanceof Band) {
                        this.jPopupMenuDocumentStructureBand.show(this.jTreeDocument, evt.getPoint().x, evt.getPoint().y);
                    } else if (elementNode.getUserObject() instanceof ElementGroup) {
                        this.jPopupMenuDocumentStructureGroup.show(this.jTreeDocument, evt.getPoint().x, evt.getPoint().y);
                    }
                }
            }
        } else if (evt.getButton() == 1 && evt.getClickCount() == 2 && MainFrame.getMainInstance().getActiveReportFrame() != null && (jrf = MainFrame.getMainInstance().getActiveReportFrame()).getSelectedElements().size() > 0) {
            MainFrame.getMainInstance().getElementPropertiesDialog().setVisible(true);
        }
    }

    public void printSelectedPaths(String prefix) {
        try {
            Enumeration<TreePath> enum_extended_paths = this.jTreeDocument.getExpandedDescendants(new TreePath(new Object[]{this.jTreeDocument.getModel().getRoot()}));
            if (enum_extended_paths != null) {
                while (enum_extended_paths.hasMoreElements()) {
                    TreePath treePath = enum_extended_paths.nextElement();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateDocumentStructureTree(JReportFrame jrf) {
        List<String> openedPaths = null;
        try {
            openedPaths = new ArrayList();
            Enumeration<TreePath> enum_extended_paths = this.jTreeDocument.getExpandedDescendants(new TreePath(new Object[]{this.jTreeDocument.getModel().getRoot()}));
            if (enum_extended_paths != null) {
                while (enum_extended_paths.hasMoreElements()) {
                    TreePath path = enum_extended_paths.nextElement();
                    openedPaths.add(((DocumentStructureTreeNode)path.getLastPathComponent()).getNodeId());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (jrf != this.oldJReportFrame) {
            if (this.oldJReportFrame != null) {
                this.oldJReportFrame.setOpenedNodesDocumentStructure(openedPaths);
            }
            if (jrf != null) {
                openedPaths = jrf.getOpenedNodesDocumentStructure();
            }
        }
        this.setDontHandleEvent(true);
        ((DocumentStructureTreeNode)this.jTreeDocument.getModel().getRoot()).removeAllChildren();
        ((DefaultTreeModel)this.jTreeDocument.getModel()).reload();
        if (jrf != null) {
            Enumeration bands = jrf.getReport().getBands().elements();
            while (bands.hasMoreElements()) {
                Band band = (Band)bands.nextElement();
                DocumentStructureTreeNode bandNode = new DocumentStructureTreeNode(band);
                ((DocumentStructureTreeNode)this.jTreeDocument.getModel().getRoot()).add(bandNode);
                Enumeration elements = jrf.getReport().getElements().elements();
                while (elements.hasMoreElements()) {
                    ReportElement element = (ReportElement)elements.nextElement();
                    if (element.getBand() != band) continue;
                    String elementGroup = element.getElementGroup();
                    try {
                        if (element.getParentElement() != null) {
                            DocumentStructureTreeNode parentNode = this.findElementTreeNode(element.getParentElement(), true);
                            if (parentNode == null) continue;
                            this.addElementToGroup(parentNode, elementGroup, element, openedPaths);
                            if (openedPaths == null || !openedPaths.contains(parentNode.getNodeId())) continue;
                            this.expandPath(parentNode);
                            continue;
                        }
                        this.addElementToGroup(bandNode, elementGroup, element, openedPaths);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (openedPaths == null || !openedPaths.contains(bandNode.getNodeId())) continue;
                this.expandPath(bandNode);
            }
            this.setDontHandleEvent(false);
            this.reportElementsSelectionChanged(new ReportElementsSelectionEvent(jrf, jrf.getSelectedElements()));
        }
        this.oldJReportFrame = jrf;
        this.jTreeDocument.updateUI();
    }

    public void addElementToGroup(DocumentStructureTreeNode parentNode, String subGroup, ReportElement element, List openedPaths) {
        if (subGroup.equals("")) {
            DocumentStructureTreeNode newNode = new DocumentStructureTreeNode(element);
            parentNode.add(newNode);
            if (openedPaths != null && openedPaths.contains(newNode.getNodeId())) {
                this.expandPath(newNode);
            }
            return;
        }
        String levelGroupName = "";
        if (subGroup.indexOf(".") >= 0) {
            levelGroupName = subGroup.substring(0, subGroup.indexOf("."));
            subGroup = subGroup.substring(subGroup.indexOf(".") + 1);
        } else {
            levelGroupName = subGroup;
            subGroup = "";
        }
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            ElementGroup ge;
            DocumentStructureTreeNode dmtn = (DocumentStructureTreeNode)parentNode.getChildAt(i);
            if (dmtn.getUserObject() == null || !(dmtn.getUserObject() instanceof ElementGroup) || !(ge = (ElementGroup)dmtn.getUserObject()).getName().equals(levelGroupName)) continue;
            this.addElementToGroup(dmtn, subGroup, element, openedPaths);
            return;
        }
        DocumentStructureTreeNode dmtn = new DocumentStructureTreeNode(new ElementGroup(levelGroupName));
        parentNode.add(dmtn);
        this.addElementToGroup(dmtn, subGroup, element, openedPaths);
        if (openedPaths != null && openedPaths.contains(dmtn.getNodeId())) {
            this.expandPath(dmtn);
        }
    }

    public void expandPath(DocumentStructureTreeNode node) {
        try {
            if (node.getParent() != null) {
                this.expandPath((DocumentStructureTreeNode)node.getParent());
            }
            this.jTreeDocument.expandPath(new TreePath(node.getPath()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void reportBandChanged(ReportBandChangedEvent evt) {
        this.updateDocumentStructureTree(evt.getJReportFrame());
    }

    public void reportElementsChanged(ReportElementChangedEvent evt) {
        if (evt.getType() == 3) {
            block0: for (int ir = 0; ir < evt.getElements().size(); ++ir) {
                ReportElement re = (ReportElement)evt.getElements().elementAt(ir);
                DocumentStructureTreeNode node = this.findElementTreeNode(re, true);
                if (node != null) continue;
                node = this.findElementTreeNode(re, false);
                if (node == null) {
                    return;
                }
                node.removeFromParent();
                DocumentStructureTreeNode root = (DocumentStructureTreeNode)this.jTreeDocument.getModel().getRoot();
                for (int i = 0; i < root.getChildCount(); ++i) {
                    DocumentStructureTreeNode bandNode = (DocumentStructureTreeNode)root.getChildAt(i);
                    if (bandNode.getUserObject() != re.band) continue;
                    bandNode.add(node);
                    this.setDontHandleEvent(true);
                    if (evt.getJReportFrame().getSelectedElements().contains(re)) {
                        this.jTreeDocument.getSelectionModel().addSelectionPath(new TreePath(new Object[]{root, bandNode, node}));
                    }
                    this.setDontHandleEvent(false);
                    continue block0;
                }
            }
            this.jTreeDocument.updateUI();
        } else if (evt.getType() == 1) {
            this.updateDocumentStructureTree(MainFrame.getMainInstance().getActiveReportFrame());
            this.jTreeDocument.updateUI();
        } else if (evt.getType() == 2) {
            this.updateDocumentStructureTree(MainFrame.getMainInstance().getActiveReportFrame());
            this.jTreeDocument.updateUI();
        }
    }

    public void reportElementsSelectionChanged(ReportElementsSelectionEvent evt) {
        if (evt.getCrosstabReportElement() != null) {
            return;
        }
        this.setDontHandleEvent(true);
        TreePath[] path = this.jTreeDocument.getSelectionPaths();
        if (path != null && evt.getSelectedElements() != null && evt.getSelectedElements().size() == 0 && (((DocumentStructureTreeNode)path[0].getLastPathComponent()).getUserObject() instanceof Band || ((DocumentStructureTreeNode)path[0].getLastPathComponent()).getUserObject() instanceof ElementGroup)) {
            this.setDontHandleEvent(false);
            return;
        }
        this.jTreeDocument.getSelectionModel().clearSelection();
        Vector v = evt.getSelectedElements();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            ReportElement re = (ReportElement)e.nextElement();
            DocumentStructureTreeNode enode = this.findElementTreeNode(re, true);
            if (enode == null) continue;
            this.jTreeDocument.getSelectionModel().addSelectionPath(new TreePath(enode.getPath()));
        }
        this.setDontHandleEvent(false);
    }

    public DocumentStructureTreeNode findElementTreeNode(ReportElement re, boolean searchInYourBandOnly) {
        DocumentStructureTreeNode root = (DocumentStructureTreeNode)this.jTreeDocument.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DocumentStructureTreeNode newchild;
            DocumentStructureTreeNode bandNode = (DocumentStructureTreeNode)root.getChildAt(i);
            if (searchInYourBandOnly && bandNode.getUserObject() != re.band || (newchild = this.findElementInTreeNode(bandNode, re)) == null) continue;
            return newchild;
        }
        return null;
    }

    public DocumentStructureTreeNode findElementInTreeNode(DocumentStructureTreeNode parentNode, ReportElement re) {
        for (int k = 0; k < parentNode.getChildCount(); ++k) {
            DocumentStructureTreeNode newchild;
            DocumentStructureTreeNode child = (DocumentStructureTreeNode)parentNode.getChildAt(k);
            if (child.getUserObject() == re) {
                return child;
            }
            if (re.getElementGroup().equals("") && re.getParentElement() == null || !(child.getUserObject() instanceof ElementGroup) && !(child.getUserObject() instanceof FrameReportElement) || (newchild = this.findElementInTreeNode(child, re)) == null) continue;
            return newchild;
        }
        return null;
    }

    public boolean isDontHandleEvent() {
        return this.dontHandleEvent;
    }

    public void setDontHandleEvent(boolean dontHandleEvent) {
        this.dontHandleEvent = dontHandleEvent;
    }

    public void applyI18n() {
        this.jMenuItemDS_cut.setText(I18n.getString("cut", "Cut"));
        this.jMenuItemDS_copy.setText(I18n.getString("copy", "Copy"));
        this.jMenuItemDS_paste.setText(I18n.getString("paste", "Paste"));
        this.jMenuItemDS_delete.setText(I18n.getString("delete", "Delete"));
        this.jMenuItemMoveUp.setText(I18n.getString("moveUp", "Move up"));
        this.jMenuItemMoveDown.setText(I18n.getString("moveDown", "Move down"));
        this.jMenuItemDSB_properties.setText(I18n.getString("bandProperties", "Band properties"));
        this.jMenuItemDS_properties.setText(I18n.getString("properties", "Properties"));
        this.jMenuItemDS_cut.setText(I18n.getString("cut", "Cut"));
        this.jMenuItemDS_copy.setText(I18n.getString("copy", "Copy"));
        this.jMenuItemDS_paste.setText(I18n.getString("paste", "Paste"));
        this.jMenuItemDS_delete.setText(I18n.getString("delete", "Delete"));
        this.jMenuItemMoveUp.setText(I18n.getString("moveUp", "Move up"));
        this.jMenuItemMoveDown.setText(I18n.getString("moveDown", "Move down"));
        this.jMenuItemDSB_properties.setText(I18n.getString("bandProperties", "Band properties"));
        this.jMenuItemDS_properties.setText(I18n.getString("properties", "Properties"));
    }

    public void subDatasetObjectChanged(SubDatasetObjectChangedEvent evt) {
    }

    public void setCutCopyEnabled(boolean enabled) {
        this.jMenuItemDS_cut.setEnabled(enabled);
        this.jMenuItemDS_copy.setEnabled(enabled);
        this.jMenuItemDS_delete.setEnabled(enabled);
    }

    public void setPasteEnebled(boolean enabled) {
        this.jMenuItemDS_paste.setEnabled(enabled);
    }
}

