/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.docking;

import it.businesslogic.ireport.gui.docking.JDraggableTabbedPane;
import it.businesslogic.ireport.gui.docking.PanelView;
import it.businesslogic.ireport.gui.docking.VTextIcon;
import it.businesslogic.ireport.gui.event.TabPaneChangedEvent;
import it.businesslogic.ireport.gui.event.TabPaneChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class DockingContainer
extends JPanel
implements TabPaneChangedListener,
ActionListener {
    public static final int INSERT_MODE_SHAREDPOSTION = 0;
    public static final int INSERT_MODE_NEWPOSITION = 1;
    private int oldWidth = 0;
    private boolean compressed = false;
    private Vector panelViews = new Vector();
    private Vector tabPanes = new Vector();
    private int positions = 0;
    private DropTarget dropTarget;
    private DropTargetListener dtListener;
    public static final int POSITION_RIGHT = 0;
    public static final int POSITION_LEFT = 1;
    private int position = 1;
    private int preferredDividerLocation = -1;
    private int realCurrentSize = 0;
    private JButton jButton1;
    private JPanel jPanel1;
    static /* synthetic */ Class class$it$businesslogic$ireport$gui$docking$PanelView;

    public DockingContainer() {
        this(1);
    }

    public DockingContainer(int position) {
        this.initComponents();
        this.setSize(new Dimension(200, 100));
        this.setPreferredSize(new Dimension(200, 100));
        this.dtListener = new DTListener();
        this.setDropTarget(new DropTarget(this, 2, new DTListener()));
        this.setBorder(null);
    }

    private JButton createButton(PanelView pv) {
        JButton jButton = new JButton();
        VTextIcon icon = new VTextIcon(this.jButton1, pv.getName(), this.getPosition() == 1 ? 2 : 4);
        jButton.setIcon(icon);
        jButton.setPreferredSize(new Dimension(20, icon.getIconHeight() + 28));
        jButton.setMinimumSize(new Dimension(20, icon.getIconHeight() + 28));
        jButton.setActionCommand(pv.getId() + "");
        jButton.addActionListener(this);
        return jButton;
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        try {
            PanelView pv = this.getPanelViewById(Integer.parseInt(s));
            pv.setMinimized(false);
            pv.setPosition(this.positions);
            this.recreateAll();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addPanel(String name, Component component, boolean closable) {
        this.insertPanel(this.positions, name, component, closable);
    }

    public boolean contains(Component c) {
        for (int i = 0; i < this.getPanelViews().size(); ++i) {
            PanelView pv = (PanelView)this.getPanelViews().elementAt(i);
            if (pv.getComponent() != c) continue;
            return true;
        }
        return false;
    }

    public PanelView getPanelView(Component c) {
        for (int i = 0; i < this.getPanelViews().size(); ++i) {
            PanelView pv = (PanelView)this.getPanelViews().elementAt(i);
            if (pv.getComponent() != c) continue;
            return pv;
        }
        return null;
    }

    public PanelView getPanelViewById(int id) {
        for (int i = 0; i < this.getPanelViews().size(); ++i) {
            PanelView pv = (PanelView)this.getPanelViews().elementAt(i);
            if (pv.getId() != id) continue;
            return pv;
        }
        return null;
    }

    public void insertPanel(int position, String name, Component component, int insertMode, boolean closable) {
        PanelView pv;
        int i;
        if (component == null) {
            return;
        }
        if (name == null) {
            name = "Panel";
        }
        for (i = 0; i < this.getPanelViews().size(); ++i) {
            pv = (PanelView)this.getPanelViews().elementAt(i);
            if (pv.getComponent() != component) continue;
            return;
        }
        if (position >= this.positions) {
            position = this.positions++;
        } else if (insertMode == 1) {
            for (i = 0; i < this.getPanelViews().size(); ++i) {
                pv = (PanelView)this.getPanelViews().elementAt(i);
                if (pv.getPosition() < position) continue;
                pv.setPosition(pv.getPosition() + 1);
            }
            ++this.positions;
        }
        this.panelViews.add(new PanelView(name, component, position, closable));
        this.recreateAll();
    }

    public void insertPanel(int position, String name, Component component, boolean closable) {
        this.insertPanel(position, name, component, 1, closable);
    }

    public void removePanel(Component component) {
        int position = -1;
        for (int i = 0; i < this.getPanelViews().size(); ++i) {
            PanelView pv = (PanelView)this.getPanelViews().elementAt(i);
            if (pv.getComponent() != component) continue;
            position = pv.getPosition();
            this.getPanelViews().remove(pv);
            break;
        }
        if (position >= 0) {
            PanelView pv;
            int i;
            boolean found = false;
            for (i = 0; i < this.getPanelViews().size(); ++i) {
                pv = (PanelView)this.getPanelViews().elementAt(i);
                if (pv.isMinimized() || pv.getPosition() != position) continue;
                found = true;
                break;
            }
            if (!found) {
                for (i = 0; i < this.getPanelViews().size(); ++i) {
                    pv = (PanelView)this.getPanelViews().elementAt(i);
                    if (pv.isMinimized() || pv.getPosition() <= position) continue;
                    pv.setPosition(pv.getPosition() - 1);
                }
                --this.positions;
            }
            this.recreateAll();
        }
        this.updateUI();
    }

    private void normalizePositions() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        int differentPositions = 0;
        for (int i = 0; i < this.getPanelViews().size(); ++i) {
            PanelView pv = (PanelView)this.getPanelViews().elementAt(i);
            if (pv.isMinimized()) continue;
            map.put(new Integer(pv.getPosition()), "");
        }
        differentPositions = map.size();
        for (int k = 0; k < differentPositions; ++k) {
            while (this.getPanelCount(k) == 0) {
                this.downPosition(k);
            }
        }
        this.positions = differentPositions;
    }

    private void downPosition(int minimumPosition) {
        for (int i = 0; i < this.getPanelViews().size(); ++i) {
            PanelView pv = (PanelView)this.getPanelViews().elementAt(i);
            if (pv.isMinimized() || pv.getPosition() <= minimumPosition) continue;
            pv.setPosition(pv.getPosition() - 1);
        }
    }

    public void moveComponent(PanelView panelView, int newPosition) {
        this.moveComponent(panelView, newPosition, 1);
    }

    public void moveComponent(PanelView panelView, int newPosition, int mode) {
        this.removePanel(panelView.getComponent());
        this.insertPanel(newPosition, panelView.getName(), panelView.getComponent(), mode, panelView.isClosable());
    }

    public void mergePosition(int newPosition) {
        if (this.positions == 1) {
            return;
        }
        if (newPosition >= this.positions) {
            return;
        }
        if (newPosition == 0 && this.positions > 1) {
            newPosition = 1;
        }
        for (int i = 0; i < this.getPanelViews().size(); ++i) {
            PanelView pv = (PanelView)this.getPanelViews().elementAt(i);
            if (pv.isMinimized() || pv.getPosition() < newPosition) continue;
            pv.setPosition(pv.getPosition() - 1);
        }
        --this.positions;
        this.recreateAll();
    }

    public void recreateAll() {
        this.removeAll();
        this.jPanel1.removeAll();
        int numPositions = this.positions;
        this.normalizePositions();
        if (this.positions > 0) {
            if (this.compressed) {
                this.compressed = false;
                this.setSize(this.getOldWidth(), 1);
            }
            this.tabPanes.removeAllElements();
            Vector tabbedPanes = new Vector();
            if (this.positions == 0) {
                return;
            }
            this.add(this.addComponents(0), "Center");
            this.updateUI();
        } else {
            this.compressed = true;
            this.setOldWidth(this.getSize().width);
            this.setSize(0, 1);
        }
        int minimizedButton = 0;
        for (int i = 0; i < this.getPanelViews().size(); ++i) {
            PanelView pv = (PanelView)this.getPanelViews().elementAt(i);
            if (!pv.isMinimized()) continue;
            JButton b = this.createButton(pv);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            this.jPanel1.add((Component)b, gridBagConstraints);
            ++minimizedButton;
        }
        if (minimizedButton > 0) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.jPanel1.add((Component)new JPanel(), gridBagConstraints);
            this.add((Component)this.jPanel1, this.getPosition() == 1 ? "West" : "East");
        }
        if (this.getParent() != null && this.getParent() instanceof JSplitPane) {
            JSplitPane sp = (JSplitPane)this.getParent();
            int currentWidth = this.realCurrentSize;
            if (this.positions == 0) {
                if (this.getPosition() == 1) {
                    sp.setDividerLocation(this.jPanel1.getWidth());
                } else {
                    this.setSize(new Dimension(24, 0));
                    sp.setDividerLocation((int)sp.getBounds().getWidth() - sp.getDividerSize() - 24);
                }
            } else {
                int width = currentWidth;
                if (width <= 174) {
                    width = 174;
                }
                if (this.getPosition() == 1) {
                    sp.setDividerLocation(width);
                } else {
                    sp.setDividerLocation(this.getPreferredDividerLocation() - (width - currentWidth));
                }
            }
            sp.updateUI();
        }
        this.updateUI();
    }

    public void setSelectedComponent(Component component) {
        for (int i = 0; i < this.tabPanes.size(); ++i) {
            JDraggableTabbedPane tab = (JDraggableTabbedPane)this.tabPanes.get(i);
            try {
                tab.setSelectedComponent(component);
                break;
            }
            catch (Exception ex) {
                continue;
            }
        }
    }

    public Component addComponents(int pos) {
        JDraggableTabbedPane jTabbedPane = new JDraggableTabbedPane();
        jTabbedPane.setPosition(pos);
        jTabbedPane.setOrientation(this.getPosition());
        jTabbedPane.setDockingContainer(this);
        jTabbedPane.addTabPaneChangedListener(this);
        this.tabPanes.add(jTabbedPane);
        for (int i = 0; i < this.getPanelViews().size(); ++i) {
            PanelView pv = (PanelView)this.getPanelViews().elementAt(i);
            if (pv.isMinimized() || pv.getPosition() != pos) continue;
            jTabbedPane.addTab(pv.getName(), pv.getComponent(), pv.isClosable());
        }
        if (pos < this.positions - 1) {
            JSplitPane jSplitPane = new JSplitPane();
            jSplitPane.setOrientation(0);
            jSplitPane.setBorder(null);
            jSplitPane.setResizeWeight(1.0 / (double)(this.positions - pos));
            jSplitPane.setLeftComponent(jTabbedPane);
            jSplitPane.setRightComponent(this.addComponents(pos + 1));
            jSplitPane.setDividerSize(5);
            return jSplitPane;
        }
        return jTabbedPane;
    }

    public Vector getPanelViews() {
        return this.panelViews;
    }

    public int getPanelCount(int position) {
        int p_number = 0;
        for (int i = 0; i < this.getPanelViews().size(); ++i) {
            PanelView pv = (PanelView)this.getPanelViews().elementAt(i);
            if (pv.isMinimized() || pv.getPosition() != position) continue;
            ++p_number;
        }
        return p_number;
    }

    public void setPanelViews(Vector panelViews) {
        this.panelViews = panelViews;
    }

    public int getOldWidth() {
        return this.oldWidth;
    }

    public void setOldWidth(int oldWidth) {
        this.oldWidth = oldWidth;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.setLayout(new BorderLayout());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                DockingContainer.this.formComponentResized(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setPreferredSize(new Dimension(24, 10));
        this.jButton1.setBorder(null);
        this.jButton1.setBorderPainted(false);
        this.jButton1.setFocusPainted(false);
        this.jButton1.setFocusable(false);
        this.jButton1.setMaximumSize(new Dimension(33, 500));
        this.jButton1.setMinimumSize(new Dimension(33, 100));
        this.jButton1.setPreferredSize(new Dimension(33, 100));
        this.jButton1.setRequestFocusEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.add((Component)this.jPanel1, "West");
    }

    private void formComponentResized(ComponentEvent evt) {
        this.realCurrentSize = (int)evt.getComponent().getSize().getWidth();
    }

    public void tabPaneChanged(TabPaneChangedEvent evt) {
        if (evt.getOperation() == 1) {
            this.removePanel(evt.getTabComponent());
        } else if (evt.getOperation() == 0) {
            PanelView pv = this.getPanelView(evt.getTabComponent());
            pv.setMinimized(true);
            this.recreateAll();
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPreferredDividerLocation() {
        return this.preferredDividerLocation;
    }

    public void setPreferredDividerLocation(int preferredDividerLocation) {
        this.preferredDividerLocation = preferredDividerLocation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DTListener
    implements DropTargetListener {
        DTListener() {
        }

        public void dragEnter(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        public void dragOver(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void drop(DropTargetDropEvent dtde) {
            try {
                DropTargetContext context = dtde.getDropTargetContext();
                Transferable tr = dtde.getTransferable();
                DataFlavor[] df = tr.getTransferDataFlavors();
                if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.gui.docking.PanelView")) {
                    DataFlavor myFlavor = new DataFlavor(class$it$businesslogic$ireport$gui$docking$PanelView == null ? (class$it$businesslogic$ireport$gui$docking$PanelView = DockingContainer.class$("it.businesslogic.ireport.gui.docking.PanelView")) : class$it$businesslogic$ireport$gui$docking$PanelView, (class$it$businesslogic$ireport$gui$docking$PanelView == null ? (class$it$businesslogic$ireport$gui$docking$PanelView = DockingContainer.class$("it.businesslogic.ireport.gui.docking.PanelView")) : class$it$businesslogic$ireport$gui$docking$PanelView).getName());
                    PanelView panelView = (PanelView)tr.getTransferData(myFlavor);
                    if (DockingContainer.this != null && panelView.getDockingContainer() != DockingContainer.this) {
                        panelView.getDockingContainer().removePanel(panelView.getComponent());
                        DockingContainer.this.insertPanel(0, panelView.getName(), panelView.getComponent(), panelView.isClosable());
                    }
                }
                context.dropComplete(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

