/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.JDragTable;
import it.businesslogic.ireport.gui.JRFieldDialog;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.gui.JRVariableDialog;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedEvent;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableModel;

public class ValuesPanel
extends JPanel {
    private Vector clipboardFields = null;
    private Vector clipboardVariables = null;
    private Vector clipboardParameters = null;
    private SubDataset subDataset;
    private JButton jButtonDeleteField;
    private JButton jButtonDeleteParameter;
    private JButton jButtonDeleteVariable;
    private JButton jButtonModifyField;
    private JButton jButtonModifyParameter;
    private JButton jButtonModifyVariable;
    private JButton jButtonNewField;
    private JButton jButtonNewParameter;
    private JButton jButtonNewVariable;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemCopy1;
    private JMenuItem jMenuItemCopy2;
    private JMenuItem jMenuItemCut;
    private JMenuItem jMenuItemCut1;
    private JMenuItem jMenuItemCut2;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemDelete1;
    private JMenuItem jMenuItemDelete2;
    private JMenuItem jMenuItemDuplicate;
    private JMenuItem jMenuItemDuplicate1;
    private JMenuItem jMenuItemDuplicate2;
    private JMenuItem jMenuItemPaste;
    private JMenuItem jMenuItemPaste1;
    private JMenuItem jMenuItemPaste2;
    private JPanel jPanelButtons;
    private JPanel jPanelButtons1;
    private JPanel jPanelButtons2;
    private JPanel jPanelFields;
    private JPanel jPanelParameters;
    private JPanel jPanelVariables;
    private JPopupMenu jPopupMenuFields;
    private JPopupMenu jPopupMenuParameters;
    private JPopupMenu jPopupMenuVariables;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane;
    private JDragTable jTableFields;
    private JDragTable jTableParameters;
    private JDragTable jTableVariables;

    public ValuesPanel() {
        this.initComponents();
        this.setClipboardFields(new Vector());
        this.setClipboardVariables(new Vector());
        this.setClipboardParameters(new Vector());
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableParameters.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ValuesPanel.this.jTableParametersListSelectionValueChanged(e);
            }
        });
        dlsm = (DefaultListSelectionModel)this.jTableVariables.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ValuesPanel.this.jTableVariablesListSelectionValueChanged(e);
            }
        });
        dlsm = (DefaultListSelectionModel)this.jTableFields.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ValuesPanel.this.jTableFieldsListSelectionValueChanged(e);
            }
        });
        this.applyI18n();
    }

    public void jTableParametersListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableParameters.getSelectedRowCount() > 0) {
            this.jButtonModifyParameter.setEnabled(true);
            this.jButtonDeleteParameter.setEnabled(true);
            int[] rows = this.jTableParameters.getSelectedRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                if (!((JRParameter)this.jTableParameters.getValueAt(rows[i], 0)).isBuiltin()) continue;
                this.jButtonModifyParameter.setEnabled(false);
                this.jButtonDeleteParameter.setEnabled(false);
            }
        } else {
            this.jButtonModifyParameter.setEnabled(false);
            this.jButtonDeleteParameter.setEnabled(false);
        }
    }

    public void jTableVariablesListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableVariables.getSelectedRowCount() > 0) {
            this.jButtonModifyVariable.setEnabled(true);
            this.jButtonDeleteVariable.setEnabled(true);
            int[] rows = this.jTableVariables.getSelectedRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                if (!((JRVariable)this.jTableVariables.getValueAt(rows[i], 0)).isBuiltin()) continue;
                this.jButtonModifyVariable.setEnabled(false);
                this.jButtonDeleteVariable.setEnabled(false);
            }
        } else {
            this.jButtonModifyVariable.setEnabled(false);
            this.jButtonDeleteVariable.setEnabled(false);
        }
    }

    public void jTableFieldsListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableFields.getSelectedRowCount() > 0) {
            this.jButtonModifyField.setEnabled(true);
            this.jButtonDeleteField.setEnabled(true);
        } else {
            this.jButtonModifyField.setEnabled(false);
            this.jButtonDeleteField.setEnabled(false);
        }
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
        if (subDataset != null) {
            this.updateParameters();
            this.updateFields();
            this.updateVariables();
        }
    }

    private void initComponents() {
        this.jPopupMenuFields = new JPopupMenu();
        this.jMenuItemCut = new JMenuItem();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemPaste = new JMenuItem();
        this.jMenuItemDelete = new JMenuItem();
        this.jMenuItemDuplicate = new JMenuItem();
        this.jPopupMenuVariables = new JPopupMenu();
        this.jMenuItemCut1 = new JMenuItem();
        this.jMenuItemCopy1 = new JMenuItem();
        this.jMenuItemPaste1 = new JMenuItem();
        this.jMenuItemDelete1 = new JMenuItem();
        this.jMenuItemDuplicate1 = new JMenuItem();
        this.jPopupMenuParameters = new JPopupMenu();
        this.jMenuItemCut2 = new JMenuItem();
        this.jMenuItemCopy2 = new JMenuItem();
        this.jMenuItemPaste2 = new JMenuItem();
        this.jMenuItemDelete2 = new JMenuItem();
        this.jMenuItemDuplicate2 = new JMenuItem();
        this.jTabbedPane = new JTabbedPane();
        this.jPanelFields = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTableFields = new JDragTable();
        this.jPanelButtons2 = new JPanel();
        this.jButtonNewField = new JButton();
        this.jButtonModifyField = new JButton();
        this.jButtonDeleteField = new JButton();
        this.jPanelVariables = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTableVariables = new JDragTable();
        this.jPanelButtons1 = new JPanel();
        this.jButtonNewVariable = new JButton();
        this.jButtonModifyVariable = new JButton();
        this.jButtonDeleteVariable = new JButton();
        this.jPanelParameters = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableParameters = new JDragTable();
        this.jPanelButtons = new JPanel();
        this.jButtonNewParameter = new JButton();
        this.jButtonModifyParameter = new JButton();
        this.jButtonDeleteParameter = new JButton();
        this.jPopupMenuFields.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                ValuesPanel.this.jPopupMenuFieldsPopupMenuWillBecomeVisible(evt);
            }
        });
        this.jMenuItemCut.setText("Item");
        this.jMenuItemCut.setActionCommand("Item");
        this.jMenuItemCut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jMenuItemCutActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemCut);
        this.jMenuItemCopy.setText("Item");
        this.jMenuItemCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemCopy);
        this.jMenuItemPaste.setText("Item");
        this.jMenuItemPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jMenuItemPasteActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemPaste);
        this.jMenuItemDelete.setText("Item");
        this.jMenuItemDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemDelete);
        this.jMenuItemDuplicate.setText("Item");
        this.jMenuItemDuplicate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jMenuItemDuplicateActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemDuplicate);
        this.jPopupMenuVariables.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                ValuesPanel.this.jPopupMenuVariablesPopupMenuWillBecomeVisible(evt);
            }
        });
        this.jMenuItemCut1.setText("Item");
        this.jMenuItemCut1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jMenuItemCut1ActionPerformed(evt);
            }
        });
        this.jPopupMenuVariables.add(this.jMenuItemCut1);
        this.jMenuItemCopy1.setText("Item");
        this.jMenuItemCopy1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jMenuItemCopy1ActionPerformed(evt);
            }
        });
        this.jPopupMenuVariables.add(this.jMenuItemCopy1);
        this.jMenuItemPaste1.setText("Item");
        this.jMenuItemPaste1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jMenuItemPaste1ActionPerformed(evt);
            }
        });
        this.jPopupMenuVariables.add(this.jMenuItemPaste1);
        this.jMenuItemDelete1.setText("Item");
        this.jMenuItemDelete1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jMenuItemDelete1ActionPerformed(evt);
            }
        });
        this.jPopupMenuVariables.add(this.jMenuItemDelete1);
        this.jMenuItemDuplicate1.setText("Item");
        this.jMenuItemDuplicate1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jMenuItemDuplicate1ActionPerformed(evt);
            }
        });
        this.jPopupMenuVariables.add(this.jMenuItemDuplicate1);
        this.jPopupMenuParameters.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                ValuesPanel.this.jPopupMenuParametersPopupMenuWillBecomeVisible(evt);
            }
        });
        this.jMenuItemCut2.setText("Item");
        this.jMenuItemCut2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jMenuItemCut2ActionPerformed(evt);
            }
        });
        this.jPopupMenuParameters.add(this.jMenuItemCut2);
        this.jMenuItemCopy2.setText("Item");
        this.jMenuItemCopy2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jMenuItemCopy2ActionPerformed(evt);
            }
        });
        this.jPopupMenuParameters.add(this.jMenuItemCopy2);
        this.jMenuItemPaste2.setText("Item");
        this.jMenuItemPaste2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jMenuItemPaste2ActionPerformed(evt);
            }
        });
        this.jPopupMenuParameters.add(this.jMenuItemPaste2);
        this.jMenuItemDelete2.setText("Item");
        this.jMenuItemDelete2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jMenuItemDelete2ActionPerformed(evt);
            }
        });
        this.jPopupMenuParameters.add(this.jMenuItemDelete2);
        this.jMenuItemDuplicate2.setText("Item");
        this.jMenuItemDuplicate2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jMenuItemDuplicate2ActionPerformed(evt);
            }
        });
        this.jPopupMenuParameters.add(this.jMenuItemDuplicate2);
        this.setLayout(new BorderLayout());
        this.jTabbedPane.setName("");
        this.jPanelFields.setLayout(new GridBagLayout());
        this.jScrollPane3.setBackground(new Color(255, 255, 255));
        this.jScrollPane3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ValuesPanel.this.jScrollPane3MouseClicked(evt);
            }
        });
        this.jTableFields.setModel(new DefaultTableModel(new Object[0][], new String[]{"Field name", "Class type"}){
            boolean[] canEdit = new boolean[]{false, false};

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableFields.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ValuesPanel.this.jTableFieldsMouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jTableFields);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanelFields.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jPanelButtons2.setLayout(null);
        this.jPanelButtons2.setMinimumSize(new Dimension(100, 100));
        this.jPanelButtons2.setOpaque(false);
        this.jPanelButtons2.setPreferredSize(new Dimension(100, 100));
        this.jButtonNewField.setText("New");
        this.jButtonNewField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jButtonNewFieldActionPerformed(evt);
            }
        });
        this.jPanelButtons2.add(this.jButtonNewField);
        this.jButtonNewField.setBounds(4, 5, 92, 22);
        this.jButtonModifyField.setText("Modify");
        this.jButtonModifyField.setEnabled(false);
        this.jButtonModifyField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jButtonModifyFieldActionPerformed(evt);
            }
        });
        this.jPanelButtons2.add(this.jButtonModifyField);
        this.jButtonModifyField.setBounds(4, 30, 92, 22);
        this.jButtonDeleteField.setText("Delete");
        this.jButtonDeleteField.setEnabled(false);
        this.jButtonDeleteField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jButtonDeleteFieldActionPerformed(evt);
            }
        });
        this.jPanelButtons2.add(this.jButtonDeleteField);
        this.jButtonDeleteField.setBounds(4, 56, 92, 22);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanelFields.add((Component)this.jPanelButtons2, gridBagConstraints);
        this.jTabbedPane.addTab("Fields", this.jPanelFields);
        this.jPanelVariables.setLayout(new GridBagLayout());
        this.jScrollPane2.setBackground(new Color(255, 255, 255));
        this.jScrollPane2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ValuesPanel.this.jScrollPane2MouseClicked(evt);
            }
        });
        this.jTableVariables.setModel(new DefaultTableModel(new Object[0][], new String[]{"Variable name", "Builtin"}){
            boolean[] canEdit = new boolean[]{false, false};

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableVariables.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ValuesPanel.this.jTableVariablesMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableVariables);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanelVariables.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanelButtons1.setLayout(null);
        this.jPanelButtons1.setMinimumSize(new Dimension(100, 100));
        this.jPanelButtons1.setPreferredSize(new Dimension(100, 100));
        this.jButtonNewVariable.setText("New");
        this.jButtonNewVariable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jButtonNewVariableActionPerformed(evt);
            }
        });
        this.jPanelButtons1.add(this.jButtonNewVariable);
        this.jButtonNewVariable.setBounds(4, 5, 92, 22);
        this.jButtonModifyVariable.setText("Modify");
        this.jButtonModifyVariable.setEnabled(false);
        this.jButtonModifyVariable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jButtonModifyVariableActionPerformed(evt);
            }
        });
        this.jPanelButtons1.add(this.jButtonModifyVariable);
        this.jButtonModifyVariable.setBounds(4, 30, 92, 22);
        this.jButtonDeleteVariable.setText("Delete");
        this.jButtonDeleteVariable.setEnabled(false);
        this.jButtonDeleteVariable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jButtonDeleteVariableActionPerformed(evt);
            }
        });
        this.jPanelButtons1.add(this.jButtonDeleteVariable);
        this.jButtonDeleteVariable.setBounds(4, 56, 92, 22);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanelVariables.add((Component)this.jPanelButtons1, gridBagConstraints);
        this.jTabbedPane.addTab("Variables", this.jPanelVariables);
        this.jPanelParameters.setLayout(new GridBagLayout());
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ValuesPanel.this.jScrollPane1MouseClicked(evt);
            }
        });
        this.jTableParameters.setModel(new DefaultTableModel(new Object[0][], new String[]{"Parameter name", "Class type", "Is for prompting", "Built-in"}){
            boolean[] canEdit = new boolean[]{false, false, false, false};

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableParameters.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ValuesPanel.this.jTableParametersMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableParameters);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanelParameters.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanelButtons.setLayout(null);
        this.jPanelButtons.setMinimumSize(new Dimension(100, 100));
        this.jPanelButtons.setPreferredSize(new Dimension(100, 100));
        this.jButtonNewParameter.setText("New");
        this.jButtonNewParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jButtonNewParameterActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonNewParameter);
        this.jButtonNewParameter.setBounds(4, 5, 92, 22);
        this.jButtonModifyParameter.setText("Modify");
        this.jButtonModifyParameter.setEnabled(false);
        this.jButtonModifyParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jButtonModifyParameterActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonModifyParameter);
        this.jButtonModifyParameter.setBounds(4, 30, 92, 22);
        this.jButtonDeleteParameter.setText("Delete");
        this.jButtonDeleteParameter.setEnabled(false);
        this.jButtonDeleteParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValuesPanel.this.jButtonDeleteParameterActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonDeleteParameter);
        this.jButtonDeleteParameter.setBounds(4, 56, 92, 22);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanelParameters.add((Component)this.jPanelButtons, gridBagConstraints);
        this.jTabbedPane.addTab("Parameters", this.jPanelParameters);
        this.add((Component)this.jTabbedPane, "Center");
    }

    private void jButtonDeleteFieldActionPerformed(ActionEvent evt) {
        this.jTableFields.getSelectedRows();
        int[] rows = this.jTableFields.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            this.getSubDataset().removeField((JRField)this.jTableFields.getValueAt(rows[i], 0));
        }
    }

    private void jPopupMenuParametersPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        if (this.getClipboardParameters().size() > 0) {
            this.jMenuItemPaste2.setEnabled(true);
        } else {
            this.jMenuItemPaste2.setEnabled(false);
        }
        if (this.jTableParameters.getSelectedRowCount() > 0) {
            this.jMenuItemCut2.setEnabled(true);
            this.jMenuItemCopy2.setEnabled(true);
            this.jMenuItemDelete2.setEnabled(true);
            this.jMenuItemDuplicate2.setEnabled(true);
        } else {
            this.jMenuItemCut2.setEnabled(false);
            this.jMenuItemCopy2.setEnabled(false);
            this.jMenuItemDelete2.setEnabled(false);
            this.jMenuItemDuplicate2.setEnabled(false);
        }
    }

    private void jPopupMenuVariablesPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        if (this.getClipboardVariables().size() > 0) {
            this.jMenuItemPaste1.setEnabled(true);
        } else {
            this.jMenuItemPaste1.setEnabled(false);
        }
        if (this.jTableVariables.getSelectedRowCount() > 0) {
            this.jMenuItemCut1.setEnabled(true);
            this.jMenuItemCopy1.setEnabled(true);
            this.jMenuItemDelete1.setEnabled(true);
            this.jMenuItemDuplicate1.setEnabled(true);
        } else {
            this.jMenuItemCut1.setEnabled(false);
            this.jMenuItemCopy1.setEnabled(false);
            this.jMenuItemDelete1.setEnabled(false);
            this.jMenuItemDuplicate1.setEnabled(false);
        }
    }

    private void jPopupMenuFieldsPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        if (this.getClipboardFields().size() > 0) {
            this.jMenuItemPaste.setEnabled(true);
        } else {
            this.jMenuItemPaste.setEnabled(false);
        }
        if (this.jTableFields.getSelectedRowCount() > 0) {
            this.jMenuItemCut.setEnabled(true);
            this.jMenuItemCopy.setEnabled(true);
            this.jMenuItemDelete.setEnabled(true);
            this.jMenuItemDuplicate.setEnabled(true);
        } else {
            this.jMenuItemCut.setEnabled(false);
            this.jMenuItemCopy.setEnabled(false);
            this.jMenuItemDelete.setEnabled(false);
            this.jMenuItemDuplicate.setEnabled(false);
        }
    }

    private void jMenuItemDuplicate2ActionPerformed(ActionEvent evt) {
        Vector<JRParameter> selectedParameters = new Vector<JRParameter>();
        this.jTableParameters.getSelectedRows();
        int[] rows = this.jTableParameters.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            selectedParameters.add(((JRParameter)this.jTableParameters.getValueAt(rows[i], 0)).cloneMe());
        }
        this.duplicateParameters(selectedParameters);
    }

    private void jMenuItemDelete2ActionPerformed(ActionEvent evt) {
        this.jButtonDeleteParameterActionPerformed(evt);
    }

    private void jMenuItemPaste2ActionPerformed(ActionEvent evt) {
        this.duplicateParameters(this.getClipboardParameters());
    }

    private void jMenuItemCopy2ActionPerformed(ActionEvent evt) {
        this.jTableParameters.getSelectedRows();
        int[] rows = this.jTableParameters.getSelectedRows();
        this.getClipboardParameters().removeAllElements();
        for (int i = rows.length - 1; i >= 0; --i) {
            JRParameter parameter = ((JRParameter)this.jTableParameters.getValueAt(rows[i], 0)).cloneMe();
            if (parameter.isBuiltin()) continue;
            this.getClipboardParameters().add(parameter);
        }
    }

    private void jMenuItemCut2ActionPerformed(ActionEvent evt) {
        this.jTableParameters.getSelectedRows();
        int[] rows = this.jTableParameters.getSelectedRows();
        this.getClipboardParameters().removeAllElements();
        for (int i = rows.length - 1; i >= 0; --i) {
            JRParameter parameter = ((JRParameter)this.jTableParameters.getValueAt(rows[i], 0)).cloneMe();
            if (parameter.isBuiltin()) continue;
            this.getClipboardParameters().add(parameter);
        }
        this.jButtonDeleteParameterActionPerformed(evt);
    }

    private void jMenuItemDuplicate1ActionPerformed(ActionEvent evt) {
        Vector<JRVariable> selectedVariables = new Vector<JRVariable>();
        this.jTableVariables.getSelectedRows();
        int[] rows = this.jTableVariables.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            selectedVariables.add(((JRVariable)this.jTableVariables.getValueAt(rows[i], 0)).cloneMe());
        }
        this.duplicateVariables(selectedVariables);
    }

    private void jMenuItemDelete1ActionPerformed(ActionEvent evt) {
        this.jButtonDeleteVariableActionPerformed(evt);
    }

    private void jMenuItemPaste1ActionPerformed(ActionEvent evt) {
        this.duplicateVariables(this.getClipboardVariables());
    }

    private void jMenuItemCopy1ActionPerformed(ActionEvent evt) {
        this.jTableVariables.getSelectedRows();
        int[] rows = this.jTableVariables.getSelectedRows();
        this.getClipboardVariables().removeAllElements();
        for (int i = rows.length - 1; i >= 0; --i) {
            JRVariable variable = ((JRVariable)this.jTableVariables.getValueAt(rows[i], 0)).cloneMe();
            if (variable.isBuiltin()) continue;
            this.getClipboardVariables().add(variable);
        }
    }

    private void jMenuItemCut1ActionPerformed(ActionEvent evt) {
        this.jTableVariables.getSelectedRows();
        int[] rows = this.jTableVariables.getSelectedRows();
        this.getClipboardVariables().removeAllElements();
        for (int i = rows.length - 1; i >= 0; --i) {
            JRVariable variable = ((JRVariable)this.jTableVariables.getValueAt(rows[i], 0)).cloneMe();
            if (variable.isBuiltin()) continue;
            this.getClipboardVariables().add(variable);
        }
        this.jButtonDeleteVariableActionPerformed(evt);
    }

    private void jMenuItemDuplicateActionPerformed(ActionEvent evt) {
        Vector<JRField> selectedFields = new Vector<JRField>();
        this.jTableFields.getSelectedRows();
        int[] rows = this.jTableFields.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            selectedFields.add(((JRField)this.jTableFields.getValueAt(rows[i], 0)).cloneMe());
        }
        this.duplicateFields(selectedFields);
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        this.jButtonDeleteFieldActionPerformed(evt);
    }

    private void jMenuItemPasteActionPerformed(ActionEvent evt) {
        this.duplicateFields(this.getClipboardFields());
    }

    private void jMenuItemCopyActionPerformed(ActionEvent evt) {
        this.jTableFields.getSelectedRows();
        int[] rows = this.jTableFields.getSelectedRows();
        this.getClipboardFields().removeAllElements();
        for (int i = rows.length - 1; i >= 0; --i) {
            this.getClipboardFields().add(((JRField)this.jTableFields.getValueAt(rows[i], 0)).cloneMe());
        }
    }

    private void jMenuItemCutActionPerformed(ActionEvent evt) {
        this.jTableFields.getSelectedRows();
        int[] rows = this.jTableFields.getSelectedRows();
        this.getClipboardFields().removeAllElements();
        for (int i = rows.length - 1; i >= 0; --i) {
            this.getClipboardFields().add(((JRField)this.jTableFields.getValueAt(rows[i], 0)).cloneMe());
        }
        this.jButtonDeleteFieldActionPerformed(evt);
    }

    private void jTableParametersMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1 && this.jTableParameters.getSelectedRow() >= 0) {
                this.jButtonModifyParameterActionPerformed(new ActionEvent(this.jButtonModifyParameter, 0, ""));
            }
        }
        if (evt.getClickCount() == 1) {
            if (evt.getButton() == 3) {
                this.jScrollPane1MouseClicked(evt);
            }
        }
    }

    private void jTableVariablesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1 && this.jTableVariables.getSelectedRow() >= 0) {
                this.jButtonModifyVariableActionPerformed(new ActionEvent(this.jButtonModifyVariable, 0, ""));
            }
        }
        if (evt.getClickCount() == 1) {
            if (evt.getButton() == 3) {
                this.jScrollPane2MouseClicked(evt);
            }
        }
    }

    private void jTableFieldsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1 && this.jTableFields.getSelectedRow() >= 0) {
                this.jButtonModifyFieldActionPerformed(new ActionEvent(this.jButtonModifyField, 0, ""));
            }
        }
        if (evt.getClickCount() == 1) {
            if (evt.getButton() == 3) {
                this.jScrollPane3MouseClicked(evt);
            }
        }
    }

    private void jScrollPane1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            if (evt.getButton() == 3) {
                this.jPopupMenuParameters.show(this.jScrollPane1, evt.getPoint().x, evt.getPoint().y);
            }
        }
    }

    private void jScrollPane2MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            if (evt.getButton() == 3) {
                this.jPopupMenuVariables.show(this.jScrollPane2, evt.getPoint().x, evt.getPoint().y);
            }
        }
    }

    private void jScrollPane3MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            if (evt.getButton() == 3) {
                this.jPopupMenuFields.show(this.jScrollPane3, evt.getPoint().x, evt.getPoint().y);
            }
        }
    }

    private void jButtonDeleteParameterActionPerformed(ActionEvent evt) {
        this.jTableParameters.getSelectedRows();
        int[] rows = this.jTableParameters.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            JRParameter parameter = (JRParameter)this.jTableParameters.getValueAt(rows[i], 0);
            if (parameter.isBuiltin()) {
                JOptionPane.showMessageDialog(this, "You can't modify or delete builtin parameters!", "Invalid operation!", 2);
                return;
            }
            this.getSubDataset().removeParameter(parameter);
        }
    }

    private void jButtonModifyParameterActionPerformed(ActionEvent evt) {
        JRParameter parameter = (JRParameter)this.jTableParameters.getValueAt(this.jTableParameters.getSelectedRow(), 0);
        this.modifyParameter(parameter);
    }

    private void jButtonNewParameterActionPerformed(ActionEvent evt) {
        this.newParameter();
    }

    private void jButtonDeleteVariableActionPerformed(ActionEvent evt) {
        this.jTableVariables.getSelectedRows();
        int[] rows = this.jTableVariables.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            if (((JRVariable)this.jTableVariables.getValueAt(rows[i], 0)).isBuiltin()) continue;
            this.getSubDataset().removeVariable((JRVariable)this.jTableVariables.getValueAt(rows[i], 0));
        }
    }

    private void jButtonModifyVariableActionPerformed(ActionEvent evt) {
        JRVariable variable = (JRVariable)this.jTableVariables.getValueAt(this.jTableVariables.getSelectedRow(), 0);
        this.modifyVariable(variable);
    }

    private void jButtonNewVariableActionPerformed(ActionEvent evt) {
        this.newVariable();
    }

    private void jButtonModifyFieldActionPerformed(ActionEvent evt) {
        JRField field = (JRField)this.jTableFields.getValueAt(this.jTableFields.getSelectedRow(), 0);
        this.modifyField(field);
    }

    private void jButtonNewFieldActionPerformed(ActionEvent evt) {
        this.newField();
    }

    public void updateFields() {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        dtm.setRowCount(0);
        if (this.getSubDataset() == null) {
            return;
        }
        Enumeration e = this.sortFieldsByName(this.getSubDataset().getFields()).elements();
        while (e.hasMoreElements()) {
            JRField field = (JRField)e.nextElement();
            Vector<Object> row = new Vector<Object>();
            row.addElement(field);
            row.addElement(field.getClassType());
            dtm.addRow(row);
        }
    }

    public void updateVariables() {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableVariables.getModel();
        dtm.setRowCount(0);
        if (this.getSubDataset() == null) {
            return;
        }
        Enumeration e = this.sortVariablesByName(this.getSubDataset().getVariables()).elements();
        while (e.hasMoreElements()) {
            JRVariable variable = (JRVariable)e.nextElement();
            Vector<Object> row = new Vector<Object>();
            row.addElement(variable);
            row.addElement(variable.isBuiltin() ? "yes" : "no");
            dtm.addRow(row);
        }
    }

    public void updateParameters() {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
        dtm.setRowCount(0);
        if (this.getSubDataset() == null) {
            return;
        }
        Enumeration e = this.sortParametersByName(this.getSubDataset().getParameters()).elements();
        while (e.hasMoreElements()) {
            JRParameter parameter = (JRParameter)e.nextElement();
            Vector<Object> row = new Vector<Object>();
            row.addElement(parameter);
            row.addElement(parameter.getClassType());
            row.addElement(parameter.isIsForPrompting() ? "yes" : "no");
            row.addElement(parameter.isBuiltin() ? "yes" : "no");
            dtm.addRow(row);
        }
    }

    public void applyI18n() {
        this.jButtonNewField.setText(I18n.getString("new", "New"));
        this.jButtonModifyField.setText(I18n.getString("modify", "Modify"));
        this.jButtonDeleteField.setText(I18n.getString("delete", "Delete"));
        this.jButtonNewVariable.setText(I18n.getString("new", "New"));
        this.jButtonModifyVariable.setText(I18n.getString("modify", "Modify"));
        this.jButtonDeleteVariable.setText(I18n.getString("delete", "Delete"));
        this.jButtonNewParameter.setText(I18n.getString("new", "New"));
        this.jButtonModifyParameter.setText(I18n.getString("modify", "Modify"));
        this.jButtonDeleteParameter.setText(I18n.getString("delete", "Delete"));
        this.jMenuItemCut.setText(I18n.getString("cut", "Cut"));
        this.jMenuItemCopy.setText(I18n.getString("copy", "Copy"));
        this.jMenuItemPaste.setText(I18n.getString("paste", "Paste"));
        this.jMenuItemDelete.setText(I18n.getString("delete", "Delete"));
        this.jMenuItemDuplicate.setText(I18n.getString("duplicate", "Duplicate"));
        this.jMenuItemCut1.setText(I18n.getString("cut", "Cut"));
        this.jMenuItemCopy1.setText(I18n.getString("copy", "Copy"));
        this.jMenuItemPaste1.setText(I18n.getString("paste", "Paste"));
        this.jMenuItemDelete1.setText(I18n.getString("delete", "Delete"));
        this.jMenuItemDuplicate1.setText(I18n.getString("duplicate", "Duplicate"));
        this.jMenuItemCut2.setText(I18n.getString("cut", "Cut"));
        this.jMenuItemCopy2.setText(I18n.getString("copy", "Copy"));
        this.jMenuItemPaste2.setText(I18n.getString("paste", "Paste"));
        this.jMenuItemDelete2.setText(I18n.getString("delete", "Delete"));
        this.jMenuItemDuplicate2.setText(I18n.getString("duplicate", "Duplicate"));
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    private Vector sortFieldsByName(Vector vector) {
        Vector<JRField> myElements = new Vector<JRField>();
        Enumeration enum2 = vector.elements();
        while (enum2.hasMoreElements()) {
            JRField elem = (JRField)enum2.nextElement();
            if (myElements.size() == 0) {
                myElements.add(elem);
                continue;
            }
            boolean inserted = false;
            for (int i = 0; i < myElements.size(); ++i) {
                JRField elem2 = (JRField)myElements.elementAt(i);
                if (elem.getName().compareTo(elem2.getName()) >= 0) continue;
                myElements.insertElementAt(elem, i);
                inserted = true;
                break;
            }
            if (inserted) continue;
            myElements.addElement(elem);
        }
        return myElements;
    }

    private Vector sortVariablesByName(Vector vector) {
        Vector<JRVariable> myElements = new Vector<JRVariable>();
        Enumeration enum2 = vector.elements();
        while (enum2.hasMoreElements()) {
            JRVariable elem = (JRVariable)enum2.nextElement();
            if (myElements.size() == 0) {
                myElements.add(elem);
                continue;
            }
            boolean inserted = false;
            for (int i = 0; i < myElements.size(); ++i) {
                JRVariable elem2 = (JRVariable)myElements.elementAt(i);
                if (elem.isBuiltin()) {
                    if (elem.isBuiltin() != elem2.isBuiltin() || elem.getName().compareTo(elem2.getName()) >= 0) continue;
                    myElements.insertElementAt(elem, i);
                    inserted = true;
                    break;
                }
                if (elem.isBuiltin() != elem2.isBuiltin() || elem.getName().compareTo(elem2.getName()) >= 0) continue;
                myElements.insertElementAt(elem, i);
                inserted = true;
                break;
            }
            if (inserted) continue;
            myElements.addElement(elem);
        }
        return myElements;
    }

    private Vector sortParametersByName(Vector vector) {
        Vector<JRParameter> myElements = new Vector<JRParameter>();
        Enumeration enum2 = vector.elements();
        while (enum2.hasMoreElements()) {
            JRParameter elem = (JRParameter)enum2.nextElement();
            if (myElements.size() == 0) {
                myElements.add(elem);
                continue;
            }
            boolean inserted = false;
            for (int i = 0; i < myElements.size(); ++i) {
                JRParameter elem2 = (JRParameter)myElements.elementAt(i);
                if (elem.isBuiltin()) {
                    if (elem.isBuiltin() != elem2.isBuiltin() || elem.getName().compareTo(elem2.getName()) >= 0) continue;
                    myElements.insertElementAt(elem, i);
                    inserted = true;
                    break;
                }
                if (elem.isBuiltin() != elem2.isBuiltin() || elem.getName().compareTo(elem2.getName()) >= 0) continue;
                myElements.insertElementAt(elem, i);
                inserted = true;
                break;
            }
            if (inserted) continue;
            myElements.addElement(elem);
        }
        return myElements;
    }

    public void modifyErrorParameter(JRParameter p) {
        this.jTabbedPane.setSelectedComponent(this.jPanelParameters);
        DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            if (dtm.getValueAt(i, 0) != p) continue;
            this.jTableParameters.setRowSelectionInterval(i, i);
            this.jButtonModifyParameterActionPerformed(new ActionEvent(this.jButtonModifyParameter, 0, this.jButtonModifyParameter.getName()));
            return;
        }
    }

    public void gotoTab(String tab) {
        if (tab.equals("Parameters")) {
            this.jTabbedPane.setSelectedIndex(2);
        } else if (tab.equals("Fields")) {
            this.jTabbedPane.setSelectedIndex(0);
        } else if (tab.equals("Variables")) {
            this.jTabbedPane.setSelectedIndex(1);
        }
    }

    public Vector getClipboardFields() {
        return this.clipboardFields;
    }

    public void setClipboardFields(Vector clipboardFields) {
        this.clipboardFields = clipboardFields;
    }

    public Vector getClipboardVariables() {
        return this.clipboardVariables;
    }

    public void setClipboardVariables(Vector clipboardVariables) {
        this.clipboardVariables = clipboardVariables;
    }

    public Vector getClipboardParameters() {
        return this.clipboardParameters;
    }

    public void setClipboardParameters(Vector clipboardParameters) {
        this.clipboardParameters = clipboardParameters;
    }

    public void duplicateFields(Vector fieldsToDuplicate) {
        this.duplicateFields(fieldsToDuplicate, this.getSubDataset());
    }

    public void duplicateFields(Vector fieldsToDuplicate, SubDataset dataset) {
        for (int i = 0; i < fieldsToDuplicate.size(); ++i) {
            JRField field = ((JRField)fieldsToDuplicate.elementAt(i)).cloneMe();
            String base_name = field.getName();
            Vector fields = dataset.getFields();
            int j = 0;
            while (true) {
                boolean found = false;
                for (int k = 0; k < fields.size(); ++k) {
                    JRField field1 = (JRField)fields.elementAt(k);
                    if (j == 0) {
                        if (!field1.getName().equals(base_name)) continue;
                        found = true;
                        break;
                    }
                    if (!field1.getName().equals(base_name + "_" + j)) continue;
                    found = true;
                    break;
                }
                if (!found) break;
                ++j;
            }
            field.setName(base_name + (j == 0 ? "" : "_" + j));
            dataset.addField(field);
        }
    }

    public void duplicateVariables(Vector variablesToDuplicate) {
        this.duplicateVariables(variablesToDuplicate, this.getSubDataset());
    }

    public void duplicateVariables(Vector variablesToDuplicate, SubDataset dataset) {
        for (int i = 0; i < variablesToDuplicate.size(); ++i) {
            JRVariable variable = ((JRVariable)variablesToDuplicate.elementAt(i)).cloneMe();
            String base_name = variable.getName();
            Vector variables = dataset.getVariables();
            int j = 0;
            while (true) {
                boolean found = false;
                for (int k = 0; k < variables.size(); ++k) {
                    JRVariable variable1 = (JRVariable)variables.elementAt(k);
                    if (j == 0) {
                        if (!variable1.getName().equals(base_name)) continue;
                        found = true;
                        break;
                    }
                    if (!variable1.getName().equals(base_name + "_" + j)) continue;
                    found = true;
                    break;
                }
                if (!found) break;
                ++j;
            }
            variable.setName(base_name + (j == 0 ? "" : "_" + j));
            if (variable.isBuiltin()) {
                JOptionPane.showMessageDialog(this, "It's not possible duplicate built-in variables!");
                continue;
            }
            dataset.addVariable(variable);
        }
    }

    public void duplicateParameters(Vector parametersToDuplicate) {
        this.duplicateParameters(parametersToDuplicate, this.getSubDataset());
    }

    public void duplicateParameters(Vector parametersToDuplicate, SubDataset dataset) {
        boolean msg_disp = false;
        for (int i = 0; i < parametersToDuplicate.size(); ++i) {
            JRParameter parameter = ((JRParameter)parametersToDuplicate.elementAt(i)).cloneMe();
            String base_name = parameter.getName();
            Vector parameters = dataset.getParameters();
            int j = 0;
            while (true) {
                boolean found = false;
                for (int k = 0; k < parameters.size(); ++k) {
                    JRParameter parameter1 = (JRParameter)parameters.elementAt(k);
                    if (j == 0) {
                        if (!parameter1.getName().equals(base_name)) continue;
                        found = true;
                        break;
                    }
                    if (!parameter1.getName().equals(base_name + "_" + j)) continue;
                    found = true;
                    break;
                }
                if (!found) break;
                ++j;
            }
            parameter.setName(base_name + (j == 0 ? "" : "_" + j));
            if (parameter.isBuiltin()) {
                if (msg_disp) continue;
                JOptionPane.showMessageDialog(this, "It's not possible duplicate built-in parameters!");
                msg_disp = true;
                continue;
            }
            dataset.addParameter(parameter);
        }
    }

    public void modifyField(JRField field) {
        Frame parent = Misc.frameFromComponent(this);
        JRFieldDialog jrpd = new JRFieldDialog(parent, true);
        jrpd.setField(field);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            field.setName(jrpd.getField().getName());
            field.setClassType(jrpd.getField().getClassType());
            field.setDescription(jrpd.getField().getDescription());
            this.getSubDataset().fireSubDatasetObjectChangedListenerSubDatasetObjectChanged(new SubDatasetObjectChangedEvent(this.getSubDataset(), 0, 1, field, field));
        }
    }

    public void newField() {
        this.newField(this.getSubDataset());
    }

    public void newField(SubDataset sd) {
        Frame parent = Misc.frameFromComponent(this);
        JRFieldDialog jrpd = new JRFieldDialog(parent, true);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            JRField field = jrpd.getField();
            sd.addField(field);
        }
    }

    public void modifyVariable(JRVariable variable) {
        if (variable.isBuiltin()) {
            JOptionPane.showMessageDialog(this, "You can't modify or delete builtin variables!", "Invalid operation!", 2);
            return;
        }
        Frame parent = Misc.frameFromComponent(this);
        JRVariableDialog jrpd = new JRVariableDialog(this.getSubDataset(), parent, true);
        jrpd.setVariable(variable);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            this.getSubDataset().getKeywordLookup().removeKeyword("$V{" + variable.getName() + "}");
            variable.setName(jrpd.getVariable().getName());
            this.getSubDataset().getKeywordLookup().addKeyword("$V{" + variable.getName() + "}");
            variable.setClassType(jrpd.getVariable().getClassType());
            variable.setCalculation(jrpd.getVariable().getCalculation());
            variable.setResetType(jrpd.getVariable().getResetType());
            variable.setResetGroup(jrpd.getVariable().getResetGroup());
            variable.setExpression(jrpd.getVariable().getExpression());
            variable.setInitialValueExpression(jrpd.getVariable().getInitialValueExpression());
            variable.setIncrementerFactoryClass(jrpd.getVariable().getIncrementerFactoryClass());
            variable.setIncrementType(jrpd.getVariable().getIncrementType());
            variable.setIncrementGroup(jrpd.getVariable().getIncrementGroup());
            this.getSubDataset().fireSubDatasetObjectChangedListenerSubDatasetObjectChanged(new SubDatasetObjectChangedEvent(this.getSubDataset(), 1, 1, variable, variable));
        }
    }

    public void newVariable() {
        this.newVariable(this.getSubDataset());
    }

    public void newVariable(SubDataset sd) {
        Frame parent = Misc.frameFromComponent(this);
        JRVariableDialog jrpd = new JRVariableDialog(sd, parent, true);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            JRVariable variable = jrpd.getVariable();
            sd.addVariable(variable);
        }
    }

    public void modifyParameter(JRParameter parameter) {
        if (parameter.isBuiltin()) {
            JOptionPane.showMessageDialog(this, "You can't modify or delete builtin parameters!", "Invalid operation!", 2);
            return;
        }
        Frame parent = Misc.frameFromComponent(this);
        JRParameterDialog jrpd = new JRParameterDialog(parent, true);
        jrpd.setSubDataset(this.getSubDataset());
        jrpd.setParameter(parameter);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            this.getSubDataset().getKeywordLookup().removeKeyword("$P{" + parameter.getName() + "}");
            parameter.setName(jrpd.getParameter().getName());
            this.getSubDataset().getKeywordLookup().addKeyword("$P{" + parameter.getName() + "}");
            parameter.setClassType(jrpd.getParameter().getClassType());
            parameter.setDescription(jrpd.getParameter().getDescription());
            parameter.setDefaultValueExpression(jrpd.getParameter().getDefaultValueExpression());
            parameter.setIsForPrompting(jrpd.getParameter().isIsForPrompting());
            this.getSubDataset().fireSubDatasetObjectChangedListenerSubDatasetObjectChanged(new SubDatasetObjectChangedEvent(this.getSubDataset(), 2, 2, parameter, parameter));
        }
    }

    public void newParameter() {
        this.newParameter(this.getSubDataset());
    }

    public void newParameter(SubDataset sd) {
        Frame parent = Misc.frameFromComponent(this);
        JRParameterDialog jrpd = new JRParameterDialog(parent, true);
        jrpd.setSubDataset(this.getSubDataset());
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            JRParameter parameter = jrpd.getParameter();
            sd.addParameter(parameter);
        }
    }
}

