/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.chart.ChartDatasetPanel;
import it.businesslogic.ireport.chart.TimePeriodDataset;
import it.businesslogic.ireport.chart.TimePeriodSeries;
import it.businesslogic.ireport.chart.TimePeriodSeriesDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TimePeriodDatasetPanel
extends JPanel
implements ChartDatasetPanel {
    private TimePeriodDataset timePeriodDataset = null;
    private SubDataset subDataset = null;
    private JButton jButtonAdd;
    private JButton jButtonModify;
    private JButton jButtonRemove;
    private JLabel jLabel1;
    private JList jList1;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemPaste;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPopupMenu jPopupMenuSeries;
    private JScrollPane jScrollPane1;

    public TimePeriodDatasetPanel() {
        this.initComponents();
        this.applyI18n();
        this.jList1.setModel(new DefaultListModel());
    }

    public void setTimePeriodDataset(TimePeriodDataset timePeriodDataset) {
        this.timePeriodDataset = timePeriodDataset;
        this.jButtonModify.setEnabled(false);
        this.jButtonModify.setEnabled(false);
        DefaultListModel lm = (DefaultListModel)this.jList1.getModel();
        lm.removeAllElements();
        Vector v = timePeriodDataset.getTimePeriodSeries();
        for (int i = 0; i < v.size(); ++i) {
            lm.addElement(v.elementAt(i));
        }
    }

    public TimePeriodDataset getTimePeriodDataset() {
        return this.timePeriodDataset;
    }

    private void initComponents() {
        this.jPopupMenuSeries = new JPopupMenu();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemPaste = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel1 = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonModify = new JButton();
        this.jButtonRemove = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jMenuItemCopy.setText("Copy series");
        this.jMenuItemCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimePeriodDatasetPanel.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jPopupMenuSeries.add(this.jMenuItemCopy);
        this.jMenuItemPaste.setText("Paste series");
        this.jMenuItemPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimePeriodDatasetPanel.this.jMenuItemPasteActionPerformed(evt);
            }
        });
        this.jPopupMenuSeries.add(this.jMenuItemPaste);
        this.setLayout(new GridBagLayout());
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                TimePeriodDatasetPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TimePeriodDatasetPanel.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(100, 0));
        this.jPanel1.setPreferredSize(new Dimension(100, 0));
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimePeriodDatasetPanel.this.jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonModify.setText("Modify");
        this.jButtonModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimePeriodDatasetPanel.this.jButtonModifyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonModify, gridBagConstraints);
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimePeriodDatasetPanel.this.jButtonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 99;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setText("Time period series");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.jLabel1, gridBagConstraints);
    }

    private void jMenuItemPasteActionPerformed(ActionEvent evt) {
        Vector v = MainFrame.getMainInstance().getChartSeriesClipBoard();
        if (v != null && v.size() > 0) {
            for (int i = 0; i < v.size(); ++i) {
                if (!(v.elementAt(i) instanceof TimePeriodSeries)) continue;
                TimePeriodSeries cs = (TimePeriodSeries)v.elementAt(i);
                cs = cs.cloneMe();
                this.timePeriodDataset.getTimePeriodSeries().addElement(cs);
                ((DefaultListModel)this.jList1.getModel()).addElement(cs);
            }
            this.jList1.updateUI();
        }
    }

    private void jMenuItemCopyActionPerformed(ActionEvent evt) {
        Object[] values = this.jList1.getSelectedValues();
        Vector<TimePeriodSeries> copy_c = new Vector<TimePeriodSeries>();
        for (int i = 0; i < values.length; ++i) {
            copy_c.add(((TimePeriodSeries)values[i]).cloneMe());
        }
        MainFrame.getMainInstance().setChartSeriesClipBoard(copy_c);
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            if (evt.getButton() == 3) {
                this.jMenuItemCopy.setEnabled(this.jList1.getSelectedIndex() >= 0);
                this.jMenuItemPaste.setEnabled(MainFrame.getMainInstance().getChartSeriesClipBoard() != null && MainFrame.getMainInstance().getChartSeriesClipBoard().size() > 0);
                this.jPopupMenuSeries.show(this, evt.getPoint().x, evt.getPoint().y);
            }
        }
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0) {
            TimePeriodSeries cs = (TimePeriodSeries)this.jList1.getSelectedValue();
            TimePeriodSeriesDialog csd = new TimePeriodSeriesDialog((Frame)MainFrame.getMainInstance(), true);
            csd.setSeriesExpression(cs.getSeriesExpression());
            csd.setStartDateExpression(cs.getStartDateExpression());
            csd.setEndDateExpression(cs.getEndDateExpression());
            csd.setValueExpression(cs.getValueExpression());
            csd.setLabelExpression(cs.getLabelExpression());
            csd.setSubDataset(this.getSubDataset());
            csd.setVisible(true);
            if (csd.getDialogResult() == 0) {
                cs.setSeriesExpression(csd.getSeriesExpression());
                cs.setStartDateExpression(csd.getStartDateExpression());
                cs.setEndDateExpression(csd.getEndDateExpression());
                cs.setValueExpression(csd.getValueExpression());
                cs.setLabelExpression(csd.getLabelExpression());
                this.jList1.updateUI();
            }
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        TimePeriodSeriesDialog csd = new TimePeriodSeriesDialog((Frame)MainFrame.getMainInstance(), true);
        csd.setSubDataset(this.getSubDataset());
        csd.setVisible(true);
        if (csd.getDialogResult() == 0) {
            TimePeriodSeries cs = new TimePeriodSeries();
            cs.setSeriesExpression(csd.getSeriesExpression());
            cs.setStartDateExpression(csd.getStartDateExpression());
            cs.setEndDateExpression(csd.getEndDateExpression());
            cs.setValueExpression(csd.getValueExpression());
            cs.setLabelExpression(csd.getLabelExpression());
            this.getTimePeriodDataset().getTimePeriodSeries().addElement(cs);
            ((DefaultListModel)this.jList1.getModel()).addElement(cs);
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        while (this.jList1.getSelectedIndex() >= 0) {
            this.getTimePeriodDataset().getTimePeriodSeries().remove(this.jList1.getSelectedValue());
            ((DefaultListModel)this.jList1.getModel()).removeElementAt(this.jList1.getSelectedIndex());
        }
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0) {
            this.jButtonModify.setEnabled(true);
            this.jButtonModify.setEnabled(true);
        } else {
            this.jButtonModify.setEnabled(false);
            this.jButtonModify.setEnabled(false);
        }
    }

    public void applyI18n() {
        this.jButtonAdd.setText(I18n.getString("charts.newseries", "Add series"));
        this.jButtonModify.setText(I18n.getString("charts.modifyseries", "Modify series"));
        this.jButtonRemove.setText(I18n.getString("charts.removeseries", "Remove series"));
        this.jMenuItemCopy.setText(I18n.getString("charts.copyseries", "Copy series"));
        this.jMenuItemPaste.setText(I18n.getString("charts.pasteseries", "Paste series"));
        this.updateUI();
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
    }
}

