/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.barcode.BcImage;
import it.businesslogic.ireport.util.Misc;
import java.awt.Image;

public class BarcodeReportElement
extends ImageReportElement {
    private String title = "Sample barcode";
    private boolean legend = false;
    private boolean showText = false;
    private String text = "\"0815\"";
    private int type = 13;
    private boolean checkSum = false;
    private String lastError = null;
    private static Image barcodeError = null;
    private int imageHeight = 0;
    private int imageWidth = 0;
    private String applicationIdentifier = "null";

    public BarcodeReportElement(int x, int y, int width, int height) {
        super(x, y, width == 0 ? 1 : Math.abs(width), height == 0 ? 1 : Math.abs(height));
        if (barcodeError == null) {
            barcodeError = Misc.loadImageFromResources("it/businesslogic/ireport/icons/barcodeerror.png");
        }
        this.setBarCodeImg(this.type, this.text, this.showText, this.checkSum);
        this.setImageClass("java.awt.Image");
        this.setScaleImage("RetainShape");
        this.setGraphicElementPen("None");
        this.setHyperlinkType("None");
        this.setAnchorNameExpression("");
        BarcodeReportElement.setImgDef(null);
        this.setKey("barcode");
    }

    public void setBarCodeImg(int type, String text, boolean showText, boolean checkSum) {
        StringBuffer bcCall = new StringBuffer("it.businesslogic.ireport.barcode.BcImage.getBarcodeImage(");
        bcCall.append(type);
        bcCall.append(",");
        bcCall.append(text);
        bcCall.append(",");
        bcCall.append(showText);
        bcCall.append(",");
        bcCall.append(checkSum);
        bcCall.append(",");
        bcCall.append(this.applicationIdentifier);
        bcCall.append(",");
        bcCall.append(this.getImageWidth() + "," + this.getImageHeight());
        bcCall.append(")");
        super.setImageExpression(bcCall.toString());
        try {
            this.setImg(BcImage.getBarcodeImage(type, text, showText, checkSum, this.getApplicationIdentifier(), this.getImageWidth(), this.getImageHeight()));
            this.lastError = null;
        }
        catch (RuntimeException e) {
            this.setImg(barcodeError);
            this.lastError = e.getMessage();
        }
    }

    public void setImageExpression(String imageExpression) {
        super.setImageExpression(imageExpression);
        String iE = imageExpression.substring(imageExpression.indexOf("(") + 1, imageExpression.lastIndexOf(")"));
        String[] params = iE.split(",");
        this.type = new Integer(params[0]);
        this.text = params[1];
        this.showText = new Boolean(params[2]);
        this.checkSum = new Boolean(params[3]);
        if (params.length > 4) {
            this.setApplicationIdentifier(params[4]);
            this.setImageWidth(Integer.parseInt(params[5]));
            this.setImageHeight(Integer.parseInt(params[6]));
        }
        this.update();
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
        this.update();
    }

    public boolean isShowText() {
        return this.showText;
    }

    public void update() {
        this.setBarCodeImg(this.type, this.text, this.showText, this.checkSum);
        this.updateBounds();
    }

    public ReportElement cloneMe() {
        BarcodeReportElement newReportElement = new BarcodeReportElement(this.position.x, this.position.y, this.width, this.height);
        this.copyBaseReportElement(newReportElement, this);
        newReportElement.setImageHeight(this.getImageHeight());
        newReportElement.setImageWidth(this.getImageWidth());
        newReportElement.setApplicationIdentifier(this.getApplicationIdentifier());
        return newReportElement;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.setImg(null);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.update();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(boolean checkSum) {
        this.checkSum = checkSum;
        this.update();
    }

    public String getLastError() {
        return this.lastError;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
        this.update();
    }

    public String getApplicationIdentifier() {
        if (this.applicationIdentifier == null || this.applicationIdentifier.equals("null")) {
            return "";
        }
        return this.applicationIdentifier;
    }

    public void setApplicationIdentifier(String applicationIdentifier) {
        if (applicationIdentifier == null || applicationIdentifier.equals("")) {
            applicationIdentifier = "null";
        }
        this.applicationIdentifier = applicationIdentifier;
        this.update();
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
        this.update();
    }
}

