/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizer;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JRAbstractLRUVirtualizer
implements JRVirtualizer {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$fill$JRAbstractLRUVirtualizer == null ? (class$net$sf$jasperreports$engine$fill$JRAbstractLRUVirtualizer = JRAbstractLRUVirtualizer.class$("net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer")) : class$net$sf$jasperreports$engine$fill$JRAbstractLRUVirtualizer));
    protected final Cache pagedIn;
    protected final HashMap pagedOut;
    protected JRVirtualizable lastObject;
    protected boolean readOnly;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRAbstractLRUVirtualizer;

    protected JRAbstractLRUVirtualizer(int maxSize) {
        this.pagedIn = new Cache(maxSize, this);
        this.pagedOut = new HashMap();
        this.lastObject = null;
        this.readOnly = false;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void registerObject(JRVirtualizable o) {
        Object old = this.pagedIn.put(o.getUID(), o);
        if (old != null) {
            this.pagedIn.put(o.getUID(), old);
            throw new IllegalStateException("Wrong object stored with UID \"" + o.getUID() + "\"");
        }
        this.lastObject = o;
    }

    public void deregisterObject(JRVirtualizable o) {
        String uid = o.getUID();
        Object old = this.pagedIn.remove(uid);
        if (old != null) {
            if (old != o) {
                this.pagedIn.put(uid, old);
                throw new IllegalStateException("Wrong object stored with UID \"" + o.getUID() + "\"");
            }
        } else {
            old = this.pagedOut.remove(uid);
            if (old != null && old != o) {
                this.pagedOut.put(uid, old);
                throw new IllegalStateException("Wrong object stored with UID \"" + o.getUID() + "\"");
            }
        }
    }

    public void touch(JRVirtualizable o) {
        if (this.lastObject != o) {
            this.lastObject = (JRVirtualizable)this.pagedIn.get(o.getUID());
        }
    }

    public void requestData(JRVirtualizable o) {
        String uid = o.getUID();
        if (this.pagedOut.containsKey(uid)) {
            try {
                this.pageIn(o);
            }
            catch (IOException e) {
                log.error((Object)"Error devirtualizing object", (Throwable)e);
                throw new JRRuntimeException(e);
            }
            o.afterInternalization();
            this.pagedOut.remove(uid);
            this.pagedIn.put(uid, o);
            this.lastObject = o;
        }
    }

    public void clearData(JRVirtualizable o) {
        String uid = o.getUID();
        if (this.pagedOut.containsKey(uid)) {
            this.dispose(o);
            this.pagedOut.remove(uid);
        }
    }

    public void virtualizeData(JRVirtualizable o) {
        String uid = o.getUID();
        if (!this.pagedOut.containsKey(uid)) {
            o.beforeExternalization();
            try {
                this.pageOut(o);
            }
            catch (IOException e) {
                log.error((Object)"Error virtualizing object", (Throwable)e);
                throw new JRRuntimeException(e);
            }
            o.removeVirtualData();
            this.pagedOut.put(uid, o);
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    protected final void writeData(JRVirtualizable o, OutputStream out) throws JRRuntimeException {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(o.getIdentityData());
            oos.writeObject(o.getVirtualData());
            oos.flush();
        }
        catch (IOException e) {
            log.error((Object)"Error virtualizing object", (Throwable)e);
            throw new JRRuntimeException(e);
        }
    }

    protected final void readData(JRVirtualizable o, InputStream in) throws JRRuntimeException {
        try {
            ObjectInputStream ois = new ObjectInputStream(in);
            o.setIdentityData(ois.readObject());
            o.setVirtualData(ois.readObject());
        }
        catch (IOException e) {
            log.error((Object)"Error devirtualizing object", (Throwable)e);
            throw new JRRuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Error devirtualizing object", (Throwable)e);
            throw new JRRuntimeException(e);
        }
    }

    protected abstract void pageOut(JRVirtualizable var1) throws IOException;

    protected abstract void pageIn(JRVirtualizable var1) throws IOException;

    protected abstract void dispose(JRVirtualizable var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class Cache
    extends LRUMap {
        private static final long serialVersionUID = 10200L;
        private final JRVirtualizer virt;

        Cache(int maxSize, JRVirtualizer virt) {
            super(maxSize);
            this.virt = virt;
        }

        protected void processRemovedLRU(Object key, Object value) {
            this.virt.virtualizeData((JRVirtualizable)value);
        }
    }
}

