/*
 * FormatCommandMoveToLeftMargin.java
 *
 * Created on 9 mei 2005, 21:36
 */

package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.ReportElement;
import java.awt.Point;
import java.util.Iterator;
import java.util.Vector;

/**
 * Move all elements towards to the left margin over a distance depicted
 * by the distance of the left most element to the left margin
 *
 * From the introduction this command the distance of the first element to the left margin had been taken.
 * This resulted in unwanted behaviour. If the first element was the most right element, then most elements were shifted
 * left of the left margin.
 *
 * Now this is corrected.
 */
public class FormatCommandMoveToLeftMargin extends FormatCommand {
    
    {
        operationType = OperationType.MOVE_TO_LEFT_MARGIN;
    }
    int deltaLeft = 0;
    
    void executeDeeper() {
        
        Vector bands = getBands();  // bands with selected elements
        for (Iterator h = bands.iterator(); h.hasNext(); ) {
            Band b = (Band) h.next();
            Vector bandElements = getBandElements( b );
            bandElements = sortXY( bandElements.elements());
            
            ReportElement re = (ReportElement) bandElements.elementAt(0);
            deltaLeft = re.getPosition().x - jrf.getReport().getLeftMargin();
            
            processElements(bandElements.elements());
        }
        
    }
    
    public void modify() {
        re.setPosition(new Point(re.getPosition().x + 10 - deltaLeft,  re.getPosition().y));
    }
    
}
