/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.base.JRBaseQuery;
import net.sf.jasperreports.engine.design.JRDesignQueryChunk;

public class JRDesignQuery
extends JRBaseQuery {
    private transient PropertyChangeSupport propSupport;
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_LANGUAGE = "language";
    protected List chunks = new ArrayList();

    public JRQueryChunk[] getChunks() {
        JRQueryChunk[] chunkArray = null;
        if (this.chunks != null && this.chunks.size() > 0) {
            chunkArray = new JRQueryChunk[this.chunks.size()];
            this.chunks.toArray(chunkArray);
        }
        return chunkArray;
    }

    public void setChunks(List chunks) {
        this.chunks = chunks;
    }

    public void addChunk(JRDesignQueryChunk chunk) {
        this.chunks.add(chunk);
    }

    public void addTextChunk(String text) {
        JRDesignQueryChunk chunk = new JRDesignQueryChunk();
        chunk.setType((byte)1);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addParameterChunk(String text) {
        JRDesignQueryChunk chunk = new JRDesignQueryChunk();
        chunk.setType((byte)2);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addParameterClauseChunk(String text) {
        JRDesignQueryChunk chunk = new JRDesignQueryChunk();
        chunk.setType((byte)3);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void setText(String text) {
        this.chunks = new ArrayList();
        if (text != null) {
            int end = 0;
            StringBuffer textChunk = new StringBuffer();
            String parameterChunk = null;
            String parameterClauseChunk = null;
            StringTokenizer tkzer = new StringTokenizer(text, "$", true);
            String token = null;
            boolean wasDelim = false;
            while (tkzer.hasMoreTokens()) {
                token = tkzer.nextToken();
                if (token.equals("$")) {
                    if (wasDelim) {
                        textChunk.append("$");
                    }
                    wasDelim = true;
                    continue;
                }
                if (token.startsWith("P{") && wasDelim) {
                    end = token.indexOf(125);
                    if (end > 0) {
                        if (textChunk.length() > 0) {
                            this.addTextChunk(textChunk.toString());
                        }
                        parameterChunk = token.substring(2, end);
                        this.addParameterChunk(parameterChunk);
                        textChunk = new StringBuffer(token.substring(end + 1));
                    } else {
                        if (wasDelim) {
                            textChunk.append("$");
                        }
                        textChunk.append(token);
                    }
                } else if (token.startsWith("P!{") && wasDelim) {
                    end = token.indexOf(125);
                    if (end > 0) {
                        if (textChunk.length() > 0) {
                            this.addTextChunk(textChunk.toString());
                        }
                        parameterClauseChunk = token.substring(3, end);
                        this.addParameterClauseChunk(parameterClauseChunk);
                        textChunk = new StringBuffer(token.substring(end + 1));
                    } else {
                        if (wasDelim) {
                            textChunk.append("$");
                        }
                        textChunk.append(token);
                    }
                } else {
                    if (wasDelim) {
                        textChunk.append("$");
                    }
                    textChunk.append(token);
                }
                wasDelim = false;
            }
            if (wasDelim) {
                textChunk.append("$");
            }
            if (textChunk.length() > 0) {
                this.addTextChunk(textChunk.toString());
            }
        }
    }

    public void setLanguage(String language) {
        String oldValue = this.language;
        this.language = language;
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LANGUAGE, oldValue, this.language);
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propSupport == null) {
            this.propSupport = new PropertyChangeSupport(this);
        }
        return this.propSupport;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propName, PropertyChangeListener l) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().removePropertyChangeListener(l);
    }
}

