/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.syntax.Token;

public class PostfixExpression
extends Expression {
    private Token operation;
    private Expression expression;

    public PostfixExpression(Expression expression, Token operation) {
        this.operation = operation;
        this.expression = expression;
    }

    public String toString() {
        return super.toString() + "[" + this.expression + this.operation + "]";
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitPostfixExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return new PostfixExpression(transformer.transform(this.expression), this.operation);
    }

    protected void resolveType(AsmClassGenerator resolver) {
        this.expression.resolve(resolver);
        this.setTypeClass(this.expression.getTypeClass());
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Token getOperation() {
        return this.operation;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getText() {
        return "(" + this.expression.getText() + this.operation.getText() + ")";
    }

    public Class getTypeClass() {
        return this.expression.getTypeClass();
    }

    public String getType() {
        return this.expression.getType();
    }
}

