/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.locale;

import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import org.syntax.jedit.JEditTextArea;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.tokenmarker.PropsTokenMarker;

public class LocaleEditorDialog
extends JDialog {
    private JEditTextArea textArea;
    private File file = null;
    private JButton jButtonClose;
    private JButton jButtonGetKeys;
    private JButton jButtonRevertToSaved;
    private JButton jButtonSave;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelData;

    public LocaleEditorDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.textArea = new JEditTextArea();
        this.textArea.getPainter().setLineHighlightColor(Color.WHITE);
        this.textArea.setDocument(new SyntaxDocument());
        this.textArea.setTokenMarker(new PropsTokenMarker());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.textArea.setBorder(new BevelBorder(1));
        this.jPanel1.add((Component)this.textArea, gridBagConstraints);
        this.setSize(700, 600);
        Misc.centerFrame(this);
    }

    public void setFile(File file) {
        this.file = file;
        String str = "";
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = fis.read(buffer)) > 0) {
                str = str + new String(buffer, 0, read);
            }
            fis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.textArea.setText(str);
        this.textArea.setCaretPosition(0);
        this.textArea.updateScrollBars();
        this.textArea.updateUI();
    }

    private void initComponents() {
        this.jPanelData = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonRevertToSaved = new JButton();
        this.jButtonGetKeys = new JButton();
        this.jPanel3 = new JPanel();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanelData.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                LocaleEditorDialog.this.jPanel1ComponentResized(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelData.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(140, 151));
        this.jPanel2.setPreferredSize(new Dimension(140, 100));
        this.jButtonSave.setFont(new Font("Tahoma", 0, 11));
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocaleEditorDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonRevertToSaved.setFont(new Font("Tahoma", 0, 11));
        this.jButtonRevertToSaved.setText("Revert to saved");
        this.jButtonRevertToSaved.setActionCommand("Modify locale");
        this.jButtonRevertToSaved.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocaleEditorDialog.this.jButtonRevertToSavedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jButtonRevertToSaved, gridBagConstraints);
        this.jButtonGetKeys.setFont(new Font("Tahoma", 0, 11));
        this.jButtonGetKeys.setText("Get keys from default");
        this.jButtonGetKeys.setActionCommand("Modify locale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jButtonGetKeys, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.jButtonClose.setFont(new Font("Tahoma", 0, 11));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocaleEditorDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanelData.add((Component)this.jPanel2, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanelData, "Center");
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jPanel1ComponentResized(ComponentEvent evt) {
        this.textArea.updateScrollBars();
        if (this.textArea.getVisibleLines() >= this.textArea.getLineCount()) {
            this.textArea.setFirstLine(0);
        }
    }

    private void jButtonRevertToSavedActionPerformed(ActionEvent evt) {
        this.setFile(this.file);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        try {
            FileOutputStream fos = new FileOutputStream(this.file);
            fos.write(this.textArea.getText().getBytes());
            fos.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error saving " + this.file.getName() + ": " + ex.getMessage());
        }
    }
}

