/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.docking;

import it.businesslogic.ireport.gui.docking.JDraggableTabbedPane;
import it.businesslogic.ireport.gui.docking.PanelView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class DockingContainer
extends JPanel {
    public static final int INSERT_MODE_SHAREDPOSTION = 0;
    public static final int INSERT_MODE_NEWPOSITION = 1;
    private int oldWidth = 0;
    private boolean compressed = false;
    private Vector panelViews = new Vector();
    private Vector tabPanes = new Vector();
    private int positions = 0;
    private DropTarget dropTarget;
    private DropTargetListener dtListener;
    static /* synthetic */ Class class$it$businesslogic$ireport$gui$docking$PanelView;

    public DockingContainer() {
        this.initComponents();
        this.dtListener = new DTListener();
        this.dropTarget = new DropTarget(this, 2, this.dtListener, true);
    }

    public void addPanel(String name, Component component) {
        this.insertPanel(this.positions, name, component);
    }

    public void insertPanel(int position, String name, Component component, int insertMode) {
        if (component == null) {
            return;
        }
        if (name == null) {
            name = "Panel";
        }
        if (position >= this.positions) {
            position = this.positions++;
        } else if (insertMode == 1) {
            for (int i = 0; i < this.getPanelViews().size(); ++i) {
                PanelView pv = (PanelView)this.getPanelViews().elementAt(i);
                if (pv.getPosition() < position) continue;
                pv.setPosition(pv.getPosition() + 1);
            }
            ++this.positions;
        }
        this.panelViews.add(new PanelView(name, component, position));
        this.recreateAll();
    }

    public void insertPanel(int position, String name, Component component) {
        this.insertPanel(position, name, component, 1);
    }

    public void removePanel(Component component) {
        int position = -1;
        for (int i = 0; i < this.getPanelViews().size(); ++i) {
            PanelView pv = (PanelView)this.getPanelViews().elementAt(i);
            if (pv.getComponent() != component) continue;
            position = pv.getPosition();
            this.getPanelViews().remove(pv);
            break;
        }
        if (position >= 0) {
            PanelView pv;
            int i;
            boolean found = false;
            for (i = 0; i < this.getPanelViews().size(); ++i) {
                pv = (PanelView)this.getPanelViews().elementAt(i);
                if (pv.getPosition() != position) continue;
                found = true;
                break;
            }
            if (!found) {
                for (i = 0; i < this.getPanelViews().size(); ++i) {
                    pv = (PanelView)this.getPanelViews().elementAt(i);
                    if (pv.getPosition() <= position) continue;
                    pv.setPosition(pv.getPosition() - 1);
                }
                --this.positions;
            }
            this.recreateAll();
        }
    }

    public void moveComponent(PanelView panelView, int newPosition) {
        this.moveComponent(panelView, newPosition, 1);
    }

    public void moveComponent(PanelView panelView, int newPosition, int mode) {
        this.removePanel(panelView.getComponent());
        this.insertPanel(newPosition, panelView.getName(), panelView.getComponent(), mode);
    }

    public void mergePosition(int newPosition) {
        if (newPosition >= this.positions) {
            return;
        }
        if (newPosition == 0 && this.positions > 1) {
            newPosition = 1;
        }
        for (int i = 0; i < this.getPanelViews().size(); ++i) {
            PanelView pv = (PanelView)this.getPanelViews().elementAt(i);
            if (pv.getPosition() >= newPosition) {
                pv.setPosition(pv.getPosition() - 1);
            }
            System.out.println(pv.getName() + "-> " + pv.getPosition());
        }
        --this.positions;
        this.recreateAll();
    }

    public void recreateAll() {
        this.removeAll();
        if (this.positions > 0) {
            if (this.compressed) {
                this.compressed = false;
                this.setSize(this.getOldWidth(), 1);
            }
            this.tabPanes.removeAllElements();
            Vector tabbedPanes = new Vector();
            if (this.positions == 0) {
                return;
            }
            this.add(this.addComponents(0), "Center");
            this.updateUI();
        } else {
            this.compressed = true;
            this.setOldWidth(this.getSize().width);
            this.setSize(0, 1);
        }
    }

    public void setSelectedComponent(Component component) {
        for (int i = 0; i < this.tabPanes.size(); ++i) {
            JDraggableTabbedPane tab = (JDraggableTabbedPane)this.tabPanes.get(i);
            try {
                tab.setSelectedComponent(component);
                break;
            }
            catch (Exception ex) {
                continue;
            }
        }
    }

    public Component addComponents(int pos) {
        JDraggableTabbedPane jTabbedPane = new JDraggableTabbedPane();
        jTabbedPane.setPosition(pos);
        jTabbedPane.setFont(new Font("Tahoma", 0, 11));
        jTabbedPane.setDockingContainer(this);
        this.tabPanes.add(jTabbedPane);
        for (int i = 0; i < this.getPanelViews().size(); ++i) {
            PanelView pv = (PanelView)this.getPanelViews().elementAt(i);
            if (pv.getPosition() != pos) continue;
            jTabbedPane.addTab(pv.getName(), pv.getComponent());
        }
        if (pos < this.positions - 1) {
            JSplitPane jSplitPane = new JSplitPane();
            jSplitPane.setOrientation(0);
            jSplitPane.setResizeWeight(1.0 / (double)(this.positions - pos));
            jSplitPane.setLeftComponent(jTabbedPane);
            jSplitPane.setRightComponent(this.addComponents(pos + 1));
            jSplitPane.setDividerSize(5);
            return jSplitPane;
        }
        return jTabbedPane;
    }

    public Vector getPanelViews() {
        return this.panelViews;
    }

    public void setPanelViews(Vector panelViews) {
        this.panelViews = panelViews;
    }

    public int getOldWidth() {
        return this.oldWidth;
    }

    public void setOldWidth(int oldWidth) {
        this.oldWidth = oldWidth;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DTListener
    implements DropTargetListener {
        DTListener() {
        }

        public void dragEnter(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        public void dragOver(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void drop(DropTargetDropEvent dtde) {
            try {
                DataFlavor myFlavor;
                PanelView panelView;
                DropTargetContext context = dtde.getDropTargetContext();
                Transferable tr = dtde.getTransferable();
                DataFlavor[] df = tr.getTransferDataFlavors();
                if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.gui.docking.PanelView") && (panelView = (PanelView)tr.getTransferData(myFlavor = new DataFlavor(class$it$businesslogic$ireport$gui$docking$PanelView == null ? (class$it$businesslogic$ireport$gui$docking$PanelView = DockingContainer.class$("it.businesslogic.ireport.gui.docking.PanelView")) : class$it$businesslogic$ireport$gui$docking$PanelView, (class$it$businesslogic$ireport$gui$docking$PanelView == null ? (class$it$businesslogic$ireport$gui$docking$PanelView = DockingContainer.class$("it.businesslogic.ireport.gui.docking.PanelView")) : class$it$businesslogic$ireport$gui$docking$PanelView).getName()))).getDockingContainer() != DockingContainer.this) {
                    panelView.getDockingContainer().removePanel(panelView.getComponent());
                    DockingContainer.this.insertPanel(0, panelView.getName(), panelView.getComponent());
                }
                context.dropComplete(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

