/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRSubreportReturnValue;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JRSubreportReturnValueDialog
extends JDialog {
    private JRSubreportReturnValue subreportReturnValue = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxCalculationType;
    private JComboBox jComboBoxSubreportVariable;
    private JComboBox jComboBoxVariable;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JTextField jTextFieldNameIncrementerFactoryClass;
    private int dialogResult;

    public JRSubreportReturnValueDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTypes();
        this.updateVariables();
        this.jComboBoxSubreportVariable.setSelectedItem("");
        this.setSize(380, 260);
        Misc.centerFrame(this);
    }

    public void setTypes() {
        this.jComboBoxCalculationType.addItem("Nothing");
        this.jComboBoxCalculationType.addItem("Count");
        this.jComboBoxCalculationType.addItem("Sum");
        this.jComboBoxCalculationType.addItem("Average");
        this.jComboBoxCalculationType.addItem("Lowest");
        this.jComboBoxCalculationType.addItem("Highest");
        this.jComboBoxCalculationType.addItem("StandardDeviation");
        this.jComboBoxCalculationType.addItem("Variance");
        this.jComboBoxCalculationType.addItem("System");
        this.jComboBoxCalculationType.addItem("First");
    }

    public void updateVariables() {
        try {
            Misc.updateComboBox(this.jComboBoxVariable, MainFrame.getMainInstance().getActiveReportFrame().getReport().getVariables(), false);
            for (int i = 0; i < this.jComboBoxVariable.getItemCount(); ++i) {
                Object var = this.jComboBoxVariable.getItemAt(i);
                if (!(var instanceof JRVariable) || !((JRVariable)var).isBuiltin()) continue;
                this.jComboBoxSubreportVariable.addItem(var + "");
                this.jComboBoxVariable.removeItem(var);
                --i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jComboBoxCalculationType = new JComboBox();
        this.jComboBoxVariable = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jTextFieldNameIncrementerFactoryClass = new JTextField();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jComboBoxSubreportVariable = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify variable");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRSubreportReturnValueDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 0, 11));
        this.jLabel1.setText("Subreport variable");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setFont(new Font("Tahoma", 0, 11));
        this.jLabel2.setText("Calculation type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel5.setFont(new Font("Tahoma", 0, 11));
        this.jLabel5.setText("Local destination variable");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.jComboBoxCalculationType.setFont(new Font("Tahoma", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxCalculationType, gridBagConstraints);
        this.jComboBoxVariable.setFont(new Font("Tahoma", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxVariable, gridBagConstraints);
        this.jLabel8.setFont(new Font("Tahoma", 0, 11));
        this.jLabel8.setText("Custom Incrementer Factory Class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel8, gridBagConstraints);
        this.jTextFieldNameIncrementerFactoryClass.setFont(new Font("Tahoma", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextFieldNameIncrementerFactoryClass, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setFont(new Font("Tahoma", 0, 11));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRSubreportReturnValueDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setFont(new Font("Tahoma", 0, 11));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRSubreportReturnValueDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jComboBoxSubreportVariable.setEditable(true);
        this.jComboBoxSubreportVariable.setFont(new Font("Tahoma", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jComboBoxSubreportVariable, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if ((this.jComboBoxSubreportVariable.getSelectedItem() + "").trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Please insert a valid subreport variable name!", "Invalid variable!", 2);
            return;
        }
        this.subreportReturnValue = new JRSubreportReturnValue();
        this.subreportReturnValue.setSubreportVariable(this.jComboBoxSubreportVariable.getSelectedItem() + "");
        if (this.jComboBoxVariable.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this, "Please insert a valid local variable! If no variables are available, please close this dialog and create one.", "Invalid variable!", 2);
            return;
        }
        this.subreportReturnValue.setToVariable(this.jComboBoxVariable.getSelectedItem() + "");
        this.subreportReturnValue.setCalculation(this.jComboBoxCalculationType.getSelectedItem() + "");
        this.subreportReturnValue.setIncrementFactoryClass(this.jTextFieldNameIncrementerFactoryClass.getText());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public JRSubreportReturnValue getSubreportReturnValue() {
        return this.subreportReturnValue;
    }

    public void setSubreportReturnValue(JRSubreportReturnValue tmpSubreportReturnValue) {
        this.jComboBoxSubreportVariable.setSelectedItem(new String(tmpSubreportReturnValue.getSubreportVariable()));
        for (int i = 0; i < this.jComboBoxVariable.getItemCount(); ++i) {
            Object var = this.jComboBoxVariable.getItemAt(i);
            if (!(var + "").equals(tmpSubreportReturnValue.getToVariable())) continue;
            this.jComboBoxVariable.setSelectedIndex(i);
            break;
        }
        this.jComboBoxCalculationType.setSelectedItem(new String(tmpSubreportReturnValue.getCalculation()));
        this.jTextFieldNameIncrementerFactoryClass.setText(new String(tmpSubreportReturnValue.getIncrementFactoryClass()));
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
}

