/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.IRFont;
import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.PdfEncoding;
import it.businesslogic.ireport.gui.JNumberComboBox;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class JRFontDialog
extends JDialog {
    private IReportFont iReportFont = null;
    private boolean init = false;
    private boolean reportFontMode = true;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxBold;
    private JCheckBox jCheckBoxDefaultFont;
    private JCheckBox jCheckBoxItalic;
    private JCheckBox jCheckBoxPDFEmbedded;
    private JCheckBox jCheckBoxStrokeTrough;
    private JCheckBox jCheckBoxUnderline;
    private JComboBox jComboBoxFontName;
    private JComboBox jComboBoxPDFFontName;
    private JComboBox jComboBoxPdfEncoding;
    private JComboBox jComboBoxReportFonts;
    private JComboBox jComboBoxTTFFont;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel27;
    private JLabel jLabel32;
    private JLabel jLabelTTF;
    private JNumberComboBox jNumberComboBoxSize;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanelFont;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTextField jTextFieldReportFont;
    private int dialogResult;

    public JRFontDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(420, 344);
        Misc.centerFrame(this);
        this.jNumberComboBoxSize.addEntry("3", 3.0);
        this.jNumberComboBoxSize.addEntry("5", 5.0);
        this.jNumberComboBoxSize.addEntry("8", 8.0);
        this.jNumberComboBoxSize.addEntry("10", 10.0);
        this.jNumberComboBoxSize.addEntry("12", 12.0);
        this.jNumberComboBoxSize.addEntry("14", 14.0);
        this.jNumberComboBoxSize.addEntry("18", 18.0);
        this.jNumberComboBoxSize.addEntry("24", 24.0);
        this.jNumberComboBoxSize.addEntry("36", 36.0);
        this.jNumberComboBoxSize.addEntry("48", 48.0);
        this.jNumberComboBoxSize.setSelectedIndex(3);
        this.jComboBoxPDFFontName.addItem("Helvetica");
        this.jComboBoxPDFFontName.addItem("Helvetica-Bold");
        this.jComboBoxPDFFontName.addItem("Helvetica-BoldOblique");
        this.jComboBoxPDFFontName.addItem("Helvetica-Oblique");
        this.jComboBoxPDFFontName.addItem("Courier");
        this.jComboBoxPDFFontName.addItem("Courier-Bold");
        this.jComboBoxPDFFontName.addItem("Courier-BoldOblique");
        this.jComboBoxPDFFontName.addItem("Courier-Oblique");
        this.jComboBoxPDFFontName.addItem("Symbol");
        this.jComboBoxPDFFontName.addItem("Times-Roman");
        this.jComboBoxPDFFontName.addItem("Times-Bold");
        this.jComboBoxPDFFontName.addItem("Times-BoldItalic");
        this.jComboBoxPDFFontName.addItem("Times-Italic");
        this.jComboBoxPDFFontName.addItem("ZapfDingbats");
        this.jComboBoxPDFFontName.addItem("STSong-Light");
        this.jComboBoxPDFFontName.addItem("MHei-Medium");
        this.jComboBoxPDFFontName.addItem("MSung-Light");
        this.jComboBoxPDFFontName.addItem("HeiseiKakuGo-W5");
        this.jComboBoxPDFFontName.addItem("HeiseiMin-W3");
        this.jComboBoxPDFFontName.addItem("HYGoThic-Medium");
        this.jComboBoxPDFFontName.addItem("HYSMyeongJo-Medium");
        this.jComboBoxPDFFontName.addItem("External TTF font...");
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1250", "CP1250 (Central European)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1251", "CP1251 (Cyrillic)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1252", "CP1252 (Western European ANSI aka WinAnsi)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1253", "CP1253 (Greek)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1254", "CP1254 (Turkish)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1255", "CP1255 (Hebrew)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1256", "CP1256 (Arabic)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1257", "CP1257 (Baltic)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Cp1258", "CP1258 (Vietnamese)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniGB-UCS2-H", "UniGB-UCS2-H (Chinese Simplified)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniGB-UCS2-V", "UniGB-UCS2-V (Chinese Simplified)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniCNS-UCS2-H", "UniCNS-UCS2-H (Chinese traditional)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniCNS-UCS2-V", "UniCNS-UCS2-V (Chinese traditional)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-H", "UniJIS-UCS2-H (Japanese)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-V", "UniJIS-UCS2-V (Japanese)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-H (Japanese)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-HW-V", "UniJIS-UCS2-HW-V (Japanese)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniKS-UCS2-H", "UniKS-UCS2-H (Korean)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("UniKS-UCS2-V", "UniKS-UCS2-V (Korean)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Identity-H", "Identity-H (Unicode with horizontal writing)"));
        this.jComboBoxPdfEncoding.addItem(new PdfEncoding("Identity-V", "Identity-V (Unicode with vertical writing)"));
        String[] fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < fontFamilies.length; ++i) {
            this.jComboBoxFontName.addItem(fontFamilies[i]);
        }
        this.jComboBoxReportFonts.setVisible(false);
    }

    private void initComponents() {
        this.jPanelFont = new JPanel();
        this.jLabel23 = new JLabel();
        this.jTextFieldReportFont = new JTextField();
        this.jLabel24 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jComboBoxFontName = new JComboBox();
        this.jNumberComboBoxSize = new JNumberComboBox();
        this.jLabel25 = new JLabel();
        this.jComboBoxPDFFontName = new JComboBox();
        this.jLabelTTF = new JLabel();
        this.jComboBoxTTFFont = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jCheckBoxBold = new JCheckBox();
        this.jCheckBoxUnderline = new JCheckBox();
        this.jCheckBoxItalic = new JCheckBox();
        this.jCheckBoxStrokeTrough = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jCheckBoxPDFEmbedded = new JCheckBox();
        this.jCheckBoxDefaultFont = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.jLabel32 = new JLabel();
        this.jComboBoxPdfEncoding = new JComboBox();
        this.jSeparator3 = new JSeparator();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jComboBoxReportFonts = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify report font");
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRFontDialog.this.closeDialog(evt);
            }
        });
        this.jPanelFont.setLayout(new GridBagLayout());
        this.jLabel23.setFont(new Font("Tahoma", 0, 11));
        this.jLabel23.setText("Report font");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jLabel23, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jTextFieldReportFont, gridBagConstraints);
        this.jLabel24.setFont(new Font("Tahoma", 0, 11));
        this.jLabel24.setText("Font name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanelFont.add((Component)this.jLabel24, gridBagConstraints);
        this.jLabel27.setFont(new Font("Tahoma", 0, 11));
        this.jLabel27.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.jPanelFont.add((Component)this.jLabel27, gridBagConstraints);
        this.jComboBoxFontName.setFont(new Font("Tahoma", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanelFont.add((Component)this.jComboBoxFontName, gridBagConstraints);
        this.jNumberComboBoxSize.setFont(new Font("Dialog", 0, 12));
        this.jNumberComboBoxSize.setMinimumSize(new Dimension(70, 22));
        this.jNumberComboBoxSize.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanelFont.add((Component)this.jNumberComboBoxSize, gridBagConstraints);
        this.jLabel25.setFont(new Font("Tahoma", 0, 11));
        this.jLabel25.setText("PDF font name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanelFont.add((Component)this.jLabel25, gridBagConstraints);
        this.jComboBoxPDFFontName.setFont(new Font("Tahoma", 0, 11));
        this.jComboBoxPDFFontName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jComboBoxPDFFontNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jComboBoxPDFFontName, gridBagConstraints);
        this.jLabelTTF.setFont(new Font("Tahoma", 0, 11));
        this.jLabelTTF.setText("TrueType font");
        this.jLabelTTF.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanelFont.add((Component)this.jLabelTTF, gridBagConstraints);
        this.jComboBoxTTFFont.setFont(new Font("Tahoma", 0, 11));
        this.jComboBoxTTFFont.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jComboBoxTTFFont, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jCheckBoxBold.setFont(new Font("Tahoma", 0, 11));
        this.jCheckBoxBold.setText("Bold");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jCheckBoxBold, gridBagConstraints);
        this.jCheckBoxUnderline.setFont(new Font("Tahoma", 0, 11));
        this.jCheckBoxUnderline.setText("Underline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jCheckBoxUnderline, gridBagConstraints);
        this.jCheckBoxItalic.setFont(new Font("Tahoma", 0, 11));
        this.jCheckBoxItalic.setText("Italic");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jCheckBoxItalic, gridBagConstraints);
        this.jCheckBoxStrokeTrough.setFont(new Font("Tahoma", 0, 11));
        this.jCheckBoxStrokeTrough.setText("Strike Trough");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jCheckBoxStrokeTrough, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelFont.add((Component)this.jSeparator2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.jCheckBoxPDFEmbedded.setFont(new Font("Tahoma", 0, 11));
        this.jCheckBoxPDFEmbedded.setText("PDF Embedded");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jCheckBoxPDFEmbedded, gridBagConstraints);
        this.jCheckBoxDefaultFont.setFont(new Font("Tahoma", 0, 11));
        this.jCheckBoxDefaultFont.setLabel("Default");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jCheckBoxDefaultFont, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabel32.setFont(new Font("Tahoma", 0, 11));
        this.jLabel32.setText("PDF Encoding");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jLabel32, gridBagConstraints);
        this.jComboBoxPdfEncoding.setEditable(true);
        this.jComboBoxPdfEncoding.setFont(new Font("Tahoma", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jComboBoxPdfEncoding, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanelFont.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelFont.add((Component)this.jSeparator3, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jPanel7, gridBagConstraints);
        this.jButtonOK.setFont(new Font("Tahoma", 0, 11));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setFont(new Font("Tahoma", 0, 11));
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel6.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelFont.add((Component)this.jPanel6, gridBagConstraints);
        this.jComboBoxReportFonts.setFont(new Font("Tahoma", 0, 11));
        this.jComboBoxReportFonts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontDialog.this.jComboBoxReportFontsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jComboBoxReportFonts, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanelFont, gridBagConstraints);
        this.pack();
    }

    private void jComboBoxReportFontsActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        if (this.jComboBoxReportFonts.getSelectedItem() != null && this.jComboBoxReportFonts.getSelectedItem() instanceof IReportFont) {
            IReportFont ifont = (IReportFont)this.jComboBoxReportFonts.getSelectedItem();
            this.setIReportFont(ifont, false);
        }
    }

    private void jComboBoxPDFFontNameActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        if (this.jComboBoxPDFFontName.getSelectedItem() == null || (this.jComboBoxPDFFontName.getSelectedItem() + "").equals("")) {
            return;
        }
        String fontName = "" + this.jComboBoxPDFFontName.getSelectedItem();
        if (fontName != null && fontName.equals("External TTF font...")) {
            this.jComboBoxTTFFont.setEnabled(true);
            this.jLabelTTF.setEnabled(true);
        } else {
            this.jComboBoxTTFFont.setEnabled(false);
            this.jLabelTTF.setEnabled(false);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldReportFont.getText().trim().length() <= 0 && this.isReportFontMode()) {
            JOptionPane.showMessageDialog(this, "Please insert a valid report font name!", "Invalid report font name!", 2);
            return;
        }
        this.iReportFont = new IReportFont();
        if (this.isReportFontMode()) {
            this.iReportFont.setReportFont(this.jTextFieldReportFont.getText());
        } else if (this.jComboBoxReportFonts.getSelectedItem() != null) {
            this.iReportFont.setReportFont(this.jComboBoxReportFonts.getSelectedItem() + "");
        }
        this.iReportFont.setBold(this.jCheckBoxBold.isSelected());
        this.iReportFont.setDefaultFont(this.jCheckBoxDefaultFont.isSelected());
        this.iReportFont.setFontName("" + this.jComboBoxFontName.getSelectedItem());
        this.iReportFont.setFontSize((int)this.jNumberComboBoxSize.getValue());
        this.iReportFont.setItalic(this.jCheckBoxItalic.isSelected());
        this.iReportFont.setPDFFontName(this.jComboBoxFontName.getSelectedItem() + "");
        this.iReportFont.setPDFFontName(this.jComboBoxPDFFontName.getSelectedItem() + "");
        if (this.iReportFont.getPDFFontName().equals("External TTF font...") && this.jComboBoxTTFFont.getSelectedItem() != null && this.jComboBoxTTFFont.getSelectedItem() instanceof IRFont) {
            this.iReportFont.setPDFFontName(((IRFont)this.jComboBoxTTFFont.getSelectedItem()).getFile().getName() + "");
        }
        this.iReportFont.setPdfEmbedded(this.jCheckBoxPDFEmbedded.isSelected());
        if (this.jComboBoxPdfEncoding.getSelectedItem() instanceof PdfEncoding) {
            this.iReportFont.setPdfEncoding(((PdfEncoding)this.jComboBoxPdfEncoding.getSelectedItem()).getEncoding());
        } else {
            this.iReportFont.setPdfEncoding(Misc.nvl(this.jComboBoxPdfEncoding.getSelectedItem(), "CP1251"));
        }
        this.iReportFont.setStrikeTrought(this.jCheckBoxStrokeTrough.isSelected());
        this.iReportFont.setTTFFont(Misc.nvl(this.jComboBoxTTFFont.getSelectedItem(), ""));
        this.iReportFont.setUnderline(this.jCheckBoxUnderline.isSelected());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public IReportFont getIReportFont() {
        return this.iReportFont;
    }

    public void setIReportFont(IReportFont iReportFont) {
        this.setIReportFont(iReportFont, true);
    }

    public void setIReportFont(IReportFont iReportFont, boolean reportFontToo) {
        this.init = true;
        if (iReportFont == null) {
            iReportFont = new IReportFont();
        }
        if (reportFontToo) {
            this.jTextFieldReportFont.setText(new String(iReportFont.getReportFont()));
            if (iReportFont.getReportFont() != null && iReportFont.getReportFont().length() > 0) {
                for (int i = 0; i < this.jComboBoxReportFonts.getItemCount(); ++i) {
                    if (!(this.jComboBoxReportFonts.getItemAt(i) + "").equals(iReportFont.getReportFont())) continue;
                    this.jComboBoxReportFonts.setSelectedIndex(i);
                    break;
                }
            }
        }
        this.jCheckBoxBold.setSelected(iReportFont.isBold());
        this.jCheckBoxItalic.setSelected(iReportFont.isItalic());
        this.jCheckBoxStrokeTrough.setSelected(iReportFont.isStrikeTrought());
        this.jCheckBoxPDFEmbedded.setSelected(iReportFont.isPdfEmbedded());
        this.jCheckBoxUnderline.setSelected(iReportFont.isUnderline());
        this.jCheckBoxDefaultFont.setSelected(iReportFont.isDefaultFont());
        this.setComboBoxText(true, iReportFont.getFontName(), this.jComboBoxFontName);
        if (iReportFont.getPDFFontName().toUpperCase().endsWith(".TTF")) {
            this.setComboBoxText(true, "External TTF font...", this.jComboBoxPDFFontName);
            this.jComboBoxTTFFont.setEnabled(true);
            this.jLabelTTF.setEnabled(true);
        } else {
            this.setComboBoxText(true, iReportFont.getPDFFontName(), this.jComboBoxPDFFontName);
        }
        if (iReportFont.getPDFFontName().toUpperCase().endsWith(".TTF")) {
            this.jComboBoxTTFFont.setEnabled(true);
            this.jLabelTTF.setEnabled(true);
            this.setFontComboBox(true, iReportFont.getPDFFontName(), this.jComboBoxTTFFont);
        } else {
            this.jComboBoxTTFFont.setEnabled(false);
            this.jLabelTTF.setEnabled(false);
        }
        this.setElementComboNumber(true, iReportFont.getFontSize(), this.jNumberComboBoxSize);
        this.setPdfEncodingComboBox(true, iReportFont.getPdfEncoding(), this.jComboBoxPdfEncoding);
        this.init = false;
    }

    public void updateFonts(Vector iRFonts) {
        Misc.updateComboBox(this.jComboBoxTTFFont, iRFonts, false);
    }

    protected boolean setComboBoxText(boolean firstTime, String value, JComboBox comboField) {
        if (!firstTime && !Misc.nvl(comboField.getSelectedItem(), "").equalsIgnoreCase(value)) {
            comboField.setSelectedIndex(0);
            return false;
        }
        try {
            comboField.setSelectedItem(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setFontComboBox(boolean firstTime, String value, JComboBox comboField) {
        if (!(firstTime || comboField.getSelectedItem() != null && comboField.getSelectedItem() instanceof IRFont && ((IRFont)comboField.getSelectedItem()).getFile().equals(value))) {
            if (comboField.getItemCount() > 0) {
                comboField.setSelectedIndex(0);
            }
            return false;
        }
        try {
            for (int i = 0; i < comboField.getItemCount(); ++i) {
                if (!(comboField.getItemAt(i) instanceof IRFont) || !((IRFont)comboField.getItemAt(i)).getFile().getName().equals(value)) continue;
                comboField.setSelectedIndex(i);
                return true;
            }
            if (comboField.getItemCount() > 0) {
                comboField.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setPdfEncodingComboBox(boolean firstTime, String value, JComboBox comboField) {
        if (!(firstTime || comboField.getSelectedItem() != null && (comboField.getSelectedItem() instanceof PdfEncoding && ((PdfEncoding)comboField.getSelectedItem()).getEncoding().equalsIgnoreCase(value) || (comboField.getSelectedItem() + "").equals(value)))) {
            if (comboField.getItemCount() > 0) {
                comboField.setSelectedIndex(0);
            }
            return false;
        }
        try {
            for (int i = 0; i < comboField.getItemCount(); ++i) {
                if (!(comboField.getItemAt(i) instanceof PdfEncoding) || !((PdfEncoding)comboField.getItemAt(i)).getEncoding().equals(value)) continue;
                comboField.setSelectedIndex(i);
                return true;
            }
            comboField.setSelectedItem(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setElementComboNumber(boolean firstTime, double value, JNumberComboBox numberField) {
        if (!firstTime && numberField.getValue() != value) {
            numberField.setSelectedItem("");
            return false;
        }
        try {
            numberField.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public boolean isReportFontMode() {
        return this.reportFontMode;
    }

    public void setReportFontMode(boolean reportFontMode) {
        this.setReportFontMode(reportFontMode ? 1 : 0);
    }

    public void setReportFontMode(int reportFontMode) {
        this.reportFontMode = reportFontMode == 1;
        this.jComboBoxReportFonts.setVisible(reportFontMode == 0);
        this.jTextFieldReportFont.setVisible(reportFontMode == 1);
        this.jCheckBoxDefaultFont.setEnabled(reportFontMode == 1);
        this.jLabel23.setVisible(reportFontMode != 3);
        if (this.jComboBoxReportFonts.getItemCount() == 0) {
            Misc.updateComboBox(this.jComboBoxReportFonts, MainFrame.getMainInstance().getActiveReportFrame().getReport().getFonts(), true);
        }
    }
}

