/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FieldPatternDialog
extends JDialog {
    private String pattern = "";
    private int dialogResult = 2;
    private int selectedCategory = -1;
    private static String[] dateFormats = new String[]{"dd/MM/yyyy", "MM/dd/yyyy", "EEEEE dd MMMMM yyyy", "MMMMM dd, yyyy", "dd/MM", "dd/MM/yy", "dd-MMM", "dd-MMM-yy", "MMM-yy", "MMMMM-yy", "dd MMMMM yyyy", "dd/MM/yyyy h.mm a", "dd/MM/yyyy HH.mm.ss", "MMM", "d/M/yyyy", "dd-MMM-yyyy", "yyyy.MM.dd G 'at' HH:mm:ss z", "EEE, MMM d, ''yy", "yyyyy.MMMMM.dd GGG hh:mm aaa", "EEE, d MMM yyyy HH:mm:ss Z", "yyMMddHHmmssZ"};
    private static String[] timeFormats = new String[]{"HH.mm", "h.mm a", "HH.mm.ss", "h.mm.ss a", "mm.ss,S", "hh 'o''clock' a, zzzz", "K:mm a, z", "yyyyy.MMMMM.dd GGG hh:mm aaa", "yyyy.MM.dd G 'at' HH:mm:ss z", "EEE, d MMM yyyy HH:mm:ss Z", "yyMMddHHmmssZ"};
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBoxPercentage;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelPattern;
    private JLabel jLabelSample;
    private JList jListCategory;
    private JList jListDateTypes;
    private JList jListNegatives;
    private JList jListTimeTypes;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPanel jPanelCurrency;
    private JPanel jPanelDate;
    private JPanel jPanelNumber;
    private JPanel jPanelPercentage;
    private JPanel jPanelScientific;
    private JPanel jPanelSheets;
    private JPanel jPanelTime;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerNumberDecimals;
    private JSpinner jSpinnerNumberDecimals1;
    private JSpinner jSpinnerNumberDecimals2;
    private JSpinner jSpinnerNumberDecimals3;

    public FieldPatternDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public FieldPatternDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.setSize(520, 350);
        Misc.centerFrame(this);
        DefaultListModel<String> dlm = new DefaultListModel<String>();
        DefaultListModel dlm2 = new DefaultListModel();
        DefaultListModel dlm3 = new DefaultListModel();
        DefaultListModel dlm4 = new DefaultListModel();
        this.jListCategory.setModel(dlm);
        dlm.addElement("Number");
        dlm.addElement("Date");
        dlm.addElement("Time");
        dlm.addElement("Currency");
        dlm.addElement("Percentage");
        dlm.addElement("Scientific");
        this.jListNegatives.setModel(dlm2);
        this.jListDateTypes.setModel(dlm3);
        this.jListTimeTypes.setModel(dlm4);
        SpinnerNumberModel sm = new SpinnerNumberModel(2, 0, 100, 1);
        this.jSpinnerNumberDecimals.setModel(sm);
        this.jSpinnerNumberDecimals1.setModel(sm);
        this.jSpinnerNumberDecimals2.setModel(sm);
        this.jSpinnerNumberDecimals3.setModel(sm);
        this.jPanelSheets.removeAll();
        ((DefaultComboBoxModel)this.jComboBoxPercentage.getModel()).addElement("%");
        ((DefaultComboBoxModel)this.jComboBoxPercentage.getModel()).addElement("\u2030");
        this.jPanelSheets.updateUI();
        this.jListCategory.setSelectedIndex(0);
        this.updateListNegatives();
        this.updateListDateTypes();
        this.updateListTimeTypes();
    }

    public void setOnlyDate(boolean b) {
        if (b) {
            DefaultListModel dlm = (DefaultListModel)this.jListCategory.getModel();
            dlm.removeAllElements();
            dlm.addElement("Date");
            this.selectedCategory = -1;
            this.jListCategory.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListCategory = new JList();
        this.jPanel2 = new JPanel();
        this.jPanelSheets = new JPanel();
        this.jPanelNumber = new JPanel();
        this.jLabel2 = new JLabel();
        this.jSpinnerNumberDecimals = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jPanel7 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jListNegatives = new JList();
        this.jPanelDate = new JPanel();
        this.jLabel7 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jListDateTypes = new JList();
        this.jPanelTime = new JPanel();
        this.jLabel8 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.jListTimeTypes = new JList();
        this.jPanelCurrency = new JPanel();
        this.jLabel5 = new JLabel();
        this.jSpinnerNumberDecimals1 = new JSpinner();
        this.jPanel9 = new JPanel();
        this.jPanelPercentage = new JPanel();
        this.jLabel6 = new JLabel();
        this.jSpinnerNumberDecimals2 = new JSpinner();
        this.jLabel9 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jComboBoxPercentage = new JComboBox();
        this.jPanelScientific = new JPanel();
        this.jLabel10 = new JLabel();
        this.jSpinnerNumberDecimals3 = new JSpinner();
        this.jPanel10 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabelSample = new JLabel();
        this.jPanel8 = new JPanel();
        this.jLabelPattern = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Pattern editor");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                FieldPatternDialog.this.formWindowClosed(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setPreferredSize(new Dimension(150, 50));
        this.jPanel1.setMinimumSize(new Dimension(100, 50));
        this.jLabel1.setFont(new Font("SansSerif", 0, 11));
        this.jLabel1.setText("Category");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jListCategory.setFont(new Font("SansSerif", 0, 11));
        this.jListCategory.setSelectionMode(0);
        this.jListCategory.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                FieldPatternDialog.this.jListCategoryValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListCategory);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanelSheets.setLayout(new BorderLayout());
        this.jPanelNumber.setLayout(new GridBagLayout());
        this.jLabel2.setFont(new Font("SansSerif", 0, 11));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Decimal places:");
        this.jLabel2.setPreferredSize(new Dimension(130, 22));
        this.jLabel2.setMaximumSize(new Dimension(75, 50));
        this.jLabel2.setMinimumSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanelNumber.add((Component)this.jLabel2, gridBagConstraints);
        this.jSpinnerNumberDecimals.setFont(new Font("SansSerif", 0, 11));
        this.jSpinnerNumberDecimals.setPreferredSize(new Dimension(100, 22));
        this.jSpinnerNumberDecimals.setMinimumSize(new Dimension(27, 22));
        this.jSpinnerNumberDecimals.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                FieldPatternDialog.this.jSpinnerNumberDecimalsPropertyChange(evt);
            }
        });
        this.jSpinnerNumberDecimals.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                FieldPatternDialog.this.jSpinnerNumberDecimalsStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanelNumber.add((Component)this.jSpinnerNumberDecimals, gridBagConstraints);
        this.jLabel3.setFont(new Font("SansSerif", 0, 11));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Use 1000 separator");
        this.jLabel3.setPreferredSize(new Dimension(130, 22));
        this.jLabel3.setMaximumSize(new Dimension(75, 50));
        this.jLabel3.setMinimumSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanelNumber.add((Component)this.jLabel3, gridBagConstraints);
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldPatternDialog.this.jCheckBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.jPanelNumber.add((Component)this.jCheckBox1, gridBagConstraints);
        this.jLabel4.setFont(new Font("SansSerif", 0, 11));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Negative numbers:");
        this.jLabel4.setPreferredSize(new Dimension(130, 22));
        this.jLabel4.setMaximumSize(new Dimension(75, 50));
        this.jLabel4.setMinimumSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanelNumber.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelNumber.add((Component)this.jPanel7, gridBagConstraints);
        this.jScrollPane2.setPreferredSize(new Dimension(100, 120));
        this.jScrollPane2.setMinimumSize(new Dimension(100, 50));
        this.jListNegatives.setFont(new Font("SansSerif", 0, 11));
        this.jListNegatives.setSelectionMode(0);
        this.jListNegatives.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                FieldPatternDialog.this.jListNegativesValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jListNegatives);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanelNumber.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanelSheets.add((Component)this.jPanelNumber, "Center");
        this.jPanelDate.setLayout(new GridBagLayout());
        this.jLabel7.setFont(new Font("SansSerif", 0, 11));
        this.jLabel7.setHorizontalAlignment(2);
        this.jLabel7.setText("Type:");
        this.jLabel7.setPreferredSize(new Dimension(100, 22));
        this.jLabel7.setMaximumSize(new Dimension(75, 50));
        this.jLabel7.setMinimumSize(new Dimension(75, 22));
        this.jLabel7.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelDate.add((Component)this.jLabel7, gridBagConstraints);
        this.jScrollPane3.setPreferredSize(new Dimension(300, 120));
        this.jScrollPane3.setMinimumSize(new Dimension(200, 50));
        this.jListDateTypes.setFont(new Font("SansSerif", 0, 11));
        this.jListDateTypes.setSelectionMode(0);
        this.jListDateTypes.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                FieldPatternDialog.this.jListDateTypesValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jListDateTypes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.jPanelDate.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jPanelSheets.add((Component)this.jPanelDate, "Center");
        this.jPanelTime.setLayout(new GridBagLayout());
        this.jLabel8.setFont(new Font("SansSerif", 0, 11));
        this.jLabel8.setHorizontalAlignment(2);
        this.jLabel8.setText("Type:");
        this.jLabel8.setPreferredSize(new Dimension(100, 22));
        this.jLabel8.setMaximumSize(new Dimension(75, 50));
        this.jLabel8.setMinimumSize(new Dimension(75, 22));
        this.jLabel8.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanelTime.add((Component)this.jLabel8, gridBagConstraints);
        this.jScrollPane4.setPreferredSize(new Dimension(300, 120));
        this.jScrollPane4.setMinimumSize(new Dimension(200, 50));
        this.jListTimeTypes.setFont(new Font("SansSerif", 0, 11));
        this.jListTimeTypes.setSelectionMode(0);
        this.jListTimeTypes.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                FieldPatternDialog.this.jListTimeTypesValueChanged(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jListTimeTypes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 0);
        this.jPanelTime.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jPanelSheets.add((Component)this.jPanelTime, "Center");
        this.jPanelCurrency.setLayout(new GridBagLayout());
        this.jLabel5.setFont(new Font("SansSerif", 0, 11));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Decimal places:");
        this.jLabel5.setPreferredSize(new Dimension(130, 22));
        this.jLabel5.setMaximumSize(new Dimension(75, 50));
        this.jLabel5.setMinimumSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanelCurrency.add((Component)this.jLabel5, gridBagConstraints);
        this.jSpinnerNumberDecimals1.setFont(new Font("SansSerif", 0, 11));
        this.jSpinnerNumberDecimals1.setPreferredSize(new Dimension(100, 22));
        this.jSpinnerNumberDecimals1.setMinimumSize(new Dimension(27, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanelCurrency.add((Component)this.jSpinnerNumberDecimals1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelCurrency.add((Component)this.jPanel9, gridBagConstraints);
        this.jPanelSheets.add((Component)this.jPanelCurrency, "Center");
        this.jPanelPercentage.setLayout(new GridBagLayout());
        this.jLabel6.setFont(new Font("SansSerif", 0, 11));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText("Decimal places:");
        this.jLabel6.setPreferredSize(new Dimension(130, 22));
        this.jLabel6.setMaximumSize(new Dimension(75, 50));
        this.jLabel6.setMinimumSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanelPercentage.add((Component)this.jLabel6, gridBagConstraints);
        this.jSpinnerNumberDecimals2.setFont(new Font("SansSerif", 0, 11));
        this.jSpinnerNumberDecimals2.setPreferredSize(new Dimension(100, 22));
        this.jSpinnerNumberDecimals2.setMinimumSize(new Dimension(27, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanelPercentage.add((Component)this.jSpinnerNumberDecimals2, gridBagConstraints);
        this.jLabel9.setFont(new Font("SansSerif", 0, 11));
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText("Type:");
        this.jLabel9.setPreferredSize(new Dimension(130, 22));
        this.jLabel9.setMaximumSize(new Dimension(75, 50));
        this.jLabel9.setMinimumSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanelPercentage.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelPercentage.add((Component)this.jPanel3, gridBagConstraints);
        this.jComboBoxPercentage.setFont(new Font("SansSerif", 0, 12));
        this.jComboBoxPercentage.setPreferredSize(new Dimension(100, 20));
        this.jComboBoxPercentage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldPatternDialog.this.jComboBoxPercentageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.jPanelPercentage.add((Component)this.jComboBoxPercentage, gridBagConstraints);
        this.jPanelSheets.add((Component)this.jPanelPercentage, "Center");
        this.jPanelScientific.setLayout(new GridBagLayout());
        this.jLabel10.setFont(new Font("SansSerif", 0, 11));
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText("Decimal places:");
        this.jLabel10.setPreferredSize(new Dimension(130, 22));
        this.jLabel10.setMaximumSize(new Dimension(75, 50));
        this.jLabel10.setMinimumSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanelScientific.add((Component)this.jLabel10, gridBagConstraints);
        this.jSpinnerNumberDecimals3.setFont(new Font("SansSerif", 0, 11));
        this.jSpinnerNumberDecimals3.setPreferredSize(new Dimension(100, 22));
        this.jSpinnerNumberDecimals3.setMinimumSize(new Dimension(27, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanelScientific.add((Component)this.jSpinnerNumberDecimals3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelScientific.add((Component)this.jPanel10, gridBagConstraints);
        this.jPanelSheets.add((Component)this.jPanelScientific, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel2.add((Component)this.jPanelSheets, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(new TitledBorder("Sample"));
        this.jLabelSample.setFont(new Font("SansSerif", 0, 12));
        this.jLabelSample.setPreferredSize(new Dimension(34, 20));
        this.jLabelSample.setMaximumSize(new Dimension(34, 50));
        this.jLabelSample.setMinimumSize(new Dimension(34, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel4.add((Component)this.jLabelSample, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel8.setLayout(new GridBagLayout());
        this.jPanel8.setBorder(new TitledBorder("Pattern"));
        this.jLabelPattern.setFont(new Font("SansSerif", 0, 12));
        this.jLabelPattern.setPreferredSize(new Dimension(34, 20));
        this.jLabelPattern.setMaximumSize(new Dimension(34, 50));
        this.jLabelPattern.setMinimumSize(new Dimension(34, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel8.add((Component)this.jLabelPattern, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel5.setPreferredSize(new Dimension(10, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.jPanel6, gridBagConstraints);
        this.jButton1.setFont(new Font("SansSerif", 0, 11));
        this.jButton1.setText("Apply");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldPatternDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel5.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setFont(new Font("SansSerif", 0, 11));
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldPatternDialog.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel5.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.getContentPane().add((Component)this.jPanel5, gridBagConstraints);
        this.pack();
    }

    private void formWindowClosed(WindowEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setPattern(this.jLabelPattern.getText());
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setDialogResult(2);
        this.setVisible(false);
        this.dispose();
    }

    private void jComboBoxPercentageActionPerformed(ActionEvent evt) {
        this.updateSample();
    }

    private void jListTimeTypesValueChanged(ListSelectionEvent evt) {
        this.updateSample();
    }

    private void jListDateTypesValueChanged(ListSelectionEvent evt) {
        this.updateSample();
    }

    private void jListNegativesValueChanged(ListSelectionEvent evt) {
        this.updateSample();
    }

    private void jSpinnerNumberDecimalsStateChanged(ChangeEvent evt) {
        this.updateSample();
        this.updateListNegatives();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.updateSample();
        this.updateListNegatives();
    }

    private void jListCategoryValueChanged(ListSelectionEvent evt) {
        int i = this.getSelectedCategory();
        if (i != this.selectedCategory) {
            this.selectedCategory = i;
            this.jPanelSheets.removeAll();
            if (i == 0) {
                this.jPanelSheets.add(this.jPanelNumber);
                this.updateSample();
            } else if (i == 1) {
                this.jPanelSheets.add(this.jPanelDate);
                this.updateSample();
            } else if (i == 2) {
                this.jPanelSheets.add(this.jPanelTime);
                this.updateSample();
            } else if (i == 3) {
                this.jPanelSheets.add(this.jPanelCurrency);
                this.updateSample();
            } else if (i == 4) {
                this.jPanelSheets.add(this.jPanelPercentage);
                this.updateSample();
            } else if (i == 5) {
                this.jPanelSheets.add(this.jPanelScientific);
                this.updateSample();
            } else {
                this.updateSample();
            }
            this.jPanelSheets.updateUI();
        }
    }

    private void jSpinnerNumberDecimalsPropertyChange(PropertyChangeEvent evt) {
    }

    public static void main(String[] args) {
        new FieldPatternDialog((Frame)new JFrame(), true).show();
    }

    private void updateSample() {
        String format = this.createPattern();
        int i = this.getSelectedCategory();
        if (i == 0) {
            DecimalFormat nf = new DecimalFormat(format);
            this.jLabelSample.setText(nf.format(1234.4321));
        } else if (i == 1) {
            if (this.jListDateTypes.getSelectedIndex() >= 0) {
                this.jLabelSample.setText("" + this.jListDateTypes.getSelectedValue());
            } else {
                this.jLabelSample.setText("");
            }
        } else if (i == 2) {
            if (this.jListTimeTypes.getSelectedIndex() >= 0) {
                this.jLabelSample.setText("" + this.jListTimeTypes.getSelectedValue());
            } else {
                this.jLabelSample.setText("");
            }
        } else if (i == 3) {
            DecimalFormat nf = new DecimalFormat(format);
            this.jLabelSample.setText(nf.format(1234.4321));
        } else if (i == 4) {
            DecimalFormat nf = new DecimalFormat(format);
            this.jLabelSample.setText(nf.format(1234.4321));
        } else if (i == 5) {
            DecimalFormat nf = new DecimalFormat(format);
            this.jLabelSample.setText(nf.format(1234.4321));
        } else {
            this.jLabelSample.setText("");
        }
    }

    private String createPattern() {
        String format = "";
        int cat = this.getSelectedCategory();
        if (cat == 0) {
            format = this.jCheckBox1.isSelected() ? "#,##0" : "###0";
            int decimals = ((SpinnerNumberModel)this.jSpinnerNumberDecimals.getModel()).getNumber().intValue();
            if (decimals > 0) {
                format = format + ".";
                for (int i = 0; i < decimals; ++i) {
                    format = format + "0";
                }
            }
            if (this.jListNegatives.getSelectedIndex() >= 0) {
                int selectedIndex = this.jListNegatives.getSelectedIndex();
                if (selectedIndex == 0) {
                    format = format + ";-" + format + "";
                }
                if (selectedIndex == 1) {
                    format = format + ";" + format + "-";
                }
                if (selectedIndex == 2) {
                    format = format + ";(" + format + ")";
                }
                if (selectedIndex == 3) {
                    format = format + ";(-" + format + ")";
                }
                if (selectedIndex == 4) {
                    format = format + ";(" + format + "-)";
                }
            }
        } else if (cat == 1) {
            if (this.jListDateTypes.getSelectedIndex() >= 0) {
                format = dateFormats[this.jListDateTypes.getSelectedIndex()];
            }
        } else if (cat == 2) {
            if (this.jListTimeTypes.getSelectedIndex() >= 0) {
                format = timeFormats[this.jListTimeTypes.getSelectedIndex()];
            }
        } else if (cat == 3) {
            format = "\u00a4 #,##0";
            int decimals = ((SpinnerNumberModel)this.jSpinnerNumberDecimals1.getModel()).getNumber().intValue();
            if (decimals > 0) {
                format = format + ".";
                for (int i = 0; i < decimals; ++i) {
                    format = format + "0";
                }
            }
        } else if (cat == 4) {
            format = "#,##0";
            int decimals = ((SpinnerNumberModel)this.jSpinnerNumberDecimals2.getModel()).getNumber().intValue();
            if (decimals > 0) {
                format = format + ".";
                for (int i = 0; i < decimals; ++i) {
                    format = format + "0";
                }
            }
            format = format + " " + this.jComboBoxPercentage.getSelectedItem();
        } else if (cat == 5) {
            format = "0";
            int decimals = ((SpinnerNumberModel)this.jSpinnerNumberDecimals3.getModel()).getNumber().intValue();
            if (decimals > 0) {
                format = format + ".0";
                for (int i = 1; i < decimals; ++i) {
                    format = format + "#";
                }
            }
            format = format + "E0";
        }
        this.jLabelPattern.setText(format);
        return format;
    }

    private void updateListNegatives() {
        String format = this.createPattern();
        DefaultListModel dlm = (DefaultListModel)this.jListNegatives.getModel();
        int selected = this.jListNegatives.getSelectedIndex();
        dlm.removeAllElements();
        if (format.indexOf(";") >= 0) {
            format = format.substring(0, format.indexOf(";"));
        }
        String[] formats = new String[]{format + ";-" + format + "", format + ";" + format + "-", format + ";(" + format + ")", format + ";(-" + format + ")", format + ";(" + format + "-)"};
        for (int i = 0; i < formats.length; ++i) {
            DecimalFormat nf = new DecimalFormat(formats[i]);
            dlm.addElement(nf.format(-1234.4321));
        }
        if (selected >= 0) {
            this.jListNegatives.setSelectedIndex(selected);
        }
    }

    private void updateListDateTypes() {
        DefaultListModel dlm = (DefaultListModel)this.jListDateTypes.getModel();
        for (int i = 0; i < dateFormats.length; ++i) {
            SimpleDateFormat nf = new SimpleDateFormat(dateFormats[i]);
            dlm.addElement(nf.format(new Date()));
        }
        this.jListDateTypes.setSelectedIndex(0);
    }

    private void updateListTimeTypes() {
        DefaultListModel dlm = (DefaultListModel)this.jListTimeTypes.getModel();
        for (int i = 0; i < timeFormats.length; ++i) {
            SimpleDateFormat nf = new SimpleDateFormat(timeFormats[i]);
            dlm.addElement(nf.format(new Date()));
        }
        this.jListTimeTypes.setSelectedIndex(0);
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public int getSelectedCategory() {
        int i = 0;
        String category = "" + this.jListCategory.getSelectedValue();
        if (category.equals("Number")) {
            i = 0;
        }
        if (category.equals("Date")) {
            i = 1;
        }
        if (category.equals("Time")) {
            i = 2;
        }
        if (category.equals("Currency")) {
            i = 3;
        }
        if (category.equals("Percentage")) {
            i = 4;
        }
        if (category.equals("Scientific")) {
            i = 5;
        }
        return i;
    }
}

