/*
 * JRParameterDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 9 maggio 2003, 17.25
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.connection.JRCsvDataSourceInspector;
import it.businesslogic.ireport.util.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.connection.*;

import java.awt.Component;
import java.io.File;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.*;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

/**
 *
 * @author  Administrator
 */
public class ConnectionDialog extends javax.swing.JDialog {
    /** Creates new form JRParameterDialog */
    JRParameter tmpParameter = null;
    private boolean init = false;
    
     public ConnectionDialog(java.awt.Dialog parent, boolean modal) {
        super(parent, modal);
        initAll();
     }
     
    public ConnectionDialog(java.awt.Frame parent, boolean modal) {
        
        super(parent, modal);
        initAll();
    }
        
    public void initAll()
    {
        initComponents();
//        this.setSize(400, 300);

        this.pack();
        Misc.centerFrame(this);
        init = true;
        jComboBoxConnectionType.addItem( "Database JDBC connection"); // Type 0
        jComboBoxConnectionType.addItem( "XML file datasource"); // Type 1
        jComboBoxConnectionType.addItem( "JavaBeans set datasource"); // Type 2
        jComboBoxConnectionType.addItem( "Custom JRDataSource"); // Type 3        
        jComboBoxConnectionType.addItem( "File CSV datasource"); // Type 4        
        jComboBoxConnectionType.addItem( "JRDataSourceProvider"); // Type 5 
        jComboBoxConnectionType.addItem( "Hibernate connection"); // Type 6 
        
        jComboBoxJDBCDriver.addItem("com.mysql.jdbc.Driver");
        jComboBoxJDBCDriver.addItem("org.gjt.mm.mysql.Driver");
        jComboBoxJDBCDriver.addItem("com.internetcds.jdbc.tds.Driver");
	jComboBoxJDBCDriver.addItem("net.sourceforge.jtds.jdbc.Driver");
        jComboBoxJDBCDriver.addItem("com.microsoft.jdbc.sqlserver.SQLServerDriver");
	jComboBoxJDBCDriver.addItem("sun.jdbc.odbc.JdbcOdbcDriver");
	jComboBoxJDBCDriver.addItem("com.ms.jdbc.odbc.JdbcOdbcDriver");
	jComboBoxJDBCDriver.addItem("oracle.jdbc.driver.OracleDriver");
	jComboBoxJDBCDriver.addItem("COM.ibm.db2.jdbc.app.DB2Driver");
	jComboBoxJDBCDriver.addItem("com.informix.jdbc.IfxDriver");
	jComboBoxJDBCDriver.addItem("com.sybase.jdbc2.jdbc.SybDriver");
	jComboBoxJDBCDriver.addItem("com.merant.datadirect.jdbc.sqlserver.SQLServerDriver");
	jComboBoxJDBCDriver.addItem("com.inet.tds.TdsDriver");
	jComboBoxJDBCDriver.addItem("org.postgresql.Driver");
	jComboBoxJDBCDriver.addItem("org.hsqldb.jdbcDriver");
	jComboBoxJDBCDriver.addItem("COM.cloudscape.JDBCDriver");
        
        
        init = false;
        
        jComboBoxConnectionType.setSelectedIndex(0);
        System.out.println(jListCVSColumns);
        jListCVSColumns.setModel( new DefaultListModel());
        jTextFieldCVSDateFormat.setText( new SimpleDateFormat().toPattern());
        
        
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroupBeansSetType = new javax.swing.ButtonGroup();
        buttonGroupCVSFieldSeparator = new javax.swing.ButtonGroup();
        buttonGroupCVSFieldSeparator1 = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jPanelConnectionType = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        jComboBoxConnectionType = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jTextFieldName = new javax.swing.JTextField();
        jSeparator2 = new javax.swing.JSeparator();
        jPanelConnectionRoot = new javax.swing.JPanel();
        jPanelXML = new javax.swing.JPanel();
        jLabel9 = new javax.swing.JLabel();
        jTextFieldXMLFile = new javax.swing.JTextField();
        jButton2 = new javax.swing.JButton();
        jLabel16 = new javax.swing.JLabel();
        jTextFieldRecordPath = new javax.swing.JTextField();
        jPanel3 = new javax.swing.JPanel();
        jSeparator7 = new javax.swing.JSeparator();
        jPanelBeansSet = new javax.swing.JPanel();
        jLabel12 = new javax.swing.JLabel();
        jTextFieldJBSetFactoryClass = new javax.swing.JTextField();
        jRadioButtonJBSetCollection = new javax.swing.JRadioButton();
        jRadioButtonJBSetArray = new javax.swing.JRadioButton();
        jLabel13 = new javax.swing.JLabel();
        jTextFieldJBSetMethodToCall = new javax.swing.JTextField();
        jSeparator6 = new javax.swing.JSeparator();
        jPanelJDBC = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jComboBoxJDBCDriver = new javax.swing.JComboBox();
        jTextFieldJDBCUrl = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        jLabel14 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jTextFieldDBName = new javax.swing.JTextField();
        jTextFieldServerAddress = new javax.swing.JTextField();
        jButtonWizard = new javax.swing.JButton();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jTextArea1 = new javax.swing.JTextArea();
        jTextFieldPassword = new javax.swing.JPasswordField();
        jTextFieldUsername = new javax.swing.JTextField();
        jCheckBoxSavePassword = new javax.swing.JCheckBox();
        jSeparator5 = new javax.swing.JSeparator();
        jPanelCustomDataSourceFactory = new javax.swing.JPanel();
        jLabel10 = new javax.swing.JLabel();
        jTextFieldJRCustomDataSourceFactoryClass = new javax.swing.JTextField();
        jLabel11 = new javax.swing.JLabel();
        jTextFieldJRCustomDataSourceMethod = new javax.swing.JTextField();
        jSeparator1 = new javax.swing.JSeparator();
        jPanelCSV = new javax.swing.JPanel();
        jLabel15 = new javax.swing.JLabel();
        jTextFieldCSVFilename = new javax.swing.JTextField();
        jButtonCSVFilename = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel11 = new javax.swing.JPanel();
        jPanel8 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jListCVSColumns = new javax.swing.JList();
        jPanel9 = new javax.swing.JPanel();
        jButtonNewParameter = new javax.swing.JButton();
        jButtonModifyParameter = new javax.swing.JButton();
        jButtonDeleteParameter = new javax.swing.JButton();
        jPanel10 = new javax.swing.JPanel();
        jButtonNewParameter1 = new javax.swing.JButton();
        jPanel6 = new javax.swing.JPanel();
        jCheckBoxCVSDateFormat = new javax.swing.JCheckBox();
        jTextFieldCVSDateFormat = new javax.swing.JTextField();
        jButtonCVSDateFormat = new javax.swing.JButton();
        jCheckBoxCVSFirstRowAsHeader = new javax.swing.JCheckBox();
        jPanel7 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jRadioButtonCVSSeparatorComma = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorSpace = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorTab = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorSemicolon = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorOther = new javax.swing.JRadioButton();
        jTextFieldCVSSeparatorText = new javax.swing.JTextField();
        jRadioButtonCVSSeparatorNewLine = new javax.swing.JRadioButton();
        jPanel5 = new javax.swing.JPanel();
        jRadioButtonCVSSeparatorComma1 = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorSpace1 = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorTab1 = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorSemicolon1 = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorNewLine1 = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorOther1 = new javax.swing.JRadioButton();
        jTextFieldCVSSeparatorText1 = new javax.swing.JTextField();
        jPanel12 = new javax.swing.JPanel();
        jSeparator4 = new javax.swing.JSeparator();
        jPanelDatasourceProvider = new javax.swing.JPanel();
        jLabel17 = new javax.swing.JLabel();
        jTextFieldJRDataSourceProvider = new javax.swing.JTextField();
        jSeparator3 = new javax.swing.JSeparator();
        jPanelHibernate = new javax.swing.JPanel();
        jTextPane1 = new javax.swing.JTextPane();
        jLabel8 = new javax.swing.JLabel();
        jPanelButtons = new javax.swing.JPanel();
        jButtonOK = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();
        jButtonOK1 = new javax.swing.JButton();

        setTitle("Connections properties");
        setModal(true);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanelConnectionType.setLayout(new java.awt.GridBagLayout());

        jPanelConnectionType.setMinimumSize(new java.awt.Dimension(164, 90));
        jPanelConnectionType.setPreferredSize(new java.awt.Dimension(10, 90));
        jLabel4.setText("Type of connection / datasource");
        jLabel4.setMaximumSize(new java.awt.Dimension(157, 21));
        jLabel4.setPreferredSize(new java.awt.Dimension(157, 14));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 0, 3);
        jPanelConnectionType.add(jLabel4, gridBagConstraints);

        jComboBoxConnectionType.setMinimumSize(new java.awt.Dimension(25, 21));
        jComboBoxConnectionType.setPreferredSize(new java.awt.Dimension(25, 21));
        jComboBoxConnectionType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxConnectionTypeActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 2, 5);
        jPanelConnectionType.add(jComboBoxConnectionType, gridBagConstraints);

        jLabel1.setText("Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 3);
        jPanelConnectionType.add(jLabel1, gridBagConstraints);

        jTextFieldName.setMinimumSize(new java.awt.Dimension(6, 21));
        jTextFieldName.setPreferredSize(new java.awt.Dimension(11, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 4, 5);
        jPanelConnectionType.add(jTextFieldName, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelConnectionType.add(jSeparator2, gridBagConstraints);

        jPanel1.add(jPanelConnectionType, java.awt.BorderLayout.NORTH);

        jPanelConnectionRoot.setLayout(new java.awt.BorderLayout());

        jPanelConnectionRoot.setPreferredSize(new java.awt.Dimension(400, 350));
        jPanelXML.setLayout(new java.awt.GridBagLayout());

        jPanelXML.setPreferredSize(new java.awt.Dimension(1, 30));
        jLabel9.setText("XML file");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 24;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelXML.add(jLabel9, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 232;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelXML.add(jTextFieldXMLFile, gridBagConstraints);

        jButton2.setText("Browse");
        jButton2.setPreferredSize(new java.awt.Dimension(70, 25));
        jButton2.setMaximumSize(new java.awt.Dimension(100, 25));
        jButton2.setMinimumSize(new java.awt.Dimension(70, 25));
        jButton2.setMargin(new java.awt.Insets(2, 4, 2, 4));
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 21;
        gridBagConstraints.ipady = -3;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 7);
        jPanelXML.add(jButton2, gridBagConstraints);

        jLabel16.setText("Select Expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 24;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelXML.add(jLabel16, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 232;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 7);
        jPanelXML.add(jTextFieldRecordPath, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelXML.add(jPanel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelXML.add(jSeparator7, gridBagConstraints);

        jPanelConnectionRoot.add(jPanelXML, java.awt.BorderLayout.CENTER);

        jPanelBeansSet.setLayout(new java.awt.GridBagLayout());

        jLabel12.setText("Factory class (the class that will produce the set)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 0, 4);
        jPanelBeansSet.add(jLabel12, gridBagConstraints);

        jTextFieldJBSetFactoryClass.setText("it.businesslogic.ireport.connection.SampleJRDataSourceFactory");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        jPanelBeansSet.add(jTextFieldJBSetFactoryClass, gridBagConstraints);

        buttonGroupBeansSetType.add(jRadioButtonJBSetCollection);
        jRadioButtonJBSetCollection.setSelected(true);
        jRadioButtonJBSetCollection.setText(" Collection of javaBeans");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 0, 4);
        jPanelBeansSet.add(jRadioButtonJBSetCollection, gridBagConstraints);

        buttonGroupBeansSetType.add(jRadioButtonJBSetArray);
        jRadioButtonJBSetArray.setText("Array of javaBeans");
        jRadioButtonJBSetArray.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonJBSetArrayActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanelBeansSet.add(jRadioButtonJBSetArray, gridBagConstraints);

        jLabel13.setText("The static method to call to retrive the array or the the collection of javaBeans");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 0, 4);
        jPanelBeansSet.add(jLabel13, gridBagConstraints);

        jTextFieldJBSetMethodToCall.setText("createBeanCollection");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        jPanelBeansSet.add(jTextFieldJBSetMethodToCall, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelBeansSet.add(jSeparator6, gridBagConstraints);

        jPanelConnectionRoot.add(jPanelBeansSet, java.awt.BorderLayout.CENTER);

        jPanelJDBC.setLayout(new java.awt.GridBagLayout());

        jLabel2.setText("JDBC Driver");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jLabel2, gridBagConstraints);

        jLabel3.setText("JDBC URL");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jLabel3, gridBagConstraints);

        jComboBoxJDBCDriver.setEditable(true);
        jComboBoxJDBCDriver.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxJDBCDriverActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelJDBC.add(jComboBoxJDBCDriver, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelJDBC.add(jTextFieldJDBCUrl, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "JDBC URL Wizard", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
        jPanel2.setMinimumSize(new java.awt.Dimension(300, 100));
        jLabel14.setText("Server Address");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel2.add(jLabel14, gridBagConstraints);

        jLabel5.setText("Database");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel2.add(jLabel5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel2.add(jTextFieldDBName, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel2.add(jTextFieldServerAddress, gridBagConstraints);

        jButtonWizard.setText("Wizard");
        jButtonWizard.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButtonWizard.setMaximumSize(new java.awt.Dimension(60, 23));
        jButtonWizard.setMinimumSize(new java.awt.Dimension(60, 23));
        jButtonWizard.setPreferredSize(new java.awt.Dimension(60, 23));
        jButtonWizard.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonWizardActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 2, 0);
        jPanel2.add(jButtonWizard, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        jPanelJDBC.add(jPanel2, gridBagConstraints);

        jLabel6.setText("Username");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jLabel6, gridBagConstraints);

        jLabel7.setText("Password");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jLabel7, gridBagConstraints);

        jTextArea1.setEditable(false);
        jTextArea1.setFont(new java.awt.Font("Tahoma", 0, 11));
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(3);
        jTextArea1.setText("ATTENTION! Passwords are stored in clear text. If you dont specify a password now, iReport will ask you for one only when required and will not save it.");
        jTextArea1.setWrapStyleWord(true);
        jTextArea1.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jTextArea1.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jTextArea1.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 6, 6, 6);
        jPanelJDBC.add(jTextArea1, gridBagConstraints);

        jTextFieldPassword.setFont(new java.awt.Font("Tahoma", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jTextFieldPassword, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanelJDBC.add(jTextFieldUsername, gridBagConstraints);

        jCheckBoxSavePassword.setText("Save password");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanelJDBC.add(jCheckBoxSavePassword, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelJDBC.add(jSeparator5, gridBagConstraints);

        jPanelConnectionRoot.add(jPanelJDBC, java.awt.BorderLayout.CENTER);

        jPanelCustomDataSourceFactory.setLayout(new java.awt.GridBagLayout());

        jLabel10.setText("Factory class");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelCustomDataSourceFactory.add(jLabel10, gridBagConstraints);

        jTextFieldJRCustomDataSourceFactoryClass.setText("it.businesslogic.ireport.connection.SampleJRDataSourceFactory");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelCustomDataSourceFactory.add(jTextFieldJRCustomDataSourceFactoryClass, gridBagConstraints);

        jLabel11.setText("The static method to call to retrive the JRDataSource");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelCustomDataSourceFactory.add(jLabel11, gridBagConstraints);

        jTextFieldJRCustomDataSourceMethod.setText("createDatasource");
        jTextFieldJRCustomDataSourceMethod.setPreferredSize(new java.awt.Dimension(314, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelCustomDataSourceFactory.add(jTextFieldJRCustomDataSourceMethod, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelCustomDataSourceFactory.add(jSeparator1, gridBagConstraints);

        jPanelConnectionRoot.add(jPanelCustomDataSourceFactory, java.awt.BorderLayout.CENTER);

        jPanelCSV.setLayout(new java.awt.GridBagLayout());

        jPanelCSV.setPreferredSize(new java.awt.Dimension(1, 30));
        jLabel15.setText("CSV file");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jPanelCSV.add(jLabel15, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jPanelCSV.add(jTextFieldCSVFilename, gridBagConstraints);

        jButtonCSVFilename.setText("Browse");
        jButtonCSVFilename.setMargin(new java.awt.Insets(2, 4, 2, 4));
        jButtonCSVFilename.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCSVFilenameActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 27;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        jPanelCSV.add(jButtonCSVFilename, gridBagConstraints);

        jPanel11.setLayout(new java.awt.GridBagLayout());

        jPanel8.setLayout(new java.awt.GridBagLayout());

        jPanel8.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Column names"));
        jListCVSColumns.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListCVSColumnsValueChanged(evt);
            }
        });
        jListCVSColumns.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jListCVSColumnsMouseClicked(evt);
            }
        });

        jScrollPane1.setViewportView(jListCVSColumns);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(jScrollPane1, gridBagConstraints);

        jPanel9.setLayout(new java.awt.GridBagLayout());

        jPanel9.setPreferredSize(new java.awt.Dimension(71, 200));
        jButtonNewParameter.setText("New");
        jButtonNewParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonNewParameterActionPerformed1(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel9.add(jButtonNewParameter, gridBagConstraints);

        jButtonModifyParameter.setText("Modify");
        jButtonModifyParameter.setEnabled(false);
        jButtonModifyParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModifyParameterActionPerformed1(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 5, 3);
        jPanel9.add(jButtonModifyParameter, gridBagConstraints);

        jButtonDeleteParameter.setText("Delete");
        jButtonDeleteParameter.setEnabled(false);
        jButtonDeleteParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDeleteParameterActionPerformed1(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 5, 3);
        jPanel9.add(jButtonDeleteParameter, gridBagConstraints);

        jPanel10.setLayout(null);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        jPanel9.add(jPanel10, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 4);
        jPanel8.add(jPanel9, gridBagConstraints);

        jButtonNewParameter1.setText("Get columns name from the first row of the file");
        jButtonNewParameter1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonNewParameterActionPerformed11(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel8.add(jButtonNewParameter1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel11.add(jPanel8, gridBagConstraints);

        jPanel6.setLayout(new java.awt.GridBagLayout());

        jPanel6.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Other"));
        jCheckBoxCVSDateFormat.setText("Use custom date format");
        jCheckBoxCVSDateFormat.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxCVSDateFormat.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jCheckBoxCVSDateFormat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxCVSDateFormatActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanel6.add(jCheckBoxCVSDateFormat, gridBagConstraints);

        jTextFieldCVSDateFormat.setEnabled(false);
        jTextFieldCVSDateFormat.setPreferredSize(new java.awt.Dimension(100, 19));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        jPanel6.add(jTextFieldCVSDateFormat, gridBagConstraints);

        jButtonCVSDateFormat.setText("Date format");
        jButtonCVSDateFormat.setEnabled(false);
        jButtonCVSDateFormat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCVSDateFormatActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanel6.add(jButtonCVSDateFormat, gridBagConstraints);

        jCheckBoxCVSFirstRowAsHeader.setText("Skip the first line (the column names will be read from the first line)");
        jCheckBoxCVSFirstRowAsHeader.setActionCommand("Skip the first line (column names will be read from the first line)");
        jCheckBoxCVSFirstRowAsHeader.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxCVSFirstRowAsHeader.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jCheckBoxCVSFirstRowAsHeader.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxCVSDateFormatActionPerformed1(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanel6.add(jCheckBoxCVSFirstRowAsHeader, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel11.add(jPanel6, gridBagConstraints);

        jTabbedPane1.addTab("Columns", jPanel11);

        jPanel7.setLayout(new java.awt.GridBagLayout());

        jPanel4.setLayout(new java.awt.GridBagLayout());

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Field separator (char)"));
        buttonGroupCVSFieldSeparator.add(jRadioButtonCVSSeparatorComma);
        jRadioButtonCVSSeparatorComma.setSelected(true);
        jRadioButtonCVSSeparatorComma.setText("Comma");
        jRadioButtonCVSSeparatorComma.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorComma.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jRadioButtonCVSSeparatorComma, gridBagConstraints);

        buttonGroupCVSFieldSeparator.add(jRadioButtonCVSSeparatorSpace);
        jRadioButtonCVSSeparatorSpace.setText("Space");
        jRadioButtonCVSSeparatorSpace.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorSpace.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jRadioButtonCVSSeparatorSpace, gridBagConstraints);

        buttonGroupCVSFieldSeparator.add(jRadioButtonCVSSeparatorTab);
        jRadioButtonCVSSeparatorTab.setText("Tab");
        jRadioButtonCVSSeparatorTab.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorTab.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jRadioButtonCVSSeparatorTab, gridBagConstraints);

        buttonGroupCVSFieldSeparator.add(jRadioButtonCVSSeparatorSemicolon);
        jRadioButtonCVSSeparatorSemicolon.setText("Semicolon");
        jRadioButtonCVSSeparatorSemicolon.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorSemicolon.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jRadioButtonCVSSeparatorSemicolon, gridBagConstraints);

        buttonGroupCVSFieldSeparator.add(jRadioButtonCVSSeparatorOther);
        jRadioButtonCVSSeparatorOther.setText("Other");
        jRadioButtonCVSSeparatorOther.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorOther.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jRadioButtonCVSSeparatorOther, gridBagConstraints);

        jTextFieldCVSSeparatorText.setPreferredSize(new java.awt.Dimension(30, 19));
        jTextFieldCVSSeparatorText.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldCVSSeparatorTextActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanel4.add(jTextFieldCVSSeparatorText, gridBagConstraints);

        buttonGroupCVSFieldSeparator.add(jRadioButtonCVSSeparatorNewLine);
        jRadioButtonCVSSeparatorNewLine.setText("New line");
        jRadioButtonCVSSeparatorNewLine.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorNewLine.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jRadioButtonCVSSeparatorNewLine, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel7.add(jPanel4, gridBagConstraints);

        jPanel5.setLayout(new java.awt.GridBagLayout());

        jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Row separator"));
        buttonGroupCVSFieldSeparator1.add(jRadioButtonCVSSeparatorComma1);
        jRadioButtonCVSSeparatorComma1.setText("Comma");
        jRadioButtonCVSSeparatorComma1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorComma1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(jRadioButtonCVSSeparatorComma1, gridBagConstraints);

        buttonGroupCVSFieldSeparator1.add(jRadioButtonCVSSeparatorSpace1);
        jRadioButtonCVSSeparatorSpace1.setText("Space");
        jRadioButtonCVSSeparatorSpace1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorSpace1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(jRadioButtonCVSSeparatorSpace1, gridBagConstraints);

        buttonGroupCVSFieldSeparator1.add(jRadioButtonCVSSeparatorTab1);
        jRadioButtonCVSSeparatorTab1.setText("Tab");
        jRadioButtonCVSSeparatorTab1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorTab1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(jRadioButtonCVSSeparatorTab1, gridBagConstraints);

        buttonGroupCVSFieldSeparator1.add(jRadioButtonCVSSeparatorSemicolon1);
        jRadioButtonCVSSeparatorSemicolon1.setText("Semicolon");
        jRadioButtonCVSSeparatorSemicolon1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorSemicolon1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(jRadioButtonCVSSeparatorSemicolon1, gridBagConstraints);

        buttonGroupCVSFieldSeparator1.add(jRadioButtonCVSSeparatorNewLine1);
        jRadioButtonCVSSeparatorNewLine1.setSelected(true);
        jRadioButtonCVSSeparatorNewLine1.setText("New line");
        jRadioButtonCVSSeparatorNewLine1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorNewLine1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(jRadioButtonCVSSeparatorNewLine1, gridBagConstraints);

        buttonGroupCVSFieldSeparator1.add(jRadioButtonCVSSeparatorOther1);
        jRadioButtonCVSSeparatorOther1.setText("Other");
        jRadioButtonCVSSeparatorOther1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorOther1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(jRadioButtonCVSSeparatorOther1, gridBagConstraints);

        jTextFieldCVSSeparatorText1.setPreferredSize(new java.awt.Dimension(30, 19));
        jTextFieldCVSSeparatorText1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldCVSSeparatorText1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanel5.add(jTextFieldCVSSeparatorText1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel7.add(jPanel5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        jPanel7.add(jPanel12, gridBagConstraints);

        jTabbedPane1.addTab("Separators", jPanel7);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelCSV.add(jTabbedPane1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelCSV.add(jSeparator4, gridBagConstraints);

        jPanelConnectionRoot.add(jPanelCSV, java.awt.BorderLayout.CENTER);

        jPanelDatasourceProvider.setLayout(new java.awt.GridBagLayout());

        jLabel17.setText("JasperReports DataSource Provider class");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 1, 3);
        jPanelDatasourceProvider.add(jLabel17, gridBagConstraints);

        jTextFieldJRDataSourceProvider.setText("it.businesslogic.ireport.examples.PersonBeansDataSource");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 3);
        jPanelDatasourceProvider.add(jTextFieldJRDataSourceProvider, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanelDatasourceProvider.add(jSeparator3, gridBagConstraints);

        jPanelConnectionRoot.add(jPanelDatasourceProvider, java.awt.BorderLayout.CENTER);

        jPanelHibernate.setLayout(new java.awt.GridBagLayout());

        jTextPane1.setText("Press the test button.\n\niReport will look in the classpath for a valid hibernate configuration.");
        jTextPane1.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelHibernate.add(jTextPane1, gridBagConstraints);

        jLabel8.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel8.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/hibernate.png")));
        jLabel8.setVerticalAlignment(javax.swing.SwingConstants.BOTTOM);
        jLabel8.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanelHibernate.add(jLabel8, gridBagConstraints);

        jPanelConnectionRoot.add(jPanelHibernate, java.awt.BorderLayout.NORTH);

        jPanel1.add(jPanelConnectionRoot, java.awt.BorderLayout.CENTER);

        jPanelButtons.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        jButtonOK.setMnemonic('s');
        jButtonOK.setText("Save");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonOK);

        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonCancel);

        jButtonOK1.setMnemonic('t');
        jButtonOK1.setText("Test");
        jButtonOK1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOK1ActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonOK1);

        jPanel1.add(jPanelButtons, java.awt.BorderLayout.SOUTH);

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-403)/2, (screenSize.height-415)/2, 403, 415);
    }// </editor-fold>//GEN-END:initComponents

    private void jListCVSColumnsValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jListCVSColumnsValueChanged

        if (jListCVSColumns.getSelectedIndex() >= 0)
        {
            jButtonModifyParameter.setEnabled(true);
            jButtonDeleteParameter.setEnabled(true);
        }
        else
        {
            jButtonModifyParameter.setEnabled(false);
            jButtonDeleteParameter.setEnabled(false);
        }
        
    }//GEN-LAST:event_jListCVSColumnsValueChanged

    private void jListCVSColumnsMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jListCVSColumnsMouseClicked

            if (evt.getClickCount() == 2 && evt.getButton() == evt.BUTTON1)
            {
                jButtonModifyParameterActionPerformed1(null);
            }
        
    }//GEN-LAST:event_jListCVSColumnsMouseClicked

    private void jCheckBoxCVSDateFormatActionPerformed1(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxCVSDateFormatActionPerformed1
// TODO add your handling code here:
    }//GEN-LAST:event_jCheckBoxCVSDateFormatActionPerformed1

    private void jButtonNewParameterActionPerformed11(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNewParameterActionPerformed11

        try {
            JRCsvDataSourceInspector ds = new JRCsvDataSourceInspector(new File( jTextFieldCSVFilename.getText()));
        
            if (jRadioButtonCVSSeparatorComma.isSelected()) ds.setFieldDelimiter(',');
            if (jRadioButtonCVSSeparatorTab.isSelected()) ds.setFieldDelimiter('\t');
            if (jRadioButtonCVSSeparatorSpace.isSelected()) ds.setFieldDelimiter(' ');
            if (jRadioButtonCVSSeparatorSemicolon.isSelected()) ds.setFieldDelimiter(';');
            if (jRadioButtonCVSSeparatorNewLine.isSelected()) ds.setFieldDelimiter('\n');
            if (jRadioButtonCVSSeparatorOther.isSelected()) ds.setFieldDelimiter((jTextFieldCVSSeparatorText.getText()+" ").charAt(0));
            
            if (jRadioButtonCVSSeparatorComma1.isSelected()) ds.setRecordDelimiter(",");
            if (jRadioButtonCVSSeparatorTab1.isSelected()) ds.setRecordDelimiter("\t");
            if (jRadioButtonCVSSeparatorSpace1.isSelected()) ds.setRecordDelimiter(" ");
            if (jRadioButtonCVSSeparatorSemicolon1.isSelected()) ds.setRecordDelimiter(";");
            if (jRadioButtonCVSSeparatorNewLine1.isSelected()) ds.setRecordDelimiter("\n");
            if (jRadioButtonCVSSeparatorOther1.isSelected()) ds.setRecordDelimiter(jTextFieldCVSSeparatorText1.getText());
            
            DefaultListModel dlm = (DefaultListModel)jListCVSColumns.getModel();
            dlm.removeAllElements();
            
            Vector names = ds.getColumnNames();
            for (int i=0; i < names.size(); ++i )
            {
                String fname = (names.elementAt(i)+"").trim();
                if (fname.length() > 0)
                  dlm.addElement(fname);
            }
            
            if (names.size() > 0)
            {
                jListCVSColumns.setSelectedIndex(0);
            }
        
        } catch (Exception ex)
        {
            JOptionPane.showMessageDialog(this,"Error:" + ex.getMessage());
        }
        
    }//GEN-LAST:event_jButtonNewParameterActionPerformed11

    private void jButtonDeleteParameterActionPerformed1(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeleteParameterActionPerformed1
        
        // Get the selected connection...
        DefaultListModel dlm = (DefaultListModel)jListCVSColumns.getModel();
        Object[] values = jListCVSColumns.getSelectedValues();

        for (int i=0; i<values.length; ++i)
        {
            dlm.removeElement(values[i]);
        }
    }//GEN-LAST:event_jButtonDeleteParameterActionPerformed1

    private void jButtonModifyParameterActionPerformed1(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModifyParameterActionPerformed1
        
        int index = jListCVSColumns.getSelectedIndex();
        
        if (index < 0) return;
        
        DefaultListModel dlm = (DefaultListModel)jListCVSColumns.getModel();
        String oldName = (String)dlm.getElementAt(index); 
        
        String name = JOptionPane.showInputDialog(this, "Column name", oldName);
        
        if (name != null)
        {
            dlm.setElementAt(name, index);
        }
    }//GEN-LAST:event_jButtonModifyParameterActionPerformed1

    private void jButtonNewParameterActionPerformed1(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNewParameterActionPerformed1
        
        DefaultListModel dlm = (DefaultListModel)jListCVSColumns.getModel();
        String name = JOptionPane.showInputDialog(this, "Column name", "COLUMN_" + dlm.getSize());
        
        if (name != null)
        {
            dlm.addElement(name);
        }
        
        if (dlm.size() == 1)
        {
            jListCVSColumns.setSelectedIndex(0);
        }
    }//GEN-LAST:event_jButtonNewParameterActionPerformed1

    private void jTextFieldCVSSeparatorText1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldCVSSeparatorText1ActionPerformed
    
        if (this.jTextFieldCVSSeparatorText1.getText().length() > 0)
        this.jRadioButtonCVSSeparatorOther1.setSelected(true);
    }//GEN-LAST:event_jTextFieldCVSSeparatorText1ActionPerformed

    private void jTextFieldCVSSeparatorTextActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldCVSSeparatorTextActionPerformed

        if (this.jTextFieldCVSSeparatorText.getText().length() > 0)
        this.jRadioButtonCVSSeparatorOther.setSelected(true);
        
    }//GEN-LAST:event_jTextFieldCVSSeparatorTextActionPerformed

    private void jButtonCVSDateFormatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCVSDateFormatActionPerformed

            FieldPatternDialog fpd = new FieldPatternDialog(this, true);
            fpd.setOnlyDate(true);
            
            fpd.setVisible(true);
            if (fpd.getDialogResult() == JOptionPane.OK_OPTION)
            {
                jTextFieldCVSDateFormat.setText( fpd.getPattern() );
            }
        
    }//GEN-LAST:event_jButtonCVSDateFormatActionPerformed

    private void jCheckBoxCVSDateFormatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxCVSDateFormatActionPerformed
        
        jTextFieldCVSDateFormat.setEnabled( this.jCheckBoxCVSDateFormat.isSelected());
        jButtonCVSDateFormat.setEnabled(  this.jCheckBoxCVSDateFormat.isSelected() );
        
        if (!this.jCheckBoxCVSDateFormat.isSelected())
        {
            jTextFieldCVSDateFormat.setText( new SimpleDateFormat().toPattern());
        }
        
    }//GEN-LAST:event_jCheckBoxCVSDateFormatActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        String fileName = "";
	    javax.swing.JFileChooser jfc = new javax.swing.JFileChooser( MainFrame.getMainInstance().getCurrentDirectory());
	    
	    jfc.setDialogTitle("Select XML file....");
	    
	    jfc.addChoosableFileFilter( new javax.swing.filechooser.FileFilter() {
		    public boolean accept(java.io.File file) {
			    String filename = file.getName();
			    return (filename.toLowerCase().endsWith(".xml") || file.isDirectory()) ;
		    }
		    public String getDescription() {
			    return "XML *.xml";
		    }
	    });
	    
	    jfc.setMultiSelectionEnabled(false);
	    jfc.setDialogType( javax.swing.JFileChooser.OPEN_DIALOG);
	    if  (jfc.showOpenDialog( this) == javax.swing.JOptionPane.OK_OPTION) {
		    java.io.File file = jfc.getSelectedFile();		
                    try {
                        jTextFieldXMLFile.setText( file.getAbsolutePath() );
                    } catch (Exception ex){}
	    }        
        
        
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButtonCSVFilenameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCSVFilenameActionPerformed
            String fileName = "";
	    javax.swing.JFileChooser jfc = new javax.swing.JFileChooser( MainFrame.getMainInstance().getCurrentDirectory());
	    
	    jfc.setDialogTitle("Select CSV file....");
	    
	    jfc.addChoosableFileFilter( new javax.swing.filechooser.FileFilter() {
		    public boolean accept(java.io.File file) {
			    String filename = file.getName();
			    return (filename.toLowerCase().endsWith(".csv") || file.isDirectory()) ;
		    }
		    public String getDescription() {
			    return "CSV *.csv";
		    }
	    });
	    
	    jfc.setMultiSelectionEnabled(false);
	    jfc.setDialogType( javax.swing.JFileChooser.OPEN_DIALOG);
	    if  (jfc.showOpenDialog( this) == javax.swing.JOptionPane.OK_OPTION) {
		    java.io.File file = jfc.getSelectedFile();		
                    try {
                        jTextFieldCSVFilename.setText( file.getAbsolutePath() );
                    } catch (Exception ex){}
	    }        
        
        
        
    }//GEN-LAST:event_jButtonCSVFilenameActionPerformed

    private void jComboBoxJDBCDriverActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxJDBCDriverActionPerformed
        // Run the wizard to populate Connection URL
        jButtonWizardActionPerformed(null);
    }//GEN-LAST:event_jComboBoxJDBCDriverActionPerformed

    private void jRadioButtonJBSetArrayActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonJBSetArrayActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_jRadioButtonJBSetArrayActionPerformed

    private void jButtonOK1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOK1ActionPerformed
        //java.awt.Frame parent = Misc.frameFromComponent(this);
        // 
        MainFrame.getMainInstance().getReportClassLoader().rescanLibDirectory();
        
        
        if (jComboBoxConnectionType.getSelectedIndex() == 0)
        {
            
            // Try the java connection...
            Connection conn = null;
            Statement stmt = null;
            try {
		    try {
                    	DriverPool.registerDriver( (String)jComboBoxJDBCDriver.getSelectedItem(), MainFrame.getMainInstance().getReportClassLoader() );
                    } catch (Exception ex)
                    {
                    	DriverPool.registerDriver( (String)jComboBoxJDBCDriver.getSelectedItem(), this.getClass().getClassLoader() );
                    }
                    
                    java.sql.Driver driver = DriverPool.getDriver( this.jTextFieldJDBCUrl.getText() );
                    
                    java.util.Properties connectProps = new java.util.Properties();
                    connectProps.setProperty("user", this.jTextFieldUsername.getText());
                    connectProps.setProperty("password", this.jTextFieldPassword.getText());
                    
                    conn = driver.connect( this.jTextFieldJDBCUrl.getText(), connectProps); 
				stmt = conn.createStatement();
			}catch (NoClassDefFoundError ex)
			{
				JOptionPane.showMessageDialog((Component)getParent(),"NoClassDefFoundError!!\nCheck your classpath!\nIf not present put your JDBC driver in lib directory of iReport and try again.","Error",JOptionPane.ERROR_MESSAGE);
				return;					
			} 
			catch (ClassNotFoundException ex)
			{
				JOptionPane.showMessageDialog((Component)getParent(),"ClassNotFoundError:\n"+ ex.getMessage() +"\n\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
				return;					
			} 
			catch (java.sql.SQLException ex)
			{
				JOptionPane.showMessageDialog((Component)getParent(),"SQL problems:\n"+ex.getMessage()+"\n"+this.jTextFieldJDBCUrl.getText() ,"Error",JOptionPane.ERROR_MESSAGE);
				return;					
			} 
			catch (Exception ex)
			{
				JOptionPane.showMessageDialog((Component)getParent(),"General problem:\n"+ex.getMessage()+"\n\nPlease check your username and password. The DBMS is running?!","Error",JOptionPane.ERROR_MESSAGE);
				return;					
			} finally {
                // Clean up
                if( stmt!=null ) try{ stmt.close(); } catch(Exception e) { /* anyone really care? */ }
                if( conn!=null ) try{ conn.close(); } catch(Exception e) { /* anyone really care? */ }
            }
			JOptionPane.showMessageDialog((Component)getParent(),"Connection test successful!","",JOptionPane.INFORMATION_MESSAGE);
			return;
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 3)
        {
            try {
                Object obj = Class.forName((String)jTextFieldJRCustomDataSourceFactoryClass.getText().trim(), true, MainFrame.getMainInstance().getReportClassLoader()).newInstance();
                obj.getClass().getMethod( (String)jTextFieldJRCustomDataSourceMethod.getText().trim(), new Class[0]).invoke(obj,new Object[0]);                
            } catch (NoClassDefFoundError ex)
	    {
		JOptionPane.showMessageDialog((Component)getParent(),"NoClassDefFoundError!!\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
		return;					
	    } 
	    catch (ClassNotFoundException ex)
	    {
		JOptionPane.showMessageDialog((Component)getParent(),"ClassNotFoundError:\n"+ ex.getMessage() +"\n\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
		return;					
	    } 
            catch (Exception ex)
            {
                JOptionPane.showMessageDialog((Component)getParent(),"Exception:\n"+ ex.getMessage() +"\n","Error",JOptionPane.ERROR_MESSAGE);
		ex.printStackTrace();

                return;	
            }
            JOptionPane.showMessageDialog((Component)getParent(),"Connection test successful!","",JOptionPane.INFORMATION_MESSAGE);
	    return;
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 2)
        {
            try {
                Object obj = Class.forName((String)jTextFieldJBSetFactoryClass.getText().trim(), true, MainFrame.getMainInstance().getReportClassLoader()).newInstance();
                Object ret_obj = obj.getClass().getMethod( (String)jTextFieldJBSetMethodToCall.getText().trim(), new Class[0]).invoke(null,new Object[0]);                
            
                if (ret_obj != null && !jRadioButtonJBSetArray.isSelected() && (ret_obj instanceof  java.util.Collection))
                {
                    JOptionPane.showMessageDialog((Component)getParent(),"Connection test successful!","",JOptionPane.INFORMATION_MESSAGE);
                }
                else if (ret_obj != null  && jRadioButtonJBSetArray.isSelected() && (ret_obj instanceof  Object[]))
                {
                    JOptionPane.showMessageDialog((Component)getParent(),"Connection test successful!","",JOptionPane.INFORMATION_MESSAGE);
                }
                else
                {
                    JOptionPane.showMessageDialog((Component)getParent(),"The method don't return a valid Array or java.util.Collection!\n","Error",JOptionPane.ERROR_MESSAGE);
                }
                
            } catch (NoClassDefFoundError ex)
	    {
		JOptionPane.showMessageDialog((Component)getParent(),"NoClassDefFoundError!!\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
		return;					
	    } 
	    catch (ClassNotFoundException ex)
	    {
		JOptionPane.showMessageDialog((Component)getParent(),"ClassNotFoundError:\n"+ ex.getMessage() +"\n\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
		return;					
	    } 
            catch (Exception ex)
            {
                JOptionPane.showMessageDialog((Component)getParent(),"Exception:\n"+ ex.getMessage() +"\n","Error",JOptionPane.ERROR_MESSAGE);
		ex.printStackTrace();
                return;	
            }
            
	    return;
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 4)
        {
            String csv_file = jTextFieldCSVFilename.getText().trim();
            
            try {
                
                JRCSVDataSourceConnection con = new JRCSVDataSourceConnection();
                java.io.File f = new java.io.File(csv_file);
                if (!f.exists())
                {
                    JOptionPane.showMessageDialog((Component)getParent(),"File " + csv_file + " not found","Error",JOptionPane.ERROR_MESSAGE);
                    return;	
                }
                
                con.setFilename( csv_file );
                if (con.getJRDataSource() != null)
                {
                    JOptionPane.showMessageDialog((Component)getParent(),"Connection test successful!","",JOptionPane.INFORMATION_MESSAGE);
                    return;
                }
                
            }
            catch (Exception ex)
            {
                JOptionPane.showMessageDialog((Component)getParent(),"Exception:\n"+ ex.getMessage() +"\n","Error",JOptionPane.ERROR_MESSAGE);
		ex.printStackTrace();
                return;	
            }
            
	    return;
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 5)
        {
            try {
                
                Object obj = Class.forName((String)jTextFieldJRDataSourceProvider.getText().trim(), true, MainFrame.getMainInstance().getReportClassLoader()).newInstance();
                if (!(obj instanceof net.sf.jasperreports.engine.JRDataSourceProvider))
                {
                    JOptionPane.showMessageDialog((Component)getParent(),"\"" + jTextFieldJRDataSourceProvider.getText() + "\" is not a subclass of\nnet.sf.jasperreports.engine.JRDataSourceProvider.","Error",JOptionPane.ERROR_MESSAGE);
                    return;	
                }
                else
                {
                    JOptionPane.showMessageDialog((Component)getParent(),"Connection test successful!","",JOptionPane.INFORMATION_MESSAGE);
                    return;
                }
                
            } catch (NoClassDefFoundError ex)
	    {
		JOptionPane.showMessageDialog((Component)getParent(),"NoClassDefFoundError!!\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
		return;					
	    } 
	    catch (ClassNotFoundException ex)
	    {
		JOptionPane.showMessageDialog((Component)getParent(),"ClassNotFoundError:\n"+ ex.getMessage() +"\n\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
		return;					
	    } 
            catch (Exception ex)
            {
                JOptionPane.showMessageDialog((Component)getParent(),"Exception:\n"+ ex.getMessage() +"\n","Error",JOptionPane.ERROR_MESSAGE);
		ex.printStackTrace();
                return;	
            }
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 6)
        {
            try {
                SwingUtilities.invokeLater( new Runnable()
                {
                    public void run()
                    {
                        Thread.currentThread().setContextClassLoader( MainFrame.getMainInstance().getReportClassLoader() );
                        SessionFactory hb_sessionFactory = null;
                        try {

                            hb_sessionFactory = new Configuration().configure().buildSessionFactory();

                            JOptionPane.showMessageDialog((Component)getParent(),"Connection test successful!","",JOptionPane.INFORMATION_MESSAGE);

                        } catch (Exception ex)
                        {
                            ex.printStackTrace();
                            JOptionPane.showMessageDialog((Component)getParent(),"Error!!\n"+ex.getMessage(),"Error",JOptionPane.ERROR_MESSAGE);
                            return;					
                        } 
                        finally
                        {

                        }
                    }
                });
            } catch (Exception ex)
            {}
        }
    }//GEN-LAST:event_jButtonOK1ActionPerformed

    private void jButtonWizardActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonWizardActionPerformed
          
        if (jComboBoxJDBCDriver.getSelectedIndex() < 0) return;
        String driver = ""+jComboBoxJDBCDriver.getSelectedItem();
        driver = driver.trim();
        if (driver.equals("")) return;
        
        String server = jTextFieldServerAddress.getText().trim();
        if( server.length()==0 ) {
            server = "localhost";
        }
        
        String databaseName = jTextFieldDBName.getText().trim();
        
        if (driver.equalsIgnoreCase("org.gjt.mm.mysql.Driver")) {
            String url = "jdbc:mysql://" + server + "/";
            if ( databaseName.length()>0 )
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.mysql.jdbc.Driver")) {
            String url = "jdbc:mysql://" + server + "/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.internetcds.jdbc.tds.Driver")) {
            String url = "jdbc:freetds:sqlserver://localhost/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.microsoft.jdbc.sqlserver.SQLServerDriver")) {
            String url = "jdbc:microsoft:sqlserver://" + server + ":1433;DatabaseName=";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("sun.jdbc.odbc.JdbcOdbcDriver")) {
            String url = "jdbc:odbc:";
            if (databaseName.length()>0)
                url += jTextFieldDBName.getText();
            else
                url += "DSNAME";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.ms.jdbc.odbc.JdbcOdbcDriver")) {
            String url = "jdbc:odbc:";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "DSNAME";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("oracle.jdbc.driver.OracleDriver")) {
            String url = "jdbc:oracle:thin:@" + server + ":1521:";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("COM.ibm.db2.jdbc.app.DB2Driver")) {
            String url = "jdbc:db2:";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.informix.jdbc.IfxDriver")) {
            String url = "jdbc:informix-sqli://" + server + ":port/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            
            url += ":informixserver=SERVERNAME";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.sybase.jdbc2.jdbc.SybDriver")) {
            String url = "jdbc:sybase:Tds:" + server + ":2638/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.mysql.jdbc.Driver")) {
            String url = "jdbc:mysql://"+server+"/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.merant.datadirect.jdbc.sqlserver.SQLServerDriver")) {
            String url = "jdbc:sqlserver://" + server + ":1433/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("com.inet.tds.TdsDriver")) {
            String url = "jdbc:inetdae7:"+server+":1433/";
            if (databaseName.length()>0)
                url += jTextFieldDBName.getText();
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("org.postgresql.Driver")) {
            String url = "jdbc:postgresql://" + server + ":5432/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("org.hsqldb.jdbcDriver")) {
            String url = "jdbc:hsqldb:[PATH_TO_DB_FILES]/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        }
        else if (driver.equalsIgnoreCase("COM.cloudscape.JDBCDriver ")) {
            String url = "jdbc:cloudscape:/cloudscape/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            jTextFieldJDBCUrl.setText(url);
        } 
        else if (driver.equalsIgnoreCase("net.sourceforge.jtds.jdbc.Driver"))
        {
            String url = "jdbc:jtds:sqlserver://" +
            server + "/";
            if (databaseName.length()>0)
                url += databaseName;
            else
                url += "MYDATABASE";
            url += ";instance=";
            jTextFieldJDBCUrl.setText(url);
        }

    }//GEN-LAST:event_jButtonWizardActionPerformed

    private void jComboBoxConnectionTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxConnectionTypeActionPerformed
        if (init) return;
        jPanelConnectionRoot.removeAll();
        if (jComboBoxConnectionType.getSelectedIndex() == 0)
        {
            jPanelConnectionRoot.add("Center", jPanelJDBC);
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 1)
        {
            jPanelConnectionRoot.add("Center", jPanelXML);
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 2)
        {
            jPanelConnectionRoot.add("Center", jPanelBeansSet);
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 3)
        {
            jPanelConnectionRoot.add("Center", jPanelCustomDataSourceFactory);
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 4)
        {
            jPanelConnectionRoot.add("Center", jPanelCSV);
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 5)
        {
            jPanelConnectionRoot.add("Center", jPanelDatasourceProvider);
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 6)
        {
            jPanelConnectionRoot.add("Center", jPanelHibernate);
        }
        
        jPanelConnectionRoot.updateUI();
    }//GEN-LAST:event_jComboBoxConnectionTypeActionPerformed

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CANCEL_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            javax.swing.JOptionPane.showMessageDialog(this,"Please insert a valid connection name!","Invalid parameter!",javax.swing.JOptionPane.WARNING_MESSAGE );
            return;
        }
        
        if (jComboBoxConnectionType.getSelectedIndex() == 0) {
            iReportConnection = new JDBCConnection();
            iReportConnection.setName( this.jTextFieldName.getText().trim() );
            ((JDBCConnection)iReportConnection).setServerAddress( this.jTextFieldServerAddress.getText().trim() );
            ((JDBCConnection)iReportConnection).setDatabase( this.jTextFieldDBName.getText().trim() );
            ((JDBCConnection)iReportConnection).setUsername( this.jTextFieldUsername.getText().trim() );
            if (jCheckBoxSavePassword.isSelected())
                ((JDBCConnection)iReportConnection).setPassword( this.jTextFieldPassword.getText());
            else
                ((JDBCConnection)iReportConnection).setPassword("");
            ((JDBCConnection)iReportConnection).setSavePassword( jCheckBoxSavePassword.isSelected() );
            ((JDBCConnection)iReportConnection).setJDBCDriver( (this.jComboBoxJDBCDriver.getSelectedItem()+"").trim() );
            if ((this.jComboBoxJDBCDriver.getSelectedItem()+"").trim().length() == 0) {
                javax.swing.JOptionPane.showMessageDialog(this,"Please insert a valid JDBC driver!","Invalid driver!",javax.swing.JOptionPane.WARNING_MESSAGE );
                return;
            }
            
            if (this.jTextFieldJDBCUrl.getText().trim().length() == 0) {
                javax.swing.JOptionPane.showMessageDialog(this,"Please insert a valid JDBC URL!","Invalid url!",javax.swing.JOptionPane.WARNING_MESSAGE );
                return;
            }
            ((JDBCConnection)iReportConnection).setUrl(this.jTextFieldJDBCUrl.getText().trim());
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 2) {
            iReportConnection = new JavaBeanDataSourceConnection();
            iReportConnection.setName( this.jTextFieldName.getText().trim() );
            ((JavaBeanDataSourceConnection)iReportConnection).setFactoryClass( this.jTextFieldJBSetFactoryClass.getText().trim() );
            ((JavaBeanDataSourceConnection)iReportConnection).setMethodToCall( this.jTextFieldJBSetMethodToCall.getText().trim() );
            if (jRadioButtonJBSetArray.isSelected())
            {
                ((JavaBeanDataSourceConnection)iReportConnection).setType( JavaBeanDataSourceConnection.BEAN_ARRAY );
            }
            else
            {
               ((JavaBeanDataSourceConnection)iReportConnection).setType( JavaBeanDataSourceConnection.BEAN_COLLECTION );
            }
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 3) {
            iReportConnection = new JRCustomDataSourceConnection();
            iReportConnection.setName( this.jTextFieldName.getText().trim() );
            ((JRCustomDataSourceConnection)iReportConnection).setFactoryClass( this.jTextFieldJRCustomDataSourceFactoryClass.getText().trim() );
            ((JRCustomDataSourceConnection)iReportConnection).setMethodToCall( this.jTextFieldJRCustomDataSourceMethod.getText().trim() );
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 4) {
            
            iReportConnection = new JRCSVDataSourceConnection();
            iReportConnection.setName( this.jTextFieldName.getText().trim() );
            ((JRCSVDataSourceConnection)iReportConnection).setFilename( this.jTextFieldCSVFilename.getText().trim() );
            
            if (jRadioButtonCVSSeparatorComma.isSelected()) ((JRCSVDataSourceConnection)iReportConnection).setFieldDelimiter(",");
            if (jRadioButtonCVSSeparatorTab.isSelected()) ((JRCSVDataSourceConnection)iReportConnection).setFieldDelimiter("\t");
            if (jRadioButtonCVSSeparatorSpace.isSelected()) ((JRCSVDataSourceConnection)iReportConnection).setFieldDelimiter(" ");
            if (jRadioButtonCVSSeparatorSemicolon.isSelected()) ((JRCSVDataSourceConnection)iReportConnection).setFieldDelimiter(";");
            if (jRadioButtonCVSSeparatorNewLine.isSelected()) ((JRCSVDataSourceConnection)iReportConnection).setFieldDelimiter("\n");
            if (jRadioButtonCVSSeparatorOther.isSelected()) ((JRCSVDataSourceConnection)iReportConnection).setFieldDelimiter(jTextFieldCVSSeparatorText.getText());
            
            if (jRadioButtonCVSSeparatorComma1.isSelected()) ((JRCSVDataSourceConnection)iReportConnection).setRecordDelimiter(",");
            if (jRadioButtonCVSSeparatorTab1.isSelected()) ((JRCSVDataSourceConnection)iReportConnection).setRecordDelimiter("\t");
            if (jRadioButtonCVSSeparatorSpace1.isSelected()) ((JRCSVDataSourceConnection)iReportConnection).setRecordDelimiter(" ");
            if (jRadioButtonCVSSeparatorSemicolon1.isSelected()) ((JRCSVDataSourceConnection)iReportConnection).setRecordDelimiter(";");
            if (jRadioButtonCVSSeparatorNewLine1.isSelected()) ((JRCSVDataSourceConnection)iReportConnection).setRecordDelimiter("\n");
            if (jRadioButtonCVSSeparatorOther1.isSelected()) ((JRCSVDataSourceConnection)iReportConnection).setRecordDelimiter(jTextFieldCVSSeparatorText1.getText());
            
            ((JRCSVDataSourceConnection)iReportConnection).setCustomDateFormat( jCheckBoxCVSDateFormat.isSelected() ?  jTextFieldCVSDateFormat.getText() : "");
            ((JRCSVDataSourceConnection)iReportConnection).setUseFirstRowAsHeader( jCheckBoxCVSFirstRowAsHeader.isSelected() );
            
            DefaultListModel dlm = (DefaultListModel)this.jListCVSColumns.getModel();
            Vector columnsNames = new Vector();
            for (int k=0; k< dlm.size(); ++k)
            {
                columnsNames.add(dlm.elementAt(k)+"");
            }
            
            ((JRCSVDataSourceConnection)iReportConnection).setColumnNames( columnsNames );
            
            if (columnsNames.size() == 0)
            {
                if (JOptionPane.showConfirmDialog(this,"You have not defined any column for your CSV file. Continue anyway?","",JOptionPane.INFORMATION_MESSAGE) != JOptionPane.OK_OPTION)
                {
                    return;
                }
            }
            if (((JRCSVDataSourceConnection)iReportConnection).getFieldDelimiter().equals( ((JRCSVDataSourceConnection)iReportConnection).getRecordDelimiter() ))
            {
                if (JOptionPane.showConfirmDialog(this,"Field delimiter char is the same as the record delimiter. Continue anyway?","",JOptionPane.INFORMATION_MESSAGE) != JOptionPane.OK_OPTION)
                {
                    return;
                }
            }
            
            
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 1) {
            iReportConnection = new JRXMLDataSourceConnection();
            iReportConnection.setName( this.jTextFieldName.getText().trim() );
            ((JRXMLDataSourceConnection)iReportConnection).setFilename( this.jTextFieldXMLFile.getText().trim() );
            ((JRXMLDataSourceConnection)iReportConnection).setSelectExpression( this.jTextFieldRecordPath.getText().trim() );
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 5) {
            iReportConnection = new JRDataSourceProviderConnection();
            iReportConnection.setName( this.jTextFieldName.getText().trim() );
            ((JRDataSourceProviderConnection)iReportConnection).getProperties().put("JRDataSourceProvider", this.jTextFieldJRDataSourceProvider.getText().trim() );
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 6) {
            iReportConnection = new JRHibernateConnection();
            iReportConnection.setName( this.jTextFieldName.getText().trim() );
        }
        
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.OK_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CLOSED_OPTION);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new JRParameterDialog(new javax.swing.JFrame(), true).show();
    }
    
    /** Getter for property tmpParameter.
     * @return Value of property tmpParameter.
     *
     */
    public it.businesslogic.ireport.JRParameter getParameter() {
        return tmpParameter;
    }    
    
    /** Setter for property tmpParameter.
     * @param tmpParameter New value of property tmpParameter.
     *
     */
    public void setParameter(it.businesslogic.ireport.JRParameter tmpParameter) {
       }
    
    /** Getter for property dialogResult.
     * @return Value of property dialogResult.
     *
     */
    public int getDialogResult() {
        return dialogResult;
    }
    
    /** Setter for property dialogResult.
     * @param dialogResult New value of property dialogResult.
     *
     */
    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    /** Getter for property iReportConnection.
     * @return Value of property iReportConnection.
     *
     */
    public it.businesslogic.ireport.IReportConnection getIReportConnection() {
        return iReportConnection;
    }
    
    /** Setter for property iReportConnection.
     * @param iReportConnection New value of property iReportConnection.
     *
     */
    public void setIReportConnection(it.businesslogic.ireport.IReportConnection iReportConnection) {
        this.iReportConnection = iReportConnection;
        
        this.jTextFieldName.setText( iReportConnection.getName());
        if (iReportConnection instanceof JDBCConnection)
        {
            JDBCConnection con = (JDBCConnection)iReportConnection;
            this.jComboBoxConnectionType.setSelectedIndex(0);
            this.jComboBoxJDBCDriver.setSelectedItem(con.getJDBCDriver());
            this.jTextFieldJDBCUrl.setText( con.getUrl());
            this.jTextFieldServerAddress.setText( con.getServerAddress() );
            this.jTextFieldDBName.setText( con.getDatabase() );
            this.jTextFieldUsername.setText( con.getUsername());
            if (con.isSavePassword())
                this.jTextFieldPassword.setText( con.getPassword());
            else 
                this.jTextFieldPassword.setText( "");
            this.jCheckBoxSavePassword.setSelected( con.isSavePassword());
        }
        else if (iReportConnection instanceof JRCustomDataSourceConnection)
        {
            JRCustomDataSourceConnection con = (JRCustomDataSourceConnection)iReportConnection;
            this.jComboBoxConnectionType.setSelectedIndex(3);
            this.jTextFieldJRCustomDataSourceFactoryClass.setText( con.getFactoryClass());
            this.jTextFieldJRCustomDataSourceMethod.setText(con.getMethodToCall());
        }
        else if (iReportConnection instanceof JavaBeanDataSourceConnection)
        {
            JavaBeanDataSourceConnection con = (JavaBeanDataSourceConnection)iReportConnection;
            this.jComboBoxConnectionType.setSelectedIndex(2);
            this.jTextFieldJBSetFactoryClass.setText( con.getFactoryClass());
            this.jTextFieldJBSetMethodToCall.setText(con.getMethodToCall());
            if (con.getType().equals(con.BEAN_ARRAY)  )
            {
                jRadioButtonJBSetArray.setSelected(true);
                jRadioButtonJBSetCollection.setSelected(false);
            }
            else
            {
                jRadioButtonJBSetArray.setSelected(false);
                jRadioButtonJBSetCollection.setSelected(true);
            }
        }
        else if (iReportConnection instanceof JRCSVDataSourceConnection)
        {
            JRCSVDataSourceConnection con = (JRCSVDataSourceConnection)iReportConnection;
            this.jComboBoxConnectionType.setSelectedIndex(4);
            this.jTextFieldCSVFilename.setText( con.getFilename() );
            
            if (con.getCustomDateFormat().length() > 0)
            {
                this.jCheckBoxCVSDateFormat.setSelected(true);
                this.jTextFieldCVSDateFormat.setText(con.getCustomDateFormat());
                this.jTextFieldCVSDateFormat.setEnabled(true);
                this.jButtonCVSDateFormat.setEnabled(true);
            }
            
            this.jCheckBoxCVSFirstRowAsHeader.setSelected( con.isUseFirstRowAsHeader() );
            
            String fieldSeparator = con.getFieldDelimiter();
            if (fieldSeparator.equals(",")) this.jRadioButtonCVSSeparatorComma.setSelected(true);
            else if (fieldSeparator.equals("\t")) this.jRadioButtonCVSSeparatorTab.setSelected(true);
            else if (fieldSeparator.equals(" ")) this.jRadioButtonCVSSeparatorSpace.setSelected(true);
            else if (fieldSeparator.equals(";")) this.jRadioButtonCVSSeparatorSemicolon.setSelected(true);
            else if (fieldSeparator.equals("\n")) this.jRadioButtonCVSSeparatorNewLine.setSelected(true);
            else {
                this.jRadioButtonCVSSeparatorOther.setSelected(true);
                this.jTextFieldCVSSeparatorText.setText(fieldSeparator);
            }
            
            String rowSeparator = con.getRecordDelimiter();
            if (rowSeparator.equals(",")) this.jRadioButtonCVSSeparatorComma1.setSelected(true);
            else if (rowSeparator.equals("\t")) this.jRadioButtonCVSSeparatorTab1.setSelected(true);
            else if (rowSeparator.equals(" ")) this.jRadioButtonCVSSeparatorSpace1.setSelected(true);
            else if (rowSeparator.equals(";")) this.jRadioButtonCVSSeparatorSemicolon1.setSelected(true);
            else if (rowSeparator.equals("\n")) this.jRadioButtonCVSSeparatorNewLine1.setSelected(true);
            else {
                this.jRadioButtonCVSSeparatorOther1.setSelected(true);
                this.jTextFieldCVSSeparatorText1.setText(rowSeparator);
            }
            
            DefaultListModel dlm = (DefaultListModel)this.jListCVSColumns.getModel();

            for (int i=0; i< con.getColumnNames().size(); ++i)
            {
                dlm.addElement(con.getColumnNames().elementAt(i)+"" );
            }
            
            if (dlm.size() > 0)
            {
                jListCVSColumns.setSelectedIndex(0);
            }
            
        }
        else if (iReportConnection instanceof JRXMLDataSourceConnection)
        {
            JRXMLDataSourceConnection con = (JRXMLDataSourceConnection)iReportConnection;
            this.jComboBoxConnectionType.setSelectedIndex(1);
            this.jTextFieldXMLFile.setText( con.getFilename() );
            this.jTextFieldRecordPath.setText( con.getSelectExpression() );            
        }
         else if (iReportConnection instanceof JRDataSourceProviderConnection)
        {
            JRDataSourceProviderConnection con = (JRDataSourceProviderConnection)iReportConnection;
            this.jComboBoxConnectionType.setSelectedIndex(5);
            this.jTextFieldJRDataSourceProvider.setText( it.businesslogic.ireport.util.Misc.nvl(con.getProperties().get("JRDataSourceProvider"), "") );            
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupBeansSetType;
    private javax.swing.ButtonGroup buttonGroupCVSFieldSeparator;
    private javax.swing.ButtonGroup buttonGroupCVSFieldSeparator1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButtonCSVFilename;
    private javax.swing.JButton jButtonCVSDateFormat;
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonDeleteParameter;
    private javax.swing.JButton jButtonModifyParameter;
    private javax.swing.JButton jButtonNewParameter;
    private javax.swing.JButton jButtonNewParameter1;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JButton jButtonOK1;
    private javax.swing.JButton jButtonWizard;
    private javax.swing.JCheckBox jCheckBoxCVSDateFormat;
    private javax.swing.JCheckBox jCheckBoxCVSFirstRowAsHeader;
    private javax.swing.JCheckBox jCheckBoxSavePassword;
    private javax.swing.JComboBox jComboBoxConnectionType;
    private javax.swing.JComboBox jComboBoxJDBCDriver;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JList jListCVSColumns;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel12;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JPanel jPanelBeansSet;
    private javax.swing.JPanel jPanelButtons;
    private javax.swing.JPanel jPanelCSV;
    private javax.swing.JPanel jPanelConnectionRoot;
    private javax.swing.JPanel jPanelConnectionType;
    private javax.swing.JPanel jPanelCustomDataSourceFactory;
    private javax.swing.JPanel jPanelDatasourceProvider;
    private javax.swing.JPanel jPanelHibernate;
    private javax.swing.JPanel jPanelJDBC;
    private javax.swing.JPanel jPanelXML;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorComma;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorComma1;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorNewLine;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorNewLine1;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorOther;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorOther1;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorSemicolon;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorSemicolon1;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorSpace;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorSpace1;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorTab;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorTab1;
    private javax.swing.JRadioButton jRadioButtonJBSetArray;
    private javax.swing.JRadioButton jRadioButtonJBSetCollection;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JSeparator jSeparator4;
    private javax.swing.JSeparator jSeparator5;
    private javax.swing.JSeparator jSeparator6;
    private javax.swing.JSeparator jSeparator7;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JTextField jTextFieldCSVFilename;
    private javax.swing.JTextField jTextFieldCVSDateFormat;
    private javax.swing.JTextField jTextFieldCVSSeparatorText;
    private javax.swing.JTextField jTextFieldCVSSeparatorText1;
    private javax.swing.JTextField jTextFieldDBName;
    private javax.swing.JTextField jTextFieldJBSetFactoryClass;
    private javax.swing.JTextField jTextFieldJBSetMethodToCall;
    private javax.swing.JTextField jTextFieldJDBCUrl;
    private javax.swing.JTextField jTextFieldJRCustomDataSourceFactoryClass;
    private javax.swing.JTextField jTextFieldJRCustomDataSourceMethod;
    private javax.swing.JTextField jTextFieldJRDataSourceProvider;
    private javax.swing.JTextField jTextFieldName;
    private javax.swing.JPasswordField jTextFieldPassword;
    private javax.swing.JTextField jTextFieldRecordPath;
    private javax.swing.JTextField jTextFieldServerAddress;
    private javax.swing.JTextField jTextFieldUsername;
    private javax.swing.JTextField jTextFieldXMLFile;
    private javax.swing.JTextPane jTextPane1;
    // End of variables declaration//GEN-END:variables

    private int dialogResult;    
    
    private IReportConnection iReportConnection;
    
}
