/*
 * IReportChartDialog.java
 *
 * Created on 29 settembre 2004, 0.56
 */

package it.businesslogic.ireport.chart.gui;
import it.businesslogic.ireport.gui.*;
import it.businesslogic.ireport.*;
import javax.swing.tree.*;
import javax.swing.table.*;
import javax.swing.*;
import it.businesslogic.ireport.chart.*;
import java.util.*;
/**
 *
 * @author  Administrator
 */
public class ReportSeriesDialog extends javax.swing.JDialog {
   
    private int dialogResult = javax.swing.JOptionPane.OK_OPTION;
    private JReportFrame jReportFrame = null;
    /** Creates new form IReportChartDialog */
    public ReportSeriesDialog(java.awt.Dialog parent, boolean modal) {
        super(parent, modal);
        initComponents();
        initFrame();  
    }
    
    public void initFrame()
    {
        javax.swing.DefaultListModel dlm =  new javax.swing.DefaultListModel() ;
        jList1.setModel(dlm );
        jList1.updateUI();       
        
        this.setSize(500,400);
        it.businesslogic.ireport.util.Misc.centerFrame(this);
        
    }
    
    public ReportSeriesDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        initFrame();
        
    }
    
    public void updateSeriesList()
    {
        
        Vector values = new Vector();
        
        javax.swing.DefaultListModel dlm =  (javax.swing.DefaultListModel)jList1.getModel();
        dlm.removeAllElements();

        if (getJReportFrame() == null) {  jList1.updateUI(); return; }
        
        // Look for variables that starts with SERIE_
        
        Enumeration var_enum = getJReportFrame().getReport().getVariables().elements();
        while (var_enum.hasMoreElements())
        {
            JRVariable var = (JRVariable)var_enum.nextElement();
            if (var.getName().startsWith("SERIE_"))
            {
                dlm.addElement( var );
            }
        }
        jList1.updateUI();
    }

    public JReportFrame getJReportFrame() {
        
        return jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {

        this.jReportFrame = jReportFrame;
        updateSeriesList();
    }

    public int getDialogResult() {
        return dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelData = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jPanel2 = new javax.swing.JPanel();
        jButtonNewSerie = new javax.swing.JButton();
        jButtonModifySerie = new javax.swing.JButton();
        jButtonDeleteSerie = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jButtonClose = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Report Series");
        jPanelData.setLayout(new java.awt.GridBagLayout());

        jList1.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jList1ValueChanged(evt);
            }
        });

        jScrollPane3.setViewportView(jList1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanelData.add(jScrollPane3, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setMinimumSize(new java.awt.Dimension(100, 151));
        jPanel2.setPreferredSize(new java.awt.Dimension(140, 100));
        jButtonNewSerie.setFont(new java.awt.Font("Tahoma", 0, 11));
        jButtonNewSerie.setText("New serie");
        jButtonNewSerie.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonNewSerieActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jButtonNewSerie, gridBagConstraints);

        jButtonModifySerie.setFont(new java.awt.Font("Tahoma", 0, 11));
        jButtonModifySerie.setEnabled(false);
        jButtonModifySerie.setLabel("Modify serie");
        jButtonModifySerie.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModifySerieActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanel2.add(jButtonModifySerie, gridBagConstraints);

        jButtonDeleteSerie.setFont(new java.awt.Font("Tahoma", 0, 11));
        jButtonDeleteSerie.setEnabled(false);
        jButtonDeleteSerie.setLabel("Remove serie");
        jButtonDeleteSerie.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDeleteSerieActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        jPanel2.add(jButtonDeleteSerie, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(jPanel3, gridBagConstraints);

        jButtonClose.setFont(new java.awt.Font("Tahoma", 0, 11));
        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jButtonClose, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 4);
        jPanelData.add(jPanel2, gridBagConstraints);

        getContentPane().add(jPanelData, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents

    private void jButtonDeleteSerieActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeleteSerieActionPerformed
        
        Object[] vars = jList1.getSelectedValues();
        
        for (int i=0; i<vars.length; ++i)
        {
            JRVariable var = (JRVariable)vars[i];
            this.getJReportFrame().getReport().removeVariable( var );
        }
        
        this.updateSeriesList();
        this.getJReportFrame().getMainFrame().getValuesDialog().getValuesPanel().updateVariables();
        
    }//GEN-LAST:event_jButtonDeleteSerieActionPerformed

    private void jButtonModifySerieActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModifySerieActionPerformed
        
        SerieDialog sd = new SerieDialog(this, true);
        sd.setJrf( this.getJReportFrame());
        JRVariable var = (JRVariable)jList1.getSelectedValue() ;
        sd.setVariable( var );
        sd.setVisible(true);
        if (sd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            String var_name = "SERIE_";
            if (!sd.getSerieReset().equals(""))
            {
                var_name += "G_" + sd.getSerieReset() + "_";
            }
            var_name += sd.getSerieName();
            
            var.setName(var_name);
            var.setResetType("Report");
            var.setCalculation("Nothing");
            var.setClassType( sd.getSerieType());
            var.setExpression( sd.getSerieExpression());
            
            this.updateSeriesList();
            this.getJReportFrame().getMainFrame().getValuesDialog().getValuesPanel().updateVariables();
        }
        
    }//GEN-LAST:event_jButtonModifySerieActionPerformed

    private void jButtonNewSerieActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNewSerieActionPerformed
        
        SerieDialog sd = new SerieDialog(this, true);
        sd.setJrf( this.getJReportFrame());
        sd.setVisible(true);
        if (sd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            String var_name = "SERIE_";
            if (!sd.getSerieReset().equals(""))
            {
                var_name += "G_" + sd.getSerieReset() + "_";
            }
            var_name += sd.getSerieName();
            
            JRVariable var = new JRVariable(var_name, false);
            var.setResetType("Report");
            var.setCalculation("Nothing");
            var.setClassType( sd.getSerieType());
            var.setExpression( sd.getSerieExpression());
            this.getJReportFrame().getReport().addVariable( var );
            
            this.updateSeriesList();
            this.getJReportFrame().getMainFrame().getValuesDialog().getValuesPanel().updateVariables();
        }
        
    }//GEN-LAST:event_jButtonNewSerieActionPerformed

    private void jList1ValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jList1ValueChanged
        
         if (this.jList1.getSelectedIndex() >= 0) {
            this.jButtonModifySerie.setEnabled(true);
            this.jButtonDeleteSerie.setEnabled(true);
        }
        else {
            this.jButtonModifySerie.setEnabled(false);
            this.jButtonDeleteSerie.setEnabled(false);
        }
        
        
    }//GEN-LAST:event_jList1ValueChanged

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
       
        this.setDialogResult( javax.swing.JOptionPane.OK_OPTION);
        this.setVisible(false);
    }//GEN-LAST:event_jButtonCloseActionPerformed
    

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonDeleteSerie;
    private javax.swing.JButton jButtonModifySerie;
    private javax.swing.JButton jButtonNewSerie;
    private javax.swing.JList jList1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanelData;
    private javax.swing.JScrollPane jScrollPane3;
    // End of variables declaration//GEN-END:variables

}
