/*
 * PieDatasetPanel.java
 *
 * Created on 15 agosto 2005, 17.55
 */

package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.SubDataset;

/**
 *
 * @author  Administrator
 */
public class HighLowDatasetPanel extends javax.swing.JPanel implements ChartDatasetPanel {
    
    private HighLowDataset highLowDataset = null;
    
    /** Creates new form PieDatasetPanel */
    public HighLowDatasetPanel() {
        initComponents();
        
        applyI18n();
        
        this.jRTextExpressionSeries.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionSeriesTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionSeriesTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionSeriesTextChanged();
            }
        });
        
        
        this.jRTextExpressionDate.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionDateTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionDateTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionDateTextChanged();
            }
        });
        
        this.jRTextExpressionVolume.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionVolumeTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionVolumeTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionVolumeTextChanged();
            }
        });
        
        this.jRTextExpressionHigh.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionHighTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionHighTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionHighTextChanged();
            }
        });
        
        this.jRTextExpressionLow.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionLowTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionLowTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionLowTextChanged();
            }
        });
        
        this.jRTextExpressionOpen.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionOpenTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionOpenTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionOpenTextChanged();
            }
        });
        
        this.jRTextExpressionClose.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionCloseTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionCloseTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionCloseTextChanged();
            }
        });
    }

    public HighLowDataset getHighLowDataset() {
        return highLowDataset;
    }
    
    /**
     * this method is used to pass the correct subdataset to the expression editor
     */
    public void setSubDataset( SubDataset sds )
    {
        jRTextExpressionSeries.setSubDataset(sds);
        jRTextExpressionDate.setSubDataset(sds);
        jRTextExpressionHigh.setSubDataset(sds);
        jRTextExpressionLow.setSubDataset(sds);
        jRTextExpressionOpen.setSubDataset(sds);
        jRTextExpressionClose.setSubDataset(sds);
        jRTextExpressionVolume.setSubDataset(sds);
    }

    public void setHighLowDataset(HighLowDataset highLowDataset) {
        this.highLowDataset = highLowDataset;
        jRTextExpressionSeries.setText( highLowDataset.getSeriesExpression() );
        jRTextExpressionDate.setText( highLowDataset.getDateExpression() );
        jRTextExpressionHigh.setText( highLowDataset.getHighExpression() );
        jRTextExpressionLow.setText( highLowDataset.getLowExpression() );
        jRTextExpressionOpen.setText( highLowDataset.getOpenExpression() );
        jRTextExpressionClose.setText( highLowDataset.getCloseExpression() );
        jRTextExpressionVolume.setText( highLowDataset.getVolumeExpression() );
    }
    
    public void jRTextExpressionSeriesTextChanged()
    {
        highLowDataset.setSeriesExpression( jRTextExpressionSeries.getText() );
    }
    
    public void jRTextExpressionDateTextChanged()
    {
        highLowDataset.setDateExpression( jRTextExpressionDate.getText() );
    }
    
    public void jRTextExpressionHighTextChanged()
    {
        highLowDataset.setHighExpression( jRTextExpressionHigh.getText() );
    }
    
    public void jRTextExpressionLowTextChanged()
    {
        highLowDataset.setLowExpression( jRTextExpressionLow.getText() );
    }
    
    public void jRTextExpressionOpenTextChanged()
    {
        highLowDataset.setOpenExpression( jRTextExpressionOpen.getText() );
    }
    
    public void jRTextExpressionCloseTextChanged()
    {
        highLowDataset.setCloseExpression( jRTextExpressionClose.getText() );
    }
    
    public void jRTextExpressionVolumeTextChanged()
    {
        highLowDataset.setVolumeExpression( jRTextExpressionVolume.getText() );
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelSeriesExpression = new javax.swing.JLabel();
        jLabelDateExpression = new javax.swing.JLabel();
        jRTextExpressionSeries = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jRTextExpressionDate = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanelHL = new javax.swing.JPanel();
        jLabelHighExpression = new javax.swing.JLabel();
        jRTextExpressionHigh = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabelLowExpression = new javax.swing.JLabel();
        jRTextExpressionLow = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jPanelOC = new javax.swing.JPanel();
        jLabelOpenExpression = new javax.swing.JLabel();
        jRTextExpressionOpen = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabelCloseExpression = new javax.swing.JLabel();
        jRTextExpressionClose = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jPanel1 = new javax.swing.JPanel();
        jLabelVolumeExpression = new javax.swing.JLabel();
        jRTextExpressionVolume = new it.businesslogic.ireport.gui.JRTextExpressionArea();

        setLayout(new java.awt.GridBagLayout());

        jLabelSeriesExpression.setFont(new java.awt.Font("Tahoma", 0, 11));
        jLabelSeriesExpression.setText("Series expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(jLabelSeriesExpression, gridBagConstraints);

        jLabelDateExpression.setFont(new java.awt.Font("Tahoma", 0, 11));
        jLabelDateExpression.setText("Date expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        add(jLabelDateExpression, gridBagConstraints);

        jRTextExpressionSeries.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionSeries.setElectricScroll(0);
        jRTextExpressionSeries.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionSeries.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        add(jRTextExpressionSeries, gridBagConstraints);

        jRTextExpressionDate.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionDate.setElectricScroll(0);
        jRTextExpressionDate.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionDate.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        add(jRTextExpressionDate, gridBagConstraints);

        jTabbedPane1.setFont(new java.awt.Font("Tahoma", 0, 11));
        jPanelHL.setLayout(new java.awt.GridBagLayout());

        jLabelHighExpression.setFont(new java.awt.Font("Tahoma", 0, 11));
        jLabelHighExpression.setText("High expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanelHL.add(jLabelHighExpression, gridBagConstraints);

        jRTextExpressionHigh.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionHigh.setElectricScroll(0);
        jRTextExpressionHigh.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionHigh.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelHL.add(jRTextExpressionHigh, gridBagConstraints);

        jLabelLowExpression.setFont(new java.awt.Font("Tahoma", 0, 11));
        jLabelLowExpression.setText("Low expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 0, 0);
        jPanelHL.add(jLabelLowExpression, gridBagConstraints);

        jRTextExpressionLow.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionLow.setElectricScroll(0);
        jRTextExpressionLow.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionLow.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        jPanelHL.add(jRTextExpressionLow, gridBagConstraints);

        jTabbedPane1.addTab("High/Low", jPanelHL);

        jPanelOC.setLayout(new java.awt.GridBagLayout());

        jLabelOpenExpression.setFont(new java.awt.Font("Tahoma", 0, 11));
        jLabelOpenExpression.setText("Open expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanelOC.add(jLabelOpenExpression, gridBagConstraints);

        jRTextExpressionOpen.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionOpen.setElectricScroll(0);
        jRTextExpressionOpen.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionOpen.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelOC.add(jRTextExpressionOpen, gridBagConstraints);

        jLabelCloseExpression.setFont(new java.awt.Font("Tahoma", 0, 11));
        jLabelCloseExpression.setText("Close expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanelOC.add(jLabelCloseExpression, gridBagConstraints);

        jRTextExpressionClose.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionClose.setElectricScroll(0);
        jRTextExpressionClose.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionClose.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelOC.add(jRTextExpressionClose, gridBagConstraints);

        jTabbedPane1.addTab("Open/Close", jPanelOC);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jLabelVolumeExpression.setFont(new java.awt.Font("Tahoma", 0, 11));
        jLabelVolumeExpression.setText("Volume expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jLabelVolumeExpression, gridBagConstraints);

        jRTextExpressionVolume.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionVolume.setElectricScroll(0);
        jRTextExpressionVolume.setMinimumSize(new java.awt.Dimension(10, 10));
        jRTextExpressionVolume.setPreferredSize(new java.awt.Dimension(10, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jRTextExpressionVolume, gridBagConstraints);

        jTabbedPane1.addTab("Volume", jPanel1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
        add(jTabbedPane1, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabelCloseExpression;
    private javax.swing.JLabel jLabelDateExpression;
    private javax.swing.JLabel jLabelHighExpression;
    private javax.swing.JLabel jLabelLowExpression;
    private javax.swing.JLabel jLabelOpenExpression;
    private javax.swing.JLabel jLabelSeriesExpression;
    private javax.swing.JLabel jLabelVolumeExpression;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanelHL;
    private javax.swing.JPanel jPanelOC;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionClose;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionDate;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionHigh;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionLow;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionOpen;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionSeries;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionVolume;
    private javax.swing.JTabbedPane jTabbedPane1;
    // End of variables declaration//GEN-END:variables
    
    public void applyI18n()
    {
        jLabelSeriesExpression.setText(it.businesslogic.ireport.util.I18n.getString("charts.seriesExpression", "Series expression"));
        jLabelDateExpression.setText(it.businesslogic.ireport.util.I18n.getString("charts.dateExpression", "Date expression"));
        jLabelHighExpression.setText(it.businesslogic.ireport.util.I18n.getString("charts.highExpression", "High expression"));
        jLabelLowExpression.setText(it.businesslogic.ireport.util.I18n.getString("charts.lowExpression", "Low expression"));
        jLabelOpenExpression.setText(it.businesslogic.ireport.util.I18n.getString("charts.openExpression", "Open expression"));
        jLabelCloseExpression.setText(it.businesslogic.ireport.util.I18n.getString("charts.closeExpression", "Close expression"));
        jLabelVolumeExpression.setText(it.businesslogic.ireport.util.I18n.getString("charts.volumeExpression", "Volume expression"));
        this.updateUI();
        
    }
         
}
