/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.base.JRBaseCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.fill.JRCrosstabExpressionEvaluator;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabCell;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabGroup;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabMeasure;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabParameter;
import net.sf.jasperreports.crosstabs.fill.JRFillCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingService;
import net.sf.jasperreports.crosstabs.fill.calculation.CrosstabCell;
import net.sf.jasperreports.crosstabs.fill.calculation.HeaderCell;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDefaultCompiler;
import net.sf.jasperreports.engine.design.JRDesignRectangle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillCellContents;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRTemplatePrintRectangle;
import net.sf.jasperreports.engine.fill.JRTemplateRectangle;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.jfree.data.general.Dataset;

public class JRFillCrosstab
extends JRFillElement
implements JRCrosstab {
    protected final JRCrosstab parentCrosstab;
    protected JRFillCrosstabDataset dataset;
    protected JRFillCrosstabRowGroup[] rowGroups;
    protected Map rowGroupsMap;
    protected JRFillCrosstabColumnGroup[] columnGroups;
    protected Map columnGroupsMap;
    protected JRFillCrosstabMeasure[] measures;
    protected BucketingService bucketingService;
    protected JRFillVariable[] variables;
    protected Map variablesMap;
    protected JRFillVariable[][][] totalVariables;
    protected boolean[][] retrieveTotal;
    protected JRFillCrosstabParameter[] parameters;
    protected Map parametersMap;
    protected JRCrosstabExpressionEvaluator crosstabEvaluator;
    protected JRFillCrosstabCell[][] crossCells;
    protected JRFillCellContents headerCell;
    protected JRFillCellContents whenNoDataCell;
    protected boolean hasData;
    protected HeaderCell[][] columnHeadersData;
    protected HeaderCell[][] rowHeadersData;
    protected CrosstabCell[][] cellData;
    protected MeasureDefinition.MeasureValue[] grandTotals;
    private boolean percentage;
    private CrosstabFiller crosstabFiller;

    public JRFillCrosstab(JRBaseFiller filler, JRCrosstab crosstab, JRFillObjectFactory factory) {
        super(filler, crosstab, factory);
        this.parentCrosstab = crosstab;
        this.loadEvaluator(filler.getJasperReport());
        JRFillObjectFactory crosstabFactory = new JRFillObjectFactory(filler, this.crosstabEvaluator);
        this.headerCell = crosstabFactory.getCell(crosstab.getHeaderCell());
        this.copyRowGroups(crosstab, crosstabFactory);
        this.copyColumnGroups(crosstab, crosstabFactory);
        this.copyMeasures(crosstab, crosstabFactory);
        this.copyCells(crosstab, crosstabFactory);
        this.whenNoDataCell = crosstabFactory.getCell(crosstab.getWhenNoDataCell());
        this.dataset = factory.getCrosstabDataset(crosstab.getDataset(), this);
        this.copyParameters(crosstab, factory);
        this.copyVariables(crosstab, crosstabFactory);
        this.crosstabFiller = new CrosstabFiller();
    }

    private void copyRowGroups(JRCrosstab crosstab, JRFillObjectFactory factory) {
        JRCrosstabRowGroup[] groups = crosstab.getRowGroups();
        this.rowGroups = new JRFillCrosstabRowGroup[groups.length];
        this.rowGroupsMap = new HashMap();
        for (int i = 0; i < groups.length; ++i) {
            JRFillCrosstabRowGroup group = factory.getCrosstabRowGroup(groups[i]);
            group.getFillHeader().setVerticalPositionType(groups[i].getPosition());
            this.rowGroups[i] = group;
            this.rowGroupsMap.put(group.getName(), new Integer(i));
        }
    }

    private void copyColumnGroups(JRCrosstab crosstab, JRFillObjectFactory factory) {
        JRCrosstabColumnGroup[] groups = crosstab.getColumnGroups();
        this.columnGroups = new JRFillCrosstabColumnGroup[groups.length];
        this.columnGroupsMap = new HashMap();
        for (int i = 0; i < groups.length; ++i) {
            JRFillCrosstabColumnGroup group;
            this.columnGroups[i] = group = factory.getCrosstabColumnGroup(groups[i]);
            this.columnGroupsMap.put(group.getName(), new Integer(i));
        }
    }

    private void copyMeasures(JRCrosstab crosstab, JRFillObjectFactory factory) {
        JRCrosstabMeasure[] crossMeasures = crosstab.getMeasures();
        this.measures = new JRFillCrosstabMeasure[crossMeasures.length];
        for (int i = 0; i < crossMeasures.length; ++i) {
            this.measures[i] = factory.getCrosstabMeasure(crossMeasures[i]);
        }
    }

    private void copyParameters(JRCrosstab crosstab, JRFillObjectFactory factory) {
        JRCrosstabParameter[] crossParams = crosstab.getParameters();
        this.parameters = new JRFillCrosstabParameter[crossParams.length];
        this.parametersMap = new HashMap();
        for (int i = 0; i < crossParams.length; ++i) {
            this.parameters[i] = factory.getCrosstabParameter(crossParams[i]);
            this.parametersMap.put(this.parameters[i].getName(), this.parameters[i]);
        }
    }

    private void copyCells(JRCrosstab crosstab, JRFillObjectFactory factory) {
        JRCrosstabCell[][] crosstabCells = crosstab.getCells();
        this.crossCells = new JRFillCrosstabCell[this.rowGroups.length + 1][this.columnGroups.length + 1];
        for (int i = 0; i <= this.rowGroups.length; ++i) {
            for (int j = 0; j <= this.columnGroups.length; ++j) {
                if (crosstabCells[i][j] == null) continue;
                this.crossCells[i][j] = factory.getCrosstabCell(crosstabCells[i][j]);
            }
        }
    }

    private void copyVariables(JRCrosstab crosstab, JRFillObjectFactory factory) {
        JRVariable[] vars = crosstab.getVariables();
        this.variables = new JRFillVariable[vars.length];
        this.variablesMap = new HashMap();
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i] = factory.getVariable(vars[i]);
            this.variablesMap.put(this.variables[i].getName(), this.variables[i]);
        }
        HashMap<String, int[]> totalVarPos = new HashMap<String, int[]>();
        this.totalVariables = new JRFillVariable[this.rowGroups.length + 1][this.columnGroups.length + 1][this.measures.length];
        for (int row = 0; row <= this.rowGroups.length; ++row) {
            JRFillCrosstabRowGroup rowGroup = row == this.rowGroups.length ? null : this.rowGroups[row];
            for (int col = 0; col <= this.columnGroups.length; ++col) {
                JRFillCrosstabColumnGroup colGroup;
                JRFillCrosstabColumnGroup jRFillCrosstabColumnGroup = colGroup = col == this.columnGroups.length ? null : this.columnGroups[col];
                if (row >= this.rowGroups.length && col >= this.columnGroups.length) continue;
                for (int m = 0; m < this.measures.length; ++m) {
                    String totalVariableName = JRDesignCrosstab.getTotalVariableName(this.measures[m], rowGroup, colGroup);
                    this.totalVariables[row][col][m] = (JRFillVariable)this.variablesMap.get(totalVariableName);
                    totalVarPos.put(totalVariableName, new int[]{row, col});
                }
            }
        }
        this.retrieveTotal = new boolean[this.rowGroups.length + 1][this.columnGroups.length + 1];
        JRExpressionCollector collector = new JRExpressionCollector();
        collector.collect(crosstab);
        List expressions = collector.getExpressions(crosstab);
        Iterator iter = expressions.iterator();
        while (iter.hasNext()) {
            JRExpression expression = (JRExpression)iter.next();
            JRExpressionChunk[] chunks = expression.getChunks();
            if (chunks == null) continue;
            for (int i = 0; i < chunks.length; ++i) {
                String varName;
                int[] pos;
                JRExpressionChunk chunk = chunks[i];
                if (chunk.getType() != 4 || (pos = (int[])totalVarPos.get(varName = chunk.getText())) == null) continue;
                this.retrieveTotal[pos[0]][pos[1]] = true;
            }
        }
    }

    protected void loadEvaluator(JasperReport jasperReport) {
        try {
            JREvaluator evaluator = JRDefaultCompiler.getInstance().loadEvaluator(jasperReport, this.parentCrosstab);
            this.crosstabEvaluator = new JRCrosstabExpressionEvaluator(evaluator);
        }
        catch (JRException e) {
            throw new JRRuntimeException("Could not load evaluator for crosstab.", e);
        }
    }

    private BucketingService createService(byte evaluation) throws JRException {
        ArrayList<BucketDefinition> rowBuckets = new ArrayList<BucketDefinition>(this.rowGroups.length);
        for (int i = 0; i < this.rowGroups.length; ++i) {
            rowBuckets.add(this.createServiceBucket(this.rowGroups[i], evaluation));
        }
        ArrayList<BucketDefinition> colBuckets = new ArrayList<BucketDefinition>(this.columnGroups.length);
        for (int i = 0; i < this.columnGroups.length; ++i) {
            colBuckets.add(this.createServiceBucket(this.columnGroups[i], evaluation));
        }
        this.percentage = false;
        ArrayList<MeasureDefinition> measureList = new ArrayList<MeasureDefinition>(this.measures.length);
        for (int i = 0; i < this.measures.length; ++i) {
            measureList.add(this.createServiceMeasure(this.measures[i]));
            this.percentage |= this.measures[i].getPercentageOfType() == 1;
        }
        if (this.percentage) {
            ((BucketDefinition)rowBuckets.get(0)).setComputeTotal();
            ((BucketDefinition)colBuckets.get(0)).setComputeTotal();
        }
        return new BucketingService(rowBuckets, colBuckets, measureList, this.dataset.isDataPreSorted(), this.retrieveTotal);
    }

    private BucketDefinition createServiceBucket(JRCrosstabGroup group, byte evaluation) throws JRException {
        JRCrosstabBucket bucket = group.getBucket();
        Comparator comparator = null;
        JRExpression comparatorExpression = bucket.getComparatorExpression();
        if (comparatorExpression != null) {
            comparator = (Comparator)this.evaluateExpression(comparatorExpression, evaluation);
        }
        byte totalPosition = group.getTotalPosition();
        return new BucketDefinition(bucket.getExpression().getValueClass(), comparator, bucket.getOrder(), totalPosition);
    }

    private MeasureDefinition createServiceMeasure(JRFillCrosstabMeasure measure) {
        return new MeasureDefinition(measure.getValueClass(), measure.getCalculation(), measure.getIncrementerFactory());
    }

    protected void reset() {
        super.reset();
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i].setValue(null);
            this.variables[i].setInitialized(true);
        }
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.dataset.evaluateDatasetRun(evaluation);
            this.initEvaluator(evaluation);
            this.bucketingService.processData();
            this.hasData = this.bucketingService.hasData();
            if (this.hasData) {
                this.columnHeadersData = this.bucketingService.getColumnHeaders();
                this.rowHeadersData = this.bucketingService.getRowHeaders();
                this.cellData = this.bucketingService.getCrosstabCells();
                if (this.percentage) {
                    this.grandTotals = this.bucketingService.getGrandTotals();
                }
                this.crosstabFiller.initCrosstab();
            }
        }
    }

    protected void initEvaluator(byte evaluation) throws JRException {
        Map parameterValues = JRFillSubreport.getParameterValues(this.filler, this.getParametersMapExpression(), this.getParameters(), evaluation, true, false);
        ResourceBundle resBdl = (ResourceBundle)parameterValues.get("REPORT_RESOURCE_BUNDLE");
        if (resBdl == null) {
            JRFillParameter resourceBundleParam = (JRFillParameter)this.filler.getParametersMap().get("REPORT_RESOURCE_BUNDLE");
            parameterValues.put("REPORT_RESOURCE_BUNDLE", resourceBundleParam.getValue());
        }
        parameterValues.put("REPORT_PARAMETERS_MAP", parameterValues);
        for (int i = 0; i < this.parameters.length; ++i) {
            Object value = parameterValues.get(this.parameters[i].getName());
            this.parameters[i].setValue(value);
        }
        JRFillParameter resourceBundleParam = (JRFillParameter)this.parametersMap.get("REPORT_RESOURCE_BUNDLE");
        this.crosstabEvaluator.init(this.parametersMap, this.variablesMap, resourceBundleParam, this.filler.getWhenResourceMissingType());
    }

    protected void initBucketingService() {
        if (this.bucketingService == null) {
            try {
                this.bucketingService = this.createService((byte)1);
            }
            catch (JRException e) {
                throw new JRRuntimeException("Could not create bucketing service", e);
            }
        } else {
            this.bucketingService.clear();
        }
    }

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        super.prepare(availableStretchHeight, isOverflow);
        if (!this.isToPrint()) {
            return false;
        }
        if (availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
            this.setToPrint(false);
            return true;
        }
        if (isOverflow && this.crosstabFiller.ended() && this.isAlreadyPrinted()) {
            if (this.isPrintWhenDetailOverflows()) {
                this.rewind();
                this.setReprinted(true);
            } else {
                this.setStretchHeight(this.getHeight());
                this.setToPrint(false);
                return false;
            }
        }
        if (isOverflow && this.isPrintWhenDetailOverflows()) {
            this.setReprinted(true);
        }
        int availableHeight = this.getHeight() + availableStretchHeight - this.getRelativeY() + this.getY() + this.getBandBottomY();
        this.crosstabFiller.fill(availableHeight);
        boolean willOverflow = this.crosstabFiller.willOverflow();
        this.setStretchHeight(willOverflow ? availableHeight : this.crosstabFiller.getUsedHeight());
        return willOverflow;
    }

    protected JRPrintElement fill() {
        JRTemplatePrintRectangle printRectangle = null;
        printRectangle = new JRTemplatePrintRectangle(this.getJRTemplateRectangle());
        printRectangle.setX(this.getX());
        printRectangle.setY(this.getRelativeY());
        printRectangle.setWidth(this.getWidth());
        printRectangle.setHeight(this.getStretchHeight());
        return printRectangle;
    }

    protected JRTemplateRectangle getJRTemplateRectangle() {
        JRStyle style = this.getElementStyle();
        JRTemplateRectangle template = (JRTemplateRectangle)this.getTemplate(style);
        if (template == null) {
            JRDesignRectangle rectangle = new JRDesignRectangle();
            rectangle.setKey(this.getKey());
            rectangle.setPositionType(this.getPositionType());
            rectangle.setMode(this.getMode());
            rectangle.setX(this.getX());
            rectangle.setY(this.getY());
            rectangle.setWidth(this.getWidth());
            rectangle.setHeight(this.getHeight());
            rectangle.setRemoveLineWhenBlank(this.isRemoveLineWhenBlank());
            rectangle.setPrintInFirstWholeBand(this.isPrintInFirstWholeBand());
            rectangle.setPrintWhenDetailOverflows(this.isPrintWhenDetailOverflows());
            rectangle.setPrintWhenGroupChanges(this.getPrintWhenGroupChanges());
            rectangle.setForecolor(this.getForecolor());
            rectangle.setBackcolor(this.getBackcolor());
            rectangle.setPen((byte)0);
            template = new JRTemplateRectangle(this.filler.getJasperPrint().getDefaultStyleProvider(), rectangle, style);
            this.registerTemplate(style, template);
        }
        return template;
    }

    protected void rewind() {
        this.crosstabFiller.initCrosstab();
    }

    protected List getPrintElements() {
        return this.crosstabFiller.getPrintElements();
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) {
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getCrosstab(this);
    }

    public void writeXml(JRXmlWriter writer) throws IOException {
        writer.writeCrosstab(this);
    }

    public int getId() {
        return this.parentCrosstab.getId();
    }

    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    public JRCrosstabRowGroup[] getRowGroups() {
        return this.rowGroups;
    }

    public JRCrosstabColumnGroup[] getColumnGroups() {
        return this.columnGroups;
    }

    public JRCrosstabMeasure[] getMeasures() {
        return this.measures;
    }

    public int getColumnBreakOffset() {
        return this.parentCrosstab.getColumnBreakOffset();
    }

    public boolean isRepeatColumnHeaders() {
        return this.parentCrosstab.isRepeatColumnHeaders();
    }

    public boolean isRepeatRowHeaders() {
        return this.parentCrosstab.isRepeatRowHeaders();
    }

    public JRCrosstabCell[][] getCells() {
        return this.crossCells;
    }

    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    public JRCrosstabParameter[] getParameters() {
        return this.parameters;
    }

    public JRExpression getParametersMapExpression() {
        return this.parentCrosstab.getParametersMapExpression();
    }

    public JRElement getElementByKey(String elementKey) {
        return JRBaseCrosstab.getElementByKey(this, elementKey);
    }

    public JRCloneable createClone(JRFillCloneFactory factory) {
        return null;
    }

    public JRCellContents getHeaderCell() {
        return this.headerCell;
    }

    public JRVariable[] getVariables() {
        return this.variables;
    }

    protected class CrosstabFiller {
        private int yOffset;
        private boolean willOverflow;
        private int[] rowHeadersXOffsets;
        private boolean[] columnBreakable;
        private boolean[] rowBreakable;
        private int[] columnCount;
        private int[] rowCount;
        private int[] columnXOffsets;
        private boolean noDataCellPrinted;
        private int startRowIndex;
        private int startColumnIndex;
        private int lastColumnIndex;
        private List columnHeaders;
        private List printRows;
        private HeaderCell[] spanHeaders;
        private int[] spanHeadersStart;
        private List rowYs = new ArrayList();
        private int rowIdx;
        private List preparedRow = new ArrayList();
        private int preparedRowHeight;
        private boolean printRowHeaders;
        private boolean printColumnHeaders;
        private JRFillVariable rowCountVar;
        private JRFillVariable colCountVar;

        protected CrosstabFiller() {
            this.setRowHeadersXOffsets();
            this.printRows = new ArrayList();
            this.rowCountVar = (JRFillVariable)JRFillCrosstab.this.variablesMap.get("ROW_COUNT");
            this.colCountVar = (JRFillVariable)JRFillCrosstab.this.variablesMap.get("COLUMN_COUNT");
        }

        protected void initCrosstab() {
            this.columnXOffsets = this.computeOffsets(JRFillCrosstab.this.columnHeadersData, JRFillCrosstab.this.columnGroups, true);
            this.columnBreakable = this.computeBreakableHeaders(JRFillCrosstab.this.columnHeadersData, JRFillCrosstab.this.columnGroups, this.columnXOffsets, true, true);
            this.columnCount = this.computeCounts(JRFillCrosstab.this.columnHeadersData);
            int[] rowYOffsets = this.computeOffsets(JRFillCrosstab.this.rowHeadersData, JRFillCrosstab.this.rowGroups, false);
            this.rowBreakable = this.computeBreakableHeaders(JRFillCrosstab.this.rowHeadersData, JRFillCrosstab.this.rowGroups, rowYOffsets, false, false);
            this.rowCount = this.computeCounts(JRFillCrosstab.this.rowHeadersData);
            this.spanHeaders = new HeaderCell[JRFillCrosstab.this.rowGroups.length - 1];
            this.spanHeadersStart = new int[JRFillCrosstab.this.rowGroups.length - 1];
            this.startRowIndex = 0;
            this.startColumnIndex = 0;
            this.lastColumnIndex = 0;
            this.noDataCellPrinted = false;
        }

        protected void setRowHeadersXOffsets() {
            this.rowHeadersXOffsets = new int[JRFillCrosstab.this.rowGroups.length + 1];
            this.rowHeadersXOffsets[0] = 0;
            for (int i = 0; i < JRFillCrosstab.this.rowGroups.length; ++i) {
                this.rowHeadersXOffsets[i + 1] = this.rowHeadersXOffsets[i] + JRFillCrosstab.this.rowGroups[i].getWidth();
            }
        }

        protected int[] computeOffsets(HeaderCell[][] headersData, JRFillCrosstabGroup[] groups, boolean width) {
            int[] offsets = new int[headersData[0].length + 1];
            offsets[0] = 0;
            for (int i = 0; i < headersData[0].length; ++i) {
                int size = 0;
                for (int j = groups.length - 1; j >= 0; --j) {
                    JRFillCellContents cell;
                    if (headersData[j][i] == null) continue;
                    JRFillCellContents jRFillCellContents = cell = headersData[j][i].isTotal() ? groups[j].getFillTotalHeader() : groups[j].getFillHeader();
                    size = cell == null ? 0 : (width ? cell.getWidth() : cell.getHeight());
                    break;
                }
                offsets[i + 1] = offsets[i] + size;
            }
            return offsets;
        }

        protected boolean[] computeBreakableHeaders(HeaderCell[][] headersData, JRFillCrosstabGroup[] groups, int[] offsets, boolean width, boolean startHeaders) {
            boolean[] breakable = new boolean[headersData[0].length];
            for (int i = 0; i < breakable.length; ++i) {
                breakable[i] = true;
            }
            for (int j = 0; j < groups.length; ++j) {
                JRFillCellContents fillHeader = groups[j].getFillHeader();
                if (fillHeader == null) continue;
                int size = width ? fillHeader.getWidth() : fillHeader.getHeight();
                for (int i = 0; i < headersData[0].length; ++i) {
                    int k;
                    HeaderCell header = headersData[j][i];
                    if (header == null || header.isTotal() || header.getLevelSpan() <= 1) continue;
                    int span = header.getLevelSpan();
                    if (startHeaders) {
                        for (k = i + 1; k < i + span && offsets[k] - offsets[i] < size; ++k) {
                            breakable[k] = false;
                        }
                    }
                    for (k = i + span - 1; k > i && offsets[i + span] - offsets[k] < size; --k) {
                        breakable[k] = false;
                    }
                }
            }
            return breakable;
        }

        private int[] computeCounts(HeaderCell[][] headersData) {
            int[] counts = new int[headersData[0].length];
            HeaderCell[] lastHeaders = headersData[headersData.length - 1];
            int c = 0;
            for (int i = 0; i < counts.length; ++i) {
                HeaderCell lastHeader = lastHeaders[i];
                if (lastHeader == null || !lastHeader.isTotal()) {
                    // empty if block
                }
                counts[i] = ++c;
            }
            return counts;
        }

        protected void fill(int availableHeight) throws JRException {
            this.printRows.clear();
            this.yOffset = 0;
            this.willOverflow = false;
            this.fillVerticalCrosstab(availableHeight);
        }

        protected boolean willOverflow() {
            return this.willOverflow;
        }

        protected int getUsedHeight() {
            return this.yOffset;
        }

        protected boolean ended() {
            return JRFillCrosstab.this.hasData ? this.startRowIndex >= JRFillCrosstab.this.rowHeadersData[0].length && this.startColumnIndex >= JRFillCrosstab.this.columnHeadersData[0].length : this.noDataCellPrinted;
        }

        protected void fillVerticalCrosstab(int availableHeight) throws JRException {
            boolean fillEnded;
            int lastRowIndex;
            int rowHeadersXOffset;
            if (!JRFillCrosstab.this.hasData) {
                this.fillNoDataCell(availableHeight);
                return;
            }
            this.printRowHeaders = this.startColumnIndex == 0 || JRFillCrosstab.this.isRepeatRowHeaders();
            int n = rowHeadersXOffset = this.printRowHeaders ? this.rowHeadersXOffsets[JRFillCrosstab.this.rowGroups.length] : 0;
            if (this.startColumnIndex == this.lastColumnIndex) {
                int availableWidth = JRFillCrosstab.this.getWidth();
                this.columnHeaders = this.getGroupHeaders(availableWidth - rowHeadersXOffset, this.columnXOffsets, this.columnBreakable, this.startColumnIndex, JRFillCrosstab.this.columnHeadersData, JRFillCrosstab.this.columnGroups);
                this.lastColumnIndex = this.startColumnIndex + this.columnHeaders.size();
                if (this.startColumnIndex == this.lastColumnIndex) {
                    throw new JRRuntimeException("Not enough space to render the crosstab.");
                }
            }
            this.printColumnHeaders = this.startRowIndex == 0 || JRFillCrosstab.this.isRepeatColumnHeaders();
            List columnHeaderRows = null;
            if (this.printColumnHeaders) {
                columnHeaderRows = this.fillColumnHeaders(rowHeadersXOffset, availableHeight - this.yOffset);
                if (this.willOverflow) {
                    return;
                }
            }
            if ((lastRowIndex = this.fillRows(rowHeadersXOffset, availableHeight - this.yOffset)) == this.startRowIndex) {
                this.willOverflow = true;
                return;
            }
            if (columnHeaderRows != null) {
                this.printRows.addAll(columnHeaderRows);
            }
            if (lastRowIndex >= JRFillCrosstab.this.rowHeadersData[0].length) {
                this.startColumnIndex = this.lastColumnIndex;
                if (this.startColumnIndex < JRFillCrosstab.this.columnHeadersData[0].length) {
                    lastRowIndex = 0;
                    this.startRowIndex = 0;
                    this.yOffset += JRFillCrosstab.this.getColumnBreakOffset();
                    this.fillVerticalCrosstab(availableHeight);
                    return;
                }
            }
            boolean bl = fillEnded = lastRowIndex >= JRFillCrosstab.this.rowHeadersData[0].length && this.lastColumnIndex >= JRFillCrosstab.this.columnHeadersData[0].length;
            if (fillEnded) {
                JRFillCrosstab.this.setStretchHeight(this.yOffset);
            } else {
                JRFillCrosstab.this.setStretchHeight(availableHeight);
            }
            this.startRowIndex = lastRowIndex;
            this.willOverflow = !fillEnded;
        }

        protected List getGroupHeaders(int available, int[] offsets, boolean[] breakable, int firstIndex, HeaderCell[][] headersData, JRFillCrosstabGroup[] groups) {
            int j;
            int lastIndex;
            ArrayList<HeaderCell[]> headers = new ArrayList<HeaderCell[]>();
            int maxOffset = available + offsets[firstIndex];
            for (lastIndex = firstIndex; lastIndex < headersData[0].length && offsets[lastIndex + 1] <= maxOffset; ++lastIndex) {
                HeaderCell[] groupHeaders = new HeaderCell[groups.length];
                for (j = 0; j < groups.length; ++j) {
                    groupHeaders[j] = headersData[j][lastIndex];
                }
                headers.add(groupHeaders);
            }
            if (lastIndex < headersData[0].length) {
                while (lastIndex > firstIndex && !breakable[lastIndex]) {
                    --lastIndex;
                    headers.remove(headers.size() - 1);
                }
            }
            if (lastIndex > firstIndex) {
                if (firstIndex > 0) {
                    HeaderCell[] firstHeaders = (HeaderCell[])headers.get(0);
                    for (j = 0; j < groups.length; ++j) {
                        int spanIndex;
                        HeaderCell header = headersData[j][firstIndex];
                        if (header != null || (spanIndex = this.getSpanIndex(firstIndex, j, headersData)) < 0) continue;
                        HeaderCell spanCell = headersData[j][spanIndex];
                        int headerEndIdx = spanCell.getLevelSpan() + spanIndex;
                        if (headerEndIdx > lastIndex) {
                            headerEndIdx = lastIndex;
                        }
                        firstHeaders[j] = HeaderCell.createLevelSpanCopy(spanCell, headerEndIdx - firstIndex);
                    }
                }
                if (lastIndex < headersData[0].length) {
                    for (int j2 = 0; j2 < groups.length; ++j2) {
                        int spanIndex;
                        HeaderCell header = headersData[j2][lastIndex];
                        if (header != null || (spanIndex = this.getSpanIndex(lastIndex, j2, headersData)) < firstIndex) continue;
                        HeaderCell spanCell = headersData[j2][spanIndex];
                        HeaderCell[] headerCells = (HeaderCell[])headers.get(spanIndex - firstIndex);
                        headerCells[j2] = HeaderCell.createLevelSpanCopy(spanCell, lastIndex - spanIndex);
                    }
                }
            }
            return headers;
        }

        protected int getSpanIndex(int i, int j, HeaderCell[][] headersData) {
            HeaderCell spanCell;
            int span;
            int spanIndex;
            for (spanIndex = i - 1; spanIndex >= 0 && headersData[j][spanIndex] == null; --spanIndex) {
            }
            if (spanIndex >= 0 && (span = (spanCell = headersData[j][spanIndex]).getLevelSpan()) > i - spanIndex) {
                return spanIndex;
            }
            return -1;
        }

        protected void fillNoDataCell(int availableHeight) throws JRException {
            if (JRFillCrosstab.this.whenNoDataCell == null) {
                this.noDataCellPrinted = true;
            } else if (availableHeight < JRFillCrosstab.this.whenNoDataCell.getHeight()) {
                this.willOverflow = true;
            } else {
                JRFillCrosstab.this.whenNoDataCell.evaluate((byte)3);
                JRFillCrosstab.this.whenNoDataCell.prepare(availableHeight - JRFillCrosstab.this.whenNoDataCell.getHeight());
                this.willOverflow = JRFillCrosstab.this.whenNoDataCell.willOverflow();
                if (!this.willOverflow) {
                    JRFillCrosstab.this.whenNoDataCell.setX(0);
                    JRFillCrosstab.this.whenNoDataCell.setY(0);
                    JRPrintFrame printCell = JRFillCrosstab.this.whenNoDataCell.fill();
                    ArrayList<JRPrintFrame> noDataRow = new ArrayList<JRPrintFrame>(1);
                    noDataRow.add(printCell);
                    this.addPrintRow(noDataRow);
                    this.yOffset += JRFillCrosstab.this.whenNoDataCell.getPrintHeight();
                    this.noDataCellPrinted = true;
                }
            }
        }

        protected List fillColumnHeaders(int rowHeadersXOffset, int availableHeight) throws JRException {
            List headerRows;
            JRFillCellContents[][] columnHeaderRows = new JRFillCellContents[JRFillCrosstab.this.columnGroups.length][this.lastColumnIndex - this.startColumnIndex + 1];
            this.rowYs.clear();
            this.rowYs.add(new Integer(0));
            if (this.printRowHeaders && JRFillCrosstab.this.headerCell != null) {
                JRFillCellContents contents = this.fillHeader(availableHeight);
                if (this.willOverflow) {
                    return null;
                }
                columnHeaderRows[JRFillCrosstab.this.columnGroups.length - 1][0] = contents;
            }
            this.rowIdx = 0;
            block0: while (this.rowIdx < JRFillCrosstab.this.columnGroups.length) {
                for (int columnIdx = this.startColumnIndex; columnIdx < this.lastColumnIndex; ++columnIdx) {
                    JRFillCellContents contents;
                    HeaderCell[] headers = (HeaderCell[])this.columnHeaders.get(columnIdx - this.startColumnIndex);
                    HeaderCell cell = headers[this.rowIdx];
                    if (cell == null) continue;
                    columnHeaderRows[this.rowIdx + cell.getDepthSpan() - 1][columnIdx - this.startColumnIndex + 1] = contents = this.prepareColumnHeader(cell, columnIdx, rowHeadersXOffset, availableHeight);
                    if (this.willOverflow) break block0;
                }
                int rowStretchHeight = this.stretchColumnHeadersRow(columnHeaderRows[this.rowIdx]);
                this.rowYs.add(new Integer((Integer)this.rowYs.get(this.rowIdx) + rowStretchHeight));
                ++this.rowIdx;
            }
            if (this.willOverflow) {
                headerRows = null;
                this.releaseColumnHeaderCells(columnHeaderRows);
            } else {
                headerRows = this.fillColumnHeaders(columnHeaderRows);
                this.yOffset += ((Integer)this.rowYs.get(JRFillCrosstab.this.columnGroups.length)).intValue();
            }
            this.resetVariables();
            return headerRows;
        }

        private void setCountVars(int rowIdx, int colIdx) {
            if (rowIdx == -1) {
                this.rowCountVar.setValue(null);
            } else {
                this.rowCountVar.setValue(new Integer(this.rowCount[rowIdx]));
            }
            if (colIdx == -1) {
                this.colCountVar.setValue(null);
            } else {
                this.colCountVar.setValue(new Integer(this.columnCount[colIdx]));
            }
        }

        private JRFillCellContents fillHeader(int availableHeight) throws JRException {
            this.setCountVars(-1, -1);
            JRFillCellContents contents = JRFillCrosstab.this.headerCell.getWorkingClone();
            contents.evaluate((byte)3);
            contents.prepare(availableHeight - JRFillCrosstab.this.headerCell.getHeight());
            this.willOverflow = contents.willOverflow();
            if (!this.willOverflow) {
                contents.setX(0);
                contents.setY(this.yOffset);
                contents.setVerticalSpan(JRFillCrosstab.this.columnGroups.length);
            }
            return contents;
        }

        private JRFillCellContents prepareColumnHeader(HeaderCell cell, int columnIdx, int xOffset, int availableHeight) throws JRException {
            JRFillCrosstabColumnGroup group = JRFillCrosstab.this.columnGroups[this.rowIdx];
            JRFillCellContents contents = cell.isTotal() ? group.getFillTotalHeader() : group.getFillHeader();
            int width = this.columnXOffsets[columnIdx + cell.getLevelSpan()] - this.columnXOffsets[columnIdx];
            int height = contents.getHeight();
            if (width <= 0 || height <= 0) {
                return null;
            }
            JRFillCellContents preparedContents = null;
            int rowY = (Integer)this.rowYs.get(this.rowIdx);
            int cellAvailableStretch = availableHeight - rowY - height;
            if (cellAvailableStretch >= 0) {
                this.setCountVars(-1, columnIdx);
                this.setGroupVariables(JRFillCrosstab.this.columnGroups, cell.getBucketValues());
                contents = contents.getTransformedContents(width, height, group.getPosition(), (byte)1);
                contents = contents.getBoxContents(columnIdx == this.startColumnIndex && (!this.printRowHeaders || JRFillCrosstab.this.headerCell == null), false);
                contents = contents.getWorkingClone();
                contents.evaluate((byte)3);
                contents.prepare(cellAvailableStretch);
                if (contents.willOverflow()) {
                    this.willOverflow = true;
                } else {
                    contents.setX(this.columnXOffsets[columnIdx] - this.columnXOffsets[this.startColumnIndex] + xOffset);
                    contents.setY(rowY + this.yOffset);
                    contents.setVerticalSpan(cell.getDepthSpan());
                    preparedContents = contents;
                }
            } else {
                this.willOverflow = true;
            }
            return preparedContents;
        }

        private int stretchColumnHeadersRow(JRFillCellContents[] headers) {
            int startRowY;
            JRFillCellContents contents;
            int j;
            int rowY = (Integer)this.rowYs.get(this.rowIdx);
            int rowStretchHeight = 0;
            for (j = 0; j < headers.length; ++j) {
                int height;
                contents = headers[j];
                if (contents == null) continue;
                startRowY = rowY;
                if (contents.getVerticalSpan() > 1) {
                    startRowY = (Integer)this.rowYs.get(this.rowIdx - contents.getVerticalSpan() + 1);
                }
                if ((height = contents.getPrintHeight() - rowY + startRowY) <= rowStretchHeight) continue;
                rowStretchHeight = height;
            }
            for (j = 0; j < headers.length; ++j) {
                contents = headers[j];
                if (contents == null) continue;
                startRowY = rowY;
                if (contents.getVerticalSpan() > 1) {
                    startRowY = (Integer)this.rowYs.get(this.rowIdx - contents.getVerticalSpan() + 1);
                }
                contents.stretchTo(rowStretchHeight + rowY - startRowY);
            }
            return rowStretchHeight;
        }

        private List fillColumnHeaders(JRFillCellContents[][] columnHeaderRows) throws JRException {
            ArrayList headerRows = new ArrayList(JRFillCrosstab.this.columnGroups.length);
            for (int i = 0; i < columnHeaderRows.length; ++i) {
                ArrayList<JRPrintFrame> headerRow = new ArrayList<JRPrintFrame>(this.lastColumnIndex - this.startColumnIndex);
                headerRows.add(headerRow);
                for (int j = 0; j < columnHeaderRows[i].length; ++j) {
                    JRFillCellContents contents = columnHeaderRows[i][j];
                    if (contents == null) continue;
                    headerRow.add(contents.fill());
                    contents.releaseWorkingClone();
                }
            }
            return headerRows;
        }

        private void releaseColumnHeaderCells(JRFillCellContents[][] columnHeaderRows) throws JRException {
            for (int i = 0; i < columnHeaderRows.length; ++i) {
                for (int j = 0; j < columnHeaderRows[i].length; ++j) {
                    JRFillCellContents contents = columnHeaderRows[i][j];
                    if (contents == null) continue;
                    contents.rewind();
                    contents.releaseWorkingClone();
                }
            }
        }

        protected int fillRows(int xOffset, int availableHeight) throws JRException {
            this.rowYs.clear();
            this.rowYs.add(new Integer(0));
            this.rowIdx = 0;
            while (this.rowIdx < JRFillCrosstab.this.cellData.length - this.startRowIndex) {
                this.initPreparedRow();
                this.prepareRow(xOffset, availableHeight);
                if (this.willOverflow) break;
                this.fillRow();
                this.rowYs.add(new Integer((Integer)this.rowYs.get(this.rowIdx) + this.preparedRowHeight));
                ++this.rowIdx;
            }
            if (this.rowIdx < JRFillCrosstab.this.cellData.length - this.startRowIndex) {
                this.releasePreparedRow();
                if (this.printRowHeaders) {
                    this.fillContinuingRowHeaders(xOffset, availableHeight);
                }
            }
            this.yOffset += ((Integer)this.rowYs.get(this.rowIdx)).intValue();
            return this.rowIdx + this.startRowIndex;
        }

        private void initPreparedRow() {
            this.preparedRow.clear();
            this.preparedRowHeight = 0;
        }

        private void removeFilledRows(int rowsToRemove) {
            if (rowsToRemove > 0) {
                for (int i = 0; i < rowsToRemove; ++i) {
                    this.printRows.remove(this.printRows.size() - 1);
                    this.rowYs.remove(this.rowYs.size() - 1);
                }
                this.rowIdx -= rowsToRemove;
            }
        }

        private void releasePreparedRow() throws JRException {
            Iterator it = this.preparedRow.iterator();
            while (it.hasNext()) {
                JRFillCellContents cell = (JRFillCellContents)it.next();
                cell.rewind();
                cell.releaseWorkingClone();
            }
            this.preparedRow.clear();
        }

        private void fillRow() throws JRException {
            int rowY = (Integer)this.rowYs.get(this.rowIdx);
            ArrayList<JRPrintFrame> rowPrints = new ArrayList<JRPrintFrame>(this.preparedRow.size());
            Iterator it = this.preparedRow.iterator();
            while (it.hasNext()) {
                JRFillCellContents cell = (JRFillCellContents)it.next();
                int spanHeight = 0;
                if (cell.getVerticalSpan() > 1) {
                    spanHeight = rowY - (Integer)this.rowYs.get(this.rowIdx - cell.getVerticalSpan() + 1);
                }
                cell.stretchTo(this.preparedRowHeight + spanHeight);
                rowPrints.add(cell.fill());
                cell.releaseWorkingClone();
            }
            this.addPrintRow(rowPrints);
        }

        private void prepareRow(int xOffset, int availableHeight) throws JRException {
            boolean overflow;
            for (int col = this.startColumnIndex; col < this.lastColumnIndex; ++col) {
                CrosstabCell data = JRFillCrosstab.this.cellData[this.rowIdx + this.startRowIndex][col];
                overflow = this.prepareDataCell(data, col, availableHeight, xOffset);
                if (!overflow) continue;
                this.willOverflow = true;
                return;
            }
            this.resetVariables();
            if (this.printRowHeaders) {
                for (int j = 0; j < JRFillCrosstab.this.rowGroups.length; ++j) {
                    HeaderCell cell = JRFillCrosstab.this.rowHeadersData[j][this.rowIdx + this.startRowIndex];
                    overflow = false;
                    if (cell == null) {
                        overflow = this.prepareClosingRowHeader(j, availableHeight);
                    } else {
                        if (cell.getLevelSpan() > 1) {
                            this.spanHeaders[j] = cell;
                            this.spanHeadersStart[j] = this.rowIdx + this.startRowIndex;
                            continue;
                        }
                        overflow = this.prepareRowHeader(j, cell, 1, availableHeight);
                    }
                    if (!overflow) continue;
                    this.willOverflow = true;
                    return;
                }
                this.resetVariables();
            }
        }

        private boolean prepareDataCell(CrosstabCell data, int column, int availableHeight, int xOffset) throws JRException {
            boolean overflow;
            JRFillCellContents contents;
            int rowY = (Integer)this.rowYs.get(this.rowIdx);
            JRFillCrosstabCell cell = JRFillCrosstab.this.crossCells[data.getRowTotalGroupIndex()][data.getColumnTotalGroupIndex()];
            JRFillCellContents jRFillCellContents = contents = cell == null ? null : cell.getFillContents();
            if (contents == null || contents.getWidth() <= 0 || contents.getHeight() <= 0) {
                return false;
            }
            int cellAvailableStretch = availableHeight - rowY - contents.getHeight();
            boolean bl = overflow = cellAvailableStretch < 0;
            if (!overflow) {
                boolean leftEmpty = this.startColumnIndex != 0 && !JRFillCrosstab.this.isRepeatRowHeaders();
                boolean topEmpty = this.startRowIndex != 0 && !JRFillCrosstab.this.isRepeatColumnHeaders();
                this.setCountVars(this.rowIdx + this.startRowIndex, column);
                this.setGroupVariables(JRFillCrosstab.this.rowGroups, data.getRowBucketValues());
                this.setGroupVariables(JRFillCrosstab.this.columnGroups, data.getColumnBucketValues());
                this.setMeasureVariables(data);
                contents = contents.getBoxContents(leftEmpty && column == this.startColumnIndex, topEmpty && this.rowIdx == 0);
                contents = contents.getWorkingClone();
                contents.evaluate((byte)3);
                contents.prepare(cellAvailableStretch);
                this.preparedRow.add(contents);
                overflow = contents.willOverflow();
                if (!overflow) {
                    contents.setX(this.columnXOffsets[column] - this.columnXOffsets[this.startColumnIndex] + xOffset);
                    contents.setY(rowY + this.yOffset);
                    int rowCellHeight = contents.getPrintHeight();
                    if (rowCellHeight > this.preparedRowHeight) {
                        this.preparedRowHeight = rowCellHeight;
                    }
                }
            }
            return overflow;
        }

        private boolean prepareRowHeader(int rowGroup, HeaderCell cell, int vSpan, int availableHeight) throws JRException {
            boolean headerOverflow;
            JRFillCellContents contents;
            JRFillCrosstabRowGroup group = JRFillCrosstab.this.rowGroups[rowGroup];
            JRFillCellContents jRFillCellContents = contents = cell.isTotal() ? group.getFillTotalHeader() : group.getFillHeader();
            if (contents.getWidth() <= 0 || contents.getHeight() <= 0) {
                return false;
            }
            int spanHeight = 0;
            int headerY = (Integer)this.rowYs.get(this.rowIdx - vSpan + 1);
            if (vSpan > 1) {
                spanHeight += (Integer)this.rowYs.get(this.rowIdx) - headerY;
            }
            int rowHeight = spanHeight + this.preparedRowHeight;
            boolean stretchContents = group.getPosition() == 4;
            int contentsHeight = stretchContents ? rowHeight : contents.getHeight();
            int cellAvailableStretch = availableHeight - headerY - contentsHeight;
            boolean bl = headerOverflow = cellAvailableStretch < 0 || rowHeight < contents.getHeight();
            if (!headerOverflow) {
                this.setCountVars(this.rowIdx + this.startRowIndex - vSpan + 1, -1);
                this.setGroupVariables(JRFillCrosstab.this.rowGroups, cell.getBucketValues());
                if (stretchContents) {
                    contents = contents.getTransformedContents(contents.getWidth(), rowHeight, (byte)1, (byte)4);
                }
                contents = contents.getBoxContents(false, this.rowIdx + 1 == vSpan && (!this.printColumnHeaders || JRFillCrosstab.this.headerCell == null));
                contents.getWorkingClone();
                contents.evaluate((byte)3);
                contents.prepare(cellAvailableStretch);
                this.preparedRow.add(contents);
                headerOverflow = contents.willOverflow();
                if (!headerOverflow) {
                    contents.setX(this.rowHeadersXOffsets[rowGroup]);
                    contents.setY(headerY + this.yOffset);
                    contents.setVerticalSpan(vSpan);
                    int rowCellHeight = contents.getPrintHeight() - spanHeight;
                    if (rowCellHeight > this.preparedRowHeight) {
                        this.preparedRowHeight = rowCellHeight;
                    }
                }
            }
            if (headerOverflow) {
                this.removeFilledRows(vSpan - 1);
            }
            return headerOverflow;
        }

        private boolean prepareClosingRowHeader(int rowGroup, int availableHeight) throws JRException {
            if (rowGroup < JRFillCrosstab.this.rowGroups.length - 1 && this.spanHeaders[rowGroup] != null && this.spanHeaders[rowGroup].getLevelSpan() + this.spanHeadersStart[rowGroup] == this.rowIdx + this.startRowIndex + 1) {
                HeaderCell cell = this.spanHeaders[rowGroup];
                int vSpan = cell.getLevelSpan();
                if (this.spanHeadersStart[rowGroup] < this.startRowIndex) {
                    vSpan += this.spanHeadersStart[rowGroup] - this.startRowIndex;
                }
                this.spanHeaders[rowGroup] = null;
                return this.prepareRowHeader(rowGroup, cell, vSpan, availableHeight);
            }
            return false;
        }

        private void removeExceedingSpanHeaders() {
            for (int j = JRFillCrosstab.this.rowGroups.length - 2; j >= 0; --j) {
                if (this.spanHeaders[j] == null || this.spanHeadersStart[j] < this.rowIdx + this.startRowIndex) continue;
                this.spanHeaders[j] = null;
            }
        }

        private void setBackSpanHeaders() {
            for (int j = JRFillCrosstab.this.rowGroups.length - 2; j >= 0 && this.spanHeaders[j] == null; --j) {
                int spanIndex = this.getSpanIndex(this.rowIdx + this.startRowIndex, j, JRFillCrosstab.this.rowHeadersData);
                if (spanIndex < 0) continue;
                this.spanHeaders[j] = JRFillCrosstab.this.rowHeadersData[j][spanIndex];
                this.spanHeadersStart[j] = spanIndex;
            }
        }

        private void fillContinuingRowHeaders(int xOffset, int availableHeight) throws JRException {
            boolean done = false;
            block0: do {
                this.removeExceedingSpanHeaders();
                if (!this.rowBreakable[this.rowIdx + this.startRowIndex]) {
                    this.removeFilledRows(1);
                    this.setBackSpanHeaders();
                    continue;
                }
                this.initPreparedRow();
                for (int j = 0; j < JRFillCrosstab.this.rowGroups.length - 1; ++j) {
                    boolean headerOverflow;
                    if (this.spanHeaders[j] == null || !(headerOverflow = this.prepareContinuingRowHeader(j, availableHeight))) continue;
                    this.releasePreparedRow();
                    continue block0;
                }
                if (!this.preparedRow.isEmpty()) {
                    int lastRowHeight = (Integer)this.rowYs.get(this.rowIdx) - (Integer)this.rowYs.get(this.rowIdx - 1);
                    if (this.preparedRowHeight > lastRowHeight) {
                        this.refillLastRow(xOffset, availableHeight);
                    } else {
                        this.fillContinuingHeaders(lastRowHeight);
                    }
                }
                done = true;
            } while (!done && this.rowIdx > 0);
        }

        private void fillContinuingHeaders(int lastRowHeight) throws JRException {
            int nextToLastHeaderY = (Integer)this.rowYs.get(this.rowIdx - 1);
            List lastPrintRow = this.getLastPrintRow();
            for (int j = 0; j < this.preparedRow.size(); ++j) {
                JRFillCellContents contents = (JRFillCellContents)this.preparedRow.get(j);
                int headerY = (Integer)this.rowYs.get(this.rowIdx - contents.getVerticalSpan());
                contents.stretchTo(nextToLastHeaderY - headerY + lastRowHeight);
                lastPrintRow.add(contents.fill());
                contents.releaseWorkingClone();
            }
        }

        private void refillLastRow(int xOffset, int availableHeight) throws JRException {
            this.removeFilledRows(1);
            this.setBackSpanHeaders();
            this.prepareRow(xOffset, availableHeight);
            this.fillRow();
            this.rowYs.add(new Integer((Integer)this.rowYs.get(this.rowIdx) + this.preparedRowHeight));
            ++this.rowIdx;
        }

        private boolean prepareContinuingRowHeader(int rowGroup, int availableHeight) throws JRException {
            boolean headerOverflow;
            HeaderCell cell = this.spanHeaders[rowGroup];
            int vSpan = this.rowIdx + this.startRowIndex - this.spanHeadersStart[rowGroup];
            if (this.spanHeadersStart[rowGroup] < this.startRowIndex) {
                vSpan += this.spanHeadersStart[rowGroup] - this.startRowIndex;
            }
            int headerY = (Integer)this.rowYs.get(this.rowIdx - vSpan);
            int lastHeaderY = (Integer)this.rowYs.get(this.rowIdx);
            int headerHeight = lastHeaderY - headerY;
            int nextToLastHeaderY = (Integer)this.rowYs.get(this.rowIdx - 1);
            int stretchHeight = nextToLastHeaderY - headerY;
            JRFillCrosstabRowGroup group = JRFillCrosstab.this.rowGroups[rowGroup];
            JRFillCellContents contents = cell.isTotal() ? group.getFillTotalHeader() : group.getFillHeader();
            boolean stretchContents = group.getPosition() == 4;
            int contentsHeight = stretchContents ? headerHeight : contents.getHeight();
            int cellAvailableStretch = availableHeight - headerY - contentsHeight;
            boolean bl = headerOverflow = cellAvailableStretch < 0 || headerHeight < contents.getHeight();
            if (!headerOverflow) {
                this.setCountVars(this.rowIdx + this.startRowIndex - vSpan, -1);
                this.setGroupVariables(JRFillCrosstab.this.rowGroups, cell.getBucketValues());
                if (stretchContents) {
                    contents = contents.getTransformedContents(contents.getWidth(), headerHeight, (byte)1, (byte)4);
                }
                contents = contents.getBoxContents(false, this.rowIdx == vSpan && (!this.printColumnHeaders || JRFillCrosstab.this.headerCell == null));
                contents.getWorkingClone();
                contents.evaluate((byte)3);
                contents.prepare(cellAvailableStretch);
                this.preparedRow.add(contents);
                headerOverflow = contents.willOverflow();
                if (!headerOverflow) {
                    contents.setX(this.rowHeadersXOffsets[rowGroup]);
                    contents.setY(headerY + this.yOffset);
                    contents.setVerticalSpan(vSpan);
                    int rowHeight = contents.getPrintHeight() - stretchHeight;
                    if (rowHeight > this.preparedRowHeight) {
                        this.preparedRowHeight = rowHeight;
                    }
                }
            }
            if (headerOverflow) {
                this.removeFilledRows(vSpan);
            }
            return headerOverflow;
        }

        protected void addPrintRow(List printRow) {
            this.printRows.add(printRow);
        }

        protected List getLastPrintRow() {
            return (List)this.printRows.get(this.printRows.size() - 1);
        }

        protected List getPrintElements() {
            ArrayList prints = new ArrayList();
            Iterator it = this.printRows.iterator();
            while (it.hasNext()) {
                List rowPrints = (List)it.next();
                prints.addAll(rowPrints);
            }
            return prints;
        }

        protected void setGroupVariables(JRFillCrosstabGroup[] groups, BucketDefinition.Bucket[] bucketValues) {
            for (int i = 0; i < groups.length; ++i) {
                Object value = null;
                if (bucketValues[i] != null && !bucketValues[i].isTotal()) {
                    value = bucketValues[i].getValue();
                }
                groups[i].getFillVariable().setValue(value);
            }
        }

        protected void setMeasureVariables(CrosstabCell cell) {
            MeasureDefinition.MeasureValue[] values = cell.getMesureValues();
            for (int i = 0; i < JRFillCrosstab.this.measures.length; ++i) {
                Object value = this.measureValue(values, i);
                JRFillCrosstab.this.measures[i].getFillVariable().setValue(value);
            }
            MeasureDefinition.MeasureValue[][][] totals = cell.getTotals();
            for (int row = 0; row <= JRFillCrosstab.this.rowGroups.length; ++row) {
                for (int col = 0; col <= JRFillCrosstab.this.columnGroups.length; ++col) {
                    MeasureDefinition.MeasureValue[] vals = totals[row][col];
                    if (!JRFillCrosstab.this.retrieveTotal[row][col]) continue;
                    for (int m = 0; m < JRFillCrosstab.this.measures.length; ++m) {
                        JRFillVariable totalVar = JRFillCrosstab.this.totalVariables[row][col][m];
                        Object value = this.measureValue(vals, m);
                        totalVar.setValue(value);
                    }
                }
            }
        }

        protected Object measureValue(MeasureDefinition.MeasureValue[] values, int measureIdx) {
            Object value = JRFillCrosstab.this.measures[measureIdx].getPercentageOfType() == 1 ? (values[measureIdx].isInitialized() ? values[measureIdx].getValue() : JRFillCrosstab.this.measures[measureIdx].getPercentageCalculator().calculatePercentage(values[measureIdx], JRFillCrosstab.this.grandTotals[measureIdx])) : values[measureIdx].getValue();
            return value;
        }

        protected void resetVariables() {
            int i;
            for (i = 0; i < JRFillCrosstab.this.rowGroups.length; ++i) {
                JRFillCrosstab.this.rowGroups[i].getFillVariable().setValue(null);
            }
            for (i = 0; i < JRFillCrosstab.this.columnGroups.length; ++i) {
                JRFillCrosstab.this.columnGroups[i].getFillVariable().setValue(null);
            }
            for (i = 0; i < JRFillCrosstab.this.measures.length; ++i) {
                JRFillCrosstab.this.measures[i].getFillVariable().setValue(null);
            }
            for (int row = 0; row <= JRFillCrosstab.this.rowGroups.length; ++row) {
                for (int col = 0; col <= JRFillCrosstab.this.columnGroups.length; ++col) {
                    if (!JRFillCrosstab.this.retrieveTotal[row][col]) continue;
                    for (int i2 = 0; i2 < JRFillCrosstab.this.measures.length; ++i2) {
                        JRFillCrosstab.this.totalVariables[row][col][i2].setValue(null);
                    }
                }
            }
        }
    }

    public class JRFillCrosstabDataset
    extends JRFillElementDataset
    implements JRCrosstabDataset {
        private Object[] bucketValues;
        private Object[] measureValues;

        public JRFillCrosstabDataset(JRCrosstabDataset dataset, JRFillObjectFactory factory) {
            super(dataset, factory);
            this.bucketValues = new Object[JRFillCrosstab.this.rowGroups.length + JRFillCrosstab.this.columnGroups.length];
            this.measureValues = new Object[JRFillCrosstab.this.measures.length];
        }

        protected void customInitialize() {
            JRFillCrosstab.this.initBucketingService();
        }

        protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
            int i;
            for (i = 0; i < JRFillCrosstab.this.rowGroups.length; ++i) {
                this.bucketValues[i] = calculator.evaluate(JRFillCrosstab.this.rowGroups[i].getBucket().getExpression());
            }
            for (i = 0; i < JRFillCrosstab.this.columnGroups.length; ++i) {
                this.bucketValues[i + JRFillCrosstab.this.rowGroups.length] = calculator.evaluate(JRFillCrosstab.this.columnGroups[i].getBucket().getExpression());
            }
            for (i = 0; i < JRFillCrosstab.this.measures.length; ++i) {
                this.measureValues[i] = calculator.evaluate(JRFillCrosstab.this.measures[i].getValueExpression());
            }
        }

        protected void customIncrement() {
            try {
                JRFillCrosstab.this.bucketingService.addData(this.bucketValues, this.measureValues);
            }
            catch (JRException e) {
                throw new JRRuntimeException("Error incrementing crosstab dataset", e);
            }
        }

        protected Dataset getCustomDataset() {
            return null;
        }

        public void collectExpressions(JRExpressionCollector collector) {
        }

        public boolean isDataPreSorted() {
            return ((JRCrosstabDataset)this.parent).isDataPreSorted();
        }
    }
}

