/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.base.JRBaseDatasetRun;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public abstract class JRBaseElementDataset
implements JRElementDataset,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected byte resetType = 1;
    protected byte incrementType = (byte)5;
    protected JRGroup resetGroup = null;
    protected JRGroup incrementGroup = null;
    protected JRDatasetRun datasetRun;

    protected JRBaseElementDataset() {
    }

    protected JRBaseElementDataset(JRElementDataset dataset) {
        if (dataset != null) {
            this.resetType = dataset.getResetType();
            this.incrementType = dataset.getIncrementType();
            this.resetGroup = dataset.getResetGroup();
            this.incrementGroup = dataset.getIncrementGroup();
            JRDatasetRun origDatasetRun = dataset.getDatasetRun();
            if (origDatasetRun != null) {
                this.datasetRun = new JRBaseDatasetRun(origDatasetRun, null);
            }
        }
    }

    protected JRBaseElementDataset(JRElementDataset dataset, JRBaseObjectFactory factory) {
        factory.put(dataset, this);
        this.resetType = dataset.getResetType();
        this.incrementType = dataset.getIncrementType();
        this.resetGroup = factory.getGroup(dataset.getResetGroup());
        this.incrementGroup = factory.getGroup(dataset.getIncrementGroup());
        this.datasetRun = factory.getDatasetRun(dataset.getDatasetRun());
    }

    public byte getResetType() {
        return this.resetType;
    }

    public byte getIncrementType() {
        return this.incrementType;
    }

    public JRGroup getResetGroup() {
        return this.resetGroup;
    }

    public JRGroup getIncrementGroup() {
        return this.incrementGroup;
    }

    public JRDatasetRun getDatasetRun() {
        return this.datasetRun;
    }
}

