/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillTextElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintText;
import net.sf.jasperreports.engine.fill.JRTemplateText;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRFillStaticText
extends JRFillTextElement
implements JRStaticText {
    protected JRFillStaticText(JRBaseFiller filler, JRStaticText staticText, JRFillObjectFactory factory) {
        super(filler, staticText, factory);
        String text = staticText.getText();
        if (text == null) {
            text = "";
        }
        this.setRawText(text);
    }

    protected JRFillStaticText(JRFillStaticText staticText, JRFillCloneFactory factory) {
        super(staticText, factory);
        String text = staticText.getText();
        if (text == null) {
            text = "";
        }
        this.setRawText(text);
    }

    public void setText(String text) {
    }

    protected JRTemplateText getJRTemplateText() {
        if (this.template == null) {
            this.template = new JRTemplateText(this.filler.getJasperPrint().getDefaultStyleProvider(), (JRStaticText)this.parent);
        }
        return (JRTemplateText)this.template;
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        this.setTextStart(0);
        this.setTextEnd(0);
    }

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        boolean willOverflow = false;
        super.prepare(availableStretchHeight, isOverflow);
        if (!this.isToPrint()) {
            return willOverflow;
        }
        boolean isToPrint = true;
        boolean isReprinted = false;
        if (isOverflow && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
            isToPrint = false;
        }
        if (!(!isToPrint || !this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
            isToPrint = false;
        }
        if (isToPrint && availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
            isToPrint = false;
            willOverflow = true;
        }
        if (isToPrint && isOverflow && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
            isReprinted = true;
        }
        this.setTextStart(0);
        this.setTextEnd(0);
        if (isToPrint) {
            this.chopTextElement(0);
        }
        this.setToPrint(isToPrint);
        this.setReprinted(isReprinted);
        return willOverflow;
    }

    protected JRPrintElement fill() {
        JRTemplatePrintText text = null;
        text = new JRTemplatePrintText(this.getJRTemplateText());
        text.setX(this.getX());
        text.setY(this.getRelativeY());
        text.setWidth(this.getWidth());
        if (this.getRotation() == 0) {
            text.setHeight(this.getStretchHeight());
        } else {
            text.setHeight(this.getHeight());
        }
        text.setRunDirection(this.getRunDirection());
        text.setLineSpacingFactor(this.getLineSpacingFactor());
        text.setLeadingOffset(this.getLeadingOffset());
        text.setTextHeight(this.getTextHeight());
        text.setText(this.textChopper.chop(this, this.getTextStart(), this.getTextEnd()));
        return text;
    }

    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getStaticText(this);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void writeXml(JRXmlWriter xmlWriter) throws IOException {
        xmlWriter.writeStaticText(this);
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) {
    }

    public JRCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillStaticText(this, factory);
    }
}

