/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.design;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.base.JRBaseCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRDesignCrosstab
extends JRDesignElement
implements JRCrosstab {
    private static final long serialVersionUID = 10101L;
    protected List parametersList = new ArrayList();
    protected Map parametersMap = new HashMap();
    protected JRExpression parametersMapExpression;
    protected JRDesignCrosstabDataset dataset;
    protected List rowGroups;
    protected List columnGroups;
    protected List measures;
    protected Map rowGroupsMap = new HashMap();
    protected Map columnGroupsMap;
    protected Map measuresMap;
    protected int columnBreakOffset = 10;
    protected boolean repeatColumnHeaders = true;
    protected boolean repeatRowHeaders = true;
    protected List cellsList;
    protected Map cellsMap;
    protected JRDesignCrosstabCell[][] crossCells;
    protected JRDesignCellContents whenNoDataCell;
    private static final Object[] BUILT_IN_PARAMETERS = new Object[]{"REPORT_PARAMETERS_MAP", class$java$util$Map == null ? (class$java$util$Map = JRDesignCrosstab.class$("java.util.Map")) : class$java$util$Map, "REPORT_LOCALE", class$java$util$Locale == null ? (class$java$util$Locale = JRDesignCrosstab.class$("java.util.Locale")) : class$java$util$Locale, "REPORT_RESOURCE_BUNDLE", class$java$util$ResourceBundle == null ? (class$java$util$ResourceBundle = JRDesignCrosstab.class$("java.util.ResourceBundle")) : class$java$util$ResourceBundle, "REPORT_CLASS_LOADER", class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = JRDesignCrosstab.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader};
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$ResourceBundle;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public JRDesignCrosstab(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
        this.rowGroups = new ArrayList();
        this.columnGroupsMap = new HashMap();
        this.columnGroups = new ArrayList();
        this.measuresMap = new HashMap();
        this.measures = new ArrayList();
        this.cellsMap = new HashMap();
        this.cellsList = new ArrayList();
        this.addBuiltinParameters();
        this.dataset = new JRDesignCrosstabDataset();
    }

    private void addBuiltinParameters() {
        for (int i = 0; i < BUILT_IN_PARAMETERS.length; ++i) {
            JRDesignCrosstabParameter parameter = new JRDesignCrosstabParameter();
            parameter.setName((String)BUILT_IN_PARAMETERS[i++]);
            parameter.setValueClass((Class)BUILT_IN_PARAMETERS[i]);
            parameter.setSystemDefined(true);
            try {
                this.addParameter(parameter);
                continue;
            }
            catch (JRException jRException) {
                // empty catch block
            }
        }
    }

    public JRDesignCrosstab() {
        this(null);
    }

    public int getId() {
        return 0;
    }

    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    public JRDesignCrosstabDataset getDesignDataset() {
        return this.dataset;
    }

    public JRCrosstabRowGroup[] getRowGroups() {
        JRCrosstabRowGroup[] groups = new JRCrosstabRowGroup[this.rowGroups.size()];
        this.rowGroups.toArray(groups);
        return groups;
    }

    public JRCrosstabColumnGroup[] getColumnGroups() {
        JRCrosstabColumnGroup[] groups = new JRCrosstabColumnGroup[this.columnGroups.size()];
        this.columnGroups.toArray(groups);
        return groups;
    }

    public JRCrosstabMeasure[] getMeasures() {
        JRCrosstabMeasure[] measureArray = new JRCrosstabMeasure[this.measures.size()];
        this.measures.toArray(measureArray);
        return measureArray;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getCrosstab(this);
    }

    public void writeXml(JRXmlWriter writer) throws IOException {
        writer.writeCrosstab(this);
    }

    public void setDataset(JRDesignCrosstabDataset dataset) {
        this.dataset = dataset;
    }

    public void addRowGroup(JRDesignCrosstabRowGroup group) throws JRException {
        String groupName = group.getName();
        if (this.rowGroupsMap.containsKey(groupName) || this.columnGroupsMap.containsKey(groupName) || this.measuresMap.containsKey(groupName)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        this.rowGroupsMap.put(groupName, new Integer(this.rowGroups.size()));
        this.rowGroups.add(group);
    }

    public void addColumnGroup(JRDesignCrosstabColumnGroup group) throws JRException {
        String groupName = group.getName();
        if (this.rowGroupsMap.containsKey(groupName) || this.columnGroupsMap.containsKey(groupName) || this.measuresMap.containsKey(groupName)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        this.columnGroupsMap.put(groupName, new Integer(this.columnGroups.size()));
        this.columnGroups.add(group);
    }

    public void addMeasure(JRCrosstabMeasure measure) throws JRException {
        String measureName = measure.getName();
        if (this.rowGroupsMap.containsKey(measureName) || this.columnGroupsMap.containsKey(measureName) || this.measuresMap.containsKey(measureName)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        this.measuresMap.put(measureName, new Integer(this.measures.size()));
        this.measures.add(measure);
    }

    public JRCrosstabRowGroup removeRowGroup(String groupName) {
        JRCrosstabRowGroup removed = null;
        Integer idx = (Integer)this.rowGroupsMap.remove(groupName);
        if (idx != null) {
            removed = (JRCrosstabRowGroup)this.rowGroups.remove(idx);
            Iterator it = this.rowGroups.listIterator(idx);
            while (it.hasNext()) {
                JRCrosstabRowGroup group = (JRCrosstabRowGroup)it.next();
                this.rowGroupsMap.put(group.getName(), new Integer(it.previousIndex()));
            }
            it = this.cellsList.iterator();
            while (it.hasNext()) {
                JRCrosstabCell cell = (JRCrosstabCell)it.next();
                String rowTotalGroup = cell.getRowTotalGroup();
                if (rowTotalGroup == null || !rowTotalGroup.equals(groupName)) continue;
                it.remove();
                this.cellsMap.remove(new Pair(rowTotalGroup, cell.getColumnTotalGroup()));
            }
        }
        return removed;
    }

    public JRCrosstabRowGroup removeRowGroup(JRCrosstabRowGroup group) {
        return this.removeRowGroup(group.getName());
    }

    public JRCrosstabColumnGroup removeColumnGroup(String groupName) {
        JRCrosstabColumnGroup removed = null;
        Integer idx = (Integer)this.columnGroupsMap.remove(groupName);
        if (idx != null) {
            removed = (JRCrosstabColumnGroup)this.columnGroups.remove(idx);
            Iterator it = this.columnGroups.listIterator(idx);
            while (it.hasNext()) {
                JRCrosstabColumnGroup group = (JRCrosstabColumnGroup)it.next();
                this.columnGroupsMap.put(group.getName(), new Integer(it.previousIndex()));
            }
            it = this.cellsList.iterator();
            while (it.hasNext()) {
                JRCrosstabCell cell = (JRCrosstabCell)it.next();
                String columnTotalGroup = cell.getColumnTotalGroup();
                if (columnTotalGroup == null || !columnTotalGroup.equals(groupName)) continue;
                it.remove();
                this.cellsMap.remove(new Pair(cell.getRowTotalGroup(), columnTotalGroup));
            }
        }
        return removed;
    }

    public JRCrosstabColumnGroup removeColumnGroup(JRCrosstabColumnGroup group) {
        return this.removeColumnGroup(group.getName());
    }

    public JRCrosstabMeasure removeMeasure(String measureName) {
        JRCrosstabMeasure removed = null;
        Integer idx = (Integer)this.measuresMap.remove(measureName);
        if (idx != null) {
            removed = (JRCrosstabMeasure)this.measures.remove(idx);
            ListIterator it = this.measures.listIterator(idx);
            while (it.hasNext()) {
                JRCrosstabMeasure group = (JRCrosstabMeasure)it.next();
                this.measuresMap.put(group.getName(), new Integer(it.previousIndex()));
            }
        }
        return removed;
    }

    public JRCrosstabMeasure removeMeasure(JRCrosstabMeasure measure) {
        return this.removeMeasure(measure.getName());
    }

    public boolean isRepeatColumnHeaders() {
        return this.repeatColumnHeaders;
    }

    public void setRepeatColumnHeaders(boolean repeatColumnHeaders) {
        this.repeatColumnHeaders = repeatColumnHeaders;
    }

    public boolean isRepeatRowHeaders() {
        return this.repeatRowHeaders;
    }

    public void setRepeatRowHeaders(boolean repeatRowHeaders) {
        this.repeatRowHeaders = repeatRowHeaders;
    }

    public JRCrosstabCell[][] getCells() {
        return this.crossCells;
    }

    public List getCellsList() {
        return this.cellsList;
    }

    public void addCell(JRDesignCrosstabCell cell) throws JRException {
        String rowTotalGroup = cell.getRowTotalGroup();
        if (rowTotalGroup != null && !this.rowGroupsMap.containsKey(rowTotalGroup)) {
            throw new JRException("Row group " + rowTotalGroup + " does not exist.");
        }
        String columnTotalGroup = cell.getColumnTotalGroup();
        if (columnTotalGroup != null && !this.columnGroupsMap.containsKey(columnTotalGroup)) {
            throw new JRException("Row group " + columnTotalGroup + " does not exist.");
        }
        Pair cellKey = new Pair(rowTotalGroup, columnTotalGroup);
        if (this.cellsMap.containsKey(cellKey)) {
            throw new JRException("Duplicate cell in crosstab.");
        }
        this.cellsMap.put(cellKey, cell);
        this.cellsList.add(cell);
    }

    public JRCrosstabCell removeCell(String rowTotalGroup, String columnTotalGroup) {
        Pair cellKey = new Pair(rowTotalGroup, columnTotalGroup);
        JRCrosstabCell cell = (JRCrosstabCell)this.cellsMap.remove(cellKey);
        if (cell != null) {
            this.cellsList.remove(cell);
        }
        return cell;
    }

    public JRCrosstabCell removeCell(JRCrosstabCell cell) {
        Pair cellKey = new Pair(cell.getRowTotalGroup(), cell.getColumnTotalGroup());
        JRCrosstabCell removedCell = (JRCrosstabCell)this.cellsMap.remove(cellKey);
        if (removedCell != null) {
            this.cellsList.remove(removedCell);
        }
        return removedCell;
    }

    public JRCrosstabParameter[] getParameters() {
        JRCrosstabParameter[] parameters = new JRCrosstabParameter[this.parametersList.size()];
        this.parametersList.toArray(parameters);
        return parameters;
    }

    public List getParametersList() {
        return this.parametersList;
    }

    public Map getParametersMap() {
        return this.parametersMap;
    }

    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public void addParameter(JRCrosstabParameter parameter) throws JRException {
        if (this.parametersMap.containsKey(parameter.getName()) && this.parametersMap.containsKey(parameter.getName())) {
            throw new JRException("Duplicate declaration of parameter : " + parameter.getName());
        }
        this.parametersMap.put(parameter.getName(), parameter);
        this.parametersList.add(parameter);
    }

    public JRCrosstabParameter removeParameter(String parameterName) {
        JRCrosstabParameter param = (JRCrosstabParameter)this.parametersMap.remove(parameterName);
        if (param != null) {
            this.parametersList.remove(param);
        }
        return param;
    }

    public JRCrosstabParameter removeParameter(JRCrosstabParameter parameter) {
        return this.removeParameter(parameter.getName());
    }

    public void setParametersMapExpression(JRExpression expression) {
        this.parametersMapExpression = expression;
    }

    public Map getVariablesMap() {
        JRVariable[] variables = this.getVariables();
        HashMap<String, JRVariable> variablesMap = new HashMap<String, JRVariable>();
        for (int i = 0; i < variables.length; ++i) {
            variablesMap.put(variables[i].getName(), variables[i]);
        }
        return variablesMap;
    }

    public JRVariable[] getVariables() {
        JRCrosstabGroup group;
        JRVariable[] variables = new JRVariable[this.rowGroups.size() + this.columnGroups.size() + this.measures.size()];
        int i = 0;
        Iterator it = this.rowGroups.iterator();
        while (it.hasNext()) {
            group = (JRCrosstabGroup)it.next();
            variables[i++] = group.getVariable();
        }
        it = this.columnGroups.iterator();
        while (it.hasNext()) {
            group = (JRCrosstabGroup)it.next();
            variables[i++] = group.getVariable();
        }
        it = this.measures.iterator();
        while (it.hasNext()) {
            JRCrosstabMeasure measure = (JRCrosstabMeasure)it.next();
            variables[i++] = measure.getVariable();
        }
        return variables;
    }

    public int getColumnBreakOffset() {
        return this.columnBreakOffset;
    }

    public void setColumnBreakOffset(int columnBreakOffset) {
        this.columnBreakOffset = columnBreakOffset;
    }

    public void preprocess() {
        this.setGroupVariablesClass(this.rowGroups);
        this.setGroupVariablesClass(this.columnGroups);
        this.calculateSizes();
    }

    protected void setGroupVariablesClass(List groups) {
        Iterator it = groups.iterator();
        while (it.hasNext()) {
            JRExpression expression;
            JRDesignCrosstabGroup group = (JRDesignCrosstabGroup)it.next();
            JRCrosstabBucket bucket = group.getBucket();
            if (bucket == null || (expression = bucket.getExpression()) == null) continue;
            group.designVariable.setValueClassName(expression.getValueClassName());
        }
    }

    protected void calculateSizes() {
        this.setWhenNoDataCellSize();
        this.createCellMatrix();
        this.calculateRowHeadersSizes();
        this.calculateColumnHeadersSizes();
    }

    protected void setWhenNoDataCellSize() {
        if (this.whenNoDataCell != null) {
            this.whenNoDataCell.setWidth(this.getWidth());
            this.whenNoDataCell.setHeight(this.getHeight());
        }
    }

    protected void createCellMatrix() {
        this.crossCells = new JRDesignCrosstabCell[this.rowGroups.size() + 1][this.columnGroups.size() + 1];
        Iterator it = this.cellsList.iterator();
        while (it.hasNext()) {
            int columnGroupIndex;
            String columnTotalGroup;
            int rowGroupIndex;
            JRDesignCrosstabCell crosstabCell = (JRDesignCrosstabCell)it.next();
            JRDesignCellContents contents = (JRDesignCellContents)crosstabCell.getContents();
            String rowTotalGroup = crosstabCell.getRowTotalGroup();
            rowGroupIndex = rowTotalGroup == null ? (rowGroupIndex = this.rowGroups.size()) : (Integer)this.rowGroupsMap.get(rowTotalGroup);
            Integer cellWidth = crosstabCell.getWidth();
            if (cellWidth != null) {
                contents.setWidth(cellWidth);
            }
            columnGroupIndex = (columnTotalGroup = crosstabCell.getColumnTotalGroup()) == null ? (columnGroupIndex = this.columnGroups.size()) : (Integer)this.columnGroupsMap.get(columnTotalGroup);
            Integer cellHeight = crosstabCell.getHeight();
            if (cellHeight != null) {
                contents.setHeight(cellHeight);
            }
            this.crossCells[rowGroupIndex][columnGroupIndex] = crosstabCell;
        }
        this.inheritCells();
    }

    protected JRDesignCrosstabRowGroup getRowGroup(int rowGroupIndex) {
        return (JRDesignCrosstabRowGroup)this.rowGroups.get(rowGroupIndex);
    }

    protected JRDesignCrosstabColumnGroup getColumnGroup(int columnGroupIndex) {
        return (JRDesignCrosstabColumnGroup)this.columnGroups.get(columnGroupIndex);
    }

    protected void inheritCells() {
        for (int i = this.rowGroups.size(); i >= 0; --i) {
            for (int j = this.columnGroups.size(); j >= 0; --j) {
                boolean used;
                boolean bl = used = !(i != this.rowGroups.size() && !this.getRowGroup(i).hasTotal() || j != this.columnGroups.size() && !this.getColumnGroup(j).hasTotal());
                if (used) {
                    if (this.crossCells[i][j] == null) {
                        this.inheritCell(i, j);
                        continue;
                    }
                    this.inheritCellSize(i, j);
                    continue;
                }
                this.crossCells[i][j] = null;
            }
        }
    }

    protected void inheritCellSize(int i, int j) {
        JRDesignCrosstabCell cell = this.crossCells[i][j];
        JRDesignCellContents contents = (JRDesignCellContents)cell.getContents();
        if (contents.getWidth() == Integer.MIN_VALUE) {
            if (i < this.rowGroups.size()) {
                JRDesignCrosstabCell rowCell = this.crossCells[this.rowGroups.size()][j];
                if (rowCell != null) {
                    contents.setWidth(rowCell.getContents().getWidth());
                }
            } else {
                int k = j + 1;
                while (k <= this.columnGroups.size()) {
                    if (this.crossCells[i][k] != null) {
                        contents.setWidth(this.crossCells[i][k].getContents().getWidth());
                        break;
                    }
                    ++j;
                }
            }
        }
        if (contents.getHeight() == Integer.MIN_VALUE) {
            if (j < this.columnGroups.size()) {
                JRDesignCrosstabCell colCell = this.crossCells[i][this.columnGroups.size()];
                if (colCell != null) {
                    contents.setHeight(colCell.getContents().getHeight());
                }
            } else {
                for (int k = i + 1; k <= this.rowGroups.size(); ++k) {
                    if (this.crossCells[k][j] == null) continue;
                    contents.setHeight(this.crossCells[k][j].getContents().getHeight());
                }
            }
        }
    }

    protected void inheritCell(int i, int j) {
        JRDesignCellContents contents;
        JRDesignCrosstabCell cell;
        int k;
        JRDesignCrosstabCell inheritedCell = null;
        if (j < this.columnGroups.size()) {
            JRDesignCrosstabCell colCell = this.crossCells[this.rowGroups.size()][j];
            JRDesignCellContents colContents = colCell == null ? null : (JRDesignCellContents)colCell.getContents();
            for (k = j + 1; inheritedCell == null && k <= this.columnGroups.size(); ++k) {
                cell = this.crossCells[i][k];
                if (cell == null) continue;
                contents = (JRDesignCellContents)cell.getContents();
                if (colContents != null && contents.getWidth() != colContents.getWidth()) continue;
                inheritedCell = cell;
            }
        }
        if (inheritedCell == null && i < this.rowGroups.size()) {
            JRDesignCrosstabCell rowCell = this.crossCells[i][this.columnGroups.size()];
            JRDesignCellContents rowContents = rowCell == null ? null : (JRDesignCellContents)rowCell.getContents();
            for (k = i + 1; inheritedCell == null && k <= this.rowGroups.size(); ++k) {
                cell = this.crossCells[k][j];
                if (cell == null) continue;
                contents = (JRDesignCellContents)cell.getContents();
                if (rowContents != null && contents.getHeight() != rowContents.getHeight()) continue;
                inheritedCell = cell;
            }
        }
        this.crossCells[i][j] = inheritedCell;
    }

    protected void calculateRowHeadersSizes() {
        int widthSum = 0;
        int heightSum = 0;
        for (int i = this.rowGroups.size() - 1; i >= 0; --i) {
            JRDesignCrosstabRowGroup group = (JRDesignCrosstabRowGroup)this.rowGroups.get(i);
            widthSum += group.getWidth();
            JRDesignCrosstabCell cell = this.crossCells[i + 1][this.columnGroups.size()];
            if (cell != null) {
                heightSum += cell.getContents().getHeight();
            }
            JRDesignCellContents header = (JRDesignCellContents)group.getHeader();
            header.setHeight(heightSum);
            header.setWidth(group.getWidth());
            if (!group.hasTotal()) continue;
            JRDesignCellContents totalHeader = (JRDesignCellContents)group.getTotalHeader();
            totalHeader.setWidth(widthSum);
            JRDesignCrosstabCell totalCell = this.crossCells[i][this.columnGroups.size()];
            if (totalCell == null) continue;
            totalHeader.setHeight(totalCell.getContents().getHeight());
        }
    }

    protected void calculateColumnHeadersSizes() {
        int heightSum = 0;
        int widthSum = 0;
        for (int i = this.columnGroups.size() - 1; i >= 0; --i) {
            JRDesignCrosstabColumnGroup group = (JRDesignCrosstabColumnGroup)this.columnGroups.get(i);
            heightSum += group.getHeight();
            JRDesignCrosstabCell cell = this.crossCells[this.rowGroups.size()][i + 1];
            if (cell != null) {
                widthSum += cell.getContents().getWidth();
            }
            JRDesignCellContents header = (JRDesignCellContents)group.getHeader();
            header.setHeight(group.getHeight());
            header.setWidth(widthSum);
            if (!group.hasTotal()) continue;
            JRDesignCellContents totalHeader = (JRDesignCellContents)group.getTotalHeader();
            totalHeader.setHeight(heightSum);
            JRDesignCrosstabCell totalCell = this.crossCells[this.rowGroups.size()][i];
            if (totalCell == null) continue;
            totalHeader.setWidth(totalCell.getContents().getWidth());
        }
    }

    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    public void setWhenNoDataCell(JRDesignCellContents whenNoDataCell) {
        this.whenNoDataCell = whenNoDataCell;
    }

    public JRElement getElementByKey(String elementKey) {
        return JRBaseCrosstab.getElementByKey(this, elementKey);
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Pair {
        final Object o1;
        final Object o2;

        Pair(Object o1, Object o2) {
            this.o1 = o1;
            this.o2 = o2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof Pair)) {
                return false;
            }
            Pair p = (Pair)o;
            return (p.o1 == null ? this.o1 == null : this.o1 != null && p.o1.equals(this.o1)) && (p.o2 == null ? this.o2 == null : this.o2 != null && p.o2.equals(this.o2));
        }

        public int hashCode() {
            int hash = this.o1 == null ? 0 : this.o1.hashCode();
            hash *= 31;
            return hash += this.o2 == null ? 0 : this.o2.hashCode();
        }
    }
}

