/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.lexer;

import org.codehaus.groovy.syntax.ReadException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.lexer.Delimiter;
import org.codehaus.groovy.syntax.lexer.GroovyLexerBase;
import org.codehaus.groovy.syntax.lexer.Lexer;
import org.codehaus.groovy.syntax.lexer.LexerException;

public class GroovyExpressionLexer
extends GroovyLexerBase
implements Delimiter {
    protected boolean delimited = true;
    protected boolean finished = false;
    protected int balance = 0;

    public Token nextToken() throws ReadException, LexerException {
        if (this.finished) {
            return null;
        }
        return super.nextToken();
    }

    public void delimit(boolean delimited) {
        this.delimited = delimited;
    }

    public boolean isDelimited() {
        return this.delimited;
    }

    public boolean isFinished() {
        return this.finished;
    }

    protected void restart() {
        this.finished = false;
    }

    protected void finish() {
        this.finished = true;
    }

    public void delegate(Lexer to) {
        this.delegate = to;
        this.delimit(false);
        to.setSource(this);
    }

    public void undelegate() {
        if (this.delegate != null) {
            this.delegate.unsetSource();
            this.delegate = null;
            this.delimit(true);
        }
    }

    public char la(int k) throws LexerException, ReadException {
        if (this.source != null) {
            if (this.delimited) {
                char c = ' ';
                int balance = this.balance;
                block4: for (int i = 1; i <= k && balance >= 0; ++i) {
                    c = this.source.la(k);
                    switch (c) {
                        case '{': {
                            ++balance;
                            continue block4;
                        }
                        case '}': {
                            --balance;
                        }
                    }
                }
                if (balance >= 0) {
                    return c;
                }
                return '\uffff';
            }
            return this.source.la(k);
        }
        return '\uffff';
    }

    public char consume() throws LexerException, ReadException {
        if (this.source != null) {
            if (this.delimited) {
                char c = this.source.la(1);
                switch (c) {
                    case '{': {
                        ++this.balance;
                        break;
                    }
                    case '}': {
                        --this.balance;
                    }
                }
                if (this.balance >= 0) {
                    return this.source.consume();
                }
                this.finish();
            } else {
                return this.source.consume();
            }
        }
        return '\uffff';
    }
}

