/**
 * ToolbarFormatPanel.java
 *
 *
 * Toolbar has been separated from MainForm at may 7, 2005 to improve maintainability.
 * In the mainform each modification took 20 seconds to be generated
 * Created on 7 mei 2005, 13:27
 */

package it.businesslogic.ireport.gui;
import javax.swing.JToolBar;
import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.gui.actions.ActionShrinkSelected;
import it.businesslogic.ireport.gui.command.FormatCommand;
import javax.swing.Action;
import javax.swing.KeyStroke;

/**
 *
 * @author Robert Lamping
 */
public class ToolbarFormatPanel extends javax.swing.JPanel
{
    
    private MainFrame mainFrame; // MainFrame.getMainInstance();;
    
    /** Creates new form ToolbarFormatPanel */
    public ToolbarFormatPanel(MainFrame mainFrame )
    {
        setMainFrame( mainFrame );
        initComponents();
        
        
        
    }
    
    public JToolBar getToolBar()
    {
        // Make toolbar available to e.g. MainFrame
        return jToolBarFormat;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jToolBarFormat = new javax.swing.JToolBar();
        jButtonFormatAlignTop = new javax.swing.JButton();
        jButtonFormatAlignBottom = new javax.swing.JButton();
        jButtonFormatAlignLeft = new javax.swing.JButton();
        jButtonFormatAlignRight = new javax.swing.JButton();
        jButtonFormatCenterHRight = new javax.swing.JButton();
        jButtonFormatCenterVRight = new javax.swing.JButton();
        Filler = new javax.swing.JButton();
        jButtonFormatAlignToBandTop = new javax.swing.JButton();
        jButtonFormatAlignToBandBottom = new javax.swing.JButton();
        jButtonFormatAlignToLeftMargin = new javax.swing.JButton();
        jButtonFormatAlignToRightMargin = new javax.swing.JButton();
        Filler1 = new javax.swing.JButton();
        jButtonFormatOrganize = new javax.swing.JButton();
        jButtonFormatJoinLeft = new javax.swing.JButton();
        jButtonFormatJoinRight = new javax.swing.JButton();
        Filler4 = new javax.swing.JButton();
        jButtonFormatEqualsSpaceH = new javax.swing.JButton();
        jButtonFormatIncreaseSpaceH = new javax.swing.JButton();
        jButtonFormatDecreaseSpaceH = new javax.swing.JButton();
        jButtonFormatRemoveSpaceH = new javax.swing.JButton();
        Filler5 = new javax.swing.JButton();
        jButtonFormatEqualsSpaceV = new javax.swing.JButton();
        jButtonFormatIncreaseSpaceV = new javax.swing.JButton();
        jButtonFormatDecreaseSpaceV = new javax.swing.JButton();
        jButtonFormatDecreaseSpaceV1 = new javax.swing.JButton();
        Filler6 = new javax.swing.JButton();
        jButtonFormatSameWidth = new javax.swing.JButton();
        jButtonFormatSameWidthMax = new javax.swing.JButton();
        jButtonFormatSameWidthMin = new javax.swing.JButton();
        Filler2 = new javax.swing.JButton();
        jButtonFormatSameHeight = new javax.swing.JButton();
        jButtonFormatSameHeightMin = new javax.swing.JButton();
        jButtonFormatSameHeightMax = new javax.swing.JButton();
        Filler3 = new javax.swing.JButton();
        jButtonFormatSameSize = new javax.swing.JButton();
        Filler9 = new javax.swing.JButton();
        jButtonFormatElementMaximizeH = new javax.swing.JButton();
        jButtonFormatElementMaximizeV = new javax.swing.JButton();
        jButtonFormatElementMaximize = new javax.swing.JButton();
        Filler7 = new javax.swing.JButton();
        jButtonFormatCenterInBandH = new javax.swing.JButton();
        jButtonFormatCenterInBandV = new javax.swing.JButton();
        jButtonFormatCenterInBand = new javax.swing.JButton();
        Filler8 = new javax.swing.JButton();
        jButtonFormatShrink = new javax.swing.JButton();
        jButtonFormatShrink.putClientProperty("hideActionText", Boolean.TRUE);

        setLayout(new java.awt.BorderLayout());

        setAutoscrolls(true);
        setName("ToolbarFormatPanel");
        getAccessibleContext().setAccessibleName("ToolbarFormatPanel");
        jToolBarFormat.setAutoscrolls(true);
        jToolBarFormat.setMaximumSize(new java.awt.Dimension(934, 48));
        jToolBarFormat.setMinimumSize(new java.awt.Dimension(814, 27));
        jToolBarFormat.setPreferredSize(new java.awt.Dimension(814, 27));
        jButtonFormatAlignTop.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/align_top.png")));
        jButtonFormatAlignTop.setToolTipText("Align Top");
        jButtonFormatAlignTop.setEnabled(false);
        jButtonFormatAlignTop.setFocusPainted(false);
        jButtonFormatAlignTop.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignTop.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignTop.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignTop.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignTop.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignTopActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignTop);

        jButtonFormatAlignBottom.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/align_bottom.png")));
        jButtonFormatAlignBottom.setToolTipText("Align bottom");
        jButtonFormatAlignBottom.setEnabled(false);
        jButtonFormatAlignBottom.setFocusPainted(false);
        jButtonFormatAlignBottom.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignBottom.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignBottom.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignBottom.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignBottom.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignBottomActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignBottom);

        jButtonFormatAlignLeft.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/align_left.png")));
        jButtonFormatAlignLeft.setToolTipText("Align left");
        jButtonFormatAlignLeft.setEnabled(false);
        jButtonFormatAlignLeft.setFocusPainted(false);
        jButtonFormatAlignLeft.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignLeft.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignLeft.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignLeft.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignLeft.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignLeftActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignLeft);

        jButtonFormatAlignRight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/align_right.png")));
        jButtonFormatAlignRight.setToolTipText("Align right");
        jButtonFormatAlignRight.setEnabled(false);
        jButtonFormatAlignRight.setFocusPainted(false);
        jButtonFormatAlignRight.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignRight.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignRight.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignRight.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignRight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignRightActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignRight);

        jButtonFormatCenterHRight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/center_h.png")));
        jButtonFormatCenterHRight.setToolTipText("Align horizontal axis");
        jButtonFormatCenterHRight.setEnabled(false);
        jButtonFormatCenterHRight.setFocusPainted(false);
        jButtonFormatCenterHRight.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatCenterHRight.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatCenterHRight.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatCenterHRight.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatCenterHRight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatCenterHRightActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatCenterHRight);

        jButtonFormatCenterVRight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/center_v.png")));
        jButtonFormatCenterVRight.setToolTipText("Align vertical axis");
        jButtonFormatCenterVRight.setEnabled(false);
        jButtonFormatCenterVRight.setFocusPainted(false);
        jButtonFormatCenterVRight.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatCenterVRight.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatCenterVRight.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatCenterVRight.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatCenterVRight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatCenterVRightActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatCenterVRight);

        Filler.setBackground(new java.awt.Color(255, 255, 255));
        Filler.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler.setBorderPainted(false);
        Filler.setContentAreaFilled(false);
        Filler.setEnabled(false);
        Filler.setFocusPainted(false);
        Filler.setFocusable(false);
        Filler.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler);

        jButtonFormatAlignToBandTop.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_top.png")));
        jButtonFormatAlignToBandTop.setToolTipText("Align to band top");
        jButtonFormatAlignToBandTop.setEnabled(false);
        jButtonFormatAlignToBandTop.setFocusPainted(false);
        jButtonFormatAlignToBandTop.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignToBandTop.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignToBandTop.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignToBandTopActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignToBandTop);

        jButtonFormatAlignToBandBottom.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_bottom.png")));
        jButtonFormatAlignToBandBottom.setToolTipText("Align to band bottom");
        jButtonFormatAlignToBandBottom.setEnabled(false);
        jButtonFormatAlignToBandBottom.setFocusPainted(false);
        jButtonFormatAlignToBandBottom.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignToBandBottom.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignToBandBottom.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignToBandBottomActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignToBandBottom);

        jButtonFormatAlignToLeftMargin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_left.png")));
        jButtonFormatAlignToLeftMargin.setToolTipText("Align to left margin");
        jButtonFormatAlignToLeftMargin.setEnabled(false);
        jButtonFormatAlignToLeftMargin.setFocusPainted(false);
        jButtonFormatAlignToLeftMargin.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignToLeftMargin.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignToLeftMargin.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignToLeftMarginActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignToLeftMargin);

        jButtonFormatAlignToRightMargin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_right.png")));
        jButtonFormatAlignToRightMargin.setToolTipText("Align to right margin");
        jButtonFormatAlignToRightMargin.setEnabled(false);
        jButtonFormatAlignToRightMargin.setFocusPainted(false);
        jButtonFormatAlignToRightMargin.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignToRightMargin.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignToRightMargin.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignToRightMarginActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignToRightMargin);

        Filler1.setBackground(new java.awt.Color(255, 255, 255));
        Filler1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler1.setBorderPainted(false);
        Filler1.setContentAreaFilled(false);
        Filler1.setEnabled(false);
        Filler1.setFocusPainted(false);
        Filler1.setFocusable(false);
        Filler1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler1.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler1.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler1.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler1);

        jButtonFormatOrganize.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/organize.png")));
        jButtonFormatOrganize.setToolTipText("Organize as a table: [CTRL+SHIFT+O]");
        jButtonFormatOrganize.setEnabled(false);
        jButtonFormatOrganize.setFocusPainted(false);
        jButtonFormatOrganize.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatOrganize.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatOrganize.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatOrganize.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatOrganize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatOrganizeActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatOrganize);

        jButtonFormatJoinLeft.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/joinleft.png")));
        jButtonFormatJoinLeft.setToolTipText("Join sides Left: [CTRL+SHIFT+L]");
        jButtonFormatJoinLeft.setEnabled(false);
        jButtonFormatJoinLeft.setFocusPainted(false);
        jButtonFormatJoinLeft.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatJoinLeft.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatJoinLeft.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatJoinLeft.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatJoinLeft.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatJoinLeftActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatJoinLeft);

        jButtonFormatJoinRight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/joinright.png")));
        jButtonFormatJoinRight.setToolTipText("Join sides right: [CTRL+SHIFT+R]");
        jButtonFormatJoinRight.setEnabled(false);
        jButtonFormatJoinRight.setFocusPainted(false);
        jButtonFormatJoinRight.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatJoinRight.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatJoinRight.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatJoinRight.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatJoinRight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatJoinRightActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatJoinRight);

        Filler4.setBackground(new java.awt.Color(255, 255, 255));
        Filler4.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler4.setBorderPainted(false);
        Filler4.setContentAreaFilled(false);
        Filler4.setEnabled(false);
        Filler4.setFocusPainted(false);
        Filler4.setFocusable(false);
        Filler4.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler4.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler4.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler4.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler4);

        jButtonFormatEqualsSpaceH.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_hspace.png")));
        jButtonFormatEqualsSpaceH.setToolTipText("Horizontal space: Make equal");
        jButtonFormatEqualsSpaceH.setEnabled(false);
        jButtonFormatEqualsSpaceH.setFocusPainted(false);
        jButtonFormatEqualsSpaceH.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatEqualsSpaceH.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatEqualsSpaceH.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatEqualsSpaceHActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatEqualsSpaceH);

        jButtonFormatIncreaseSpaceH.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_hspace_plus.png")));
        jButtonFormatIncreaseSpaceH.setToolTipText("Horizontal space: Increase");
        jButtonFormatIncreaseSpaceH.setEnabled(false);
        jButtonFormatIncreaseSpaceH.setFocusPainted(false);
        jButtonFormatIncreaseSpaceH.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatIncreaseSpaceH.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatIncreaseSpaceH.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatIncreaseSpaceHActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatIncreaseSpaceH);

        jButtonFormatDecreaseSpaceH.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_hspace_min.png")));
        jButtonFormatDecreaseSpaceH.setToolTipText("Horizontal space: Decrease");
        jButtonFormatDecreaseSpaceH.setEnabled(false);
        jButtonFormatDecreaseSpaceH.setFocusPainted(false);
        jButtonFormatDecreaseSpaceH.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatDecreaseSpaceH.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatDecreaseSpaceH.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatDecreaseSpaceHActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatDecreaseSpaceH);

        jButtonFormatRemoveSpaceH.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_hspace_zero.png")));
        jButtonFormatRemoveSpaceH.setToolTipText("Horizontal space: Remove");
        jButtonFormatRemoveSpaceH.setEnabled(false);
        jButtonFormatRemoveSpaceH.setFocusPainted(false);
        jButtonFormatRemoveSpaceH.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatRemoveSpaceH.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatRemoveSpaceH.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatRemoveSpaceH.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatRemoveSpaceH.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatRemoveSpaceHActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatRemoveSpaceH);

        Filler5.setBackground(new java.awt.Color(255, 255, 255));
        Filler5.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler5.setBorderPainted(false);
        Filler5.setContentAreaFilled(false);
        Filler5.setEnabled(false);
        Filler5.setFocusPainted(false);
        Filler5.setFocusable(false);
        Filler5.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler5.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler5.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler5.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler5);

        jButtonFormatEqualsSpaceV.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_vspace.png")));
        jButtonFormatEqualsSpaceV.setToolTipText("Vertical space: Make equal");
        jButtonFormatEqualsSpaceV.setEnabled(false);
        jButtonFormatEqualsSpaceV.setFocusPainted(false);
        jButtonFormatEqualsSpaceV.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatEqualsSpaceV.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatEqualsSpaceV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatEqualsSpaceVActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatEqualsSpaceV);

        jButtonFormatIncreaseSpaceV.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_vspace_plus.png")));
        jButtonFormatIncreaseSpaceV.setToolTipText("Vertical space: Increase");
        jButtonFormatIncreaseSpaceV.setEnabled(false);
        jButtonFormatIncreaseSpaceV.setFocusPainted(false);
        jButtonFormatIncreaseSpaceV.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatIncreaseSpaceV.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatIncreaseSpaceV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatIncreaseSpaceVActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatIncreaseSpaceV);

        jButtonFormatDecreaseSpaceV.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_vspace_min.png")));
        jButtonFormatDecreaseSpaceV.setToolTipText("Vertical space: Decrease");
        jButtonFormatDecreaseSpaceV.setEnabled(false);
        jButtonFormatDecreaseSpaceV.setFocusPainted(false);
        jButtonFormatDecreaseSpaceV.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatDecreaseSpaceV.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatDecreaseSpaceV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatDecreaseSpaceVActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatDecreaseSpaceV);

        jButtonFormatDecreaseSpaceV1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_vspace_zero.png")));
        jButtonFormatDecreaseSpaceV1.setToolTipText("Vertical space: remove");
        jButtonFormatDecreaseSpaceV1.setEnabled(false);
        jButtonFormatDecreaseSpaceV1.setFocusPainted(false);
        jButtonFormatDecreaseSpaceV1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatDecreaseSpaceV1.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatDecreaseSpaceV1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatDecreaseSpaceV1ActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatDecreaseSpaceV1);

        Filler6.setBackground(new java.awt.Color(255, 255, 255));
        Filler6.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler6.setBorderPainted(false);
        Filler6.setContentAreaFilled(false);
        Filler6.setEnabled(false);
        Filler6.setFocusPainted(false);
        Filler6.setFocusable(false);
        Filler6.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler6.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler6.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler6.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler6);

        jButtonFormatSameWidth.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_hsize.gif")));
        jButtonFormatSameWidth.setToolTipText("Same width");
        jButtonFormatSameWidth.setEnabled(false);
        jButtonFormatSameWidth.setFocusPainted(false);
        jButtonFormatSameWidth.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatSameWidth.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatSameWidth.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatSameWidthActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatSameWidth);

        jButtonFormatSameWidthMax.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_hsize_plus.gif")));
        jButtonFormatSameWidthMax.setToolTipText("Same width (max)");
        jButtonFormatSameWidthMax.setEnabled(false);
        jButtonFormatSameWidthMax.setFocusPainted(false);
        jButtonFormatSameWidthMax.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatSameWidthMax.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatSameWidthMax.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatSameWidthMaxActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatSameWidthMax);

        jButtonFormatSameWidthMin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_hsize_min.gif")));
        jButtonFormatSameWidthMin.setToolTipText("Same width (min)");
        jButtonFormatSameWidthMin.setEnabled(false);
        jButtonFormatSameWidthMin.setFocusPainted(false);
        jButtonFormatSameWidthMin.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatSameWidthMin.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatSameWidthMin.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatSameWidthMinActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatSameWidthMin);

        Filler2.setBackground(new java.awt.Color(255, 255, 255));
        Filler2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler2.setBorderPainted(false);
        Filler2.setContentAreaFilled(false);
        Filler2.setEnabled(false);
        Filler2.setFocusPainted(false);
        Filler2.setFocusable(false);
        Filler2.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler2.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler2.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler2.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler2);

        jButtonFormatSameHeight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_vsize.gif")));
        jButtonFormatSameHeight.setToolTipText("Same height");
        jButtonFormatSameHeight.setEnabled(false);
        jButtonFormatSameHeight.setFocusPainted(false);
        jButtonFormatSameHeight.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatSameHeight.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatSameHeight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatSameHeightActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatSameHeight);

        jButtonFormatSameHeightMin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_vsize_min.gif")));
        jButtonFormatSameHeightMin.setToolTipText("Same height (min)");
        jButtonFormatSameHeightMin.setEnabled(false);
        jButtonFormatSameHeightMin.setFocusPainted(false);
        jButtonFormatSameHeightMin.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatSameHeightMin.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatSameHeightMin.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatSameHeightMinActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatSameHeightMin);

        jButtonFormatSameHeightMax.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_vsize_plus.gif")));
        jButtonFormatSameHeightMax.setToolTipText("Same heigt (max)");
        jButtonFormatSameHeightMax.setEnabled(false);
        jButtonFormatSameHeightMax.setFocusPainted(false);
        jButtonFormatSameHeightMax.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatSameHeightMax.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatSameHeightMax.setOpaque(false);
        jButtonFormatSameHeightMax.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatSameHeightMaxActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatSameHeightMax);

        Filler3.setBackground(new java.awt.Color(255, 255, 255));
        Filler3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler3.setBorderPainted(false);
        Filler3.setContentAreaFilled(false);
        Filler3.setEnabled(false);
        Filler3.setFocusPainted(false);
        Filler3.setFocusable(false);
        Filler3.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler3.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler3.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler3.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler3);

        jButtonFormatSameSize.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_size.gif")));
        jButtonFormatSameSize.setToolTipText("Same size");
        jButtonFormatSameSize.setEnabled(false);
        jButtonFormatSameSize.setFocusPainted(false);
        jButtonFormatSameSize.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatSameSize.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatSameSize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatSameSizeActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatSameSize);

        Filler9.setBackground(new java.awt.Color(255, 255, 255));
        Filler9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler9.setBorderPainted(false);
        Filler9.setContentAreaFilled(false);
        Filler9.setEnabled(false);
        Filler9.setFocusPainted(false);
        Filler9.setFocusable(false);
        Filler9.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler9.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler9.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler9.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler9);

        jButtonFormatElementMaximizeH.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_hmaximise.gif")));
        jButtonFormatElementMaximizeH.setToolTipText("Enlarge between margins");
        jButtonFormatElementMaximizeH.setEnabled(false);
        jButtonFormatElementMaximizeH.setFocusPainted(false);
        jButtonFormatElementMaximizeH.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatElementMaximizeH.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatElementMaximizeH.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatElementMaximizeHActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatElementMaximizeH);

        jButtonFormatElementMaximizeV.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_vmaximise.gif")));
        jButtonFormatElementMaximizeV.setToolTipText("Enlarge to band height");
        jButtonFormatElementMaximizeV.setEnabled(false);
        jButtonFormatElementMaximizeV.setFocusPainted(false);
        jButtonFormatElementMaximizeV.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatElementMaximizeV.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatElementMaximizeV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatElementMaximizeVActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatElementMaximizeV);

        jButtonFormatElementMaximize.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_maximise.gif")));
        jButtonFormatElementMaximize.setToolTipText("Enlarge between margins and to band height");
        jButtonFormatElementMaximize.setEnabled(false);
        jButtonFormatElementMaximize.setFocusPainted(false);
        jButtonFormatElementMaximize.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatElementMaximize.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatElementMaximize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatElementMaximizeActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatElementMaximize);

        Filler7.setBackground(new java.awt.Color(255, 255, 255));
        Filler7.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler7.setBorderPainted(false);
        Filler7.setContentAreaFilled(false);
        Filler7.setEnabled(false);
        Filler7.setFocusPainted(false);
        Filler7.setFocusable(false);
        Filler7.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler7.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler7.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler7.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler7);

        jButtonFormatCenterInBandH.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_hcenter.gif")));
        jButtonFormatCenterInBandH.setToolTipText("Center between margins");
        jButtonFormatCenterInBandH.setEnabled(false);
        jButtonFormatCenterInBandH.setFocusPainted(false);
        jButtonFormatCenterInBandH.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatCenterInBandH.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatCenterInBandH.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatCenterInBandHActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatCenterInBandH);

        jButtonFormatCenterInBandV.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_vcenter.gif")));
        jButtonFormatCenterInBandV.setToolTipText("Vertically center in band");
        jButtonFormatCenterInBandV.setEnabled(false);
        jButtonFormatCenterInBandV.setFocusPainted(false);
        jButtonFormatCenterInBandV.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatCenterInBandV.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatCenterInBandV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatCenterInBandVActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatCenterInBandV);

        jButtonFormatCenterInBand.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_ccenter.gif")));
        jButtonFormatCenterInBand.setToolTipText("Center in band");
        jButtonFormatCenterInBand.setEnabled(false);
        jButtonFormatCenterInBand.setFocusPainted(false);
        jButtonFormatCenterInBand.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatCenterInBand.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatCenterInBand.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatCenterInBandActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatCenterInBand);

        Filler8.setBackground(new java.awt.Color(255, 255, 255));
        Filler8.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler8.setBorderPainted(false);
        Filler8.setContentAreaFilled(false);
        Filler8.setEnabled(false);
        Filler8.setFocusPainted(false);
        Filler8.setFocusable(false);
        Filler8.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler8.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler8.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler8.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler8);

        jButtonFormatShrink.setAction(new ActionShrinkSelected());
        jButtonFormatShrink.setEnabled(false);
        jButtonFormatShrink.setFocusPainted(false);
        jButtonFormatShrink.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatShrink.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatShrink.setMinimumSize(new java.awt.Dimension(22, 21));
        jButtonFormatShrink.setPreferredSize(new java.awt.Dimension(22, 21));
        jButtonFormatShrink.addAncestorListener(new javax.swing.event.AncestorListener() {
            public void ancestorMoved(javax.swing.event.AncestorEvent evt) {
            }
            public void ancestorAdded(javax.swing.event.AncestorEvent evt) {
                jButtonFormatShrinkAncestorAdded(evt);
            }
            public void ancestorRemoved(javax.swing.event.AncestorEvent evt) {
            }
        });

        jToolBarFormat.add(jButtonFormatShrink);

        add(jToolBarFormat, java.awt.BorderLayout.NORTH);

    }// </editor-fold>//GEN-END:initComponents
    
    private void jButtonFormatShrinkAncestorAdded(javax.swing.event.AncestorEvent evt)//GEN-FIRST:event_jButtonFormatShrinkAncestorAdded
    {//GEN-HEADEREND:event_jButtonFormatShrinkAncestorAdded
// TODO add your handling code here:
    }//GEN-LAST:event_jButtonFormatShrinkAncestorAdded
    
    private void jButtonFormatCenterInBandActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatCenterInBandActionPerformed
        FormatCommand.getCommand( OperationType.CENTER_IN_BAND).execute();
    }//GEN-LAST:event_jButtonFormatCenterInBandActionPerformed
    
    private void jButtonFormatCenterInBandVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatCenterInBandVActionPerformed
        FormatCommand.getCommand( OperationType.CENTER_IN_BAND_V).execute();
    }//GEN-LAST:event_jButtonFormatCenterInBandVActionPerformed
    
    private void jButtonFormatCenterInBandHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatCenterInBandHActionPerformed
        FormatCommand.getCommand( OperationType.CENTER_IN_BAND_H).execute();
        
    }//GEN-LAST:event_jButtonFormatCenterInBandHActionPerformed
    
    private void jButtonFormatElementMaximizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatElementMaximizeActionPerformed
        FormatCommand.getCommand( OperationType.ELEMENT_MAXIMIZE).execute();
    }//GEN-LAST:event_jButtonFormatElementMaximizeActionPerformed
    
    private void jButtonFormatElementMaximizeVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatElementMaximizeVActionPerformed
        FormatCommand.getCommand( OperationType.ELEMENT_MAXIMIZE_V).execute();
    }//GEN-LAST:event_jButtonFormatElementMaximizeVActionPerformed
    
    private void jButtonFormatElementMaximizeHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatElementMaximizeHActionPerformed
        FormatCommand.getCommand( OperationType.ELEMENT_MAXIMIZE_H).execute();
    }//GEN-LAST:event_jButtonFormatElementMaximizeHActionPerformed
    
    private void jButtonFormatDecreaseSpaceV1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatDecreaseSpaceV1ActionPerformed
        FormatCommand.getCommand( OperationType.REMOVE_SPACE_V).execute();
    }//GEN-LAST:event_jButtonFormatDecreaseSpaceV1ActionPerformed
    
    private void jButtonFormatDecreaseSpaceVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatDecreaseSpaceVActionPerformed
        FormatCommand.getCommand( OperationType.DECREASE_SPACE_V).execute();
    }//GEN-LAST:event_jButtonFormatDecreaseSpaceVActionPerformed
    
    private void jButtonFormatIncreaseSpaceVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatIncreaseSpaceVActionPerformed
        FormatCommand.getCommand( OperationType.INCREASE_SPACE_V).execute();
    }//GEN-LAST:event_jButtonFormatIncreaseSpaceVActionPerformed
    
    private void jButtonFormatEqualsSpaceVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatEqualsSpaceVActionPerformed
        FormatCommand.getCommand( OperationType.EQUALS_SPACE_V).execute();
    }//GEN-LAST:event_jButtonFormatEqualsSpaceVActionPerformed
    
    private void jButtonFormatRemoveSpaceHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatRemoveSpaceHActionPerformed
        FormatCommand.getCommand( OperationType.JOIN_LEFT).execute();
    }//GEN-LAST:event_jButtonFormatRemoveSpaceHActionPerformed
    
    private void jButtonFormatDecreaseSpaceHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatDecreaseSpaceHActionPerformed
        FormatCommand.getCommand( OperationType.DECREASE_SPACE_H).execute();
    }//GEN-LAST:event_jButtonFormatDecreaseSpaceHActionPerformed
    
    private void jButtonFormatIncreaseSpaceHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatIncreaseSpaceHActionPerformed
        FormatCommand.getCommand( OperationType.INCREASE_SPACE_H).execute();
    }//GEN-LAST:event_jButtonFormatIncreaseSpaceHActionPerformed
    
    private void jButtonFormatEqualsSpaceHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatEqualsSpaceHActionPerformed
        FormatCommand.getCommand( OperationType.EQUALS_SPACE_H).execute();
    }//GEN-LAST:event_jButtonFormatEqualsSpaceHActionPerformed
    
    private void jButtonFormatJoinRightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatJoinRightActionPerformed
        FormatCommand.getCommand( OperationType.JOIN_RIGHT).execute();
    }//GEN-LAST:event_jButtonFormatJoinRightActionPerformed
    
    private void jButtonFormatJoinLeftActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatJoinLeftActionPerformed
        FormatCommand.getCommand( OperationType.JOIN_LEFT).execute();
    }//GEN-LAST:event_jButtonFormatJoinLeftActionPerformed
    
    private void jButtonFormatOrganizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatOrganizeActionPerformed
        FormatCommand.getCommand( OperationType.ORGANIZE_AS_A_TABLE).execute();
    }//GEN-LAST:event_jButtonFormatOrganizeActionPerformed
    
    private void jButtonFormatSameHeightMaxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatSameHeightMaxActionPerformed
        FormatCommand.getCommand( OperationType.SAME_HEIGHT_MAX).execute();
    }//GEN-LAST:event_jButtonFormatSameHeightMaxActionPerformed
    
    private void jButtonFormatSameHeightMinActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatSameHeightMinActionPerformed
        FormatCommand.getCommand( OperationType.SAME_HEIGHT_MIN).execute();
    }//GEN-LAST:event_jButtonFormatSameHeightMinActionPerformed
    
    private void jButtonFormatSameWidthMinActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatSameWidthMinActionPerformed
        FormatCommand.getCommand( OperationType.SAME_WIDTH_MIN).execute();
    }//GEN-LAST:event_jButtonFormatSameWidthMinActionPerformed
    
    private void jButtonFormatSameWidthMaxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatSameWidthMaxActionPerformed
        FormatCommand.getCommand( OperationType.SAME_WIDTH_MAX).execute();
    }//GEN-LAST:event_jButtonFormatSameWidthMaxActionPerformed
    
    private void jButtonFormatSameWidthActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatSameWidthActionPerformed
        FormatCommand.getCommand( OperationType.SAME_WIDTH).execute();
    }//GEN-LAST:event_jButtonFormatSameWidthActionPerformed
    
    private void jButtonFormatAlignToLeftMarginActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatAlignToLeftMarginActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_TO_LEFT_MARGIN).execute();
    }//GEN-LAST:event_jButtonFormatAlignToLeftMarginActionPerformed
    
    private void jButtonFormatAlignToBandBottomActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatAlignToBandBottomActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_BOTTOM_TO_BAND).execute();
    }//GEN-LAST:event_jButtonFormatAlignToBandBottomActionPerformed
    
    private void jButtonFormatSameSizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatSameSizeActionPerformed
        FormatCommand.getCommand( OperationType.SAME_SIZE).execute();
    }//GEN-LAST:event_jButtonFormatSameSizeActionPerformed
    
    private void jButtonFormatSameHeightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatSameHeightActionPerformed
        FormatCommand.getCommand( OperationType.SAME_HEIGHT).execute();
    }//GEN-LAST:event_jButtonFormatSameHeightActionPerformed
    
    private void jButtonFormatAlignToRightMarginActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatAlignToRightMarginActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_TO_RIGHT_MARGIN).execute();
    }//GEN-LAST:event_jButtonFormatAlignToRightMarginActionPerformed
    
    private void jButtonFormatAlignToBandTopActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatAlignToBandTopActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_TOP_TO_BAND).execute();
    }//GEN-LAST:event_jButtonFormatAlignToBandTopActionPerformed
    
    private void jButtonFormatCenterVRightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatCenterVRightActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_VERTICAL_AXIS).execute();
    }//GEN-LAST:event_jButtonFormatCenterVRightActionPerformed
    
    private void jButtonFormatCenterHRightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatCenterHRightActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_HORIZONTAL_AXIS).execute();
    }//GEN-LAST:event_jButtonFormatCenterHRightActionPerformed
    
    private void jButtonFormatAlignRightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatAlignRightActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_RIGHT).execute();
    }//GEN-LAST:event_jButtonFormatAlignRightActionPerformed
    
    private void jButtonFormatAlignLeftActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatAlignLeftActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_LEFT).execute();
    }//GEN-LAST:event_jButtonFormatAlignLeftActionPerformed
    
    private void jButtonFormatAlignBottomActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatAlignBottomActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_BOTTOM).execute();
    }//GEN-LAST:event_jButtonFormatAlignBottomActionPerformed
    
    private void jButtonFormatAlignTopActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonFormatAlignTopActionPerformed
    {//GEN-HEADEREND:event_jButtonFormatAlignTopActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_TOP).execute();
    }//GEN-LAST:event_jButtonFormatAlignTopActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton Filler;
    private javax.swing.JButton Filler1;
    private javax.swing.JButton Filler2;
    private javax.swing.JButton Filler3;
    private javax.swing.JButton Filler4;
    private javax.swing.JButton Filler5;
    private javax.swing.JButton Filler6;
    private javax.swing.JButton Filler7;
    private javax.swing.JButton Filler8;
    private javax.swing.JButton Filler9;
    private javax.swing.JButton jButtonFormatAlignBottom;
    private javax.swing.JButton jButtonFormatAlignLeft;
    private javax.swing.JButton jButtonFormatAlignRight;
    private javax.swing.JButton jButtonFormatAlignToBandBottom;
    private javax.swing.JButton jButtonFormatAlignToBandTop;
    private javax.swing.JButton jButtonFormatAlignToLeftMargin;
    private javax.swing.JButton jButtonFormatAlignToRightMargin;
    private javax.swing.JButton jButtonFormatAlignTop;
    private javax.swing.JButton jButtonFormatCenterHRight;
    private javax.swing.JButton jButtonFormatCenterInBand;
    private javax.swing.JButton jButtonFormatCenterInBandH;
    private javax.swing.JButton jButtonFormatCenterInBandV;
    private javax.swing.JButton jButtonFormatCenterVRight;
    private javax.swing.JButton jButtonFormatDecreaseSpaceH;
    private javax.swing.JButton jButtonFormatDecreaseSpaceV;
    private javax.swing.JButton jButtonFormatDecreaseSpaceV1;
    private javax.swing.JButton jButtonFormatElementMaximize;
    private javax.swing.JButton jButtonFormatElementMaximizeH;
    private javax.swing.JButton jButtonFormatElementMaximizeV;
    private javax.swing.JButton jButtonFormatEqualsSpaceH;
    private javax.swing.JButton jButtonFormatEqualsSpaceV;
    private javax.swing.JButton jButtonFormatIncreaseSpaceH;
    private javax.swing.JButton jButtonFormatIncreaseSpaceV;
    private javax.swing.JButton jButtonFormatJoinLeft;
    private javax.swing.JButton jButtonFormatJoinRight;
    private javax.swing.JButton jButtonFormatOrganize;
    private javax.swing.JButton jButtonFormatRemoveSpaceH;
    private javax.swing.JButton jButtonFormatSameHeight;
    private javax.swing.JButton jButtonFormatSameHeightMax;
    private javax.swing.JButton jButtonFormatSameHeightMin;
    private javax.swing.JButton jButtonFormatSameSize;
    private javax.swing.JButton jButtonFormatSameWidth;
    private javax.swing.JButton jButtonFormatSameWidthMax;
    private javax.swing.JButton jButtonFormatSameWidthMin;
    private javax.swing.JButton jButtonFormatShrink;
    private javax.swing.JToolBar jToolBarFormat;
    // End of variables declaration//GEN-END:variables
    
    /**
     * Returns the value of mainFrame.
     */
    public MainFrame getMainFrame()
    {
        return mainFrame;
    }
    
    /**
     * Sets the value of mainFrame.
     * @param mainFrame The value to assign mainFrame.
     */
    public void setMainFrame(MainFrame mainFrame)
    {
        this.mainFrame = mainFrame;
    }
    
    
    
}