/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.library;

import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.library.AbstractLibraryObject;
import it.businesslogic.ireport.gui.library.CustomExpression;
import it.businesslogic.ireport.util.I18n;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class LibraryTreeCellRenderer
extends DefaultTreeCellRenderer {
    static ImageIcon objectIcon;
    static ImageIcon typeIcon;
    static ImageIcon folderClosedIcon;
    static ImageIcon folderOpenedIcon;
    static ImageIcon folderFieldsIcon;
    static ImageIcon folderVariablesIcon;
    static ImageIcon folderParametersIcon;
    static ImageIcon fieldsIcon;
    static ImageIcon variablesIcon;
    static ImageIcon parametersIcon;
    static ImageIcon expressionIcon;
    static ImageIcon datasetIcon;

    public LibraryTreeCellRenderer() {
        if (objectIcon == null) {
            objectIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/javabean/object.png"));
        }
        if (typeIcon == null) {
            typeIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/javabean/type.png"));
        }
        if (folderClosedIcon == null) {
            folderClosedIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/folderClosed.gif"));
        }
        if (folderOpenedIcon == null) {
            folderOpenedIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/folderOpened.gif"));
        }
        if (expressionIcon == null) {
            expressionIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/elements/exp.png"));
        }
        if (folderFieldsIcon == null) {
            folderFieldsIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/editor/fieldsfolder.gif"));
        }
        if (folderVariablesIcon == null) {
            folderVariablesIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/editor/variablesfolder.gif"));
        }
        if (folderParametersIcon == null) {
            folderParametersIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/editor/parametersfolder.gif"));
        }
        if (fieldsIcon == null) {
            fieldsIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/editor/field.png"));
        }
        if (variablesIcon == null) {
            variablesIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/editor/variable.png"));
        }
        if (parametersIcon == null) {
            parametersIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/tree/editor/parameter.png"));
        }
        if (datasetIcon == null) {
            datasetIcon = new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/library/datasource.png"));
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setForeground(Color.BLACK);
        ImageIcon icon = this.getElementIcon(value);
        if (icon != null) {
            this.setIcon(icon);
        } else if (expanded) {
            this.setIcon(folderOpenedIcon);
            this.setToolTipText(null);
        } else {
            this.setIcon(folderClosedIcon);
            this.setToolTipText(null);
        }
        this.setToolTipText(null);
        return this;
    }

    protected ImageIcon getElementIcon(Object value) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        this.setForeground(Color.BLACK);
        if (node.getUserObject() != null && node.getUserObject() instanceof AbstractLibraryObject) {
            return ((AbstractLibraryObject)node.getUserObject()).getIcon();
        }
        if (node.getUserObject() != null && node.getUserObject() instanceof JRField) {
            return fieldsIcon;
        }
        if (node.getUserObject() != null && node.getUserObject() instanceof JRVariable) {
            return variablesIcon;
        }
        if (node.getUserObject() != null && node.getUserObject() instanceof JRParameter) {
            return parametersIcon;
        }
        if (node.getUserObject() != null && node.getUserObject() instanceof CustomExpression) {
            return expressionIcon;
        }
        if (node.getUserObject().toString().equals(I18n.getString("gui.library.fields", "Fields"))) {
            return folderFieldsIcon;
        }
        if (node.getUserObject().toString().equals(I18n.getString("gui.library.variables", "Variables"))) {
            return folderVariablesIcon;
        }
        if (node.getUserObject().toString().equals(I18n.getString("gui.library.parameters", "Parameters"))) {
            return folderParametersIcon;
        }
        if (node.getUserObject() != null && node.getUserObject() instanceof SubDataset) {
            return datasetIcon;
        }
        return null;
    }
}

